<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:smc_xsl_util="com.stonesoft.snapshot.xsl.SMCXSLUtil"
                xmlns:smc_img_util="com.stonesoft.snapshot.xsl.SMCImgXSLUtil"
                xmlns:smc_header_util="com.stonesoft.snapshot.xsl.SMCHeaderXSLUtil"
                xmlns:smc_global_inspection_util="com.stonesoft.snapshot.xsl.SMCGlobalInspectionXSLUtil"                
                xmlns:smc_alias_util="com.stonesoft.snapshot.xsl.AliasXSLUtil"
                xmlns:smc_engine_cluster_util="com.stonesoft.snapshot.xsl.EngineClusterXSLUtil"
                xmlns:smc_policy_action_util="com.stonesoft.snapshot.xsl.SMCPolicyActionXSLUtil"
                xmlns:smc_policy_option_util="com.stonesoft.snapshot.xsl.SMCPolicyOptionXSLUtil"                
                exclude-result-prefixes="smc_xsl_util smc_img_util smc_header_util smc_global_inspection_util smc_alias_util smc_engine_cluster_util smc_policy_action_util smc_policy_option_util"
                version="1.0">
  <xsl:output method="html" indent="yes"/>

<!-- List of network elements handled -->
  <xsl:variable name="network-element">
  ,network,router,host,address_range,radius_server,tacacs_server,dns_server,dhcp_server,monitoring_server,log_server,mgt_server,cis_server,ldap_server,active_directory_server,smc_authentication_server,group,netlink,dynamic_netlink,netlink_pool,server_pool,alias,expression,location,geolocation,snmp_agent,fw_single,fw_cluster,single_ips,ips_cluster,analyzer,combined_sensor_analyzer,firewall_layer2_single,firewall_layer2_cluster,authentication_service,domain,internal_dns_server,ssl_vpn_cluster,soho_firewall,interface_zone,domain_name,
  </xsl:variable>

<!-- List of services handled -->
  <xsl:variable name="service">
  ,service_ethernet,service_ip,service_icmpv6,service_tcp,service_udp,service_icmp,service_rpc,gen_service_group,icmp_service_group,ip_service_group,rpc_service_group,tcp_service_group,udp_service_group,ethernet_service_group,
  </xsl:variable>
  
  <!-- List of categories handled -->
  <xsl:variable name="category">
  ,category,
  </xsl:variable>
  
<!-- List of situations handled -->
  <xsl:variable name="situation">
  ,situation,category,vulnerability,situation_context,situation_context_group,
  </xsl:variable>
  
<!-- List of protocols handled -->
  <xsl:variable name="protocol">
  ,module,protocol_agent,
  </xsl:variable>

<!-- List of logical interfaces handled -->
  <xsl:variable name="logical-interface">
  ,logical_interface,
  </xsl:variable>
  
  <!-- List of mac address handled -->
  <xsl:variable name="mac-address">
  ,mac_address,
  </xsl:variable>
  
<!-- List of policies handled -->
  <xsl:variable name="policy">
  ,fw_sub_policy,fw_policy,fw_template_policy,ips_sub_policy,ips_policy,ips_template_policy,fw_layer2_sub_policy,fw_layer2_policy,fw_layer2_template_policy,inspection_template_policy,
  </xsl:variable>

<!-- List of vpns handled -->
  <xsl:variable name="vpn">
  ,vpn,vpn_site,internal_gateway,external_gateway,vpn_profile,gateway_type,client_gateway,soho_gateways_group,	
  </xsl:variable>
  
<!--  List of gateways handled -->
  <xsl:variable name="gateway">
  ,internal_gateway,external_gateway,client_gateway,soho_gateways_group,  
  </xsl:variable>
  
<!--  List of qos handled -->
  <xsl:variable name="qos">
  ,qos_class,qos_policy,  
  </xsl:variable>


<!-- *** Define template for handling input file: 
     *** Choose what elements to handle, in whatorder, and (for some elements)
     *** print out template of the table. -->
     
  <xsl:template match="generic_import_export">
    <!-- Copy the current node -->             
    <!-- Including any attributes it has and any child nodes -->

    <xsl:apply-templates select="fw_policy"/>
    <xsl:apply-templates select="ips_policy"/>
    <xsl:apply-templates select="fw_layer2_policy"/>

  	<xsl:if test="fw_template_policy">
  	  <h2><xsl:value-of select="smc_img_util:getBigTitleImgHTMLRef( 'fw_template_policy' )" disable-output-escaping="yes"/></h2>
  	  <div id='fw_template_policy' style='display: block;'> 
        <xsl:apply-templates select="fw_template_policy"/>
      </div>
    </xsl:if>    
    <xsl:if test="fw_sub_policy">
      <h2><xsl:value-of select="smc_img_util:getBigTitleImgHTMLRef( 'fw_sub_policy' )" disable-output-escaping="yes"/></h2>
      <div id='fw_sub_policy' style='display: block;'>
        <xsl:apply-templates select="fw_sub_policy"/>
      </div>
    </xsl:if>
    <xsl:if test="inspection_template_policy">
      <h2><xsl:value-of select="smc_img_util:getBigTitleImgHTMLRef( 'inspection_template_policy' )" disable-output-escaping="yes"/></h2>
      <div id='inspection_template_policy' style='display: block;'> 
        <xsl:apply-templates select="inspection_template_policy"/>
      </div>
    </xsl:if>

    <xsl:if test="ips_template_policy">
      <h2><xsl:value-of select="smc_img_util:getBigTitleImgHTMLRef( 'ips_template_policy' )" disable-output-escaping="yes"/></h2>
      <div id='ips_template_policy' style='display: block;'>
        <xsl:apply-templates select="ips_template_policy"/>
      </div>
    </xsl:if>
    <xsl:if test="ips_sub_policy">
      <h2><xsl:value-of select="smc_img_util:getBigTitleImgHTMLRef( 'ips_sub_policy' )" disable-output-escaping="yes"/></h2>
      <div id='ips_sub_policy' style='display: block;'>
        <xsl:apply-templates select="ips_sub_policy"/>
      </div>
    </xsl:if>

    <xsl:if test="fw_layer2_template_policy">
      <h2><xsl:value-of select="smc_img_util:getBigTitleImgHTMLRef( 'fw_layer2_template_policy' )" disable-output-escaping="yes"/></h2>
      <div id='fw_layer2_template_policy' style='display: block;'>
        <xsl:apply-templates select="fw_layer2_template_policy"/>
      </div>
    </xsl:if>
    <xsl:if test="fw_layer2_sub_policy">
      <h2><xsl:value-of select="smc_img_util:getBigTitleImgHTMLRef( 'fw_layer2_sub_policy' )" disable-output-escaping="yes"/></h2>
      <div id='fw_layer2_sub_policy' style='display: block;'>
        <xsl:apply-templates select="fw_layer2_sub_policy"/>
      </div>
    </xsl:if>
      
    <xsl:if test="active_directory_server|smc_authentication_server|network|host|address_range|router|ldap_server|log_server|dns_server|dhcp_server|cis_server|mgt_server|monitoring_server|radius_server|tacacs_server|fw_single|fw_cluster|analyzer|single_ips|ips_cluster|combined_sensor_analyzer|firewall_layer2_single|firewall_layer2_cluster|alias|expression|netlink|netlink_pool|dynamic_netlink|server_pool|group|ssl_vpn_cluster|soho_firewall|domain_name|interface_zone">
   	  <h2><xsl:value-of select="smc_img_util:getBigTitleNEsImgHTMLRef('BigTitleForNEs')" disable-output-escaping="yes"/></h2>
      <div id='BigTitleForNEs' style='display: block;'> 
	  <xsl:if test="fw_single|fw_cluster|analyzer|single_ips|ips_cluster|combined_sensor_analyzer|firewall_layer2_single|firewall_layer2_cluster">
		 <h3><xsl:value-of select="smc_img_util:getTitleEnginesImgHTMLRef('engines')" disable-output-escaping="yes"/></h3>
		 <div id='engines' style='display: block;'>
			 <xsl:apply-templates select="fw_single"/>
			 <xsl:apply-templates select="fw_cluster"/>
             <xsl:apply-templates select="analyzer"/>
             <xsl:apply-templates select="single_ips"/>
             <xsl:apply-templates select="ips_cluster"/>
             <xsl:apply-templates select="combined_sensor_analyzer"/>
             <xsl:apply-templates select="firewall_layer2_single"/>
             <xsl:apply-templates select="firewall_layer2_cluster"/>
	     </div>
	  </xsl:if>
        
      <xsl:if test="ssl_vpn_cluster">
        <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'ssl_vpn_cluster' )" disable-output-escaping="yes"/></h3>
        <div id='ssl_vpn_cluster' style='display: block;'> 
          <xsl:apply-templates select="ssl_vpn_cluster"/>
        </div>
      </xsl:if>
        
       <xsl:if test="mgt_server">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'mgt_server' )" disable-output-escaping="yes"/></h3>
         <div id='mgt_server' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getDefaultHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="mgt_server"/>
	         </table>
         </div>
       </xsl:if> 

	   <xsl:if test="monitoring_server">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'monitoring_server' )" disable-output-escaping="yes"/></h3>
         <div id='monitoring_server' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getDefaultHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="monitoring_server"/>
	         </table>
         </div>
       </xsl:if>
        
       <xsl:if test="log_server">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'log_server' )" disable-output-escaping="yes"/></h3>
         <div id='log_server' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getDefaultHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="log_server"/>
	         </table>
         </div>
       </xsl:if>
        
       <xsl:if test="network">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'network' )" disable-output-escaping="yes"/></h3>
         <div id='network' style='display: block;'>
	         <table>
	         <xsl:value-of select="smc_header_util:getNetworkHTMLTableHeader()" disable-output-escaping="yes"/>
	         <xsl:apply-templates select="network"/>
	         </table>
         </div>
       </xsl:if>
        
       <xsl:if test="address_range and address_range[@name != 'NONE'] and address_range[@name != 'ANY']">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'address_range' )" disable-output-escaping="yes"/></h3>
         <div id='address_range' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getIPRangeHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="address_range"/>
	         </table>
	     </div>
       </xsl:if>
        
       <xsl:if test="domain_name">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'domain_name' )" disable-output-escaping="yes"/></h3>
         <div id='domain_name' style='display: block;'>
             <table>
               <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
               <xsl:apply-templates select="domain_name"/>
             </table>
         </div>
       </xsl:if>
       
	   <xsl:if test="dns_server">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'dns_server' )" disable-output-escaping="yes"/></h3>
         <div id='dns_server' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getDefaultHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="dns_server"/>
	         </table>
	     </div>
       </xsl:if>
        
	   <xsl:if test="active_directory_server">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'active_directory_server' )" disable-output-escaping="yes"/></h3>
         <div id='active_directory_server' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getDefaultHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="active_directory_server"/>
	         </table>
	     </div>
       </xsl:if>
       
       <xsl:if test="smc_authentication_server">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'smc_authentication_server' )" disable-output-escaping="yes"/></h3>
         <div id='smc_authentication_server' style='display: block;'>
             <table>
               <xsl:value-of select="smc_header_util:getDefaultHTMLTableHeader()" disable-output-escaping="yes"/>
               <xsl:apply-templates select="smc_authentication_server"/>
             </table>
         </div>
       </xsl:if>
        
       <xsl:if test="dhcp_server">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'dhcp_server' )" disable-output-escaping="yes"/></h3>
         <div id='dhcp_server' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getDefaultHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="dhcp_server"/>
	         </table>
	      </div>
       </xsl:if>
        
       <xsl:if test="host">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'host' )" disable-output-escaping="yes"/></h3>
         <div id='host' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getIPv6NetworkElementHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="host"/>
	         </table>
         </div>
       </xsl:if>
        
       <xsl:if test="router">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'router' )" disable-output-escaping="yes"/></h3>
         <div id='router' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getIPv6NetworkElementHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="router"/>
	         </table>
         </div>
       </xsl:if>
        
       <xsl:if test="cis_server">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'cis_server' )" disable-output-escaping="yes"/></h3>
         <div id='cis_server' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getDefaultHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="cis_server"/>
	         </table>
         </div>
       </xsl:if>
       
       <xsl:if test="ldap_server">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'ldap_server' )" disable-output-escaping="yes"/></h3>
         <div id='ldap_server' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getDefaultHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="ldap_server"/>
	         </table>
	     </div>
       </xsl:if>
        
       <xsl:if test="radius_server">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'radius_server' )" disable-output-escaping="yes"/></h3>
         <div id='radius_server' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getDefaultHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="radius_server"/>
	         </table>
	     </div>
       </xsl:if>
       
       <xsl:if test="tacacs_server">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'tacacs_server' )" disable-output-escaping="yes"/></h3>
         <div id='tacacs_server' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getDefaultHTMLTableHeader()" disable-output-escaping="yes"/>
	           <xsl:apply-templates select="tacacs_server"/>
	         </table>
         </div>
       </xsl:if>
        
       <xsl:if test="alias">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'alias' )" disable-output-escaping="yes"/></h3>
         <div id='alias' style='display: block;'>
			 <table>
			   <tr>
			     <th class="smc_comparison_result"></th>
				 <th> Name </th>
				 <th> Default Value </th>
			     <th> Translation for Clusters </th>
			   </tr>
			   <xsl:apply-templates select="alias"/>
	   		 </table>
	     </div>
       </xsl:if>
        
	   <xsl:if test="expression">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'expression' )" disable-output-escaping="yes"/></h3>
         <div  id='expression' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
			   <xsl:apply-templates select="expression"/>
	    	 </table>
    	 </div>
       </xsl:if>
        
	   <xsl:if test="netlink">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'netlink' )" disable-output-escaping="yes"/></h3>
         <div id='netlink' style='display: block;'>
	         <table>
	           <tr>
	             <th class="smc_comparison_result"></th>
	             <th> Name </th>
	             <th> Gateway </th>
	             <th> Networks </th>
	             <th> Probe Addresses </th>
	           </tr>
	           <xsl:apply-templates select="netlink"/>
	         </table>
         </div>
       </xsl:if>
        
       <xsl:if test="dynamic_netlink">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'dynamic_netlink' )" disable-output-escaping="yes"/></h3>
         <div id='dynamic_netlink' style='display: block;'>
             <table>
               <tr>
                 <th class="smc_comparison_result"></th>
                 <th> Name </th>
                 <th> Probe Addresses </th>
               </tr>
               <xsl:apply-templates select="dynamic_netlink"/>
             </table>
         </div>
       </xsl:if>
        
	   <xsl:if test="netlink_pool">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'netlink_pool' )" disable-output-escaping="yes"/></h3>
         <div id='netlink_pool' style='display: block;'>
	         <table>
	           <tr>
	             <th class="smc_comparison_result"></th>
	             <th> Name </th>
	             <th> Multi-Link Members </th>
	           </tr>
			   <xsl:apply-templates select="netlink_pool"/>
			 </table>
		 </div>
       </xsl:if>
        
	   <xsl:if test="server_pool">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'server_pool' )" disable-output-escaping="yes"/></h3>
         <div id='server_pool' style='display: block;'>
	         <table>
	           <tr>
	             <th class="smc_comparison_result"></th>
	             <th> Name </th>
	             <th> External Addresses </th>
	             <th> Server Pool Members </th>
	             <th> Traffic Allocation </th>
	           </tr>
			   <xsl:apply-templates select="server_pool"/>
		     </table>
         </div>	     
       </xsl:if>
        
	   <xsl:if test="group">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'group' )" disable-output-escaping="yes"/></h3>
         <div id='group' style='display: block;'>
	         <table>
	           <xsl:value-of select="smc_header_util:getWithContentsHTMLTableHeader()" disable-output-escaping="yes"/>
			   <xsl:apply-templates select="group"/>
	 		 </table>
 		 </div>
       </xsl:if>
        
       <xsl:if test="soho_firewall">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'soho_firewall' )" disable-output-escaping="yes"/></h3>
         <div id='soho_firewall' style='display: block;'>
	         <table>
			   <tr>
			     <th class="smc_comparison_result"></th>
				 <th> Name </th>
			     <th> External </th>
			     <th> Corporate </th>
			     <th> Guest</th>
			   </tr>
			   <xsl:apply-templates select="soho_firewall"/>
	  		 </table>
  		 </div>
       </xsl:if>
       </div>
    </xsl:if>
    
    <xsl:if test="interface_zone">
         <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'interface_zone' )" disable-output-escaping="yes"/></h3>
         <div id='interface_zone' style='display: block;'>
             <table>
               <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
               <xsl:apply-templates select="interface_zone"/>
             </table>
         </div>
       </xsl:if>
    
    <!-- Services -->
    
	<xsl:if test="service_ethernet|service_ip|service_tcp|service_udp|service_icmp|service_rpc|gen_service_group|icmp_service_group|ip_service_group|rpc_service_group|tcp_service_group|udp_service_group|ethernet_service_group">
      <h2><xsl:value-of select="smc_img_util:getTitleServicesImgHTMLRef('services')" disable-output-escaping="yes"/></h2>
      <div id='services' style='display: block;'>
	  <xsl:if test="service_ethernet|ethernet_service_group">
	    <xsl:if test="service_ethernet">
		  <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'service_ethernet' )" disable-output-escaping="yes"/></h3>
		  <div id='service_ethernet' style='display: block;'> 
			  <table>
			    <tr>
			      <th class="smc_comparison_result"></th>
		          <th> Name </th>
				  <th> Type </th>
				  <th> Protocol </th>
				</tr>
			    <xsl:apply-templates select="service_ethernet"/>
			  </table>
		  </div>
		</xsl:if>
		<xsl:if test="ethernet_service_group">	
		  <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'ethernet_service_group' )" disable-output-escaping="yes"/></h3>
		  <div id='ethernet_service_group' style='display: block;'>	
			  <table>
	            <xsl:value-of select="smc_header_util:getWithContentsHTMLTableHeader()" disable-output-escaping="yes"/>
				<xsl:apply-templates select="ethernet_service_group"/>
			  </table>
		  </div>
	    </xsl:if>
	  </xsl:if>
	  <xsl:if test="gen_service_group">
        <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'gen_service_group' )" disable-output-escaping="yes"/></h3>
        <div id='gen_service_group' style='display: block;'>   
			<table>
	          <xsl:value-of select="smc_header_util:getWithContentsHTMLTableHeader()" disable-output-escaping="yes"/>
			  <xsl:apply-templates select="gen_service_group"/>
			</table>
		</div>
	  </xsl:if>
	  
	  <xsl:if test="service_icmp|icmp_service_group">
        <xsl:if test="service_icmp">
          <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'service_icmp' )" disable-output-escaping="yes"/></h3>
          <div id='service_icmp' style='display: block;'>
	          <table>
				<tr>
				  <th class="smc_comparison_result"></th>
				  <th> Name </th>
				  <th> Type </th>
				  <th> Code </th>
			    </tr>
				<xsl:apply-templates select="service_icmp"/>
			  </table>
		  </div>
		</xsl:if>			
		<xsl:if test="icmp_service_group">
	      <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'icmp_service_group' )" disable-output-escaping="yes"/></h3>
	      <div id='icmp_service_group' style='display: block;'>
			  <table>
	            <xsl:value-of select="smc_header_util:getWithContentsHTMLTableHeader()" disable-output-escaping="yes"/>
				<xsl:apply-templates select="icmp_service_group"/>
			  </table>
		  </div>
		</xsl:if>			
	  </xsl:if>
	  
	  <xsl:if test="service_ip|ip_service_group">
         <xsl:if test="service_ip">
           <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'service_ip' )" disable-output-escaping="yes"/></h3>
           <div id='service_ip' style='display: block;'>
	           <table>
				<tr>
				  <th class="smc_comparison_result"></th>
				  <th> Name </th>
				  <th> Protocol Number </th>
				  <th> Protocol </th>
				</tr>
				<xsl:apply-templates select="service_ip"/>
			  </table>
		   </div>
		</xsl:if>			
        <xsl:if test="ip_service_group">
          <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'ip_service_group' )" disable-output-escaping="yes"/></h3>
          <div id='ip_service_group' style='display: block;'>
			<table>
	            <xsl:value-of select="smc_header_util:getWithContentsHTMLTableHeader()" disable-output-escaping="yes"/>
				<xsl:apply-templates select="ip_service_group"/>
			</table>
		  </div>
		</xsl:if>			
	  </xsl:if>
	  
	  <xsl:if test="service_rpc|rpc_service_group">
        <xsl:if test="service_rpc">
          <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'service_rpc' )" disable-output-escaping="yes"/></h3>
          <div id='service_rpc' style='display: block;'>
	          <table>
				<tr>
				  <th class="smc_comparison_result"></th>
				  <th> Name </th>
				  <th> Program Number </th>
				  <th> Transport </th>
				  <th> Version </th>
				</tr>
				<xsl:apply-templates select="service_rpc"/>
			  </table>
	      </div>
		</xsl:if>			
		<xsl:if test="rpc_service_group">
		  <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'rpc_service_group' )" disable-output-escaping="yes"/></h3>
		  <div id='rpc_service_group' style='display: block;'>
			  <table>
	            <xsl:value-of select="smc_header_util:getWithContentsHTMLTableHeader()" disable-output-escaping="yes"/>
				<xsl:apply-templates select="rpc_service_group"/>
		      </table>
		  </div>
		</xsl:if>
	  </xsl:if>
	  
	  <xsl:if test="service_tcp|tcp_service_group">
		<xsl:if test="service_tcp">
		  <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'service_tcp' )" disable-output-escaping="yes"/></h3>
		  <div id='service_tcp' style='display: block;'>
			  <table>
				<tr>
				  <th class="smc_comparison_result"></th>
				  <th> Name </th>
				  <th> Min Dst Port </th>
				  <th> Max Dst Port </th>
				  <th> Min Src Port </th>
				  <th> Max Src Port </th>
				  <th> Protocol </th>
				</tr>
			    <xsl:apply-templates select="service_tcp"/>
			  </table>
		  </div>
		</xsl:if>
	    <xsl:if test="tcp_service_group">
		  <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'tcp_service_group' )" disable-output-escaping="yes"/></h3>
		  <div id='tcp_service_group' style='display: block;'>
			  <table>
	            <xsl:value-of select="smc_header_util:getWithContentsHTMLTableHeader()" disable-output-escaping="yes"/>
				<xsl:apply-templates select="tcp_service_group"/>
			  </table>
		  </div>
		</xsl:if>				
	  </xsl:if>
	  
	  <xsl:if test="service_udp|udp_service_group">
        <xsl:if test="service_udp">
          <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'service_udp' )" disable-output-escaping="yes"/></h3>
	      <div id='service_udp' style='display: block;'>
	        <table>
			  <tr>
			    <th class="smc_comparison_result"></th>
			    <th> Name </th>
			    <th> Min Dst Port </th>
			    <th> Max Dst Port </th>
			    <th> Min Src Port </th>
			    <th> Max Src Port </th>
			    <th> Protocol </th>
			  </tr>
			  <xsl:apply-templates select="service_udp"/>
		    </table>
		  </div>
        </xsl:if>
        <xsl:if test="udp_service_group">
        <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'udp_service_group' )" disable-output-escaping="yes"/></h3>
          <div id='udp_service_group' style='display: block;'>
			<table>
	          <xsl:value-of select="smc_header_util:getWithContentsHTMLTableHeader()" disable-output-escaping="yes"/>
			  <xsl:apply-templates select="udp_service_group"/>
			</table>
	      </div>
		</xsl:if>
	  </xsl:if>
	  </div>
	</xsl:if>
	
	<!--  Other Elements -->
	<xsl:if test="category|logical_interface|snmp_agent|domain|mac_address|location|authentication_service|module|situation|vulnerability|situation_context|situation_context_group|protocol_agent|user_response">
	  <h2><xsl:value-of select="smc_img_util:getTitleOthersImgHTMLRef('others')" disable-output-escaping="yes"/></h2>
	  <div id='others' style='display: block;'>
	    <xsl:if test="category">
	      <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'category', category/@type )" disable-output-escaping="yes"/></h3>
	        <div id='category' style='display: block;'>
		      <table>
	            <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
	            <xsl:apply-templates select="category"/>
	          </table>
	        </div>
	    </xsl:if>
	    <xsl:if test="logical_interface">
	      <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'logical_interface' )" disable-output-escaping="yes"/></h3>
	      <div id='logical_interface' style='display: block;'>
		    <table>
	          <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
		      <xsl:apply-templates select="logical_interface"/>
		    </table>
		  </div>
	    </xsl:if>
	    <xsl:if test="protocol_agent">
          <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'protocol_agent' )" disable-output-escaping="yes"/></h3>
          <div id='protocol_agent' style='display: block;'>
            <table>
              <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
              <xsl:apply-templates select="protocol_agent"/>
            </table>
          </div>
        </xsl:if>	    
	    <xsl:if test="snmp_agent">
		  <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'snmp_agent' )" disable-output-escaping="yes"/></h3>
		  <div id='snmp_agent' style='display: block;'>
		    <table>
              <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
			  <xsl:apply-templates select="snmp_agent"/>
		    </table>
		  </div>
        </xsl:if>
	    <xsl:if test="domain">
          <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'domain' )" disable-output-escaping="yes"/></h3>
          <div id='domain' style='display: block;'>
            <table>
              <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
              <xsl:apply-templates select="domain"/>
            </table>
          </div>
        </xsl:if>
        <xsl:if test="qos_class">
           <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'qos_class' )" disable-output-escaping="yes"/></h3>
           <div id='qos_class' style='display: block;'> 
             <table>
               <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
               <xsl:apply-templates select="qos_class"/>
             </table>
           </div>
        </xsl:if>
        <xsl:if test="mac_address">
	      <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'mac_address' )" disable-output-escaping="yes"/></h3>
	      <div id='mac_address' style='display: block;'>
	        <table>
              <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
		      <xsl:apply-templates select="mac_address"/>
	        </table>
	      </div>
	    </xsl:if>
	    <xsl:if test="location">
	      <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'location' )" disable-output-escaping="yes"/></h3>
	      <div id='location' style='display: block;'>
		     <table>
	           <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
			   <xsl:apply-templates select="location"/>
		     </table>
          </div>
	    </xsl:if>
	    <xsl:if test="user_response">
          <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'user_response' )" disable-output-escaping="yes"/></h3>
          <div id='user_response' style='display: block;'>
             <table>
               <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
               <xsl:apply-templates select="user_response"/>
             </table>
          </div>
        </xsl:if>
	    <xsl:if test="authentication_service">
		  <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'authentication_service' )" disable-output-escaping="yes"/></h3>
		  <div id='authentication_service' style='display: block;'>
			<table>
		      <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
			  <xsl:apply-templates select="authentication_service"/>
			</table>
	      </div>
	    </xsl:if>
	    <xsl:if test="situation">
          <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'situation', situation/@type )" disable-output-escaping="yes"/></h3>
          <div id='situation' style='display: block;'>
            <table>
              <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
              <xsl:apply-templates select="situation"/>
            </table>
          </div>
        </xsl:if>
        <xsl:if test="situation_context">
          <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'situation_context', situation_context/@type )" disable-output-escaping="yes"/></h3>
          <div id='situation_context' style='display: block;'>
            <table>
              <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
              <xsl:apply-templates select="situation_context"/>
            </table>
          </div>
        </xsl:if>
        <xsl:if test="situation_context_group">
          <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'situation_context_group' )" disable-output-escaping="yes"/></h3>
          <div id='situation_context_group' style='display: block;'>
            <table>
              <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
              <xsl:apply-templates select="situation_context_group"/>
            </table>
          </div>                
        </xsl:if>        
        <xsl:if test="module|vulnerability">
          <h3><xsl:value-of select="smc_img_util:getTitleInspectionsImgHTMLRef('inspections')" disable-output-escaping="yes"/></h3>
          <div id='inspections' style='display: block;'>
            <xsl:if test="module">
              <table>
                <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
                <xsl:apply-templates select="module"/>
              </table>
            </xsl:if>
            <xsl:if test="vulnerability">
              <table>
                <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
                <xsl:apply-templates select="vulnerability"/>
              </table>      
            </xsl:if>
          </div>
        </xsl:if>
	  </div>
	</xsl:if>	
	<!-- VPN -->
	
	<xsl:if test="vpn|vpn_site|internal_gateway|external_gateway|vpn_topology|vpn_profile|gateway_type|soho_gateways_group|client_gateway">
      <h2><xsl:value-of select="smc_img_util:getTitleVPNElementsImgHTMLRef('vpns')" disable-output-escaping="yes"/></h2>
      <div id='vpns'>
	  <xsl:if test="vpn">
		<h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'vpn' )" disable-output-escaping="yes"/></h3>
		<div id='vpn' style='display: block;'>
		<table>
		  <tr>
		    <th class="smc_comparison_result"></th>
		    <th> Name </th>
	        <th> VPN Profile </th>
	        <th> NAT </th>
		  </tr>
		  <xsl:apply-templates select="vpn" mode="vpn_parameters"/>
		</table>
		<xsl:apply-templates select="vpn" mode="vpn_content"/>
		</div>
	  </xsl:if>	
      <xsl:if test="vpn_topology">
		<h3>Topologies</h3>
		<xsl:apply-templates select="vpn_topology"/>
	  </xsl:if>
	  <xsl:if test="internal_gateway|external_gateway|soho_gateways_group|client_gateway">
        <h3><xsl:value-of select="smc_img_util:getTitleGatewaysImgHTMLRef('gateways')" disable-output-escaping="yes"/></h3>
        <div id='gateways' style='display: block;'>
        <table>
          <tr>
            <th class="smc_comparison_result"></th>
            <th> Name </th>
            <th> Firewall </th>
            <th> Gateway Profile </th>
            <th> End Points </th>
            <th> Sites </th>
            <th> Backup Gateways </th>
          </tr>
          <xsl:apply-templates select="internal_gateway|external_gateway|soho_gateways_group|client_gateway"/>
       </table>
	   </div>
     </xsl:if>
	 <xsl:if test="vpn_site">
	   <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'vpn_site' )" disable-output-escaping="yes"/></h3>
	   <div id='vpn_site' style='display: block;'>
		   <table>
		     <tr>
		       <th class="smc_comparison_result"></th>
			   <th> Name </th>
			   <th> Network Elements </th>
			 </tr>	
			 <xsl:apply-templates select="vpn_site"	/>
		   </table>
	   </div>
	 </xsl:if>
	 <xsl:if test="vpn_profile">
		<h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'vpn_profile' )" disable-output-escaping="yes"/></h3>
		<div id='vpn_profile' style='display: block;'>
		    <table>
	          <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
	  		  <xsl:apply-templates select="vpn_profile"/>
	  		</table>
  		</div>
	  </xsl:if>
	  </div>
	</xsl:if>
    <xsl:if test="gateway_type">
      <h3><xsl:value-of select="smc_img_util:getTitleImgHTMLRef( 'gateway_type' )" disable-output-escaping="yes"/></h3>
      <div id='gateway_type' style='display: block;'>
	      <table>
	        <xsl:value-of select="smc_header_util:getSimpleHTMLTableHeader()" disable-output-escaping="yes"/>
	        <xsl:apply-templates select="gateway_type"/>
	      </table>
	  </div>
    </xsl:if>
  </xsl:template>

<!-- *** Handling for alias network elements.
     *** Currently unfinished, only does Default values -->

  <xsl:template match="alias">
    <tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td>
        <xsl:variable name='ref'>
          <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
        </xsl:variable>
        <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
        <xsl:value-of select="$ref"/>
      </td>
	  <td> 
	    <xsl:if test="default_alias_value">
		  <xsl:choose>
		    <xsl:when test="default_alias_value/@ne_ref = 'ANY'">
			  <xsl:value-of select="smc_img_util:getImgHTMLRef( 'address_range', 'ANY' )" disable-output-escaping="yes"/>
			</xsl:when>
			<xsl:when test="default_alias_value/@ne_ref = 'NONE'">
              <xsl:value-of select="smc_img_util:getImgHTMLRef( 'address_range', 'NONE' )" disable-output-escaping="yes"/>
            </xsl:when>
			<xsl:otherwise>
			  <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="default_alias_value/@ne_ref"/></xsl:with-param></xsl:call-template>
			</xsl:otherwise>
		  </xsl:choose>  
		</xsl:if>
	  </td>
	  <td>
	    <xsl:value-of select="smc_alias_util:getAliasValueHTML(@name, /generic_import_export/fw_single, /generic_import_export/fw_cluster, /generic_import_export/analyzer, /generic_import_export/combined_sensor_analyzer, /generic_import_export/single_ips, /generic_import_export/ips_cluster, /generic_import_export/firewall_layer2_single, /generic_import_export/firewall_layer2_cluster)" disable-output-escaping="yes"/>
	  </td>
	</tr>
  </xsl:template>

  <xsl:template match="netlink">
    <tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td>
        <xsl:variable name='ref'>
          <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
        </xsl:variable>           
        <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
        <xsl:value-of select="$ref"/>
      </td>	  
	  <xsl:call-template name="attribute-comparison-result-td"> 
	    <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
		<xsl:with-param name="attribute"><xsl:value-of select="@gateway_ref"/></xsl:with-param>
		<xsl:with-param name="old_attribute"><xsl:value-of select="@old_gateway_ref"/></xsl:with-param>
		<xsl:with-param name="call_template_name">network-element-ref</xsl:with-param>
      </xsl:call-template>
      <td>
        <xsl:if test="network_list">
          <ul class="smc_element_list">
            <xsl:for-each select="network_list">
              <li>
                <span>
                  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
                  <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="@ref"/></xsl:with-param></xsl:call-template>
                </span>
              </li>
            </xsl:for-each>
          </ul>
        </xsl:if>
      </td>
      <td>
        <xsl:if test="probe_address">
          <ul class="smc_element_list">
            <xsl:for-each select="probe_address">
              <li>
                <span>
                  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
                  <xsl:value-of select="@value"/>
                </span>
              </li>
            </xsl:for-each>
          </ul>
        </xsl:if>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="dynamic_netlink">
    <tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <td>
        <xsl:variable name='ref'>
          <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
        </xsl:variable>
        <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
        <xsl:value-of select="$ref"/>
      </td>
      <td>
        <xsl:if test="probe_address">
          <ul class="smc_element_list">
            <xsl:for-each select="probe_address">
              <li>
                <span>
                  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
                  <xsl:value-of select="@value"/>
                </span>
              </li>
            </xsl:for-each>
          </ul>
        </xsl:if>
      </td>
    </tr>
  </xsl:template>
   
  <xsl:template match="netlink_pool">
    <tr>
      <!-- **** ignore comparison flag: comparison is done on the sub central and sub satellite table *****  -->
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"></xsl:with-param></xsl:call-template>
      <td>
        <xsl:variable name='ref'>
          <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
        </xsl:variable>           
        <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
        <xsl:value-of select="$ref"/>
      </td>
	  <td>  
	  	<table>
		  <tr>
		    <th class="smc_comparison_result"></th>
			<th> Netlink </th>
			<th> Network </th>
			<th> First IP </th>
			<th> Last IP </th>
			<th> Status </th>
		  </tr>
		  <xsl:apply-templates select="netlink_address"/>
	  	</table>
	  </td>
    </tr>
  </xsl:template>
    
  <xsl:template match="netlink_address">
    <tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  
	  	<xsl:choose>
		  <xsl:when test="@dynamic_index">
		  <td> 
	    	<xsl:text> Dynamic </xsl:text>
	      </td>
	      </xsl:when>
		  <xsl:otherwise>	
		    <xsl:call-template name="attribute-comparison-result-td"> 
	          <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
	          <xsl:with-param name="attribute"><xsl:value-of select="@netlink_ref"/></xsl:with-param>
	          <xsl:with-param name="old_attribute"><xsl:value-of select="@old_netlink_ref"/></xsl:with-param>
	          <xsl:with-param name="call_template_name">network-element-ref</xsl:with-param>
	        </xsl:call-template> 
		  </xsl:otherwise>
	  	</xsl:choose>
	  	<xsl:choose>
		  <xsl:when test="@dynamic_index">
		  </xsl:when>
		  <xsl:otherwise>					
            <xsl:call-template name="attribute-comparison-result-td"> 
              <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
              <xsl:with-param name="attribute"><xsl:value-of select="@network_ref"/></xsl:with-param>
              <xsl:with-param name="old_attribute"><xsl:value-of select="@old_network_ref"/></xsl:with-param>
              <xsl:with-param name="call_template_name">network-element-ref</xsl:with-param>
            </xsl:call-template> 
		  </xsl:otherwise>
		</xsl:choose>
	   <xsl:call-template name="attribute-comparison-result-td"> 
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@first_address"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_first_address"/></xsl:with-param>
      </xsl:call-template> 
       <xsl:call-template name="attribute-comparison-result-td"> 
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@last_address"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_last_address"/></xsl:with-param>
      </xsl:call-template> 
      <xsl:call-template name="attribute-comparison-result-td"> 
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@netlink_role"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_netlink_role"/></xsl:with-param>
      </xsl:call-template> 
    </tr>
  </xsl:template>    
    
  <xsl:template match="server_pool">
    <tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
  	  <td>
        <xsl:variable name='ref'>
          <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
        </xsl:variable>        	  
  	    <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
  	    <xsl:value-of select="$ref"/>
  	  </td>
	  <td> 
	    <table>
		  <tr>
		    <th class="smc_comparison_result"></th>
			<th> Netlink </th>
			<th> Network </th>
			<th> IP Address </th>
			<th> Proxy ARP Entry </th>
		  </tr>
		  <xsl:apply-templates select="ip_netlink_weight"/>
		</table>
	  </td>
      <td>
        <xsl:if test="ne_list">
          <ul class="smc_element_list">
            <xsl:for-each select="ne_list">
              <li>
                <span>
                  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
                  <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="@ref"/></xsl:with-param></xsl:call-template>
                </span>
              </li>
            </xsl:for-each>
          </ul>
        </xsl:if>
      </td>
      <xsl:call-template name="attribute-comparison-result-td"> 
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@server_allocation"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_server_allocation"/></xsl:with-param>
      </xsl:call-template>  
    </tr>
  </xsl:template>
    
  <xsl:template match="ip_netlink_weight">
    <tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="attribute-comparison-result-td"> 
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@netlink_ref"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_netlink_ref"/></xsl:with-param>
        <xsl:with-param name="call_template_name">network-element-ref</xsl:with-param>
      </xsl:call-template>
	  <xsl:call-template name="attribute-comparison-result-td"> 
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@network_ref"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_network_ref"/></xsl:with-param>
        <xsl:with-param name="call_template_name">network-element-ref</xsl:with-param>
      </xsl:call-template> 
	  <xsl:call-template name="attribute-comparison-result-td"> 
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@ipaddress"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_ipaddress"/></xsl:with-param>
      </xsl:call-template>  
	   <xsl:choose>
        <xsl:when test="@arp_generate and @old_arp_generate" >
          <xsl:choose>
            <xsl:when test="@arp_generate = 'true' ">
              <xsl:call-template name="attribute-comparison-result-td">
                <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
                <xsl:with-param name="attribute">Yes</xsl:with-param>
                <xsl:with-param name="old_attribute">No</xsl:with-param>
              </xsl:call-template>
            </xsl:when>
            <xsl:when test="@old_arp_generate = 'true' ">
              <xsl:call-template name="attribute-comparison-result-td">
                <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
                <xsl:with-param name="attribute">No</xsl:with-param>
                <xsl:with-param name="old_attribute">Yes</xsl:with-param>
              </xsl:call-template>
            </xsl:when>
          </xsl:choose> 
        </xsl:when>
        <xsl:when test="@arp_generate = 'true'" >
          <td><xsl:text> Yes </xsl:text></td>
        </xsl:when>
        <xsl:otherwise>
          <td><xsl:text> No </xsl:text></td>
        </xsl:otherwise>
      </xsl:choose>
     </tr>
   </xsl:template>  
   

<!--default rendering -->
  <xsl:template match="module|situation|vulnerability|situation_context|situation_context_group|category|logical_interface|snmp_agent|domain|qos_class|location|mac_address|authentication_service|protocol_agent|user_response">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:variable name='ref'>
        <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
      </xsl:variable>      
	  <xsl:choose>
        <xsl:when test="name()='logical_interface'">
          <td>
            <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('li', @name)"/></xsl:attribute>
            <xsl:value-of select="$ref"/>
          </td>
        </xsl:when>
        <xsl:when test="name()='user_response'">
          <td>
            <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ur', @name)"/></xsl:attribute>
            <xsl:value-of select="$ref"/>
          </td>
        </xsl:when>        
        <xsl:otherwise>
          <td id="{generate-id(.)}"><xsl:value-of select="$ref"/></td>
        </xsl:otherwise>
      </xsl:choose> 
	</tr>
  </xsl:template>

  <!-- *** Generic handling for most IPv4 network elements -->
  <xsl:template match="active_directory_server|smc_authentication_server|dns_server|dhcp_server|cis_server|ldap_server|radius_server|tacacs_server|monitoring_server">
    <tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template> 
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <td>
         <xsl:variable name='ref'>
           <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
         </xsl:variable>
         <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
         <xsl:value-of select="$ref"/>
      </td>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="mvia_address/@address"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="mvia_address/@old_address"/></xsl:with-param>
      </xsl:call-template>
    </tr>
  </xsl:template>
  
  <!-- *** Generic handling for network elements with IPv6 support-->
  <xsl:template match="host|router">
    <tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template> 
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <td>
         <xsl:variable name='ref'>
           <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
         </xsl:variable>
         <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
         <xsl:value-of select="$ref"/>
      </td>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="mvia_address/@address"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="mvia_address/@old_address"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@ipv6_address"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_ipv6_address"/></xsl:with-param>
      </xsl:call-template>
    </tr>
  </xsl:template>
  
  <!-- *** SG servers *** -->
  <xsl:template match="log_server|mgt_server">
    <tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template> 
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <td>
         <xsl:variable name='ref'>
           <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
         </xsl:variable>
         <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
         <xsl:value-of select="$ref"/>
      </td>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="multi_contact_mvia/@address"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="multi_contact_mvia/@old_address"/></xsl:with-param>
      </xsl:call-template>
    </tr>
  </xsl:template>

<!-- *** Network element 'network' -->
  <xsl:template match="network">
    <tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <td>
         <xsl:variable name='ref'>
           <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
         </xsl:variable>
         <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
         <xsl:value-of select="$ref"/>
      </td>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@ipv4_network"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_ipv4_network"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@ipv6_network"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_ipv6_network"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@broadcast"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_broadcast"/></xsl:with-param>
      </xsl:call-template>
    </tr>
  </xsl:template>

<!-- *** Network element 'address_range' -->

  <xsl:template match="address_range">
    <xsl:if test="@name != 'NONE' and @name != 'ANY'">
        <tr>
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td>
             <xsl:variable name='ref'>
               <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
             </xsl:variable>
             <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
             <xsl:value-of select="$ref"/>
          </td>
          <xsl:call-template name="attribute-comparison-result-td">
            <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
            <xsl:with-param name="attribute"><xsl:value-of select="@ip_range"/></xsl:with-param>
            <xsl:with-param name="old_attribute"><xsl:value-of select="@old_ip_range"/></xsl:with-param>
          </xsl:call-template>
        </tr>
   </xsl:if>
  </xsl:template>

  <!-- *** Firewall elements: single and cluster -->
  <xsl:template match="fw_single">
    <xsl:value-of select="smc_engine_cluster_util:getClusterHTML(., smc_xsl_util:getId('ne', @name), 'false', 'false')" disable-output-escaping="yes"/>
  </xsl:template>

  <xsl:template match="fw_cluster">
    <xsl:value-of select="smc_engine_cluster_util:getClusterHTML(., smc_xsl_util:getId('ne', @name), 'true', 'false')" disable-output-escaping="yes"/>
  </xsl:template>
  
<!-- *** Network element 'ssl_vpn_cluster' -->
  
  <xsl:template match="ssl_vpn_cluster">
    <table>
      <tr>
        <th class="smc_comparison_result"></th>
        <th align="left" colspan="4">
          <xsl:variable name='ref'>
            <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
          </xsl:variable>
          <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
          <xsl:text>SSL VPN Gateway </xsl:text>
          <xsl:value-of select="$ref"/>
        </th>
      </tr>
      <tr>
        <th class="smc_comparison_result"></th>
        <th> Node </th>
        <th> IP Address </th>
      </tr>
      <xsl:for-each select="ssl_vpn_node">
        <tr>
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template> 
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td id="{generate-id(.)}"><xsl:if test="position() = 1"></xsl:if><xsl:value-of select="@name"/></td>
          <xsl:call-template name="attribute-comparison-result-td">
            <xsl:with-param name="comparison_result"><xsl:value-of select="firewall_node_interface/@comparison_result"/></xsl:with-param>
            <xsl:with-param name="attribute"><xsl:value-of select="firewall_node_interface/mvia_address/@address"/></xsl:with-param>
            <xsl:with-param name="old_attribute"><xsl:value-of select="firewall_node_interface/mvia_address/@old_address"/></xsl:with-param>
          </xsl:call-template>
        </tr>
      </xsl:for-each>
    </table>
    <p></p>
  </xsl:template>
  
  <!-- *** Network element 'soho_firewall' -->
  
  <xsl:template match="soho_firewall">
    <tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <td>
         <xsl:variable name='ref'>
           <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
         </xsl:variable>
         <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
         <xsl:value-of select="$ref"/>
      </td>
      <td>
	    <xsl:choose>
	      <xsl:when test="@adsl_mode='Disabled'">
	        <xsl:value-of select="@external_ip_address"/>
	      </xsl:when>
	      <xsl:otherwise> <xsl:text> ADSL </xsl:text> </xsl:otherwise>
	    </xsl:choose>
     </td>   
     <xsl:call-template name="attribute-comparison-result-td">
       <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
       <xsl:with-param name="attribute"><xsl:value-of select="@corporate_local_network"/></xsl:with-param>
       <xsl:with-param name="old_attribute"><xsl:value-of select="@old_corporate_local_network"/></xsl:with-param>
     </xsl:call-template>
     <xsl:call-template name="attribute-comparison-result-td">
       <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
       <xsl:with-param name="attribute"><xsl:value-of select="@guest_local_network"/></xsl:with-param>
       <xsl:with-param name="old_attribute"><xsl:value-of select="@old_guest_local_network"/></xsl:with-param>
     </xsl:call-template>
    <!--  <td><xsl:value-of select="@corporate_local_network"/></td>
     <td><xsl:value-of select="@guest_local_network"/></td> -->
   </tr>
  </xsl:template>

<!-- *** IPS analyzer element -->

  <xsl:template match="analyzer">
    <xsl:value-of select="smc_engine_cluster_util:getClusterHTML(., smc_xsl_util:getId('ne', @name), 'false', 'false')" disable-output-escaping="yes"/>
  </xsl:template>
  
  <xsl:template match="combined_sensor_analyzer">
    <xsl:value-of select="smc_engine_cluster_util:getClusterHTML(., smc_xsl_util:getId('ne', @name), 'false', 'true')" disable-output-escaping="yes"/>
  </xsl:template>

<!-- *** IPS sensor elements: single and cluster -->

  <xsl:template match="single_ips">
    <xsl:value-of select="smc_engine_cluster_util:getClusterHTML(., smc_xsl_util:getId('ne', @name), 'false', 'true')" disable-output-escaping="yes"/>
  </xsl:template>

  <xsl:template match="ips_cluster">
    <xsl:value-of select="smc_engine_cluster_util:getClusterHTML(., smc_xsl_util:getId('ne', @name), 'true', 'true')" disable-output-escaping="yes"/>
  </xsl:template>
  
<!-- *** FW Layer2 elements: single and cluster -->

  <xsl:template match="firewall_layer2_single">
    <xsl:value-of select="smc_engine_cluster_util:getClusterHTML(., smc_xsl_util:getId('ne', @name), 'false', 'true')" disable-output-escaping="yes"/>
  </xsl:template>

  <xsl:template match="firewall_layer2_cluster">
    <xsl:value-of select="smc_engine_cluster_util:getClusterHTML(., smc_xsl_util:getId('ne', @name), 'true', 'true')" disable-output-escaping="yes"/>
  </xsl:template>
  
  <!-- *** only named elements (no ip info) -->
  <xsl:template match="expression|interface_zone|domain_name">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td>
         <xsl:variable name='ref'>
           <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
         </xsl:variable>
         <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
         <xsl:value-of select="$ref"/>
      </td>
	</tr>
  </xsl:template>
  
  <!-- ***  'group' -->
  <xsl:template match="group">
	<tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td>
         <xsl:variable name='ref'>
           <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
         </xsl:variable>
         <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('ne', @name)"/></xsl:attribute>
         <xsl:value-of select="$ref"/>
      </td>
      <td>
        <xsl:if test="ne_list">
          <ul class="smc_element_list">
            <xsl:for-each select="ne_list">
              <li>
                <span>
                  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
                  <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="@ref"/></xsl:with-param></xsl:call-template>
                </span>
              </li>
            </xsl:for-each>
          </ul>
        </xsl:if>
      </td>
    </tr>
  </xsl:template>
  
  <!-- *** Services 'ethernet_service' -->
  <xsl:template match="service_ethernet">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td id="{generate-id(.)}"><xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/></td>
	  <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@frame_type"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_frame_type"/></xsl:with-param>
      </xsl:call-template>
      <xsl:choose>
        <xsl:when test="not(@protocol_agent_ref) and @protocol_agent_ref_key != ''">
          <!-- to be compatible with old snapshots where the protocol name was not exported -->
          <td>YES</td>
        </xsl:when>
        <xsl:otherwise>
	      <xsl:call-template name="attribute-comparison-result-td">
	        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
	        <xsl:with-param name="attribute"><xsl:value-of select="@protocol_agent_ref"/></xsl:with-param>
	        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_protocol_agent_ref"/></xsl:with-param>
	        <xsl:with-param name="call_template_name">protocol-ref</xsl:with-param>
	      </xsl:call-template>
        </xsl:otherwise>
      </xsl:choose>
	</tr>
  </xsl:template>
  
  <!-- *** Services 'icmp_service' -->
  <xsl:template match="service_icmp">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td id="{generate-id(.)}"><xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/></td>
	  <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@icmp_type"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_icmp_type"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@icmp_code"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_icmp_code"/></xsl:with-param>
      </xsl:call-template>
	</tr>
  </xsl:template>
  
  <!-- *** Services 'ip_service' -->
  <xsl:template match="service_ip">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td id="{generate-id(.)}"><xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/></td>
	  <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@protocol_number"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_protocol_number"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@protocol_agent_ref"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_protocol_agent_ref"/></xsl:with-param>
        <xsl:with-param name="call_template_name">protocol-ref</xsl:with-param>
      </xsl:call-template>
	</tr>
  </xsl:template>
  
  <!-- *** Services 'rpc_service' -->
  <xsl:template match="service_rpc">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td id="{generate-id(.)}"><xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/></td>
	  <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@program_number"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_program_number"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@transport"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_transport"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@rpc_version"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_rpc_version"/></xsl:with-param>
      </xsl:call-template>
	</tr>
  </xsl:template>
  
  <!-- *** Services 'tcp_service' and Services 'udp_service' -->
  <xsl:template match="service_udp|service_tcp">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td id="{generate-id(.)}"><xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/></td>
	  <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@min_dst_port"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_min_dst_port"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@max_dst_port"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_max_dst_port"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@min_src_port"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_min_src_port"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@max_src_port"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_max_src_port"/></xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@protocol_agent_ref"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_protocol_agent_ref"/></xsl:with-param>
        <xsl:with-param name="call_template_name">protocol-ref</xsl:with-param>
      </xsl:call-template>
	</tr>
  </xsl:template>
    
  <!-- *** Services 'gen_service_group' -->
  <xsl:template match="gen_service_group|ip_service_group|icmp_service_group|rpc_service_group|udp_service_group|tcp_service_group|ethernet_service_group">
    <tr>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
        <td id="{generate-id(.)}"><xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/></td>
        <td>
        <xsl:if test="service_ref">
          <ul class="smc_element_list">
            <xsl:for-each select="service_ref">
              <li>
                <span>
                  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
                  <xsl:call-template name="service-ref"><xsl:with-param name="value"><xsl:value-of select="@ref"/></xsl:with-param></xsl:call-template>
                </span>
              </li>
            </xsl:for-each>
          </ul>
        </xsl:if>
      </td>
    </tr>
  </xsl:template>

  <!-- *** VPN -->

  <xsl:template match="vpn" mode="vpn_parameters">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td><xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/></td>
	  <xsl:call-template name="attribute-comparison-result-td">
	    <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@vpn_profile_ref"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_vpn_profile_ref"/></xsl:with-param>
        <xsl:with-param name="call_template_name">vpn-ref</xsl:with-param>
      </xsl:call-template>
	  <xsl:call-template name="attribute-comparison-result-td">
        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
        <xsl:with-param name="attribute"><xsl:value-of select="@nat_enabled"/></xsl:with-param>
        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_nat_enabled"/></xsl:with-param>
      </xsl:call-template>
	</tr>
  </xsl:template>
  
  <xsl:template match="vpn" mode="vpn_content">
    <h3>
      <xsl:variable name='ref'>
        <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
      </xsl:variable>
      <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('vpn', @name)"/></xsl:attribute>
      VPN: <xsl:value-of select="$ref"/>    
    </h3>
    <h3>Overall Topology</h3>
    <xsl:apply-templates select="vpn_topology" mode="topology"/> 
    <h3> Overridden Tunnels </h3>
    <xsl:apply-templates select="vpn_topology" mode="tunnels"/>
  </xsl:template>

  <xsl:template match="vpn_topology" mode="topology">
	<table class="smc_vpn_topology">
      <tr>
        <th class="smc_comparison_result"></th>
        <th> Central Gateways </th>
	    <th> Satellite Gateways </th>
      </tr>
      <tr>
      <!-- **** ignore comparison flag: comparison is done on the sub central and sub satellite table *****  -->
        <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	    <td> 
	      <table>
		    <tr>
		      <th class="smc_comparison_result"></th>
		      <th> Gateway </th>
		      <th> Sites </th>
		      <th> Parent Gateway </th>	
		    </tr>
		    <xsl:apply-templates select="gateway_node[ @central != 'false' ]"/>
	      </table>
	    </td>
	    <td> 
	      <table>
		    <tr>
		      <th class="smc_comparison_result"></th>
	          <th> Gateway </th>
		      <th> Sites </th>
		      <th> Parent Gateway </th>	
		    </tr>
		    <xsl:apply-templates select="gateway_node[ @central = 'false' ]"/>
	      </table>
	    </td>
	  </tr>
  </table>
  </xsl:template>
    <xsl:template match="vpn_topology" mode="tunnels">
      <table>
        <tr>
         <th class="smc_comparison_result"></th>
	     <th colspan="4" > <xsl:text> Gateway &lt;-&gt; Gateway </xsl:text>  </th>
	   </tr>
	   <tr>
	     <th class="smc_comparison_result"></th>
	     <th> Gateway A </th>
	     <th> Gateway B </th>
	     <th colspan="2"> VPN Profile </th>
	   </tr>
	   <xsl:choose>
	  	 <xsl:when test="vpn_gw_gw">	
		   <xsl:apply-templates select="vpn_gw_gw"/>
		 </xsl:when>
		 <xsl:otherwise> 
		   <tr>
		     <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
             <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	         <td colspan="4">			
	 	       <xsl:text> none </xsl:text>
	         </td>
		   </tr>
	     </xsl:otherwise>
       </xsl:choose>
       <tr>
         <th class="smc_comparison_result"></th>
         <th colspan="4" ><xsl:text> End-Point &lt;-&gt; End-Point </xsl:text></th>
	   </tr>
	   <tr>
	     <th class="smc_comparison_result"></th>
	     <th> End-Point A </th>
	     <th> End-Point B </th>
	     <th> IPsec Profile </th>
	     <th> Mode </th>
	   </tr>
	   <xsl:choose>
	     <xsl:when test="vpn_ep_ep">	
	      <xsl:apply-templates select="vpn_ep_ep"/>
	    </xsl:when>
	    <xsl:otherwise>
	      <tr>
	        <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
            <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	        <td colspan="4">			
   	          <xsl:text> none </xsl:text>
   	        </td>
   	      </tr>
        </xsl:otherwise>	
      </xsl:choose> 
    </table>
  </xsl:template>
  
  <xsl:template match="gateway_node">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td>
	    <xsl:call-template name="vpn-ref"><xsl:with-param name="value"><xsl:value-of select="@gateway_ref"/></xsl:with-param></xsl:call-template>
	  </td>
	  <td>
        <xsl:if test="vpn_site_ref">
	    <ul class="smc_element_list">
		  <xsl:for-each select="vpn_site_ref">
            <li>
            <span>
              <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
		      <xsl:choose>
                <xsl:when test="@enabled='false'">
                  <span class="disabled">
                    <xsl:call-template name="vpn-ref"><xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
                    <xsl:if test="@site_mode != 'normal' or @old_site_mode != ''">
                        <xsl:text> (</xsl:text>
                        <xsl:call-template name="attribute-comparison-result"> 
                            <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
                            <xsl:with-param name="attribute"><xsl:value-of select="@site_mode"/></xsl:with-param>
                            <xsl:with-param name="old_attribute"><xsl:value-of select="@old_site_mode"/></xsl:with-param>
                        </xsl:call-template>
                        <xsl:text>)</xsl:text>
                    </xsl:if>
                  </span>
                </xsl:when>
                <xsl:otherwise>
                  <span>           
                    <xsl:call-template name="vpn-ref"><xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
                    <xsl:if test="@site_mode != 'normal' or @old_site_mode != ''">
                        <xsl:text> (</xsl:text>
	                    <xsl:call-template name="attribute-comparison-result"> 
	                        <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
	                        <xsl:with-param name="attribute"><xsl:value-of select="@site_mode"/></xsl:with-param>
	                        <xsl:with-param name="old_attribute"><xsl:value-of select="@old_site_mode"/></xsl:with-param>
	                    </xsl:call-template>
	                    <xsl:text>)</xsl:text>
                    </xsl:if>
                  </span>
                </xsl:otherwise>
              </xsl:choose>
            </span>
            </li>
		  </xsl:for-each>
		</ul>
        </xsl:if>
	  </td>
	  <td>
	    <xsl:if test="@parent_gateway_ref">
		  <xsl:call-template name="vpn-ref"><xsl:with-param name="value"><xsl:value-of select="@parent_gateway_ref"/></xsl:with-param></xsl:call-template>
	    </xsl:if>
	  </td>
	</tr>
  </xsl:template>
  
  <xsl:template match="vpn_gw_gw">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <xsl:if test="@enabled='false'"><xsl:attribute name="class">disabled</xsl:attribute></xsl:if>
	  <td> <xsl:call-template name="vpn-ref"><xsl:with-param name="value"><xsl:value-of select="@gateway_1_ref"/></xsl:with-param></xsl:call-template> </td>
  	  <td> <xsl:call-template name="vpn-ref"><xsl:with-param name="value"><xsl:value-of select="@gateway_2_ref"/></xsl:with-param></xsl:call-template> </td>
  	  <td colspan="2"> 
	    <xsl:choose>
	      <xsl:when test="@vpn_profile_ref">
 	   	    <xsl:call-template name="vpn-ref"><xsl:with-param name="value"><xsl:value-of select="@vpn_profile_ref"/></xsl:with-param></xsl:call-template>
	  	  </xsl:when> 
	  	  <xsl:otherwise>
		    <xsl:text> default </xsl:text> 
	      </xsl:otherwise>						
	    </xsl:choose>
	  </td>
	</tr>
  </xsl:template>
  
  <xsl:template match="vpn_ep_ep">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <xsl:if test="@enabled='false'"><xsl:attribute name="class">disabled</xsl:attribute></xsl:if>
	  <td> <xsl:value-of select="@end_point_1_address"/> </td>
  	  <td> <xsl:value-of select="@end_point_2_address"/> </td>
	  <td> <xsl:call-template name="vpn-ref"><xsl:with-param name="value"><xsl:value-of select="@vpn_profile_ref"/></xsl:with-param></xsl:call-template> </td>
	  <td> <xsl:value-of select="@mode"/> 
	  <xsl:if test="vpn_qos_class_mode">
        <ul class="smc_element_list">
          <xsl:for-each select="vpn_qos_class_mode">
            <li>
            <span>
              <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>         
                <xsl:call-template name="attribute-comparison-result"> 
                    <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
                    <xsl:with-param name="attribute"><xsl:value-of select="@qos_class_ref"/></xsl:with-param>
                    <xsl:with-param name="old_attribute"><xsl:value-of select="@old_qos_class_ref"/></xsl:with-param>
                    <xsl:with-param name="call_template_name">qos-ref</xsl:with-param>
                 </xsl:call-template>   
	             <xsl:text>
	                <xsl:call-template name="attribute-comparison-result"> 
	                    <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
	                    <xsl:with-param name="attribute"><xsl:value-of select="@mode"/></xsl:with-param>
	                    <xsl:with-param name="old_attribute"><xsl:value-of select="@old_mode"/></xsl:with-param>
	                </xsl:call-template>
	            </xsl:text>
            </span>
            </li>
          </xsl:for-each>
        </ul>
        </xsl:if>
	  </td>
	</tr>
  </xsl:template>
  
  <xsl:template match="vpn_site">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td>
        <xsl:variable name='ref'>
          <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
        </xsl:variable>	  
	    <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('vpn', @name)"/></xsl:attribute>
	    <xsl:value-of select="$ref"/>
	  </td>
	  <td>
	    <xsl:apply-templates select="network_element_ref"/>
      </td>
	</tr>
  </xsl:template>

  <xsl:template match="network_element_ref" >
    <span>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
    </span>
  </xsl:template>

  <xsl:template match="internal_gateway|external_gateway|soho_gateways_group|client_gateway">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <xsl:variable name="gateway_name"><xsl:value-of select="@name"/></xsl:variable>
	  <td>
	    <xsl:variable name='ref'>
          <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
        </xsl:variable>   
        <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('vpn', @name)"/></xsl:attribute>
	    <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
	  </td>
	  <xsl:choose>  
	    <xsl:when test="@fw_ref">
	      <xsl:call-template name="attribute-comparison-result-td"> 
            <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
            <xsl:with-param name="attribute"><xsl:value-of select="@fw_ref"/></xsl:with-param>
            <xsl:with-param name="old_attribute"><xsl:value-of select="@old_fw_ref"/></xsl:with-param>
            <xsl:with-param name="call_template_name">network-element-ref</xsl:with-param>
          </xsl:call-template>	
		</xsl:when>
		<xsl:otherwise> 
		  <td><xsl:text> N/A </xsl:text></td>
   		</xsl:otherwise>
      </xsl:choose>
	  <xsl:choose>
	    <xsl:when test="@gateway_type_ref">	
	      <xsl:call-template name="attribute-comparison-result-td"> 
            <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
            <xsl:with-param name="attribute"><xsl:value-of select="@gateway_type_ref"/></xsl:with-param>
            <xsl:with-param name="old_attribute"><xsl:value-of select="@old_gateway_type_ref"/></xsl:with-param>
            <xsl:with-param name="call_template_name">vpn-ref</xsl:with-param>
          </xsl:call-template>  
		</xsl:when>
		<xsl:otherwise> 
		  <td><xsl:text> N/A </xsl:text></td>
   		</xsl:otherwise>
      </xsl:choose>
      <td>
        <xsl:if test="end_point">
          <ul class="smc_element_list">
            <xsl:for-each select="end_point">
              <li>
                <span>
                  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
                  <xsl:value-of select="smc_img_util:getEndPointImgHTMLRef(mvia_address/@address)" disable-output-escaping="yes"/>
                </span>
              </li>
            </xsl:for-each>
          </ul>
        </xsl:if>
      </td>
      <td>
        <xsl:call-template name="gateway-ref"><xsl:with-param name="value"><xsl:value-of select="$gateway_name"/></xsl:with-param></xsl:call-template>
      </td>
      <td>
        <xsl:if test="name()='internal_gateway'">
	      <xsl:choose>
		    <xsl:when test="backup_gateway_ref">
		      <table>
                <tr>
                  <th>Rank</th>
                  <th>Gateway</th>
                </tr>
		        <xsl:for-each select="backup_gateway_ref">
                  <tr>
                    <xsl:call-template name="attribute-comparison-result-td"> 
                      <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
                      <xsl:with-param name="attribute"><xsl:value-of select="@rank"/></xsl:with-param>
                      <xsl:with-param name="old_attribute"><xsl:value-of select="@old_rank"/></xsl:with-param>
                    </xsl:call-template>
                    <xsl:call-template name="attribute-comparison-result-td"> 
                      <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
                      <xsl:with-param name="attribute"><xsl:value-of select="@ref"/></xsl:with-param>
                      <xsl:with-param name="old_attribute"><xsl:value-of select="@old_ref"/></xsl:with-param>
                      <xsl:with-param name="call_template_name">gw-ref</xsl:with-param>
                    </xsl:call-template>
                  </tr>
                </xsl:for-each>
              </table>
		    </xsl:when>
		    <xsl:otherwise> 
		      <xsl:text> N/A </xsl:text>
		    </xsl:otherwise>
		  </xsl:choose>
        </xsl:if>
      </td>
	</tr>
  </xsl:template>

  <xsl:template match="vpn_profile|gateway_type">
	<tr>
	  <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
	  <td>
        <xsl:variable name='ref'>
          <xsl:value-of select="smc_img_util:getWellFormatedRef(@name)"/>
        </xsl:variable>
	    <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('vpn', @name)"/></xsl:attribute>
	    <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
	  </td>
	</tr>
  </xsl:template>

  <xsl:template name="gateway-ref">
    <xsl:param name="value"/>
    <xsl:if test="../vpn_site[@gateway_ref=$value]!=''">
      <ul class="smc_element_list">
        <xsl:for-each select= "../vpn_site[@gateway_ref=$value]">
          <li>
            <span>
             <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
             <xsl:call-template name="vpn-ref"><xsl:with-param name="value"><xsl:value-of select="@name"/></xsl:with-param></xsl:call-template>
           </span>
          </li>
        </xsl:for-each>
      </ul>
    </xsl:if>
  </xsl:template>

<!-- *** Formatting for rule base line.
     *** Including formatting for network element reference. -->

  <xsl:template name="network-element-ref">
    <xsl:param name="value"/>
    <xsl:variable name='ref'>
        <xsl:value-of select="smc_img_util:getWellFormatedRef($value)"/>
    </xsl:variable>
    <xsl:choose>
       <xsl:when test="/generic_import_export/*[@name=$value and contains($network-element, concat(',',name(),','))]">
         <xsl:for-each select="/generic_import_export/*[@name=$value and contains($network-element, concat(',',name(),','))]">
           <a>
		     <xsl:attribute name="href">#<xsl:value-of select="smc_xsl_util:getId('ne', $value)"/></xsl:attribute>
		     <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
	       </a>
         </xsl:for-each>
       </xsl:when>
       <xsl:when test="/generic_import_export/*[@name=$ref and contains($network-element, concat(',',name(),','))]">
         <xsl:for-each select="/generic_import_export/*[@name=$ref and contains($network-element, concat(',',name(),','))]">
           <a>
             <xsl:attribute name="href">#<xsl:value-of select="smc_xsl_util:getId('ne', $value)"/></xsl:attribute>
             <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
           </a>
         </xsl:for-each>
       </xsl:when>
       <xsl:otherwise>
       <em>
         <xsl:value-of select="$ref"/>
       </em>
     </xsl:otherwise></xsl:choose>     
  </xsl:template>
  
  <xsl:template name="service-ref">
    <xsl:param name="value"/>
    <xsl:variable name='ref'>
        <xsl:value-of select="smc_img_util:getWellFormatedRef($value)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="/generic_import_export/*[@name=$value and contains($service, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$value and contains($service, concat(',',name(),','))]">
		  <a>
		    <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
		    <xsl:value-of select="smc_img_util:getServiceImgHTMLRef( name(), @protocol_agent_ref, $ref )" disable-output-escaping="yes"/>
		  </a>
         </xsl:for-each>
       </xsl:when>
       <xsl:when test="/generic_import_export/*[@name=$ref and contains($service, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$ref and contains($service, concat(',',name(),','))]">
          <a>
            <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getServiceImgHTMLRef( name(), @protocol_agent_ref, $ref )" disable-output-escaping="yes"/>
          </a>
         </xsl:for-each>
       </xsl:when>
       <xsl:otherwise>
       <em>
         <xsl:value-of select="$ref"/>
       </em>
      </xsl:otherwise>
    </xsl:choose>     
  </xsl:template>

  <xsl:template name="matchexpression-ref">
    <xsl:param name="value"/>
    <xsl:variable name='ref'>
        <xsl:value-of select="smc_img_util:getWellFormatedRef($value)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="/generic_import_export/*[@name=$value]">
        <xsl:for-each select="/generic_import_export/*[@name=$value]">
          <a>
            <xsl:text> ( </xsl:text>
            <xsl:for-each select="match_element_entry">
                <xsl:if test="position() > 1">
                    <xsl:text> and </xsl:text>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="@class_id = '41'">
                        <xsl:value-of select="smc_img_util:getUserRef( @ref )" disable-output-escaping="yes"/>
                    </xsl:when>
                    <xsl:when test="@class_id = '42'">
                        <xsl:value-of select="smc_img_util:getUserRef( @ref )" disable-output-escaping="yes"/>
                    </xsl:when>
                    <xsl:when test="@class_id = '4145' or @class_id = '56' or @class_id = '68'">
			           <xsl:call-template name="situation-ref">
				            <xsl:with-param name="value"><xsl:value-of select="@ref"/></xsl:with-param>
				            <xsl:with-param name="class_id"><xsl:value-of select="@class_id"/></xsl:with-param>
			           </xsl:call-template>
			        </xsl:when>
			        <xsl:when test="@class_id >= '27' and @class_id &lt; '56'">
                        <xsl:call-template name="service-ref"><xsl:with-param name="value"><xsl:value-of select="@ref"/></xsl:with-param></xsl:call-template>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="@ref"/></xsl:with-param></xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <xsl:text> ) </xsl:text>
          </a>
         </xsl:for-each>
       </xsl:when>
       <xsl:when test="/generic_import_export/*[@name=$ref]">
        <xsl:for-each select="/generic_import_export/*[@name=$ref]">
          <a>
            <xsl:value-of select="name()" disable-output-escaping="yes"/>
          </a>
         </xsl:for-each>
       </xsl:when>
       <xsl:otherwise>
       <em>
         <xsl:value-of select="$ref"/>
       </em>
      </xsl:otherwise>
    </xsl:choose>     
  </xsl:template>
  
  <xsl:template name="category-ref">
    <xsl:param name="value"/>
    <xsl:param name="class_id"/>
    <xsl:variable name='ref'>
      <xsl:value-of select="smc_img_util:getWellFormatedRef($value)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="/generic_import_export/*[@name=$value and contains($category, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$value and contains($category, concat(',',name(),','))]">    
	      <a>
	        <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
	        <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref, $class_id )" disable-output-escaping="yes"/>
          </a>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="/generic_import_export/*[@name=$ref and contains($category, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$ref and contains($category, concat(',',name(),','))]">    
          <a>
            <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref, $class_id )" disable-output-escaping="yes"/>
          </a>
        </xsl:for-each>
      </xsl:when>      
      <xsl:otherwise>
        <em>
          <xsl:value-of select="$ref"/>
        </em>
      </xsl:otherwise>
    </xsl:choose>     
  </xsl:template>
  
  <xsl:template name="situation-ref">
    <xsl:param name="value"/>
    <xsl:param name="class_id"/>
    <xsl:variable name='ref'>
      <xsl:value-of select="smc_img_util:getWellFormatedRef($value)"/>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test="/generic_import_export/*[@name=$value and contains($situation, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$value and contains($situation, concat(',',name(),','))]">
          <a>
            <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref, $class_id )" disable-output-escaping="yes"/>
          </a>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="/generic_import_export/*[@name=$ref and contains($situation, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$ref and contains($situation, concat(',',name(),','))]">
          <a>
            <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref, $class_id )" disable-output-escaping="yes"/>
          </a>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <em>
          <xsl:value-of select="$ref"/>
        </em>
      </xsl:otherwise>
    </xsl:choose>      
  </xsl:template>
  
  <xsl:template name="protocol-ref">
    <xsl:param name="value"/>
    <xsl:variable name='ref'>
      <xsl:value-of select="smc_img_util:getWellFormatedRef($value)"/>
    </xsl:variable>    
    <xsl:choose>
      <xsl:when test="/generic_import_export/*[@name=$value and contains($protocol, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$value and contains($protocol, concat(',',name(),','))]">
          <a>
	        <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
          </a>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="/generic_import_export/*[@name=$ref and contains($protocol, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$ref and contains($protocol, concat(',',name(),','))]">
          <a>
            <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
          </a>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <em>
          <xsl:value-of select="$ref"/>
        </em>
      </xsl:otherwise>
    </xsl:choose>   
  </xsl:template>
  
  <xsl:template name="logical-interface-ref">
    <xsl:param name="value"/>
    <xsl:variable name='ref'>
      <xsl:value-of select="smc_img_util:getWellFormatedRef($value)"/>
    </xsl:variable>      
    <xsl:choose>
      <xsl:when test="/generic_import_export/*[@name=$value and name()='logical_interface']">
        <xsl:for-each select="/generic_import_export/*[@name=$value and name()='logical_interface']">
          <a>
            <xsl:attribute name="href">#<xsl:value-of select="smc_xsl_util:getId('li', $value)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( 'logical_interface', $ref )" disable-output-escaping="yes"/>
          </a>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="/generic_import_export/*[@name=$ref and name()='logical_interface']">
        <xsl:for-each select="/generic_import_export/*[@name=$ref and name()='logical_interface']">
          <a>
            <xsl:attribute name="href">#<xsl:value-of select="smc_xsl_util:getId('li', $value)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( 'logical_interface', $ref )" disable-output-escaping="yes"/>
          </a>
        </xsl:for-each>
      </xsl:when>
      <xsl:otherwise>
        <em>
          <xsl:value-of select="$ref"/>
        </em>
      </xsl:otherwise>
    </xsl:choose> 
  </xsl:template>
  
  <xsl:template name="mac-address-ref">
    <xsl:param name="value"/>
    <xsl:variable name='ref'>
      <xsl:value-of select="smc_img_util:getWellFormatedRef($value)"/>
    </xsl:variable>     
    <xsl:choose>
      <xsl:when test="/generic_import_export/*[@name=$value and contains($mac-address, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$value and contains($mac-address, concat(',',name(),','))]">
          <a>
            <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
          </a>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="/generic_import_export/*[@name=$ref and contains($mac-address, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$ref and contains($mac-address, concat(',',name(),','))]">
          <a>
            <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
          </a>
        </xsl:for-each>
      </xsl:when>      
      <xsl:otherwise>
        <em>
          <xsl:value-of select="$ref"/>
        </em>
      </xsl:otherwise>
    </xsl:choose>     
  </xsl:template>
  
  <xsl:template name="policy-ref">
    <xsl:param name="value"/>
    <xsl:variable name='ref'>
      <xsl:value-of select="smc_img_util:getWellFormatedRef($value)"/>
    </xsl:variable>       
    <xsl:choose>
      <xsl:when test="/generic_import_export/*[@name=$value and contains($policy, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$value and contains($policy, concat(',',name(),','))]">
	      <a> 
	      	<xsl:attribute name="href">#<xsl:value-of select="smc_xsl_util:getId('policy', $value)"/></xsl:attribute>
	      	<xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
		  </a>
        </xsl:for-each>
      </xsl:when>
      <xsl:when test="/generic_import_export/*[@name=$ref and contains($policy, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$ref and contains($policy, concat(',',name(),','))]">
          <a> 
            <xsl:attribute name="href">#<xsl:value-of select="smc_xsl_util:getId('policy', $value)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
          </a>
        </xsl:for-each>
      </xsl:when>      
      <xsl:otherwise>
        <em>
          <xsl:value-of select="$ref"/>
        </em>
      </xsl:otherwise>
    </xsl:choose>     
  </xsl:template>
  
  
  <xsl:template name="vpn-ref">
    <xsl:param name="value"/>
    <xsl:variable name='ref'>
      <xsl:value-of select="smc_img_util:getWellFormatedRef($value)"/>
    </xsl:variable>      
    <xsl:choose>
      <xsl:when test="/generic_import_export/*[@name=$value and contains($vpn, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$value and contains($vpn, concat(',',name(),','))]">
		  <a> 
		    <xsl:attribute name="href">#<xsl:value-of select="smc_xsl_util:getId('vpn', $value)"/></xsl:attribute>
		    <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
	      </a>
       </xsl:for-each>
     </xsl:when>
      <xsl:when test="/generic_import_export/*[@name=$ref and contains($vpn, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$ref and contains($vpn, concat(',',name(),','))]">
          <a> 
            <xsl:attribute name="href">#<xsl:value-of select="smc_xsl_util:getId('vpn', $value)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
          </a>
       </xsl:for-each>
     </xsl:when>     
     <xsl:otherwise>
       <em>
         <xsl:value-of select="$ref"/>
       </em>
     </xsl:otherwise></xsl:choose>     
  </xsl:template>
  
  <xsl:template name="gw-ref">
    <xsl:param name="value"/>
    <xsl:variable name='ref'>
      <xsl:value-of select="smc_img_util:getWellFormatedRef($value)"/>
    </xsl:variable>         
    <xsl:choose>
      <xsl:when test="/generic_import_export/*[@name=$value and contains($gateway, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$value and contains($gateway, concat(',',name(),','))]">
          <a> 
            <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
          </a>
       </xsl:for-each>
     </xsl:when>
      <xsl:when test="/generic_import_export/*[@name=$ref and contains($gateway, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$ref and contains($gateway, concat(',',name(),','))]">
          <a> 
            <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
          </a>
       </xsl:for-each>
     </xsl:when>     
     <xsl:otherwise>
       <em>
         <xsl:value-of select="$ref"/>
       </em>
     </xsl:otherwise></xsl:choose>     
  </xsl:template>
  
  <xsl:template name="qos-ref">
    <xsl:param name="value"/>
    <xsl:variable name='ref'>
      <xsl:value-of select="smc_img_util:getWellFormatedRef($value)"/>
    </xsl:variable>        
    <xsl:choose>
      <xsl:when test="/generic_import_export/*[@name=$value and contains($qos, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$value and contains($qos, concat(',',name(),','))]">
          <a> 
            <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
          </a>
       </xsl:for-each>
     </xsl:when>
      <xsl:when test="/generic_import_export/*[@name=$ref and contains($qos, concat(',',name(),','))]">
        <xsl:for-each select="/generic_import_export/*[@name=$ref and contains($qos, concat(',',name(),','))]">
          <a> 
            <xsl:attribute name="href">#<xsl:value-of select="generate-id(.)"/></xsl:attribute>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), $ref )" disable-output-escaping="yes"/>
          </a>
       </xsl:for-each>
     </xsl:when>     
     <xsl:otherwise>
       <em>
         <xsl:value-of select="$ref"/>
       </em>
     </xsl:otherwise></xsl:choose>     
  </xsl:template>
  
  <xsl:template match="match_source_ref|match_destination_ref|match_service_ref|match_tag_source_ref|match_tag_destination_ref|match_protocol_ref|match_situation_ref|match_logical_interface_ref">
    <span>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:choose>
         <xsl:when test="@type = 'network_element'">
           <xsl:choose>
              <xsl:when test="@value != 'ANY'">
                <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="smc_img_util:getImgHTMLRef( 'address_range', 'ANY' )" disable-output-escaping="yes"/>
              </xsl:otherwise>
           </xsl:choose>
         </xsl:when>
         <xsl:when test="@type = 'user_entry'">
            <xsl:value-of select="smc_img_util:getUserRef( @value )" disable-output-escaping="yes"/>
         </xsl:when>
         <xsl:when test="@type = 'application'">
            <xsl:call-template name="situation-ref">
            <xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param>
            <xsl:with-param name="class_id"><xsl:value-of select="@class_id"/></xsl:with-param>
           </xsl:call-template>
         </xsl:when>
         <xsl:when test="@type = 'match_expression'">
            <xsl:call-template name="matchexpression-ref">
                <xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param>
           </xsl:call-template>
         </xsl:when>
         <xsl:when test="@type = 'service'">
           <xsl:choose>
              <xsl:when test="@value != 'ANY'">
                <xsl:call-template name="service-ref"><xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="smc_img_util:getImgHTMLRef( 'gen_service_group', 'ANY' )" disable-output-escaping="yes"/>
              </xsl:otherwise>
           </xsl:choose>           
         </xsl:when>
         <xsl:when test="@type = 'category'">
           <xsl:choose>
              <xsl:when test="@value != 'ANY'">
                <xsl:call-template name="category-ref">
                  <xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param>
                  <xsl:with-param name="class_id"><xsl:value-of select="@class_id"/></xsl:with-param>
                </xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="smc_img_util:getImgHTMLRef( 'situation', 'ANY', '4097' )" disable-output-escaping="yes"/>
              </xsl:otherwise>
           </xsl:choose>
         </xsl:when>
         <xsl:when test="@type = 'protocol_agent'">
           <xsl:choose>
              <xsl:when test="@value != 'ANY'">
                <xsl:call-template name="protocol-ref"><xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="smc_img_util:getImgHTMLRef( 'protocol_agent', 'ANY' )" disable-output-escaping="yes"/>
              </xsl:otherwise>
           </xsl:choose>
           <xsl:call-template name="protocol-ref"><xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
         </xsl:when>
         <xsl:when test="@type = 'situation'"><!--  <xsl:when test="@type = 'situation' and @value != 'ANY'">  -->
           <xsl:call-template name="situation-ref">
            <xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param>
            <xsl:with-param name="class_id"><xsl:value-of select="@class_id"/></xsl:with-param>
           </xsl:call-template>
         </xsl:when>
         <xsl:when test="@type = 'logical_interface'">
           <xsl:call-template name="logical-interface-ref"><xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
         </xsl:when>
         <xsl:when test="@type = 'mac_address'">
           <xsl:call-template name="mac-address-ref"><xsl:with-param name="value"><xsl:value-of select="@value"/></xsl:with-param></xsl:call-template>
         </xsl:when>
         <xsl:when test="@type = 'string' and @value = 'none'">
           <!--  <strong><xsl:text>NONE</xsl:text></strong> --> 
         </xsl:when>
         <xsl:otherwise>
           <strong><xsl:value-of select="@value"/></strong>
         </xsl:otherwise>
       </xsl:choose>
    </span>
  </xsl:template>

  <xsl:template match="match_sources|match_destinations|match_services|match_situations|match_protocols|match_tag_sources|match_tag_destinations|match_logical_interfaces">
    <xsl:if test="node()">
      <ul class="smc_element_list">
        <li>
          <xsl:apply-templates select="node()"/>
        </li>
      </ul>
    </xsl:if>
  </xsl:template>

  <xsl:template match="rule_time_range">
   <span>
    <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
    
    <!-- month range -->
    <xsl:if test="@month_range and @month_range != 'jan to dec'">
        <xsl:value-of select="@month_range"/><xsl:text> </xsl:text>
    </xsl:if>
	<xsl:for-each select="rule_day_range">
	  <!-- day range -->
	  <xsl:if test="@week_day_range and @week_day_range != 'mon to sun'">
		<xsl:value-of select="@week_day_range"/>
	  </xsl:if>
	  <xsl:if test="@month_day_range and @month_day_range != '1 to 31'">
		<xsl:value-of select="@month_day_range"/>
	  </xsl:if>
	  <!-- time range -->
      <xsl:text> </xsl:text>
      <xsl:if test="@begin_hour !='0' or @begin_minute!='0' or @end_hour!='23' or @end_minute!='59'">
        <xsl:value-of select="@begin_hour"/>:<xsl:value-of select="@begin_minute"/> to <xsl:value-of select="@end_hour"/>:<xsl:value-of select="@end_minute"/> UTC
      </xsl:if>
    </xsl:for-each>
     </span>
  </xsl:template>
  
  <xsl:template match="match_vpn">
    <span>
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:if test="@match_type = 'no_vpn'"><xsl:text>No VPN</xsl:text></xsl:if>
	  <xsl:for-each select="vpn_ref">
        <xsl:call-template name="vpn-ref"><xsl:with-param name="value"><xsl:value-of select="@ref"/></xsl:with-param></xsl:call-template>
      </xsl:for-each>
    </span>
  </xsl:template>
  
  <xsl:template match="user_match" mode="auth">
    <xsl:if test="user">
    <ul class="smc_element_list">
      <xsl:for-each select="user">
        <!-- if it is not the first, we add an end line 
        <xsl:if test="position() != 1">
          <xsl:text> </xsl:text>
        </xsl:if>
        -->
        <li>
          <span>
            <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
              <xsl:choose>
                <xsl:when test="@type='user' or @type='group_discrete'">
                  <xsl:value-of select="smc_img_util:getPredefinedImgHTMLRef( @type, @ref )" disable-output-escaping="yes"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="smc_img_util:getPredefinedImgHTMLRef( 'group', @ref )" disable-output-escaping="yes"/>
                </xsl:otherwise>
              </xsl:choose>
            <xsl:text> in </xsl:text>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( 'domain', @domain )" disable-output-escaping="yes"/>
          </span>
        </li>
      </xsl:for-each>
    </ul>
    </xsl:if>
    <xsl:if test="@authorize_client='true'">
      <xsl:text>Authorize Client IP</xsl:text>
	  <xsl:if test="@timeout"> Timeout: <xsl:value-of select="@timeout"/>
	    <xsl:text>s</xsl:text>
	  </xsl:if>
	  <xsl:text>  with Method: </xsl:text>
	  <xsl:value-of select="@method"/>
	  <xsl:text> on: </xsl:text>
	  <ul class="smc_element_list">
        <xsl:for-each select="auth_service">
          <!-- if it is not the first, we add an end line
          <xsl:if test="position() != 1">
            <xsl:text> </xsl:text>
          </xsl:if>
          -->
          <li> 
            <span>
              <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
              <xsl:value-of select="smc_img_util:getImgHTMLRef( 'authentication_service', @ref )" disable-output-escaping="yes"/>
              <xsl:text> service</xsl:text>
            </span>
          </li>
        </xsl:for-each>
      </ul>
	</xsl:if>
  </xsl:template>

  <xsl:template match="user_match" mode="usr">
    <xsl:if test="user">
    <ul class="smc_element_list">
      <xsl:for-each select="user">
        <!-- if it is not the first, we add an end line 
        <xsl:if test="position() != 1">
          <xsl:text> </xsl:text>
        </xsl:if>
        -->
        <li>
          <span>
            <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
              <xsl:choose>
                <xsl:when test="@type='user' or @type='group_discrete'">
                  <xsl:value-of select="smc_img_util:getPredefinedImgHTMLRef( @type, @ref )" disable-output-escaping="yes"/>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="smc_img_util:getPredefinedImgHTMLRef( 'group', @ref )" disable-output-escaping="yes"/>
                </xsl:otherwise>
              </xsl:choose>
            <xsl:text> in </xsl:text>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( 'domain', @domain )" disable-output-escaping="yes"/>
          </span>
        </li>
      </xsl:for-each>
    </ul>
    </xsl:if>
  </xsl:template>

  <xsl:template match="option" mode="qos">
    <xsl:call-template name="attribute-comparison-result-td"> 
      <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
      <xsl:with-param name="attribute"><xsl:value-of select="@qos_class_ref"/></xsl:with-param>
      <xsl:with-param name="old_attribute"><xsl:value-of select="@old_qos_class_ref"/></xsl:with-param>
      <xsl:with-param name="call_template_name">qos-ref</xsl:with-param>
    </xsl:call-template>
  </xsl:template>
     
  <xsl:template match="option" mode="nat">
	<xsl:for-each select="nat_src">
        <xsl:if test="load_balancing_nat">
          <span>
            <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="load_balancing_nat/@comparison_result"/></xsl:with-param></xsl:call-template>
		    <xsl:text>Source: Load Balancing NAT</xsl:text>
		  </span>
        </xsl:if>
		<xsl:if test="dynamic_nat">
		  <span>
            <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="dynamic_nat/@comparison_result"/></xsl:with-param></xsl:call-template>
            <xsl:text>Source: Dynamic NAT: </xsl:text>
		    <xsl:for-each select="dynamic_nat/packet_description">
			  <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="@ne_ref"/></xsl:with-param></xsl:call-template>
	        </xsl:for-each>
	      </span>
        </xsl:if>
	    <xsl:if test="static_nat">
	      <span>
            <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="static_nat/@comparison_result"/></xsl:with-param></xsl:call-template>
            <xsl:text>Source NAT: </xsl:text>
		    <xsl:for-each select="static_nat/packet_description">
			  <xsl:if test="@ne_ref">
 			    <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="@ne_ref"/></xsl:with-param></xsl:call-template>
			  </xsl:if>
			  <xsl:if test="@min_ip">
			    <xsl:value-of select="@min_ip"/>
			    <xsl:if test="@max_ip">
		  	      <xsl:text>-</xsl:text><xsl:value-of select="@max_ip"/>
			    </xsl:if>
			    <xsl:if test="@netmask">
			      <xsl:text>/</xsl:text><xsl:value-of select="@netmask"/>
			    </xsl:if>
			  </xsl:if>
			  <xsl:if test="@first_port">
			    <xsl:text> and </xsl:text><xsl:value-of select="@first_port"/><xsl:text>-</xsl:text><xsl:value-of select="@last_port"/>
			  </xsl:if>
			</xsl:for-each>
			<xsl:text> to </xsl:text>
		    <xsl:for-each select="static_nat/packet_description_new">
			  <xsl:if test="@ne_ref">
				<xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="@ne_ref"/></xsl:with-param></xsl:call-template>
			  </xsl:if>
			  <xsl:if test="@min_ip">
				<xsl:value-of select="@min_ip"/>
				<xsl:if test="@max_ip">
				  <xsl:text>-</xsl:text><xsl:value-of select="@max_ip"/>
				</xsl:if>
				<xsl:if test="@netmask">
				  <xsl:text>/</xsl:text><xsl:value-of select="@netmask"/>
			  </xsl:if>
			</xsl:if>
			<xsl:if test="@first_port">
			  <xsl:text> and </xsl:text><xsl:value-of select="@first_port"/><xsl:text>-</xsl:text><xsl:value-of select="@last_port"/>
			</xsl:if>
		  </xsl:for-each>
	    </span>
      </xsl:if>	
	</xsl:for-each>
	 
    <xsl:for-each select="nat_dst">
      <xsl:if test="load_balancing_nat">
        <span>
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="load_balancing_nat/@comparison_result"/></xsl:with-param></xsl:call-template>
		  <xsl:text>Destination: Load Balancing NAT</xsl:text>
	    </span>
      </xsl:if>
      <xsl:if test="dynamic_nat">
        <span>
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="dynamic_nat/@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:text>Destination: Dynamic NAT: </xsl:text>
		  <xsl:for-each select="dynamic_nat/packet_description">
		    <span>
              <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
              <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="@ne_ref"/></xsl:with-param></xsl:call-template>
            </span> 
		  </xsl:for-each>
        </span>
      </xsl:if> 
	  <xsl:if test="static_nat">
	    <span>
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="static_nat/@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:text>Destination NAT: </xsl:text>
		  <xsl:for-each select="static_nat/packet_description">
  	        <xsl:if test="@ne_ref">
  	          <span>
                <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
                <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="@ne_ref"/></xsl:with-param></xsl:call-template>
              </span>
			</xsl:if>
		    <xsl:if test="@min_ip">
		      <xsl:value-of select="@min_ip"/>
	   	      <xsl:if test="@max_ip">
			    <xsl:text>-</xsl:text><xsl:value-of select="@max_ip"/>
		   	  </xsl:if>
			  <xsl:if test="@netmask">
			    <xsl:text>/</xsl:text><xsl:value-of select="@netmask"/>
			  </xsl:if>
			</xsl:if>
		    <xsl:if test="@first_port">
		      <xsl:text> and </xsl:text><xsl:value-of select="@first_port"/><xsl:text>-</xsl:text><xsl:value-of select="@last_port"/>
		    </xsl:if>
		  </xsl:for-each>
	      <xsl:text> to </xsl:text>
	      <xsl:for-each select="static_nat/packet_description_new">
	 	    <xsl:if test="@ne_ref">
	 	      <span>
                <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
		        <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="@ne_ref"/></xsl:with-param></xsl:call-template>
		      </span>
		    </xsl:if>
		    <xsl:if test="@min_ip">
		      <xsl:value-of select="@min_ip"/>
		        <xsl:if test="@max_ip">
			  <xsl:text>-</xsl:text><xsl:value-of select="@max_ip"/>
	   	    </xsl:if>
		    <xsl:if test="@netmask">
  	          <xsl:text>/</xsl:text><xsl:value-of select="@netmask"/>
		    </xsl:if>
		    </xsl:if>
		      <xsl:if test="@first_port">
		       <xsl:text> and </xsl:text><xsl:value-of select="@first_port"/><xsl:text>-</xsl:text><xsl:value-of select="@last_port"/>
		    </xsl:if>
		  </xsl:for-each>
	    </span>
      </xsl:if>
	</xsl:for-each>
  </xsl:template>

  <xsl:template match="rule_entry" mode="fw_access">
    <xsl:choose>
      <xsl:when test="insert_point_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_access_insert_point</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="13"><xsl:value-of select="@name"/></td>
        </tr>
      </xsl:when>
      <xsl:when test="comment_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_access_comment</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="13">
            <xsl:call-template name="attribute-comparison-result"> 
              <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
              <xsl:with-param name="attribute"><xsl:value-of select="@comment"/></xsl:with-param>
              <xsl:with-param name="old_attribute"><xsl:value-of select="@old_comment"/></xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="access_rule" mode="fw"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="rule_entry" mode="fw_ipv6_access">
    <xsl:choose>
      <xsl:when test="insert_point_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_ipv6_access_insert_point</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="13"><xsl:value-of select="@name"/></td>
        </tr>
      </xsl:when>
      <xsl:when test="comment_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_ipv6_access_comment</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="13">
            <xsl:call-template name="attribute-comparison-result"> 
              <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
              <xsl:with-param name="attribute"><xsl:value-of select="@comment"/></xsl:with-param>
              <xsl:with-param name="old_attribute"><xsl:value-of select="@old_comment"/></xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="ipv6_rule" mode="fw"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="access_rule|ipv6_rule" mode="fw">
  	<tr>
  	  <xsl:choose>
  	    <xsl:when test="../@is_disabled = 'true'"><xsl:attribute name="class">disabled</xsl:attribute></xsl:when>
  	    <xsl:when test="../../../../@comparison_result"></xsl:when>
  	    <xsl:otherwise>
		  <xsl:if test="action[@type='allow']"><xsl:attribute name="class">allowed</xsl:attribute></xsl:if> 
		  <xsl:if test="action[@type='refuse']"><xsl:attribute name="class">refuse</xsl:attribute></xsl:if>
		  <xsl:if test="action[@type='discard']"><xsl:attribute name="class">discard</xsl:attribute></xsl:if>
		  <xsl:if test="action[@type='blacklist']"><xsl:attribute name="class">blacklist</xsl:attribute></xsl:if>
		  <xsl:if test="action[@type='jump']"><xsl:attribute name="class">jump</xsl:attribute></xsl:if>
	    </xsl:otherwise>
	  </xsl:choose>

      <!-- rule comparison  -->
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param></xsl:call-template>
       <xsl:call-template name="comparison-result-td-for-rule">
         <xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param>
         <xsl:with-param name="moved_result"><xsl:value-of select="../@moved_result"/></xsl:with-param>
       </xsl:call-template>

      <!-- ID -->
      <td><xsl:value-of select="count(parent::rule_entry/preceding-sibling::rule_entry) + 1"/></td>
	  <!-- Source -->
	  <td><xsl:apply-templates select="match_part/match_sources"/></td>
	  <!-- Destinations -->
      <td><xsl:apply-templates select="match_part/match_destinations"/></td>
	  <!-- Services -->
      <td><xsl:apply-templates select="match_part/match_services"/></td>
	  <!-- Action -->
	  <xsl:value-of select="smc_policy_action_util:getActionHTML(., /generic_import_export/blacklist_response, 'false', 'false', 'false')" disable-output-escaping="yes"/>
	  <!-- Authentication -->
      <td><xsl:apply-templates select="match_part/user_match" mode="auth"/></td>
 	  <!-- QoS Class -->
      <xsl:apply-templates select="option" mode="qos"/>
	  <!-- Option -->
	  <xsl:value-of select="smc_policy_option_util:getOptionHTML(option, 'false', 'false')" disable-output-escaping="yes"/>
	  <!-- Rule Time Range -->
	  <td>
	    <xsl:choose>
	      <xsl:when test="match_part/rule_time_range[@comparison_result='added_element'] or match_part/rule_time_range[@comparison_result='removed_element']">
	        <xsl:apply-templates select="match_part/rule_time_range[@comparison_result='added_element']"/>
	        <xsl:text> </xsl:text>
	        <xsl:apply-templates select="match_part/rule_time_range[@comparison_result='removed_element']"/>
	      </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="match_part/rule_time_range"/>
          </xsl:otherwise>	      
	    </xsl:choose>	  
	  </td>
	  <!-- Comment -->
      <td>
        <xsl:call-template name="attribute-comparison-result"> 
          <xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param>
          <xsl:with-param name="attribute"><xsl:value-of select="../@comment"/></xsl:with-param>
          <xsl:with-param name="old_attribute"><xsl:value-of select="../@old_comment"/></xsl:with-param>
        </xsl:call-template>
      </td>
	  <!-- Tag -->
      <td><xsl:text>@</xsl:text><xsl:value-of select="../@tag"/></td>
	  <!-- Source VPN -->
      <td><xsl:apply-templates select="match_part/match_vpn"/></td>
    </tr>
  </xsl:template>
  
  <xsl:template match="rule_entry" mode="ips_access">
    <xsl:choose>
      <xsl:when test="insert_point_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">ips_access_insert_point</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="10"><xsl:value-of select="@name"/></td>
        </tr>
      </xsl:when>
      <xsl:when test="comment_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">ips_access_comment</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="10">
            <xsl:call-template name="attribute-comparison-result"> 
              <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
              <xsl:with-param name="attribute"><xsl:value-of select="@comment"/></xsl:with-param>
              <xsl:with-param name="old_attribute"><xsl:value-of select="@old_comment"/></xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:when>    
      <xsl:otherwise>
        <xsl:apply-templates select="access_rule" mode="ips"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="rule_entry" mode="ips_ethernet">
    <xsl:choose>
      <xsl:when test="insert_point_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">ips_ethernet_insert_point</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="10"><xsl:value-of select="@name"/></td>
        </tr>
      </xsl:when>
      <xsl:when test="comment_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">ips_ethernet_comment</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="10">
            <xsl:call-template name="attribute-comparison-result"> 
              <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
              <xsl:with-param name="attribute"><xsl:value-of select="@comment"/></xsl:with-param>
              <xsl:with-param name="old_attribute"><xsl:value-of select="@old_comment"/></xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="ethernet_rule" mode="ips"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="rule_entry" mode="ips_ipv6_access">
    <xsl:choose>
      <xsl:when test="insert_point_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">ips_ipv6_access_insert_point</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="10"><xsl:value-of select="@name"/></td>
        </tr>
      </xsl:when>
      <xsl:when test="comment_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">ips_ipv6_access_comment</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="10">
            <xsl:call-template name="attribute-comparison-result"> 
              <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
              <xsl:with-param name="attribute"><xsl:value-of select="@comment"/></xsl:with-param>
              <xsl:with-param name="old_attribute"><xsl:value-of select="@old_comment"/></xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="ipv6_rule" mode="ips"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>  

  <xsl:template match="rule_entry" mode="fw_layer2_access">
    <xsl:choose>
      <xsl:when test="insert_point_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_layer2_access_insert_point</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="10"><xsl:value-of select="@name"/></td>
        </tr>
      </xsl:when>
      <xsl:when test="comment_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_layer2_access_comment</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="10">
            <xsl:call-template name="attribute-comparison-result"> 
              <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
              <xsl:with-param name="attribute"><xsl:value-of select="@comment"/></xsl:with-param>
              <xsl:with-param name="old_attribute"><xsl:value-of select="@old_comment"/></xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:when>    
      <xsl:otherwise>
        <xsl:apply-templates select="access_rule" mode="fw_layer2"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="rule_entry" mode="fw_layer2_ethernet">
    <xsl:choose>
      <xsl:when test="insert_point_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_layer2_ethernet_insert_point</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="10"><xsl:value-of select="@name"/></td>
        </tr>
      </xsl:when>
      <xsl:when test="comment_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_layer2_ethernet_comment</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="10">
            <xsl:call-template name="attribute-comparison-result"> 
              <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
              <xsl:with-param name="attribute"><xsl:value-of select="@comment"/></xsl:with-param>
              <xsl:with-param name="old_attribute"><xsl:value-of select="@old_comment"/></xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="ethernet_rule" mode="fw_layer2"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match="rule_entry" mode="fw_layer2_ipv6_access">
    <xsl:choose>
      <xsl:when test="insert_point_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_layer2_ipv6_access_insert_point</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="10"><xsl:value-of select="@name"/></td>
        </tr>
      </xsl:when>
      <xsl:when test="comment_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_layer2_ipv6_access_comment</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="10">
            <xsl:call-template name="attribute-comparison-result"> 
              <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
              <xsl:with-param name="attribute"><xsl:value-of select="@comment"/></xsl:with-param>
              <xsl:with-param name="old_attribute"><xsl:value-of select="@old_comment"/></xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="ipv6_rule" mode="fw_layer2"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>  
  
   <xsl:template match="access_rule|ipv6_rule|ethernet_rule" mode="ips">
    <tr>
      <xsl:choose>
        <xsl:when test="../@is_disabled = 'true'"><xsl:attribute name="class">disabled</xsl:attribute></xsl:when>
        <xsl:when test="../../../../@comparison_result"></xsl:when>
        <xsl:otherwise>
          <xsl:if test="action[@type='allow']"><xsl:attribute name="class">allowed</xsl:attribute></xsl:if> 
          <xsl:if test="action[@type='refuse']"><xsl:attribute name="class">refuse</xsl:attribute></xsl:if>
          <xsl:if test="action[@type='discard']"><xsl:attribute name="class">discard</xsl:attribute></xsl:if>
          <xsl:if test="action[@type='blacklist']"><xsl:attribute name="class">blacklist</xsl:attribute></xsl:if>
          <xsl:if test="action[@type='jump']"><xsl:attribute name="class">jump</xsl:attribute></xsl:if>
        </xsl:otherwise>
      </xsl:choose>
      
      <!-- rule comparison  -->
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param></xsl:call-template>
       <xsl:call-template name="comparison-result-td-for-rule">
         <xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param>
         <xsl:with-param name="moved_result"><xsl:value-of select="../@moved_result"/></xsl:with-param>
       </xsl:call-template>
      
      <!-- ID -->
      <td><xsl:value-of select="count(parent::rule_entry/preceding-sibling::rule_entry) + 1"/></td>
      <!-- Logical Interface -->
      <td>
        <!-- special handling (no match_logical_interfaces node means ANY)-->
        <xsl:choose>
          <xsl:when test="match_part/match_logical_interfaces">
            <xsl:apply-templates select="match_part/match_logical_interfaces"/>
            <xsl:if test="match_part/match_logical_interfaces/@comparison_result = 'removed_element'">
              <span class="added">
                <xsl:value-of select="smc_img_util:getImgHTMLRef( 'logical_interface', 'ANY' )" disable-output-escaping="yes"/>
              </span>
            </xsl:if>
            <xsl:if test="match_part/match_logical_interfaces/@comparison_result = 'added_element'">
              <span class="removed">
                <xsl:value-of select="smc_img_util:getImgHTMLRef( 'logical_interface', 'ANY' )" disable-output-escaping="yes"/>
              </span>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( 'logical_interface', 'ANY' )" disable-output-escaping="yes"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <!-- Source -->
      <td><xsl:apply-templates select="match_part/match_sources"/></td>
      <!-- Destinations -->
      <td><xsl:apply-templates select="match_part/match_destinations"/></td>
      <!-- Services -->
      <td><xsl:apply-templates select="match_part/match_services"/></td>
      <!-- Action -->
      <xsl:value-of select="smc_policy_action_util:getActionHTML(., /generic_import_export/blacklist_response, 'false', 'true', 'false')" disable-output-escaping="yes"/>
      <!-- Option -->
      <xsl:value-of select="smc_policy_option_util:getOptionHTML(option, 'false', 'true')" disable-output-escaping="yes"/>
      <!-- Rule Time Range -->
      <xsl:if test="../access_rule | ../ipv6_rule">
        <td>
          <xsl:choose>
            <xsl:when test="match_part/rule_time_range[@comparison_result='added_element'] or match_part/rule_time_range[@comparison_result='removed_element']">
              <xsl:apply-templates select="match_part/rule_time_range[@comparison_result='added_element']"/>
              <xsl:text> </xsl:text>
              <xsl:apply-templates select="match_part/rule_time_range[@comparison_result='removed_element']"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates select="match_part/rule_time_range"/>
            </xsl:otherwise>        
          </xsl:choose>     
        </td>
      </xsl:if>
      <!-- Comment -->
      <td>
        <xsl:call-template name="attribute-comparison-result"> 
          <xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param>
          <xsl:with-param name="attribute"><xsl:value-of select="../@comment"/></xsl:with-param>
          <xsl:with-param name="old_attribute"><xsl:value-of select="../@old_comment"/></xsl:with-param>
        </xsl:call-template>
      </td>
      <!-- Tag -->
      <td><xsl:text>@</xsl:text><xsl:value-of select="../@tag"/></td>
    </tr>
   </xsl:template>
  
   <xsl:template match="access_rule|ipv6_rule|ethernet_rule" mode="fw_layer2">
    <tr>
      <xsl:choose>
        <xsl:when test="../@is_disabled = 'true'"><xsl:attribute name="class">disabled</xsl:attribute></xsl:when>
        <xsl:when test="../../../../@comparison_result"></xsl:when>
        <xsl:otherwise>
          <xsl:if test="action[@type='allow']"><xsl:attribute name="class">allowed</xsl:attribute></xsl:if> 
          <xsl:if test="action[@type='refuse']"><xsl:attribute name="class">refuse</xsl:attribute></xsl:if>
          <xsl:if test="action[@type='discard']"><xsl:attribute name="class">discard</xsl:attribute></xsl:if>
          <xsl:if test="action[@type='blacklist']"><xsl:attribute name="class">blacklist</xsl:attribute></xsl:if>
          <xsl:if test="action[@type='jump']"><xsl:attribute name="class">jump</xsl:attribute></xsl:if>
        </xsl:otherwise>
      </xsl:choose>
      
      <!-- rule comparison  -->
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param></xsl:call-template>
       <xsl:call-template name="comparison-result-td-for-rule">
         <xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param>
         <xsl:with-param name="moved_result"><xsl:value-of select="../@moved_result"/></xsl:with-param>
       </xsl:call-template>
      
      <!-- ID -->
      <td><xsl:value-of select="count(parent::rule_entry/preceding-sibling::rule_entry) + 1"/></td>
      <!-- Logical Interface -->
      <td>
        <!-- special handling (no match_logical_interfaces node means ANY)-->
        <xsl:choose>
          <xsl:when test="match_part/match_logical_interfaces">
            <xsl:apply-templates select="match_part/match_logical_interfaces"/>
            <xsl:if test="match_part/match_logical_interfaces/@comparison_result = 'removed_element'">
              <span class="added">
                <xsl:value-of select="smc_img_util:getImgHTMLRef( 'logical_interface', 'ANY' )" disable-output-escaping="yes"/>
              </span>
            </xsl:if>
            <xsl:if test="match_part/match_logical_interfaces/@comparison_result = 'added_element'">
              <span class="removed">
                <xsl:value-of select="smc_img_util:getImgHTMLRef( 'logical_interface', 'ANY' )" disable-output-escaping="yes"/>
              </span>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( 'logical_interface', 'ANY' )" disable-output-escaping="yes"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <!-- Source -->
      <td><xsl:apply-templates select="match_part/match_sources"/></td>
      <!-- Destinations -->
      <td><xsl:apply-templates select="match_part/match_destinations"/></td>
      <!-- Services -->
      <td><xsl:apply-templates select="match_part/match_services"/></td>
      <!-- Action -->
      <xsl:value-of select="smc_policy_action_util:getActionHTML(., /generic_import_export/blacklist_response, 'false', 'false', 'true')" disable-output-escaping="yes"/>
      <!-- Option -->
      <xsl:value-of select="smc_policy_option_util:getOptionHTML(option, 'false', 'true')" disable-output-escaping="yes"/>
      <!-- Rule Time Range -->
      <xsl:if test="../access_rule | ../ipv6_rule">
        <td>
          <xsl:choose>
            <xsl:when test="match_part/rule_time_range[@comparison_result='added_element'] or match_part/rule_time_range[@comparison_result='removed_element']">
              <xsl:apply-templates select="match_part/rule_time_range[@comparison_result='added_element']"/>
              <xsl:text> </xsl:text>
              <xsl:apply-templates select="match_part/rule_time_range[@comparison_result='removed_element']"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:apply-templates select="match_part/rule_time_range"/>
            </xsl:otherwise>        
          </xsl:choose>     
        </td>
      </xsl:if>
      <!-- Comment -->
      <td>
        <xsl:call-template name="attribute-comparison-result"> 
          <xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param>
          <xsl:with-param name="attribute"><xsl:value-of select="../@comment"/></xsl:with-param>
          <xsl:with-param name="old_attribute"><xsl:value-of select="../@old_comment"/></xsl:with-param>
        </xsl:call-template>
      </td>
      <!-- Tag -->
      <td><xsl:text>@</xsl:text><xsl:value-of select="../@tag"/></td>
    </tr>
  </xsl:template>
  
  <xsl:template match="rule_entry" mode="inspection">
    <xsl:choose>
      <xsl:when test="insert_point_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">inspection_insert_point</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="12"><xsl:value-of select="@name"/></td>
        </tr>
      </xsl:when>
      <xsl:when test="comment_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">inspection_comment</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="12">
            <xsl:call-template name="attribute-comparison-result"> 
              <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
              <xsl:with-param name="attribute"><xsl:value-of select="@comment"/></xsl:with-param>
              <xsl:with-param name="old_attribute"><xsl:value-of select="@old_comment"/></xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="inspection_rule"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template> 

   <xsl:template match="inspection_rule">
   	 <tr>
   	   <xsl:choose>
        <xsl:when test="../@is_disabled = 'true'"><xsl:attribute name="class">disabled</xsl:attribute></xsl:when>
        <xsl:when test="../../../../@comparison_result"></xsl:when>
        <xsl:otherwise>
          <xsl:if test="action[@type='allow']"><xsl:attribute name="class">allowed</xsl:attribute></xsl:if> 
          <xsl:if test="action[@type='terminate']"><xsl:attribute name="class">discard</xsl:attribute></xsl:if>
        </xsl:otherwise>
      </xsl:choose>
   	   
   	   <!-- rule comparison  -->
       <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param></xsl:call-template>
       <xsl:call-template name="comparison-result-td-for-rule">
         <xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param>
         <xsl:with-param name="moved_result"><xsl:value-of select="../@moved_result"/></xsl:with-param>
       </xsl:call-template>
      
       <!-- ID -->
       <td><xsl:value-of select="count(parent::rule_entry/preceding-sibling::rule_entry) + 1"/></td>
	   <!-- Situations -->
	   <td>
        <!-- special handling (no match_situations node means ANY)-->
        <xsl:choose>
          <xsl:when test="match_part/match_situations">
            <xsl:apply-templates select="match_part/match_situations"/>
            <xsl:if test="match_part/match_situations/@comparison_result = 'removed_element'">
                <span class="added">
                    <xsl:value-of select="smc_img_util:getImgHTMLRef( 'situation', 'ANY', '4097' )" disable-output-escaping="yes"/>
                </span>
            </xsl:if>
            <xsl:if test="match_part/match_situations/@comparison_result = 'added_element'">
                <span class="removed">
                    <xsl:value-of select="smc_img_util:getImgHTMLRef( 'situation', 'ANY', '4097' )" disable-output-escaping="yes"/>
                </span>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( 'situation', 'ANY', '4097' )" disable-output-escaping="yes"/>
          </xsl:otherwise>
        </xsl:choose>
      </td>
	   <!-- severity -->
	  <td> 
        <xsl:choose>
	        <xsl:when test="match_part/@comparison_result='modified_element' and (match_part/@old_min !='' or match_part/@old_max !='')">
	          <ul class="smc_comparison_element_list">
	            <li class="added">
                  <xsl:choose>
                    <xsl:when test="match_part/@min = '1' and match_part/@max = '10'">
   	                ANY
   	                </xsl:when>
                    <xsl:otherwise>
                       <xsl:value-of select="match_part/@min"/>-<xsl:value-of select="match_part/@max"/>
                    </xsl:otherwise>
                  </xsl:choose>
	            </li>
	            <li class="removed">
	              <xsl:choose>
                    <xsl:when test="match_part/@old_min = '1' and match_part/@old_max = '10'">
                        ANY
                    </xsl:when>
                    <xsl:when test="(match_part/@min = '1' and not(match_part/@old_min))and match_part/@old_max = '10'">
                        ANY
                    </xsl:when>
                    <xsl:when test="match_part/@old_min = '1' and (match_part/@max = '10' and not(match_part/@old_max))">
                        ANY
                    </xsl:when>
                    <xsl:when test="not(match_part/@old_min)">
                      <xsl:value-of select="match_part/@min"/>-<xsl:value-of select="match_part/@old_max"/>
                    </xsl:when>
                    <xsl:when test="not(match_part/@old_max)">
                      <xsl:value-of select="match_part/@old_min"/>-<xsl:value-of select="match_part/@max"/>
                    </xsl:when>
                    <xsl:otherwise>
                      <xsl:value-of select="match_part/@old_min"/>-<xsl:value-of select="match_part/@old_max"/>
                    </xsl:otherwise>
                  </xsl:choose>
	            </li>       
	          </ul>
	        </xsl:when>
	        <xsl:otherwise>
	          <xsl:choose>
                <xsl:when test="match_part/@min = '1' and match_part/@max = '10'">
                  ANY
                </xsl:when>
                <xsl:otherwise>
                  <xsl:value-of select="match_part/@min"/>-<xsl:value-of select="match_part/@max"/>
                </xsl:otherwise>
              </xsl:choose>	        
	        </xsl:otherwise>
        </xsl:choose>  
       </td>
   	   <!-- Logical Interface -->
   	   <td>
        <!-- special handling (no match_logical_interfaces node means ANY)-->
        <xsl:choose>
          <xsl:when test="match_part/match_logical_interfaces">
            <xsl:apply-templates select="match_part/match_logical_interfaces"/>
            <xsl:if test="match_part/match_logical_interfaces/@comparison_result = 'removed_element'">
                <span class="added">
                    <xsl:value-of select="smc_img_util:getImgHTMLRef( 'logical_interface', 'ANY' )" disable-output-escaping="yes"/>
                </span>
            </xsl:if>
            <xsl:if test="match_part/match_logical_interfaces/@comparison_result = 'added_element'">
                <span class="removed">
                    <xsl:value-of select="smc_img_util:getImgHTMLRef( 'logical_interface', 'ANY' )" disable-output-escaping="yes"/>
                </span>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
             <xsl:value-of select="smc_img_util:getImgHTMLRef( 'logical_interface', 'ANY' )" disable-output-escaping="yes"/>
          </xsl:otherwise>
        </xsl:choose>
       </td>
	   <!-- Sources -->
       <td><xsl:apply-templates select="match_part/match_sources"/></td>
	   <!-- Destinations -->
       <td><xsl:apply-templates select="match_part/match_destinations"/></td>
	   <!-- Protocols -->
	   <td>
        <!-- special handling (no match_protocols node means ANY)-->
        <xsl:choose>
          <xsl:when test="match_part/match_protocols">
            <xsl:apply-templates select="match_part/match_protocols"/>
            <xsl:if test="match_part/match_protocols/@comparison_result = 'removed_element'">
                <span class="added">
                    <xsl:value-of select="smc_img_util:getImgHTMLRef( 'protocol_agent', 'ANY' )" disable-output-escaping="yes"/>
                </span>
            </xsl:if>
            <xsl:if test="match_part/match_protocols/@comparison_result = 'added_element'">
                <span class="removed">
                    <xsl:value-of select="smc_img_util:getImgHTMLRef( 'protocol_agent', 'ANY' )" disable-output-escaping="yes"/>
                </span>
            </xsl:if>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="smc_img_util:getImgHTMLRef( 'protocol_agent', 'ANY' )" disable-output-escaping="yes"/>
          </xsl:otherwise>
        </xsl:choose>
       </td>   
	   <!-- Action -->
       <xsl:value-of select="smc_policy_action_util:getActionHTML(., /generic_import_export/blacklist_response, 'true', 'false', 'false')" disable-output-escaping="yes"/>
	   <!-- Option -->
	   <xsl:value-of select="smc_policy_option_util:getOptionHTML(option, 'true', 'false')" disable-output-escaping="yes"/>
	   <!-- Time -->
	   <td>
        <xsl:choose>
          <xsl:when test="match_part/rule_time_range[@comparison_result='added_element'] or match_part/rule_time_range[@comparison_result='removed_element']">
            <xsl:apply-templates select="match_part/rule_time_range[@comparison_result='added_element']"/>
            <xsl:text> </xsl:text>
            <xsl:apply-templates select="match_part/rule_time_range[@comparison_result='removed_element']"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:apply-templates select="match_part/rule_time_range"/>
          </xsl:otherwise>        
        </xsl:choose>     
      </td>
	   <!-- Comment -->
      <td>
        <xsl:call-template name="attribute-comparison-result"> 
          <xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param>
          <xsl:with-param name="attribute"><xsl:value-of select="../@comment"/></xsl:with-param>
          <xsl:with-param name="old_attribute"><xsl:value-of select="../@old_comment"/></xsl:with-param>
        </xsl:call-template>
      </td>
	   <!-- Tag -->
       <td><xsl:text>@</xsl:text><xsl:value-of select="../@tag"/></td>
    </tr>
  </xsl:template>
  
  <xsl:template match="rule_entry" mode="fw_nat">
    <xsl:choose>
      <xsl:when test="insert_point_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_nat_insert_point</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="8"><xsl:value-of select="@name"/></td>
        </tr>
      </xsl:when>
      <xsl:when test="comment_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_nat_comment</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="8">
            <xsl:call-template name="attribute-comparison-result"> 
              <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
              <xsl:with-param name="attribute"><xsl:value-of select="@comment"/></xsl:with-param>
              <xsl:with-param name="old_attribute"><xsl:value-of select="@old_comment"/></xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="nat_rule"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template match="rule_entry" mode="fw_ipv6_nat">
    <xsl:choose>
      <xsl:when test="insert_point_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_ipv6_nat_insert_point</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="8"><xsl:value-of select="@name"/></td>
        </tr>
      </xsl:when>
      <xsl:when test="comment_rule">
        <tr>
          <xsl:choose>
            <xsl:when test="../../../@comparison_result"></xsl:when>
            <xsl:otherwise>
              <xsl:attribute name="class">fw_ipv6_nat_comment</xsl:attribute> 
            </xsl:otherwise>
          </xsl:choose>
          <!-- rule comparison  -->
          <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <xsl:call-template name="comparison-result-td"><xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param></xsl:call-template>
          <td colspan="8">
            <xsl:call-template name="attribute-comparison-result"> 
              <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
              <xsl:with-param name="attribute"><xsl:value-of select="@comment"/></xsl:with-param>
              <xsl:with-param name="old_attribute"><xsl:value-of select="@old_comment"/></xsl:with-param>
            </xsl:call-template>
          </td>
        </tr>
      </xsl:when>    
      <xsl:otherwise>
        <xsl:apply-templates select="ipv6_nat_rule"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>  
  
  <xsl:template match="nat_rule|ipv6_nat_rule">
    <tr>
      <xsl:if test="../@is_disabled = 'true'"><xsl:attribute name="class">disabled</xsl:attribute></xsl:if>
      
	  <!-- rule comparison  -->
      <xsl:call-template name="comparison-result-class"><xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param></xsl:call-template>
      <xsl:call-template name="comparison-result-td-for-rule">
        <xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param>
        <xsl:with-param name="moved_result"><xsl:value-of select="../@moved_result"/></xsl:with-param>
      </xsl:call-template>
	
	  <!-- ID -->
      <td><xsl:value-of select="count(parent::rule_entry/preceding-sibling::rule_entry) + 1"/></td>
	  <!-- Sources -->
      <td><xsl:apply-templates select="match_part/match_sources"/></td>
	  <!-- Destinations -->
      <td><xsl:apply-templates select="match_part/match_destinations"/></td>
      <!-- Services -->
      <td><xsl:apply-templates select="match_part/match_services"/></td>
	  <!-- NAT -->
      <td class="option"><xsl:apply-templates select="option" mode="nat"/></td>
	  <!-- Used on -->
	  <xsl:choose>
          <xsl:when test="@valid_fw_ref != 'ANY'">
              <xsl:call-template name="attribute-comparison-result-td"> 
                <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
                <xsl:with-param name="attribute"><xsl:value-of select="@valid_fw_ref"/></xsl:with-param>
                <xsl:with-param name="old_attribute"><xsl:value-of select="@old_valid_fw_ref"/></xsl:with-param>
              </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
              <td>
             <xsl:value-of select="smc_img_util:getImgHTMLRef( 'address_range', 'ANY' )" disable-output-escaping="yes"/>
             <xsl:if test="@comparison_result = 'removed_element'">
                <span class="added">
                    <xsl:value-of select="smc_img_util:getImgHTMLRef( 'address_range', 'ANY' )" disable-output-escaping="yes"/>
                </span>
             </xsl:if>
             <xsl:if test="@comparison_result = 'added_element'">
                <span class="removed">
                    <xsl:value-of select="smc_img_util:getImgHTMLRef( 'address_range', 'ANY' )" disable-output-escaping="yes"/>
                </span>
             </xsl:if>
             </td>
          </xsl:otherwise>
      </xsl:choose>
	  <!-- Comment -->
      <td>
        <xsl:call-template name="attribute-comparison-result"> 
          <xsl:with-param name="comparison_result"><xsl:value-of select="../@comparison_result"/></xsl:with-param>
          <xsl:with-param name="attribute"><xsl:value-of select="../@comment"/></xsl:with-param>
          <xsl:with-param name="old_attribute"><xsl:value-of select="../@old_comment"/></xsl:with-param>
        </xsl:call-template>
      </td>
	  <!-- Tag -->
      <td><xsl:text>@</xsl:text><xsl:value-of select="../@tag"/></td>
    </tr>
  </xsl:template>
  
  <xsl:template match="access_entry" mode="fw">
    <xsl:apply-templates select="rule_entry" mode="fw_access"/>
  </xsl:template>
  
  <xsl:template match="access_entry" mode="ips">
    <xsl:apply-templates select="rule_entry" mode="ips_access"/>
  </xsl:template>
  
  <xsl:template match="access_entry" mode="fw_layer2">
    <xsl:apply-templates select="rule_entry" mode="fw_layer2_access"/>
  </xsl:template>
  
  <xsl:template match="ipv6_access_entry" mode="ips">
    <xsl:apply-templates select="rule_entry" mode="ips_ipv6_access"/>
  </xsl:template>
  
  <xsl:template match="ipv6_access_entry" mode="fw">
    <xsl:apply-templates select="rule_entry" mode="fw_ipv6_access"/>
  </xsl:template>
  
  <xsl:template match="ipv6_access_entry" mode="fw_layer2">
    <xsl:apply-templates select="rule_entry" mode="fw_layer2_ipv6_access"/>
  </xsl:template>
  
  <xsl:template match="ethernet_entry" mode="ips">
    <xsl:apply-templates select="rule_entry" mode="ips_ethernet"/>
  </xsl:template>
  
  <xsl:template match="ethernet_entry" mode="fw_layer2">
    <xsl:apply-templates select="rule_entry" mode="fw_layer2_ethernet"/>
  </xsl:template>
  
   <xsl:template match="inspection_entry">
    <xsl:apply-templates select="rule_entry" mode="inspection"/>
  </xsl:template>
  
  <xsl:template match="nat_entry">
    <xsl:apply-templates select="rule_entry" mode="fw_nat"/>
  </xsl:template>
  
  <xsl:template match="ipv6_nat_entry">
    <xsl:apply-templates select="rule_entry" mode="fw_ipv6_nat"/>
  </xsl:template>

  <xsl:template match="global_inspection_entry">
    <xsl:value-of select="smc_global_inspection_util:getGlobalInspectionHTML( . )" disable-output-escaping="yes"/>
  </xsl:template>

  <xsl:template name="fw_policy-common">
    <xsl:if test="@template_policy_ref">
	  <h3><xsl:text>Inherited Template Policy: </xsl:text>
	  <xsl:call-template name="policy-ref"><xsl:with-param name="value">
	  <xsl:value-of select="@template_policy_ref"/></xsl:with-param></xsl:call-template></h3>
    </xsl:if>
    <xsl:if test="@inspection_policy_ref">
      <h3><xsl:text>Inspection Policy: </xsl:text>
      <xsl:call-template name="policy-ref"><xsl:with-param name="value">
      <xsl:value-of select="@inspection_policy_ref"/></xsl:with-param></xsl:call-template></h3>
    </xsl:if>
     
    <xsl:if test="access_entry/rule_entry/access_rule">
	  <h3> IPv4 Access Rules </h3>
	    <table class="fw_access">
	      <!-- Including any attributes it has and any child nodes -->
	      <tr>
	        <th class="smc_comparison_result"></th>
	        <th>ID</th>
		    <th>Source</th>
		    <th>Destination</th>
		    <th>Service</th>
		    <th>Action</th>
		 	<th>Authentication</th>
		 	<th>QoS Class</th>
		 	<th>Logging</th>
			<th>Time</th>
			<th>Comment</th>
			<th>Tag</th>
		 	<th>Source VPN</th>
	      </tr>
	      <xsl:apply-templates select="access_entry" mode="fw"/>
	    </table>
  	</xsl:if>
  	
  	<xsl:if test="ipv6_access_entry/rule_entry/ipv6_rule">
      <h3> IPv6 Access Rules </h3>
        <table class="fw_ipv6_access">
          <!-- Including any attributes it has and any child nodes -->
          <tr>
            <th class="smc_comparison_result"></th>
            <th>ID</th>
            <th>Source</th>
            <th>Destination</th>
            <th>Service</th>
            <th>Action</th>
            <th>Authentication</th>
            <th>QoS Class</th>
            <th>Logging</th>
            <th>Time</th>
            <th>Comment</th>
            <th>Tag</th>
            <th>Source VPN</th>
          </tr>
          <xsl:apply-templates select="ipv6_access_entry" mode="fw"/>
        </table>
    </xsl:if>
	
    <xsl:if test="nat_entry/rule_entry/nat_rule">
	  <h3> IPv4 NAT Rules </h3>
      <table class="fw_nat">
      <!-- Including any attributes it has and any child nodes -->
        <tr>
          <th class="smc_comparison_result"></th>
	      <th>ID</th>
		  <th>Source</th>
		  <th>Destination</th>
		  <th>Service</th>
		  <th>NAT</th>
		  <th>Used On</th>
		  <th>Comment</th>
		  <th>Tag</th>
        </tr>
        <xsl:apply-templates select="nat_entry"/>
      </table>
	</xsl:if>
	
	<xsl:if test="ipv6_nat_entry/rule_entry/ipv6_nat_rule">
      <h3> IPv6 NAT Rules </h3>
      <table class="fw_ipv6_nat">
      <!-- Including any attributes it has and any child nodes -->
        <tr>
          <th class="smc_comparison_result"></th>
          <th>ID</th>
          <th>Source</th>
          <th>Destination</th>
          <th>Service</th>
          <th>NAT</th>
          <th>Used On</th>
          <th>Comment</th>
          <th>Tag</th>
        </tr>
        <xsl:apply-templates select="ipv6_nat_entry"/>
      </table>
    </xsl:if>
  </xsl:template>

  <xsl:template name="inspection_policy-common">
    <xsl:if test="@template_policy_ref">
      <h3><xsl:text>Inherited Template Policy: </xsl:text>
      <xsl:call-template name="policy-ref"><xsl:with-param name="value">
      <xsl:value-of select="@template_policy_ref"/></xsl:with-param></xsl:call-template></h3>
    </xsl:if>

    <xsl:if test="inspection_entry/rule_entry/inspection_rule">
      <h3> Inspection: Exception Rules </h3>
        <table class="inspection">
          <!-- Including any attributes it has and any child nodes -->
          <tr>
            <th class="smc_comparison_result"></th>
            <th>ID</th>
            <th>Situation</th>
            <th>Severity</th>
            <th>Logical Interface</th>
            <th>Source</th>
            <th>Destination</th>
            <th>Protocol</th>
            <th>Action</th>
            <th>Logging</th>
            <th>Time</th>
            <th>Comment</th>
            <th>Tag</th>
          </tr>
          <xsl:apply-templates select="inspection_entry"/>
       </table>
    </xsl:if>

    <xsl:if test="global_inspection_entry/rule_entry/global_inspection_rule">
      <h3> Inspection: Global Rules </h3>
      <table>
      <!-- Including any attributes it has and any child nodes -->
        <tr>
          <th class="smc_comparison_result"></th>
          <th>Situation</th>
          <th>Action</th>
          <th>Logging</th>
 <!--            <th>Exceptions</th>  -->
         <th>Comment</th>
          <th>Tag</th>
        </tr>
        <xsl:apply-templates select="global_inspection_entry"/>
      </table>
    </xsl:if>
  </xsl:template>

  <xsl:template name="ips_policy-common">
    <xsl:if test="@template_policy_ref">
	  <h3> <xsl:text>Inherited Template Policy: </xsl:text>
	  <xsl:call-template name="policy-ref"><xsl:with-param name="value"><xsl:value-of select="@template_policy_ref"/></xsl:with-param></xsl:call-template></h3>
    </xsl:if>    
    <xsl:if test="@inspection_policy_ref">
      <h3><xsl:text>Inspection Policy: </xsl:text>
      <xsl:call-template name="policy-ref"><xsl:with-param name="value">
      <xsl:value-of select="@inspection_policy_ref"/></xsl:with-param></xsl:call-template></h3>
    </xsl:if>
    
    <xsl:if test="ethernet_entry/rule_entry/ethernet_rule">
      <h3> Ethernet Rules </h3>
        <table>
          <!-- Including any attributes it has and any child nodes -->
          <tr>
            <th class="smc_comparison_result"></th>
            <th>ID</th>
            <th>Logical Interface</th>
            <th>Source</th>
            <th>Destination</th>
            <th>Service</th>
            <th>Action</th>
            <th>Logging</th>
            <th>Comment</th>
            <th>Tag</th>
          </tr>
          <xsl:apply-templates select="ethernet_entry" mode="ips"/>
        </table>
    </xsl:if>

	<xsl:if test="access_entry/rule_entry/access_rule">
	  <h3> IPv4 Access Rules </h3>
	    <table>
	      <!-- Including any attributes it has and any child nodes -->
	      <tr>
	        <th class="smc_comparison_result"></th>
		    <th>ID</th>
	   	    <th>Logical Interface</th>
			<th>Source</th>
			<th>Destination</th>
			<th>Service</th>
			<th>Action</th>
			<th>Logging</th>
			<th>Time</th>
			<th>Comment</th>
			<th>Tag</th>
	      </tr>
	      <xsl:apply-templates select="access_entry" mode="ips"/>
	   </table>
	 </xsl:if>
	       
    <xsl:if test="ipv6_access_entry/rule_entry/ipv6_rule">
      <h3> IPv6 Access Rules </h3>
        <table>
          <!-- Including any attributes it has and any child nodes -->
          <tr>
            <th class="smc_comparison_result"></th>
            <th>ID</th>
            <th>Logical Interface</th>
            <th>Source</th>
            <th>Destination</th>
            <th>Service</th>
            <th>Action</th>
            <th>Logging</th>
            <th>Time</th>
            <th>Comment</th>
            <th>Tag</th>
          </tr>
          <xsl:apply-templates select="ipv6_access_entry" mode="ips"/>
        </table>
    </xsl:if>

   </xsl:template>

  <xsl:template name="fw_layer2_policy-common">
    <xsl:if test="@template_policy_ref">
      <h3> <xsl:text>Inherited Template Policy: </xsl:text>
      <xsl:call-template name="policy-ref"><xsl:with-param name="value"><xsl:value-of select="@template_policy_ref"/></xsl:with-param></xsl:call-template></h3>
    </xsl:if>    
    <xsl:if test="@inspection_policy_ref">
      <h3><xsl:text>Inspection Policy: </xsl:text>
      <xsl:call-template name="policy-ref"><xsl:with-param name="value">
      <xsl:value-of select="@inspection_policy_ref"/></xsl:with-param></xsl:call-template></h3>
    </xsl:if>
    
    <xsl:if test="ethernet_entry/rule_entry/ethernet_rule">
      <h3> Ethernet Rules </h3>
        <table>
          <!-- Including any attributes it has and any child nodes -->
          <tr>
            <th class="smc_comparison_result"></th>
            <th>ID</th>
            <th>Logical Interface</th>
            <th>Source</th>
            <th>Destination</th>
            <th>Service</th>
            <th>Action</th>
            <th>Logging</th>
            <th>Comment</th>
            <th>Tag</th>
          </tr>
          <xsl:apply-templates select="ethernet_entry" mode="fw_layer2"/>
        </table>
    </xsl:if>

    <xsl:if test="access_entry/rule_entry/access_rule">
      <h3> IPv4 Access Rules </h3>
        <table>
          <!-- Including any attributes it has and any child nodes -->
          <tr>
            <th class="smc_comparison_result"></th>
            <th>ID</th>
            <th>Logical Interface</th>
            <th>Source</th>
            <th>Destination</th>
            <th>Service</th>
            <th>Action</th>
            <th>Logging</th>
            <th>Time</th>
            <th>Comment</th>
            <th>Tag</th>
          </tr>
          <xsl:apply-templates select="access_entry" mode="fw_layer2"/>
       </table>
     </xsl:if>
           
    <xsl:if test="ipv6_access_entry/rule_entry/ipv6_rule">
      <h3> IPv6 Access Rules </h3>
        <table>
          <!-- Including any attributes it has and any child nodes -->
          <tr>
            <th class="smc_comparison_result"></th>
            <th>ID</th>
            <th>Logical Interface</th>
            <th>Source</th>
            <th>Destination</th>
            <th>Service</th>
            <th>Action</th>
            <th>Logging</th>
            <th>Time</th>
            <th>Comment</th>
            <th>Tag</th>
          </tr>
          <xsl:apply-templates select="ipv6_access_entry" mode="fw_layer2"/>
        </table>
    </xsl:if>

   </xsl:template>

  <xsl:template match="fw_policy">
    <xsl:call-template name="fw_policy-common"/>    
  </xsl:template>

  <xsl:template match="ips_policy">
     <xsl:call-template name="ips_policy-common"/>
  </xsl:template>  

  <xsl:template match="fw_layer2_policy">
     <xsl:call-template name="fw_layer2_policy-common"/>
  </xsl:template>  

  <xsl:template match="fw_template_policy">
    <h2>
      <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('policy', @name)"/></xsl:attribute>
      <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), smc_img_util:getWellFormatedRef(@name) )" disable-output-escaping="yes"/>
    </h2>
    <xsl:call-template name="fw_policy-common"/>
  </xsl:template>

   <xsl:template match="ips_template_policy">
     <h2>
      <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('policy', @name)"/></xsl:attribute>
       <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), smc_img_util:getWellFormatedRef(@name) )" disable-output-escaping="yes"/>
     </h2> 
     <xsl:call-template name="ips_policy-common"/>
  </xsl:template>

   <xsl:template match="fw_layer2_template_policy">
     <h2>
      <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('policy', @name)"/></xsl:attribute>
       <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), smc_img_util:getWellFormatedRef(@name) )" disable-output-escaping="yes"/>
     </h2> 
     <xsl:call-template name="fw_layer2_policy-common"/>
  </xsl:template>

  <xsl:template match="inspection_template_policy">
    <h2>
      <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('policy', @name)"/></xsl:attribute>
      <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), smc_img_util:getWellFormatedRef(@name) )" disable-output-escaping="yes"/>
    </h2>
    <xsl:call-template name="inspection_policy-common"/>
  </xsl:template>

  <xsl:template match="fw_sub_policy">
    <h2>
      <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('policy', @name)"/></xsl:attribute>
      <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), smc_img_util:getWellFormatedRef(@name) )" disable-output-escaping="yes"/>
	</h2>
    <xsl:call-template name="fw_policy-common"/>
   </xsl:template>

  <xsl:template match="ips_sub_policy">
    <h2>
      <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('policy', @name)"/></xsl:attribute>
      <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), smc_img_util:getWellFormatedRef(@name) )" disable-output-escaping="yes"/>
    </h2> 
    <xsl:call-template name="ips_policy-common"/>
  </xsl:template>

  <xsl:template match="fw_layer2_sub_policy">
    <h2>
      <xsl:attribute name="id"><xsl:value-of select="smc_xsl_util:getId('policy', @name)"/></xsl:attribute>
      <xsl:value-of select="smc_img_util:getImgHTMLRef( name(), smc_img_util:getWellFormatedRef(@name) )" disable-output-escaping="yes"/>
    </h2> 
    <xsl:call-template name="fw_layer2_policy-common"/>
  </xsl:template>

  <xsl:template name="comparison-result-class">
    <xsl:param name="comparison_result"/>
    <xsl:choose>
      <xsl:when test="$comparison_result='added_element'"><xsl:attribute name="class">added</xsl:attribute></xsl:when>
      <xsl:when test="$comparison_result='removed_element'"><xsl:attribute name="class">removed</xsl:attribute></xsl:when>
      <xsl:when test="$comparison_result='modified_element'"><xsl:attribute name="class">modified</xsl:attribute></xsl:when> 
    </xsl:choose>
  </xsl:template>

  <xsl:template name="boolean-attribute-comparison-result">
    <xsl:param name="comparison_result"/>
    <xsl:param name="attribute"/>
    <xsl:param name="old_attribute"/>
    <xsl:param name="prefix"/>
    <xsl:param name="suffix"/>
    <xsl:choose>
      <xsl:when test="$comparison_result='modified_element'">   
       <xsl:if test="$prefix !=''"><xsl:value-of select="$prefix"/></xsl:if>
        <ul class="smc_comparison_element_list">   
          <xsl:if test="$attribute = 'true' ">
            <li class="added"><xsl:text>YES</xsl:text></li>
            <li class="removed"><xsl:text>NO</xsl:text></li> 
          </xsl:if> 
          <xsl:if test="$old_attribute = 'true' ">  
            <li class="added"><xsl:text>NO</xsl:text></li>
            <li class="removed"><xsl:text>YES</xsl:text></li>      
          </xsl:if> 
        </ul>
      </xsl:when>
      <xsl:otherwise>
        <xsl:if test="$attribute='true'">
          <xsl:if test="$prefix !=''"><xsl:value-of select="$prefix"/></xsl:if>
          <xsl:text>YES</xsl:text>
        </xsl:if> 
      </xsl:otherwise>
    </xsl:choose>  
    <xsl:if test="$suffix!=''"><xsl:value-of select="$suffix"/></xsl:if>
  </xsl:template>

  <xsl:template name="comparison-result-td">
    <xsl:param name="comparison_result"/>
    <td class="smc_comparison_result">
      <xsl:if test="$comparison_result != ''">
        <xsl:value-of select="smc_img_util:getPredefinedImgHTMLRef( $comparison_result )" disable-output-escaping="yes"/>
      </xsl:if>
    </td>
  </xsl:template>
    <xsl:template name="comparison-result-td-for-rule">
    <xsl:param name="comparison_result"/>
    <xsl:param name="moved_result"/>
    <td class="smc_comparison_result">
      <xsl:if test="$moved_result != ''">
        <xsl:value-of select="smc_img_util:getPredefinedImgHTMLRef( $moved_result )" disable-output-escaping="yes"/>
      </xsl:if>      
      <xsl:if test="$comparison_result != ''">
        <xsl:value-of select="smc_img_util:getPredefinedImgHTMLRef( $comparison_result )" disable-output-escaping="yes"/>
      </xsl:if>
    </td>
  </xsl:template>

  <xsl:template name="network-ipaddress-comparison-result-td">
    <xsl:param name="comparison_result"/>
    <xsl:param name="ipaddress"/>
    <xsl:param name="netmask"/>
    <xsl:param name="old_ipaddress"/>
    <xsl:param name="old_netmask"/>
    <td> 
      <xsl:choose>
        <xsl:when test="$comparison_result='modified_element'">
	      <ul class="smc_comparison_element_list">
	        <li class="added">
	          <xsl:value-of select="$ipaddress"/><xsl:text>/</xsl:text><xsl:value-of select="$netmask"/>
	        </li>
	        <li class="removed">
	          <xsl:value-of select="$old_ipaddress"/><xsl:text>/</xsl:text>
	          <xsl:choose>
	            <xsl:when test="@old_netmask">
	              <xsl:value-of select="$old_netmask"/></xsl:when>
	            <xsl:otherwise>
                  <xsl:value-of select="$netmask"/> 
                </xsl:otherwise> 
              </xsl:choose>  
	        </li>       
	      </ul>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$ipaddress"/><xsl:text>/</xsl:text><xsl:value-of select="$netmask"/> 
        </xsl:otherwise>
    </xsl:choose>  
    </td>
  </xsl:template>     
  
  <xsl:template name="engine-ip-control-comparison-result-td">  
    <xsl:param name="comparison_result"/>
    <xsl:param name="attribute"/>
    <xsl:param name="old_attribute"/>
    <xsl:choose>
      <xsl:when test="$comparison_result='modified_element' and $old_attribute !='' ">
        <xsl:call-template name="attribute-comparison-result-td">
          <xsl:with-param name="comparison_result"><xsl:value-of select="@comparison_result"/></xsl:with-param>
          <xsl:with-param name="attribute"><xsl:value-of select="$attribute"/></xsl:with-param>
          <xsl:with-param name="old_attribute"><xsl:value-of select="$old_attribute"/></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <td>
	  	  <xsl:if test="$attribute !='none'"><xsl:value-of select="$attribute"/></xsl:if>
		</td>
      </xsl:otherwise>
    </xsl:choose>  
  </xsl:template>  
  
  <xsl:template name="attribute-comparison-result">  
    <xsl:param name="comparison_result"/>
    <xsl:param name="attribute"/>
    <xsl:param name="old_attribute"/>
    <xsl:param name="call_template_name"/>
    <xsl:param name="prefix"/>
    <xsl:param name="suffix"/>
      <xsl:if test="$prefix !=''"><xsl:value-of select="$prefix"/></xsl:if>
      <xsl:choose>
        <xsl:when test="$comparison_result='modified_element' and $old_attribute !='' ">
          <ul class="smc_comparison_element_list">
            <li class="added">
               <xsl:call-template name="render-attribute">
                 <xsl:with-param name="attribute"><xsl:value-of select="$attribute"/></xsl:with-param>
                 <xsl:with-param name="call_template_name"><xsl:value-of select="$call_template_name"/></xsl:with-param>   
               </xsl:call-template>
            </li>
            <li class="removed">
               <xsl:call-template name="render-attribute">
                 <xsl:with-param name="attribute"><xsl:value-of select="$old_attribute"/></xsl:with-param>
                 <xsl:with-param name="call_template_name"><xsl:value-of select="$call_template_name"/></xsl:with-param>
               </xsl:call-template>
            </li>       
          </ul>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="render-attribute">
            <xsl:with-param name="attribute"><xsl:value-of select="$attribute"/></xsl:with-param>
            <xsl:with-param name="call_template_name"><xsl:value-of select="$call_template_name"/></xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
    </xsl:choose>  
    <xsl:if test="$suffix!=''"><xsl:value-of select="$suffix"/></xsl:if>
  </xsl:template>  
  
  <xsl:template name="attribute-comparison-result-td">  
    <xsl:param name="comparison_result"/>
    <xsl:param name="attribute"/>
    <xsl:param name="old_attribute"/>
    <xsl:param name="call_template_name"/>
    <xsl:param name="prefix"/>
    <xsl:param name="suffix"/>
    <td> 
      <xsl:if test="$prefix !=''"><xsl:value-of select="$prefix"/></xsl:if>
      <xsl:choose>
        <xsl:when test="$comparison_result='modified_element' and $old_attribute !='' ">
          <ul class="smc_comparison_element_list">
            <li class="added">
               <xsl:call-template name="render-attribute">
                 <xsl:with-param name="attribute"><xsl:value-of select="$attribute"/></xsl:with-param>
                 <xsl:with-param name="call_template_name"><xsl:value-of select="$call_template_name"/></xsl:with-param>   
               </xsl:call-template>
            </li>
            <li class="removed">
               <xsl:call-template name="render-attribute">
                 <xsl:with-param name="attribute"><xsl:value-of select="$old_attribute"/></xsl:with-param>
                 <xsl:with-param name="call_template_name"><xsl:value-of select="$call_template_name"/></xsl:with-param>
               </xsl:call-template>
            </li>       
          </ul>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="render-attribute">
            <xsl:with-param name="attribute"><xsl:value-of select="$attribute"/></xsl:with-param>
            <xsl:with-param name="call_template_name"><xsl:value-of select="$call_template_name"/></xsl:with-param>
          </xsl:call-template>
        </xsl:otherwise>
    </xsl:choose>  
    <xsl:if test="$suffix!=''"><xsl:value-of select="$suffix"/></xsl:if>
    </td>
  </xsl:template>  
  
  <xsl:template name="render-attribute">
    <xsl:param name="attribute"/>
    <xsl:param name="call_template_name"/>
      <xsl:choose>
        <xsl:when test="$call_template_name = 'vpn-ref' ">
          <xsl:call-template name="vpn-ref"><xsl:with-param name="value"><xsl:value-of select="$attribute"/></xsl:with-param></xsl:call-template>
        </xsl:when>
        <xsl:when test="$call_template_name = 'policy-ref' ">
          <xsl:call-template name="policy-ref"><xsl:with-param name="value"><xsl:value-of select="$attribute"/></xsl:with-param></xsl:call-template>
        </xsl:when>
        <xsl:when test="$call_template_name = 'network-element-ref' ">
          <xsl:call-template name="network-element-ref"><xsl:with-param name="value"><xsl:value-of select="$attribute"/></xsl:with-param></xsl:call-template>
        </xsl:when>
        <xsl:when test="$call_template_name = 'logical-interface-ref' ">
          <xsl:call-template name="logical-interface-ref"><xsl:with-param name="value"><xsl:value-of select="$attribute"/></xsl:with-param></xsl:call-template>
        </xsl:when>
        <xsl:when test="$call_template_name = 'mac-address-ref' ">
          <xsl:call-template name="mac-address-ref"><xsl:with-param name="value"><xsl:value-of select="$attribute"/></xsl:with-param></xsl:call-template>
        </xsl:when>
        <xsl:when test="$call_template_name = 'protocol-ref' ">
          <xsl:call-template name="protocol-ref"><xsl:with-param name="value"><xsl:value-of select="$attribute"/></xsl:with-param></xsl:call-template>
        </xsl:when>
        <xsl:when test="$call_template_name = 'situation-ref' ">
           <xsl:call-template name="situation-ref">
            <xsl:with-param name="value"><xsl:value-of select="$attribute"/></xsl:with-param>
            <xsl:with-param name="class_id">null</xsl:with-param>
           </xsl:call-template>
        </xsl:when>
        <xsl:when test="$call_template_name = 'service-ref' ">
          <xsl:call-template name="service-ref"><xsl:with-param name="value"><xsl:value-of select="$attribute"/></xsl:with-param></xsl:call-template>
        </xsl:when>
        <xsl:when test="$call_template_name = 'category-ref' ">
          <xsl:call-template name="category-ref">
            <xsl:with-param name="value"><xsl:value-of select="$attribute"/></xsl:with-param>
            <xsl:with-param name="class_id">null</xsl:with-param>
           </xsl:call-template>
        </xsl:when>
        <xsl:when test="$call_template_name = 'gateway-ref' ">
          <xsl:call-template name="gateway-ref"><xsl:with-param name="value"><xsl:value-of select="$attribute"/></xsl:with-param></xsl:call-template>
        </xsl:when>
        <xsl:when test="$call_template_name = 'gw-ref' ">
          <xsl:call-template name="gw-ref"><xsl:with-param name="value"><xsl:value-of select="$attribute"/></xsl:with-param></xsl:call-template>
        </xsl:when>
        <xsl:when test="$call_template_name = 'qos-ref' ">
          <xsl:call-template name="qos-ref"><xsl:with-param name="value"><xsl:value-of select="$attribute"/></xsl:with-param></xsl:call-template>
        </xsl:when>        
        <xsl:otherwise>
          <xsl:value-of select="$attribute"/> 
        </xsl:otherwise>
    </xsl:choose>  
  </xsl:template>  

<!-- ***  copy all template -->

  <xsl:template match="node()|@*">
  <!-- Copy the current node -->
    <xsl:copy>
      <!-- Including any attributes it has and any child nodes -->
      <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
  </xsl:template>
  
</xsl:stylesheet>
