<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:smc_converter_util="com.stonesoft.ie.xsl.EverestToKatlaXslUtil"
                              exclude-result-prefixes="smc_converter_util">
	<xsl:output doctype-system="generic_import_export_v5.4.dtd" indent="yes"/>
	<!-- converter, when importing a file using 5.3 dtd: transform into 5.4 dtd -->
	<!-- when importing older file, it will pass through older converters first -->
    
    <!-- Copy the log_server content and the ha_log_server content if @ref=@name -->
     <xsl:template match="log_server">
        <xsl:copy>
            <xsl:apply-templates select="node()|@*"/>
            <xsl:apply-templates select="//ha_log_server[@ref=current()/@name]"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="fw_single/contact_policy"/>

    <!-- Do a copy of the element secondary_log_server and change some attribute name -->
    <!-- and delete the ha_log_server-->
    <xsl:template match="ha_log_server">
      <xsl:element name="secondary_log_server_ref">
            <xsl:attribute name="value"><xsl:value-of select="@ref"/></xsl:attribute>
            <xsl:attribute name="class_id">7</xsl:attribute>
        </xsl:element>
    </xsl:template>
    
    <!-- PR 71458 -->
    <xsl:template match="filter_expression/@datatype_mask"/>
    <xsl:template match="filter_expression/@is_common_filter"/>
    
    <xsl:template match="filter_expression/@default_value | query_data_filter/@default_value | logical/@default_value">
         <xsl:attribute name="default_value">
              <xsl:choose>
                  <xsl:when test=". = 0">false</xsl:when>
                  <xsl:when test=". = 1">true</xsl:when>
                  <xsl:when test=". = 2">false_by_cmp</xsl:when>
                  <xsl:when test=". = 'undefined'">undefined</xsl:when>
              </xsl:choose>
         </xsl:attribute>
    </xsl:template>
    
    <xsl:template match="filter_expression//@order_no | query_data_filter//@order_no"/>
    <xsl:template match="logical[not(@name)]/@default_value"/>
    
    <xsl:template match="query_data_filter">
        <xsl:copy>
            <xsl:attribute name='name'></xsl:attribute>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="logical[@type = 'AND']/logical[@identification = 4]"/>
            <xsl:apply-templates select="logical[@type = 'AND']/logical[@identification = 2]"/>
            <xsl:apply-templates select="logical[@type = 'AND']/logical[@identification = 3]"/>
            <xsl:apply-templates select="logical[@type = 'AND']/logical[@identification = 1]"/>
        </xsl:copy>
    </xsl:template>
    <xsl:template match="query_data_filter/logical[@type = 'AND']/logical[@identification = 4]">
        <query_data type="data_type">
            <xsl:apply-templates/>
        </query_data>
    </xsl:template>
    <xsl:template match="query_data_filter/logical[@type = 'AND']/logical[@identification = 2]">
        <query_data type="quick_filter_data">
            <xsl:apply-templates/>
        </query_data>
    </xsl:template>
    <xsl:template match="query_data_filter/logical[@type = 'AND']/logical[@identification = 3]">
        <query_data type="sources">
            <xsl:apply-templates/>
        </query_data>
    </xsl:template>
    <xsl:template match="query_data_filter/logical[@type = 'AND']/logical[@identification = 1]">
        <filter_data>
            <xsl:apply-templates/>
        </filter_data>
    </xsl:template>
    <xsl:template match="query_data_filter/logical[@type = 'AND']/logical[@identification = 1]/logical[@type = 'AND' or @type = 'OR']">
        <filter_group negated="false">
            <xsl:attribute name="type"><xsl:value-of select="@type"/></xsl:attribute>
            <xsl:apply-templates/>
        </filter_group>
    </xsl:template>
    <xsl:template match="query_data_filter/logical[@type = 'AND']/logical[@identification = 1]/logical[@type = 'NOT' and logical[@type = 'AND' or @type = 'OR']]">
        <filter_group negated="true">
            <xsl:attribute name="type"><xsl:value-of select="logical/@type"/></xsl:attribute>
            <xsl:apply-templates select="logical/node()"/>
        </filter_group>
    </xsl:template>
    <xsl:template match="query_data_filter//logical[@identification = 1]//logical[@name and @type = 'AND']">
        <tmpfilter>
            <xsl:apply-templates select="@name"/>
            <xsl:apply-templates select="@default_value"/>
            <xsl:apply-templates/>
        </tmpfilter>
    </xsl:template>

    <!-- FIELDS: Separate FieldGroup keys from ValueGuiInformation types. -->

    <xsl:template match="filter_expression//reference[@type='field_group']/@ref_key | query_data_filter//reference[@type='field_group']/@ref_key">
         <xsl:attribute name="ref_key">
             <xsl:choose>
                 <xsl:when test=". = '12848'">1</xsl:when>
                 <xsl:when test=". = '13088'">2</xsl:when>
                 <xsl:when test=". = '13344'">3</xsl:when>
                 <xsl:when test=". = '13600'">4</xsl:when>
                 <xsl:when test=". = '13856'">5</xsl:when>
                 <xsl:when test=". = '14112'">6</xsl:when>
                 <xsl:when test=". = '14384'">7</xsl:when>
                 <xsl:when test=". = '14640'">8</xsl:when>
                 <xsl:when test=". = '14896'">9</xsl:when>
             </xsl:choose>
         </xsl:attribute>
    </xsl:template>

    <!-- separate inspection policy from fw/ips template policy and fw/ips policy -->
     <xsl:template match="fw_template_policy | fw_policy | ips_template_policy | ips_policy">
        <xsl:copy>
            <xsl:if test="not(@key)">
                <!-- add reference to inspection policy, except for system policy (handled by update package) -->
                <xsl:choose>
                    <xsl:when test="count(inspection_entry/rule_entry)='0' and count(global_inspection_entry/rule_entry)='0'">
                        <xsl:choose>
                            <xsl:when test="@template_policy_ref='Default'">
                                <xsl:attribute name="inspection_policy_ref_key">106</xsl:attribute>
                            </xsl:when>
                            <xsl:when test="@template_policy_ref='Default Inspection Rules'">
                                <xsl:attribute name="inspection_policy_ref_key">107</xsl:attribute>
                            </xsl:when>
                            <xsl:when test="@template_policy_ref='IPS System Template'">
                                <xsl:attribute name="inspection_policy_ref_key">107</xsl:attribute>
                            </xsl:when>
                            <xsl:when test="@template_policy_ref='IPS Strict Template'">
                                <xsl:attribute name="inspection_policy_ref_key">108</xsl:attribute>
                            </xsl:when>
                            <xsl:otherwise>
                                <!-- unknown parent policy: create inspection policy -->
                                <xsl:attribute name="inspection_policy_ref"><xsl:value-of select="@name"/> - Inspection</xsl:attribute>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="inspection_policy_ref"><xsl:value-of select="@name"/> - Inspection</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <!-- replace parent template 'IPS Strict Template' (1000003) with IPS Access Rules Template (1000001) -->
            <xsl:choose>
             <xsl:when test="not(@key) and @template_policy_ref_key='1000003'">
                <xsl:attribute name="template_policy_ref_key">1000001</xsl:attribute>
             </xsl:when>
             <xsl:when test="@template_policy_ref_key">
                <xsl:attribute name="template_policy_ref_key"><xsl:value-of select="@template_policy_ref_key"/></xsl:attribute>
             </xsl:when>
            </xsl:choose>
            <xsl:apply-templates select="@*[name(.) != 'template_policy_ref_key'] | node()[name(.) != 'inspection_entry'
                                                 and name(.) != 'global_inspection_entry']"/>
        </xsl:copy>

        <!-- create an inspection policy with the inspection rules; except for system policy -->
        <xsl:if test="not(@key)">
        <xsl:choose>
            <xsl:when test="count(inspection_entry/rule_entry)='0' and count(global_inspection_entry/rule_entry)='0' and (@template_policy_ref='Default' or @template_policy_ref='Default Inspection Rules' or @template_policy_ref='IPS System Template' or @template_policy_ref='IPS Strict Template')">
            <!-- do not create inspection policy: we use a system one -->
            </xsl:when>
            <xsl:otherwise>
        <inspection_template_policy>
            <xsl:attribute name="name"><xsl:value-of select="@name"/> - Inspection</xsl:attribute>
            <xsl:attribute name="comment">Inspection policy for <xsl:value-of select="@name"/></xsl:attribute>
            <xsl:if test="@template_policy_ref">
                <xsl:variable name="template_ref">
                    <xsl:value-of select="@template_policy_ref"/>
                </xsl:variable>
                <xsl:choose>
                    <xsl:when test="@template_policy_ref='Default'">
                        <xsl:attribute name="template_policy_ref_key">106</xsl:attribute>
                    </xsl:when>
                    <xsl:when test="@template_policy_ref='Default Inspection Rules'">
                        <xsl:attribute name="template_policy_ref_key">107</xsl:attribute>
                    </xsl:when>
                    <xsl:when test="@template_policy_ref='IPS System Template'">
                        <xsl:attribute name="template_policy_ref_key">107</xsl:attribute>
                    </xsl:when>
                    <xsl:when test="@template_policy_ref='IPS Strict Template'">
                        <xsl:attribute name="template_policy_ref_key">108</xsl:attribute>
                    </xsl:when>
                    <!-- if the parent template has no inspection rule, and is under a system template, use the system inspection template -->
                    <xsl:when test="../node()[name(.)='fw_template_policy' and @name=$template_ref and @template_policy_ref='Default' and count(inspection_entry/rule_entry)='0' and count(global_inspection_entry/rule_entry)='0']">
                        <xsl:attribute name="template_policy_ref_key">106</xsl:attribute>
                    </xsl:when>
                    <xsl:when test="../node()[name(.)='fw_template_policy' and @name=$template_ref and @template_policy_ref='Default Inspection Rules' and count(inspection_entry/rule_entry)='0' and count(global_inspection_entry/rule_entry)='0']">
                        <xsl:attribute name="template_policy_ref_key">107</xsl:attribute>
                    </xsl:when>
                    <xsl:when test="../node()[name(.)='ips_template_policy' and @name=$template_ref and @template_policy_ref='IPS System Template' and count(inspection_entry/rule_entry)='0' and count(global_inspection_entry/rule_entry)='0']">
                        <xsl:attribute name="template_policy_ref_key">107</xsl:attribute>
                    </xsl:when>
                    <xsl:when test="../node()[name(.)='ips_template_policy' and @name=$template_ref and @template_policy_ref='IPS Strict Template' and count(inspection_entry/rule_entry)='0' and count(global_inspection_entry/rule_entry)='0']">
                        <xsl:attribute name="template_policy_ref_key">108</xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="template_policy_ref"><xsl:value-of select="@template_policy_ref"/> - Inspection</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
            <xsl:apply-templates select="node()[name(.) = 'inspection_entry'
                                             or name(.) = 'global_inspection_entry']"/>
        </inspection_template_policy>
            </xsl:otherwise>
        </xsl:choose>
        </xsl:if>
    </xsl:template>

    <!-- overview sources separated from associated elements -->
    <xsl:template match="report[@class_id = 'overview']/section/associated_element_ref">
	<source_element_ref>
		<xsl:apply-templates select="@*"/>
	</source_element_ref>
    </xsl:template>    

    <!--  rename firewallpolicyloaded_test into policyloaded_test;
      remove policy_ref from firewallpolicyloaded_test.
      Keep order as required by dtd. -->
	<xsl:template match="fw_single|fw_cluster">
         <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="node()[name(.) = 'category_ref'
                                             or name(.) = 'tester_parameters']"/>
            <xsl:for-each select="firewallpolicyloaded_test">
                <xsl:element name="policyloaded_test">
                <xsl:apply-templates select="@*[name(.) != 'policy_ref'
                                              and name(.)!='policy_ref_key']|node()"/>                    
                </xsl:element>
            </xsl:for-each>
            <xsl:apply-templates select="node()[name(.) != 'firewallpolicyloaded_test'
                                            and name(.) != 'category_ref'
                                            and name(.) != 'tester_parameters']"/>
         </xsl:copy>
	</xsl:template>

    <xsl:template match="firewall_node">
         <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates select="node()[name(.) = 'node_interface']"/>
            <xsl:for-each select="firewallpolicyloaded_test">
                <xsl:element name="policyloaded_test">
                <xsl:apply-templates select="@*[name(.) != 'policy_ref'
                                              and name(.)!='policy_ref_key']|node()"/>                    
                </xsl:element>
            </xsl:for-each>
            <xsl:apply-templates select="node()[name(.) != 'firewallpolicyloaded_test'
                                            and name(.) != 'node_interface']"/>
         </xsl:copy>
    </xsl:template>

    <!--  rename single_sensor into single_ips *
    and sensor_cluster into ips_cluster  
    and sensor_node into ips_node -->
    <xsl:template match="generic_import_export">
         <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:for-each select="single_sensor">
                <xsl:element name="single_ips">
                <xsl:apply-templates select="@*|node()"/>                    
                </xsl:element>
            </xsl:for-each>
            <xsl:for-each select="sensor_cluster">
                <xsl:element name="ips_cluster">
                <xsl:apply-templates select="@*"/>
                <xsl:apply-templates select="node()[name(.) != 'sensor_node'
                                                and name(.) != 'alias_value' 
                                                and name(.) != 'log_moderation']"/>                    
                <xsl:for-each select="sensor_node">
	                <xsl:element name="ips_node">
	                <xsl:apply-templates select="@*|node()"/>                    
	                </xsl:element>
	            </xsl:for-each>
	            <xsl:apply-templates select="node()[name(.) = 'alias_value' 
	                                             or name(.) = 'log_moderation']"/> 
                </xsl:element>
            </xsl:for-each>
            <xsl:apply-templates select="node()[name(.) != 'single_sensor'
                                            and name(.) != 'sensor_cluster']"/>
         </xsl:copy>
    </xsl:template>

 	<!-- copy everything else -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node() [name(.) != 'ha_log_server'] "/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
