<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:smc_converter_util="com.stonesoft.ie.xsl.EverestToKatlaXslUtil"
                              exclude-result-prefixes="smc_converter_util">
	<xsl:output doctype-system="generic_import_export_v5.3.dtd" indent="yes"/>
	<!-- converter, when importing a file using 5.2 dtd: transform into 5.3 dtd -->
	<!-- when importing older file, it will pass through older converters first -->
	<!-- tester_parameters: auto_recovery and boot_recovery have now true/false value and not on/off -->
	<xsl:template match="tester_parameters">
	    <xsl:copy>
		<xsl:choose>
			<xsl:when test="@auto_recovery or @boot_recovery">
				<xsl:if test="@auto_recovery">
					<xsl:choose>
						<xsl:when test="@auto_recovery='on'">
							<xsl:attribute name="auto_recovery">true</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="auto_recovery">false</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="@boot_recovery">
					<xsl:choose>
						<xsl:when test="@boot_recovery='on'">
							<xsl:attribute name="boot_recovery">true</xsl:attribute>
						</xsl:when>
						<xsl:otherwise>
							<xsl:attribute name="boot_recovery">false</xsl:attribute>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:apply-templates select="@*[name(.) != 'auto_recovery' and name(.) != 'boot_recovery']|node()"/>
			</xsl:when>
			<xsl:otherwise>
       		    <xsl:apply-templates select="@*|node()"/>
			</xsl:otherwise>
		</xsl:choose>
		</xsl:copy>
	</xsl:template>
	
	<!-- add IKEv2 related attributes in capabilities, remove ah_esp_for_ipsec, rename sha256_for_ike and sha256_for_ipsec. -->
	<xsl:template match="capabilities">
		<xsl:choose>
			<xsl:when test="(parent::gateway_type)">
				<xsl:copy>
					<xsl:attribute name="ike_v1">true</xsl:attribute>
					<xsl:attribute name="ike_v2">false</xsl:attribute>
					<xsl:attribute name="sha2_for_ike"><xsl:value-of select="@sha256_for_ike"/></xsl:attribute>
                    <xsl:attribute name="sha2_for_ipsec"><xsl:value-of select="@sha256_for_ipsec"/></xsl:attribute>
					<xsl:apply-templates select="@*[name(.) != 'ah_esp_for_ipsec'
					                            and name(.)!='sha256_for_ike'
                                                and name(.)!='sha256_for_ipsec']|node()"/>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="(parent::vpn_profile)">
				<xsl:copy>
					<xsl:attribute name="ike_v1"><xsl:text>true</xsl:text></xsl:attribute>
					<xsl:attribute name="ike_v2"><xsl:text>false</xsl:text></xsl:attribute>
					<xsl:attribute name="sha2_for_ike"><xsl:value-of select="@sha256_for_ike"/></xsl:attribute>
                    <xsl:attribute name="sha2_for_ipsec"><xsl:value-of select="@sha256_for_ipsec"/></xsl:attribute>
					<xsl:choose>
						<xsl:when test="@ah_esp_for_ipsec='true'">
							<xsl:attribute name="esp_for_ipsec">true</xsl:attribute>
							<xsl:apply-templates select="@*[name(.) != 'ah_esp_for_ipsec' 
							                            and name(.) != 'esp_for_ipsec'
							                            and name(.)!='sha256_for_ike'
                                                        and name(.)!='sha256_for_ipsec']|node()"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:apply-templates select="@*[name(.) != 'ah_esp_for_ipsec'
							                            and name(.)!='sha256_for_ike'
							                            and name(.)!='sha256_for_ipsec']|node()"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:copy>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

    <!-- removal of enabled for dhcp_server_on_interface and removal of disabled dhcp_server_on_interface + merge dhcp_address_range_min/dhcp_address_range_max in dhcp_address_range -->
    <xsl:template match="dhcp_server_on_interface">
        <xsl:choose>
            <xsl:when test="@enabled='true'">
                <xsl:copy>
                    <xsl:if test="@dhcp_address_range_min and @dhcp_address_range_max">
                        <xsl:attribute name="dhcp_address_range"><xsl:value-of select="@dhcp_address_range_min"/>-<xsl:value-of select="@dhcp_address_range_max"/></xsl:attribute>
                    </xsl:if>
                    <xsl:apply-templates select="@*[name(.)!='enabled' and name(.)!='dhcp_address_range_min' and name(.)!='dhcp_address_range_max']|node()"/>
                </xsl:copy>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
    
    <!-- test_notification attribute replaced by two xml attributes alert_notification/snmp_notification -->
    <xsl:template match="external_test|filesystemspace_test|freeswapspace_test|linkstatus_test|multiping_test|inline_test">
        <xsl:copy>
            <xsl:choose>
                <xsl:when test="@test_notification='alert'">
                    <xsl:attribute name="alert_notification">true</xsl:attribute>
                    <xsl:apply-templates select="@*[name(.) != 'test_notification']|node()"/>
                </xsl:when>
                <xsl:when test="@test_notification='snmp'">
                    <xsl:attribute name="snmp_notification">true</xsl:attribute>
                    <xsl:apply-templates select="@*[name(.) != 'test_notification']|node()"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="@*[name(.) != 'test_notification']|node()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:copy>
    </xsl:template>
    <!-- policy_ref/policy_ref_key attributes removed since null is the default value -->
    <xsl:template match="firewallpolicyloaded_test">
        <xsl:copy>
            <xsl:choose>
                <xsl:when test="@test_notification='alert'">
                    <xsl:attribute name="alert_notification">true</xsl:attribute>
                    <xsl:apply-templates select="@*[name(.) != 'test_notification' and name(.) != 'policy_ref' and name(.) != 'policy_ref_key']|node()"/>
                </xsl:when>
                <xsl:when test="@test_notification='snmp'">
                    <xsl:attribute name="snmp_notification">true</xsl:attribute>
                    <xsl:apply-templates select="@*[name(.) != 'test_notification' and name(.) != 'policy_ref' and name(.) != 'policy_ref_key']|node()"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="@*[name(.) != 'test_notification' and name(.) != 'policy_ref' and name(.) != 'policy_ref_key']|node()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:copy>
    </xsl:template>
    
    <!-- + removal of obsolete firewallrunning_test/interfaceup_test xml child from engine cluster xml definitions
         + removal of arp_entry since moved directly in physical_interface
         + change tls_server_credentials_list structure to have tls_server_credentials_list by entry
      -->
    <xsl:template match="single_sensor">
        <xsl:copy>
            <xsl:apply-templates select="@*   [    name(.) != 'ca_for_signing'
                                               and name(.) != 'mgt_server_ref'
                                               and name(.) != 'mgt_server_ref_key' ] |
                                        node()[    name(.) != 'firewallrunning_test'
                                               and name(.) != 'interfaceup_test'
                                               and name(.) != 'arp_entry'
                                               and name(.) != 'tls_server_credentials_list'
                                               and name(.) != 'external_test'
                                               and name(.) != 'filesystemspace_test'
                                               and name(.) != 'inline_test'
                                               and name(.) != 'freeswapspace_test'
                                               and name(.) != 'linkstatus_test'
                                               and name(.) != 'multiping_test'
                                               and name(.) != 'physical_interface'
                                               and name(.) != 'capture_interface'
                                               and name(.) != 'inline_interface'
                                               and name(.) != 'sensor_single_interface'
                                               and name(.) != 'default_responses'
                                               and name(.) != 'alias_value'
                                               and name(.) != 'domain_server_address']"/>

            <xsl:apply-templates select="freeswapspace_test"/>
            <xsl:apply-templates select="linkstatus_test"/>
            <xsl:apply-templates select="multiping_test"/>
            <xsl:apply-templates select="external_test"/>
            <xsl:apply-templates select="filesystemspace_test"/>
            <xsl:apply-templates select="inline_test"/>
            
            <xsl:apply-templates select="physical_interface"/>
            <xsl:apply-templates select="capture_interface"/>
            <xsl:apply-templates select="inline_interface"/>
            
            <xsl:for-each select="sensor_single_interface">
                <xsl:element name="node_interface">
                    <xsl:if test="single_sensor_ndi_mode/@control_ip_address='primary'">
                        <xsl:attribute name="primary_mgt">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="single_sensor_ndi_mode/@control_ip_address='backup'">
                        <xsl:attribute name="backup_mgt">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="single_sensor_ndi_mode/@log_analyzer_communication">
                        <xsl:attribute name="outgoing"><xsl:value-of select="single_sensor_ndi_mode/@log_analyzer_communication"/></xsl:attribute>
                    </xsl:if>

                    <xsl:attribute name="nodeid">1</xsl:attribute>
                    <xsl:attribute name="network_value"><xsl:value-of select="smc_converter_util:getNetworkValue(mvia_address/@address, @network_value)" disable-output-escaping="yes"/></xsl:attribute>
            
                    <xsl:apply-templates select="@*[name(.) != 'network_value']|node()[name(.) != 'single_sensor_ndi_mode']"/>
                </xsl:element>            
            </xsl:for-each>
            
            <xsl:apply-templates select="domain_server_address"/>                                                                                  
            
            <xsl:if test="@ca_for_signing">
                <xsl:element name="tls_client_protection">
                    <xsl:attribute name="ca_for_signing_ref"><xsl:value-of select="@ca_for_signing"/></xsl:attribute>
                    <xsl:element name="tls_trusted_ca_tag_ref">
                        <xsl:attribute name="ref_key">10040000</xsl:attribute>
                        <xsl:attribute name="class_id">8109</xsl:attribute>
                    </xsl:element>                    
                </xsl:element>
            </xsl:if>            
            
            <xsl:for-each select="tls_server_credentials_list">
                <xsl:for-each select="list_entry">
                    <xsl:element name="tls_server_credentials_list">
                        <xsl:attribute name='ref'><xsl:value-of select="@value"/></xsl:attribute>
                        <xsl:if test="@ref_key">
                            <xsl:attribute name='ref_key'><xsl:value-of select="@ref_key"/></xsl:attribute>
                        </xsl:if>
                        <xsl:if test="@class_id">
                            <xsl:attribute name='class_id'><xsl:value-of select="@class_id"/></xsl:attribute>
                        </xsl:if>                        
                    </xsl:element>
                </xsl:for-each>
            </xsl:for-each>
            
            <xsl:apply-templates select="alias_value"/>            
        </xsl:copy>
    </xsl:template>
    

    <!-- + removal of obsolete firewallrunning_test/interfaceup_test xml child from engine cluster xml definitions
         + removal of arp_entry since moved directly in physical_interface
         + change tls_server_credentials_list structure to have tls_server_credentials_list by entry
         + change order in xml children nodes: to have physical_interface before interfaces
      -->
    <xsl:template match="combined_sensor_analyzer">
        <xsl:copy>
            <xsl:apply-templates select="@*   [    name(.) != 'ca_for_signing'
                                               and name(.) != 'mgt_server_ref'
                                               and name(.) != 'mgt_server_ref_key' ] |
                                        node()[    name(.) != 'firewallrunning_test'
                                               and name(.) != 'interfaceup_test'
                                               and name(.) != 'arp_entry'
                                               and name(.) != 'tls_server_credentials_list'
                                               and name(.) != 'external_test'
                                               and name(.) != 'filesystemspace_test'
                                               and name(.) != 'inline_test'
                                               and name(.) != 'freeswapspace_test'
                                               and name(.) != 'linkstatus_test'
                                               and name(.) != 'multiping_test'
                                               and name(.) != 'physical_interface'
                                               and name(.) != 'combined_interface'
                                               and name(.) != 'capture_interface'
                                               and name(.) != 'inline_interface'
                                               and name(.) != 'default_responses'
                                               and name(.) != 'analyzer_default_responses'
                                               and name(.) != 'alias_value'
                                               and name(.) != 'domain_server_address'
                                               and name(.) != 'blacklisting_fw_cvi' ]"/>
            
            <xsl:apply-templates select="freeswapspace_test"/>
            <xsl:apply-templates select="linkstatus_test"/>
            <xsl:apply-templates select="multiping_test"/>
            <xsl:apply-templates select="external_test"/>
            <xsl:apply-templates select="filesystemspace_test"/>
            <xsl:apply-templates select="inline_test"/>
            
            <xsl:apply-templates select="physical_interface"/>
            <xsl:apply-templates select="capture_interface"/>
            <xsl:apply-templates select="inline_interface"/>
            
            <xsl:for-each select="combined_interface">
                <xsl:element name="node_interface">
                    <xsl:if test="combined_ndi_mode/@control_ip_address='primary'">
                        <xsl:attribute name="primary_mgt">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="combined_ndi_mode/@control_ip_address='backup'">
                        <xsl:attribute name="backup_mgt">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="combined_ndi_mode/@log_analyzer_communication">
                        <xsl:attribute name="outgoing"><xsl:value-of select="combined_ndi_mode/@log_analyzer_communication"/></xsl:attribute>
                    </xsl:if>
                    
                    <xsl:attribute name="nodeid">1</xsl:attribute>
                    <xsl:attribute name="network_value"><xsl:value-of select="smc_converter_util:getNetworkValue(mvia_address/@address, @network_value)" disable-output-escaping="yes"/></xsl:attribute>
            
                    <xsl:apply-templates select="@*[name(.) != 'network_value']|node()[name(.) != 'combined_ndi_mode']"/>
                </xsl:element>            
            </xsl:for-each>
            
            <xsl:apply-templates select="blacklisting_fw_cvi"/>
            <xsl:apply-templates select="domain_server_address"/>
            
            <xsl:if test="@ca_for_signing">
                <xsl:element name="tls_client_protection">
                    <xsl:attribute name="ca_for_signing_ref"><xsl:value-of select="@ca_for_signing"/></xsl:attribute>
                    <xsl:element name="tls_trusted_ca_tag_ref">
                        <xsl:attribute name="ref_key">10040000</xsl:attribute>
                        <xsl:attribute name="class_id">8109</xsl:attribute>
                    </xsl:element>                    
                </xsl:element>
            </xsl:if>   
            
            <xsl:for-each select="tls_server_credentials_list">
                <xsl:for-each select="list_entry">
                    <xsl:element name="tls_server_credentials_list">
                        <xsl:attribute name='ref'><xsl:value-of select="@value"/></xsl:attribute>
                        <xsl:if test="@ref_key">
                            <xsl:attribute name='ref_key'><xsl:value-of select="@ref_key"/></xsl:attribute>
                        </xsl:if>
                        <xsl:if test="@class_id">
                            <xsl:attribute name='class_id'><xsl:value-of select="@class_id"/></xsl:attribute>
                        </xsl:if>                        
                    </xsl:element>
                </xsl:for-each>
            </xsl:for-each>
            
            <xsl:apply-templates select="alias_value"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- + removal of obsolete firewallrunning_test/interfaceup_test xml child from engine cluster xml definitions
         + removal of arp_entry since moved directly in physical_interface
         + change order in xml children nodes: to have physical_interface before interfaces
      -->      
    <xsl:template match="fw_cluster">
        <xsl:copy>
            <xsl:apply-templates select="@*    [    name(.) != 'ca_for_signing'
                                                and name(.) != 'mgt_server_ref'
                                                and name(.) != 'mgt_server_ref_key'] |
                                         node()[    name(.) != 'firewallrunning_test'
                                                and name(.) != 'interfaceup_test'
                                                and name(.) != 'arp_entry'
                                                and name(.) != 'tls_server_credentials_list'
                                                and name(.) != 'firewall_node'
                                                and name(.) != 'external_test'
                                                and name(.) != 'filesystemspace_test'
                                                and name(.) != 'firewallpolicyloaded_test'
                                                and name(.) != 'freeswapspace_test'
                                                and name(.) != 'linkstatus_test'
                                                and name(.) != 'multiping_test'
                                                and name(.) != 'physical_interface'
                                                and name(.) != 'connection_timeout'
                                                and name(.) != 'policy_route'                                                                                  
                                                and name(.) != 'static_multicast_route'
                                                and name(.) != 'lbfilter'
                                                and name(.) != 'cluster_virtual_interface'
                                                and name(.) != 'nat_pool'
                                                and name(.) != 'antivirus'
                                                and name(.) != 'log_moderation'
                                                and name(.) != 'alias_value'
                                                and name(.) != 'domain_server_address' ]"/>

            <xsl:apply-templates select="firewallpolicyloaded_test"/>
            <xsl:apply-templates select="freeswapspace_test"/>
            <xsl:apply-templates select="linkstatus_test"/>
            <xsl:apply-templates select="multiping_test"/>
            <xsl:apply-templates select="external_test"/>
            <xsl:apply-templates select="filesystemspace_test"/>
            
            <xsl:apply-templates select="physical_interface"/>
            <xsl:apply-templates select="connection_timeout"/>
            <xsl:apply-templates select="policy_route"/>
            <xsl:apply-templates select="static_multicast_route"/>
            <xsl:apply-templates select="nat_pool"/>
            <xsl:apply-templates select="antivirus"/>
            <xsl:apply-templates select="log_moderation"/>
            <xsl:apply-templates select="lbfilter"/>
            <xsl:apply-templates select="cluster_virtual_interface"/>
            <xsl:apply-templates select="domain_server_address"/>
            
            <xsl:if test="@ca_for_signing">
                <xsl:element name="tls_client_protection">
                    <xsl:attribute name="ca_for_signing_ref"><xsl:value-of select="@ca_for_signing"/></xsl:attribute>
                    <xsl:element name="tls_trusted_ca_tag_ref">
                        <xsl:attribute name="ref_key">10040000</xsl:attribute>
                        <xsl:attribute name="class_id">8109</xsl:attribute>
                    </xsl:element>                    
                </xsl:element>
            </xsl:if>
            
            <xsl:for-each select="tls_server_credentials_list">
                <xsl:for-each select="list_entry">
                    <xsl:element name="tls_server_credentials_list">
                        <xsl:attribute name='ref'><xsl:value-of select="@value"/></xsl:attribute>
                        <xsl:if test="@ref_key">
                            <xsl:attribute name='ref_key'><xsl:value-of select="@ref_key"/></xsl:attribute>
                        </xsl:if>
                        <xsl:if test="@class_id">
                            <xsl:attribute name='class_id'><xsl:value-of select="@class_id"/></xsl:attribute>
                        </xsl:if>                        
                    </xsl:element>
                </xsl:for-each>
            </xsl:for-each>
            
            <xsl:apply-templates select="firewall_node"/>
            <xsl:apply-templates select="alias_value"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- + removal of obsolete firewallrunning_test/interfaceup_test xml child from engine cluster xml definitions
         + removal of arp_entry since moved directly in physical_interface
         + change order in xml children nodes: to have physical_interface before interfaces
      -->      
    <xsl:template match="sensor_cluster">
        <xsl:copy>
            <xsl:apply-templates select="@*    [    name(.) != 'ca_for_signing'
                                                and name(.) != 'mgt_server_ref'
                                                and name(.) != 'mgt_server_ref_key'] |
                                         node()[    name(.) != 'firewallrunning_test'
                                                and name(.) != 'interfaceup_test'
                                                and name(.) != 'arp_entry'
                                                and name(.) != 'external_test'
                                                and name(.) != 'filesystemspace_test'
                                                and name(.) != 'inline_test'
                                                and name(.) != 'freeswapspace_test'
                                                and name(.) != 'linkstatus_test'
                                                and name(.) != 'multiping_test'
                                                and name(.) != 'tls_server_credentials_list'
                                                and name(.) != 'sensor_node'
                                                and name(.) != 'physical_interface'
                                                and name(.) != 'capture_interface'
                                                and name(.) != 'inline_interface'
                                                and name(.) != 'default_responses'
                                                and name(.) != 'alias_value' 
                                                and name(.) != 'domain_server_address' ]"/>
            
            <xsl:apply-templates select="freeswapspace_test"/>
            <xsl:apply-templates select="linkstatus_test"/>
            <xsl:apply-templates select="multiping_test"/>
            <xsl:apply-templates select="external_test"/>
            <xsl:apply-templates select="filesystemspace_test"/>
            <xsl:apply-templates select="inline_test"/>
            
            <xsl:apply-templates select="physical_interface"/>
            <xsl:apply-templates select="capture_interface"/>
            <xsl:apply-templates select="inline_interface"/>
            <xsl:apply-templates select="domain_server_address"/>
            
            <xsl:if test="@ca_for_signing">
                <xsl:element name="tls_client_protection">
                    <xsl:attribute name="ca_for_signing_ref"><xsl:value-of select="@ca_for_signing"/></xsl:attribute>
                    <xsl:element name="tls_trusted_ca_tag_ref">
                        <xsl:attribute name="ref_key">10040000</xsl:attribute>
                        <xsl:attribute name="class_id">8109</xsl:attribute>
                    </xsl:element>                    
                </xsl:element>
            </xsl:if>
            
            <xsl:for-each select="tls_server_credentials_list">
                <xsl:for-each select="list_entry">
                    <xsl:element name="tls_server_credentials_list">
                        <xsl:attribute name='ref'><xsl:value-of select="@value"/></xsl:attribute>
                        <xsl:if test="@ref_key">
                            <xsl:attribute name='ref_key'><xsl:value-of select="@ref_key"/></xsl:attribute>
                        </xsl:if>
                        <xsl:if test="@class_id">
                            <xsl:attribute name='class_id'><xsl:value-of select="@class_id"/></xsl:attribute>
                        </xsl:if>                        
                    </xsl:element>
                </xsl:for-each>
            </xsl:for-each>
            
            <xsl:apply-templates select="sensor_node"/>            
            <xsl:apply-templates select="alias_value"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- + removal of obsolete firewallrunning_test/interfaceup_test xml child from engine cluster xml definitions
         + removal of arp_entry since moved directly in physical_interface
      -->
    <xsl:template match="fw_single">
        <xsl:copy>
            <xsl:apply-templates select="@*    [    name(.) != 'ca_for_signing'
                                                and name(.) != 'mgt_server_ref'
                                                and name(.) != 'mgt_server_ref_key'] |
                                         node()[    name(.) != 'firewallrunning_test'
                                                and name(.) != 'interfaceup_test'
                                                and name(.) != 'external_test'
                                                and name(.) != 'filesystemspace_test'
                                                and name(.) != 'firewallpolicyloaded_test'
                                                and name(.) != 'freeswapspace_test'
                                                and name(.) != 'linkstatus_test'
                                                and name(.) != 'multiping_test'
                                                and name(.) != 'arp_entry'
                                                and name(.) != 'tls_server_credentials_list'
                                                and name(.) != 'connection_timeout'
                                                and name(.) != 'physical_interface'
                                                and name(.) != 'policy_route'
                                                and name(.) != 'static_multicast_route'
                                                and name(.) != 'nat_pool'
                                                and name(.) != 'antivirus'
                                                and name(.) != 'log_moderation'
                                                and name(.) != 'modem_interface'
                                                and name(.) != 'adsl_interface'
                                                and name(.) != 'wireless_interface'
                                                and name(.) != 'contact_policy'
                                                and name(.) != 'wireless_interface'
                                                and name(.) != 'alias_value'
                                                and name(.) != 'domain_server_address'
                                                and name(.) != 'fw_single_interface' ]"/>

            <xsl:apply-templates select="firewallpolicyloaded_test"/>
            <xsl:apply-templates select="freeswapspace_test"/>
            <xsl:apply-templates select="linkstatus_test"/>
            <xsl:apply-templates select="multiping_test"/>
            <xsl:apply-templates select="external_test"/>
            <xsl:apply-templates select="filesystemspace_test"/>
            
            <xsl:apply-templates select="physical_interface"/>
            <xsl:apply-templates select="modem_interface"/>
            <xsl:apply-templates select="adsl_interface"/>
            <xsl:apply-templates select="wireless_interface"/>
            <xsl:apply-templates select="connection_timeout"/>
            <xsl:apply-templates select="policy_route"/>
            <xsl:apply-templates select="static_multicast_route"/>
            <xsl:apply-templates select="nat_pool"/>
            <xsl:apply-templates select="antivirus"/>
            <xsl:apply-templates select="log_moderation"/>
            <xsl:apply-templates select="contact_policy"/>
            <xsl:apply-templates select="domain_server_address"/>
            
            <xsl:if test="@ca_for_signing">
                <xsl:element name="tls_client_protection">
                    <xsl:attribute name="ca_for_signing_ref"><xsl:value-of select="@ca_for_signing"/></xsl:attribute>
                    <xsl:element name="tls_trusted_ca_tag_ref">
                        <xsl:attribute name="ref_key">10040000</xsl:attribute>
                        <xsl:attribute name="class_id">8109</xsl:attribute>
                    </xsl:element>                    
                </xsl:element>
            </xsl:if>
            
            <xsl:for-each select="tls_server_credentials_list">
                <xsl:for-each select="list_entry">
                    <xsl:element name="tls_server_credentials_list">
                        <xsl:attribute name='ref'><xsl:value-of select="@value"/></xsl:attribute>
                        <xsl:if test="@ref_key">
                            <xsl:attribute name='ref_key'><xsl:value-of select="@ref_key"/></xsl:attribute>
                        </xsl:if>
                        <xsl:if test="@class_id">
                            <xsl:attribute name='class_id'><xsl:value-of select="@class_id"/></xsl:attribute>
                        </xsl:if>                        
                    </xsl:element>
                </xsl:for-each>
            </xsl:for-each>
            
            <xsl:apply-templates select="fw_single_interface"/>
            <xsl:apply-templates select="alias_value"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- + removal of obsolete firewallrunning_test/interfaceup_test xml child from engine cluster xml definitions
         + removal of arp_entry since moved directly in physical_interface
         + change order in xml children nodes: to have physical_interface before interfaces
      -->      
    <xsl:template match="analyzer">
        <xsl:copy>
            <xsl:apply-templates select="@*    [    name(.) != 'ca_for_signing'
                                                and name(.) != 'mgt_server_ref'
                                                and name(.) != 'mgt_server_ref_key' ] |
                                         node()[    name(.) != 'firewallrunning_test'
                                                and name(.) != 'interfaceup_test'
                                                and name(.) != 'arp_entry'
                                                and name(.) != 'external_test'
                                                and name(.) != 'filesystemspace_test'
                                                and name(.) != 'freeswapspace_test'
                                                and name(.) != 'linkstatus_test'
                                                and name(.) != 'multiping_test'                                                
                                                and name(.) != 'physical_interface' 
                                                and name(.) != 'analyzer_interface'
                                                and name(.) != 'analyzer_default_responses'
                                                and name(.) != 'alias_value'
                                                and name(.) != 'blacklisting_fw_cvi' ]"/>
            
            <xsl:apply-templates select="freeswapspace_test"/>
            <xsl:apply-templates select="linkstatus_test"/>
            <xsl:apply-templates select="multiping_test"/>
            <xsl:apply-templates select="external_test"/>
            <xsl:apply-templates select="filesystemspace_test"/>
            
            <xsl:apply-templates select="physical_interface"/>
            
            <xsl:for-each select="analyzer_interface">
                <xsl:element name="node_interface">
                    <xsl:if test="analyzer_ndi_mode/@control_ip_address='primary'">
                        <xsl:attribute name="primary_mgt">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="analyzer_ndi_mode/@control_ip_address='backup'">
                        <xsl:attribute name="backup_mgt">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="analyzer_ndi_mode/@log_analyzer_communication">
                        <xsl:attribute name="outgoing"><xsl:value-of select="analyzer_ndi_mode/@log_analyzer_communication"/></xsl:attribute>
                    </xsl:if>
                    
                    <xsl:attribute name="nodeid">1</xsl:attribute>
                    <xsl:attribute name="network_value"><xsl:value-of select="smc_converter_util:getNetworkValue(mvia_address/@address, @network_value)" disable-output-escaping="yes"/></xsl:attribute>
            
                    <xsl:apply-templates select="@*[name(.) != 'network_value']|node()[name(.) != 'analyzer_ndi_mode']"/>
                </xsl:element>            
            </xsl:for-each>
            
            <xsl:apply-templates select="blacklisting_fw_cvi"/>
            <xsl:apply-templates select="alias_value"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- renaming of firewall_node_interface/sensor_node_interface in node_interface
       + removal of obsolete firewallrunning_test/interfaceup_test xml child from engine cluster xml definitions
      -->
    <xsl:template match="firewall_node">
        <xsl:variable name="node_id"><xsl:value-of select="@nodeid"/></xsl:variable>
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            
            <xsl:for-each select="firewall_node_interface">
                <xsl:element name="node_interface">
                    <xsl:if test="firewall_ndi_mode/@control_ip_address='primary'">
                        <xsl:attribute name="primary_mgt">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="firewall_ndi_mode/@control_ip_address='backup'">
                        <xsl:attribute name="backup_mgt">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="firewall_ndi_mode/@heartbeat='primary'">
                        <xsl:attribute name="primary_heartbeat">true</xsl:attribute>
                    </xsl:if>            
                    <xsl:if test="firewall_ndi_mode/@heartbeat='backup'">
                        <xsl:attribute name="backup_heartbeat">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="firewall_ndi_mode/@default_ip_for_connections">
                        <xsl:attribute name="outgoing"><xsl:value-of select="firewall_ndi_mode/@default_ip_for_connections"/></xsl:attribute>                    
                    </xsl:if>
                    
                    <xsl:attribute name="nodeid"><xsl:value-of select="$node_id"/></xsl:attribute>
                    <xsl:attribute name="network_value"><xsl:value-of select="smc_converter_util:getNetworkValue(mvia_address/@address, @network_value)" disable-output-escaping="yes"/></xsl:attribute>
            
                    <xsl:apply-templates select="@*[name(.) != 'network_value']|node()[name(.) != 'firewall_ndi_mode']"/>                    
                </xsl:element>
            </xsl:for-each>
            
            <xsl:apply-templates select="node()[    name(.) != 'firewall_node_interface'
                                                and name(.) != 'firewallrunning_test'
                                                and name(.) != 'interfaceup_test'
                                                and name(.) != 'external_test'
                                                and name(.) != 'filesystemspace_test'
                                                and name(.) != 'firewallpolicyloaded_test'
                                                and name(.) != 'freeswapspace_test'
                                                and name(.) != 'linkstatus_test'
                                                and name(.) != 'multiping_test' ]"/>
            
            <xsl:apply-templates select="firewallpolicyloaded_test"/>
            <xsl:apply-templates select="freeswapspace_test"/>
            <xsl:apply-templates select="linkstatus_test"/>
            <xsl:apply-templates select="multiping_test"/>
            <xsl:apply-templates select="external_test"/>
            <xsl:apply-templates select="filesystemspace_test"/>                   
        </xsl:copy>
    </xsl:template>
    <xsl:template match="ssl_vpn_node">
        <xsl:variable name="node_id"><xsl:value-of select="@nodeid"/></xsl:variable>
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            
            <xsl:for-each select="firewall_node_interface">
                <xsl:element name="node_interface">
                    <xsl:if test="firewall_ndi_mode/@control_ip_address='primary'">
                        <xsl:attribute name="primary_mgt">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="firewall_ndi_mode/@control_ip_address='backup'">
                        <xsl:attribute name="backup_mgt">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="firewall_ndi_mode/@heartbeat='primary'">
                        <xsl:attribute name="primary_heartbeat">true</xsl:attribute>
                    </xsl:if>            
                    <xsl:if test="firewall_ndi_mode/@heartbeat='backup'">
                        <xsl:attribute name="backup_heartbeat">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="firewall_ndi_mode/@default_ip_for_connections">
                        <xsl:attribute name="outgoing"><xsl:value-of select="firewall_ndi_mode/@default_ip_for_connections"/></xsl:attribute>                    
                    </xsl:if>
                    
                    <xsl:attribute name="nodeid"><xsl:value-of select="$node_id"/></xsl:attribute>
                    <xsl:attribute name="network_value"><xsl:value-of select="smc_converter_util:getNetworkValue(mvia_address/@address, @network_value)" disable-output-escaping="yes"/></xsl:attribute>
            
                    <xsl:apply-templates select="@*[name(.) != 'network_value' and name(.) != 'igmp_mode' and name(.) != 'igmp_version']|node()[name(.) != 'firewall_ndi_mode']"/>                    
                </xsl:element>
            </xsl:for-each>
            
            <xsl:apply-templates select="node()[ name(.) != 'firewall_node_interface' ]"/>
        </xsl:copy>
    </xsl:template>    
    <xsl:template match="sensor_node">
        <xsl:variable name="node_id"><xsl:value-of select="@nodeid"/></xsl:variable>
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:for-each select="sensor_node_interface">
                <xsl:element name="node_interface">
                    <xsl:if test="sensor_ndi_mode/@control_ip_address='primary'">
                        <xsl:attribute name="primary_mgt">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="sensor_ndi_mode/@control_ip_address='backup'">
                        <xsl:attribute name="backup_mgt">true</xsl:attribute>
                    </xsl:if>
                    <xsl:if test="sensor_ndi_mode/@heartbeat='primary'">
                        <xsl:attribute name="primary_heartbeat">true</xsl:attribute>
                    </xsl:if>            
                    <xsl:if test="sensor_ndi_mode/@heartbeat='backup'">
                        <xsl:attribute name="backup_heartbeat">true</xsl:attribute>
                    </xsl:if>  
                    <xsl:if test="sensor_ndi_mode/@log_analyzer_communication">
                        <xsl:attribute name="outgoing"><xsl:value-of select="sensor_ndi_mode/@log_analyzer_communication"/></xsl:attribute>                        
                    </xsl:if>
                    
                    <xsl:attribute name="nodeid"><xsl:value-of select="$node_id"/></xsl:attribute>
                    <xsl:attribute name="network_value"><xsl:value-of select="smc_converter_util:getNetworkValue(mvia_address/@address, @network_value)" disable-output-escaping="yes"/></xsl:attribute>
            
                    <xsl:apply-templates select="@*[name(.) != 'network_value' and name(.) != 'igmp_mode' and name(.) != 'igmp_version']|node()[name(.) != 'sensor_ndi_mode']"/>           
                </xsl:element>
            </xsl:for-each>
            <xsl:apply-templates select="node()[name(.)!='sensor_node_interface']"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- + arp_entry moved from engine cluster xml definition to interface xml definition
         + merge interface_id and vlan_id in interface_id
         + renaming of physical_interface children in vlan_interface
      -->
    <xsl:template match="physical_interface">
        <xsl:if test="not(parent::physical_interface)">
            <xsl:variable name="pint_nicid">
                <xsl:value-of select="@interface_id"/>
            </xsl:variable>
            
            <xsl:copy>
                <xsl:apply-templates select="@*"/>
            
                <xsl:for-each select="preceding-sibling::arp_entry">
                    <xsl:if test="@nicid = $pint_nicid">
                        <xsl:apply-templates select="."/>
                    </xsl:if>
                </xsl:for-each>
                
                <xsl:apply-templates select="node()"/>
                
                <xsl:for-each select="physical_interface">
                    <xsl:variable name="pint_nicid_with_vlanid">
                        <xsl:value-of select="concat($pint_nicid, concat('.', @vlan_id))"/>
                    </xsl:variable>
                
                    <xsl:element name="vlan_interface">
                        <xsl:attribute name="interface_id"><xsl:value-of select="@interface_id"/>.<xsl:value-of select="@vlan_id"/></xsl:attribute>
                        
                        <xsl:apply-templates select="@*[name(.) != 'interface_id' and name(.) != 'vlan_id']"/>
                        
                        <xsl:for-each select="../preceding-sibling::arp_entry">
                            <xsl:if test="@nicid = $pint_nicid_with_vlanid">
                                <xsl:apply-templates select="."/>
                            </xsl:if>
                        </xsl:for-each>
                        
                        <xsl:apply-templates select="node()[name(.) != 'log_moderation']"/>
                    </xsl:element>
                </xsl:for-each>            
            </xsl:copy>
        </xsl:if>
    </xsl:template>      

    
    <!-- + ssid_profile new child for ssid_interface to gather all ssid attributes
         + arp_entry moved from engine cluster xml definition to interface xml definition
         + merge interface_id and vlan_id in interface_id
      -->
    <xsl:template match="ssid_interface">
        <xsl:variable name="pint_nicid_with_vlanid">
            <xsl:value-of select="concat(@interface_id, concat('.', @vlan_id))"/>
        </xsl:variable>
                        
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.) != 'interface_id' and name(.) != 'vlan_id' and name(.) != 'ssid' and name(.) != 'bssid' and name(.) != 'ssid_broadcast' and name(.) != 'security_mode' and name(.) != 'default_key' and name(.) != 'key_length' and name(.) != 'encrypted_key_1' and name(.) != 'encrypted_key_2' and name(.) != 'encrypted_key_3' and name(.) != 'encrypted_key_4' and name(.) != 'wpa_mode' and name(.) != 'encrypted_wpa_shared_key' and name(.) != 'dhcp_server_address_range' and name(.) != 'primary_dns_server_ref' and name(.) != 'primary_dns_server_ref_key' and name(.) != 'secondary_dns_server_ref' and name(.) != 'secondary_dns_server_ref_key' and name(.) != 'radius_server_ref' and name(.) != 'radius_server_ref_key' and name(.)!='cvi_mode' and name(.)!='syn_mode']"/>
        
            <xsl:for-each select="../preceding-sibling::arp_entry">
                <xsl:if test="@nicid = $pint_nicid_with_vlanid">
                    <xsl:apply-templates select="."/>
                </xsl:if>
            </xsl:for-each>

            <xsl:attribute name="interface_id"><xsl:value-of select="@interface_id"/>.<xsl:value-of select="@vlan_id"/></xsl:attribute>
            
            <xsl:apply-templates select="node()[name(.) != 'mac_filtering']"/>
            
            <xsl:element name="ssid_profile">
                <xsl:apply-templates select="@*[name(.) = 'ssid' or name(.) = 'bssid' or name(.) = 'ssid_broadcast' or name(.) = 'security_mode' or name(.) = 'default_key' or name(.) = 'key_length' or name(.) = 'encrypted_key_1' or name(.) = 'encrypted_key_2' or name(.) = 'encrypted_key_3' or name(.) = 'encrypted_key_4' or name(.) = 'wpa_mode' or name(.) = 'encrypted_wpa_shared_key' or name(.) = 'dhcp_server_address_range' or name(.) = 'primary_dns_server_ref' or name(.) = 'primary_dns_server_ref_key' or name(.) = 'secondary_dns_server_ref' or name(.) = 'secondary_dns_server_ref_key' or name(.) = 'radius_server_ref' or name(.) = 'radius_server_ref_key']|node()[name(.) = 'mac_filtering']"/>
            </xsl:element>
        </xsl:copy>
    </xsl:template>
    
    <!-- + wireless_profile new child for wireless_interface to gather all wireless attributes
         + arp_entry moved from engine cluster xml definition to interface xml definition
      -->
    <xsl:template match="wireless_interface">
        <xsl:variable name="pint_nicid">
            <xsl:value-of select="@interface_id"/>
        </xsl:variable>
                
        <xsl:copy>
            <xsl:for-each select="preceding-sibling::arp_entry">
                <xsl:if test="nicid = $pint_nicid">
                    <xsl:apply-templates select="."/>
                </xsl:if>
            </xsl:for-each>
        
            <xsl:apply-templates select="@*[name(.) != 'wireless_channel' and name(.) != 'wireless_network_mode' and name(.) != 'wireless_country' and name(.)!='cvi_mode']|node()"/>
            <xsl:element name="wireless_profile">
                <xsl:apply-templates select="@*[name(.) = 'wireless_channel' or name(.) = 'wireless_network_mode' or name(.) = 'wireless_country']|node()"/>
            </xsl:element>
        </xsl:copy>
    </xsl:template>

    <!-- + removal of cvi_mode and syn_mode for ssid/modem interfaces
         + arp_entry moved from engine cluster xml definition to interface xml definition
      -->
    <xsl:template match="modem_interface">
        <xsl:variable name="pint_nicid">
            <xsl:value-of select="@interface_id"/>
        </xsl:variable>
    
        <xsl:copy>
            <xsl:for-each select="preceding-sibling::arp_entry">
                <xsl:if test="nicid = $pint_nicid">
                    <xsl:apply-templates select="."/>
                </xsl:if>
            </xsl:for-each>
        
            <xsl:apply-templates select="@*[name(.)!='cvi_mode' and name(.)!='syn_mode']|node()"/>
        </xsl:copy>
    </xsl:template>
    <!-- + removal of cvi_mode for adsl/wireless interfaces
         + arp_entry moved from engine cluster xml definition to interface xml definition
      -->
    <xsl:template match="adsl_interface">
        <xsl:variable name="pint_nicid">
            <xsl:value-of select="@interface_id"/>
        </xsl:variable>
    
        <xsl:copy>
            <xsl:for-each select="preceding-sibling::arp_entry">
                <xsl:if test="nicid = $pint_nicid">
                    <xsl:apply-templates select="."/>
                </xsl:if>
            </xsl:for-each>
                    
            <xsl:apply-templates select="@*[name(.)!='cvi_mode']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- merge XXX_ndi_mode in XXX_interface -->
    <xsl:template match="fw_single_interface">
        <xsl:copy>
            <xsl:if test="single_fw_ndi_mode/@control_ip_address='primary'">
                <xsl:attribute name="primary_mgt">true</xsl:attribute>
            </xsl:if>
            <xsl:if test="single_fw_ndi_mode/@control_ip_address='backup'">
                <xsl:attribute name="backup_mgt">true</xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="single_fw_ndi_mode/@*[name(.) != 'control_ip_address']"/>
            
            <xsl:attribute name="nodeid">1</xsl:attribute>
            <xsl:attribute name="network_value"><xsl:value-of select="smc_converter_util:getNetworkValue(mvia_address/@address, @network_value)" disable-output-escaping="yes"/></xsl:attribute>
            <xsl:if test="@vrrp_id or @vrrp_priority or @vrrp_address">
                <xsl:attribute name="vrrp">true</xsl:attribute>
            </xsl:if>
            <xsl:if test="@pppoe_username and (not(@modem) or @modem='false')">
                <xsl:attribute name="pppoe">true</xsl:attribute>
            </xsl:if>

            <xsl:apply-templates select="@*[name(.) != 'network_value' and name(.) != 'pppoe_password']|node()[name(.) != 'single_fw_ndi_mode']"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- renaming used_for_auth_request in auth_request + network_value change -->
    <xsl:template match="cluster_virtual_interface">
        <xsl:copy>
            <xsl:attribute name="auth_request"><xsl:value-of select="@used_for_auth_request"/></xsl:attribute>
            <xsl:attribute name="network_value"><xsl:value-of select="smc_converter_util:getNetworkValue(mvia_address/@address, @network_value)" disable-output-escaping="yes"/></xsl:attribute>
            
            <xsl:apply-templates select="@*[name(.) != 'used_for_auth_request' and name(.) != 'network_value']|node()"/>
        </xsl:copy>
    </xsl:template>          
    
    <!-- merge source_ip/source_netmask and dest_ip/dest_netmask for policy_route-->
    <xsl:template match="policy_route">
        <xsl:copy>
            <xsl:attribute name="source"><xsl:value-of select="smc_converter_util:getNetworkValue(@source_ip, @source_netmask)" disable-output-escaping="yes"/></xsl:attribute>
            <xsl:attribute name="destination"><xsl:value-of select="smc_converter_util:getNetworkValue(@dest_ip, @dest_netmask)" disable-output-escaping="yes"/></xsl:attribute>
            
            <xsl:apply-templates select="@*[name(.) != 'source_ip' and name(.) != 'source_netmask' and name(.) != 'dest_ip' and name(.) != 'dest_netmask']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- merge first_address/last_address for nat_pool -->
    <xsl:template match="nat_pool">
        <xsl:copy>
            <xsl:if test="@first_address and @last_address">
                <xsl:attribute name="nat_pool_range"><xsl:value-of select="@first_address"/>-<xsl:value-of select="@last_address"/></xsl:attribute>
            </xsl:if>
            
            <xsl:apply-templates select="@*[name(.) != 'first_address' and name(.) != 'last_address']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- + merge min/max for lbfilter_iprange and merge ipaddress/netmask for lbfilter_ipnetwork for only ip_descriptor in lbfilter
         + action 'pass_all|block_all|pass' replaced by 'node'
      -->
    <xsl:template match="lbfilter">
        <xsl:copy>
            <xsl:if test="lbfilter_iprange">
                <xsl:attribute name="ip_descriptor"><xsl:value-of select="lbfilter_iprange/@min"/>-<xsl:value-of select="lbfilter_iprange/@max"/></xsl:attribute>            
            </xsl:if>
            <xsl:if test="lbfilter_ipnetwork">
                <xsl:attribute name="ip_descriptor"><xsl:value-of select="smc_converter_util:getNetworkValue(lbfilter_ipnetwork/@ipaddress, lbfilter_ipnetwork/@netmask)" disable-output-escaping="yes"/></xsl:attribute>
            </xsl:if>
            
            <xsl:choose>
                <xsl:when test="@action='pass_all'">
                    <xsl:attribute name="action">node</xsl:attribute>
                </xsl:when>
                <xsl:when test="@action='block_all'">
                    <xsl:attribute name="action">node</xsl:attribute>
                </xsl:when>
                <xsl:when test="@action='pass'">
                    <xsl:attribute name="action">node</xsl:attribute>
                </xsl:when>                
                <xsl:otherwise>
                    <xsl:attribute name="action"><xsl:value-of select="@action"/></xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            
            <xsl:apply-templates select="@*[name(.) != 'action']|node()[name(.) != 'lbfilter_iprange' and name(.) != 'lbfilter_ipnetwork']"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="connection_timeout">
        <xsl:copy>
            <xsl:choose>
                <xsl:when test="@protocol='others'">
                    <xsl:attribute name="protocol">other</xsl:attribute>
                </xsl:when>
                <xsl:when test="@protocol='ipsec_etablished'">
                    <xsl:attribute name="protocol">ipsec_established</xsl:attribute>
                </xsl:when>

                <xsl:otherwise>
                    <xsl:attribute name="protocol"><xsl:value-of select="@protocol"/></xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates select="@*[name(.) != 'protocol']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="arp_entry">
        <xsl:copy>
            <xsl:attribute name="netmask"><xsl:value-of select="smc_converter_util:getNetmaskValue(@netmask)" disable-output-escaping="yes"/></xsl:attribute>
            <xsl:apply-templates select="@*[name(.) != 'netmask']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="ssl_vpn_cluster">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.) != 'mgt_server_ref' and name(.) != 'mgt_server_ref_key'] |
                                         node()[    name(.) != 'category_ref'
                                                and name(.) != 'ssl_vpn_node'
                                                and name(.) != 'physical_interface' ]"/>
            
            <xsl:apply-templates select="category_ref"/>
            <xsl:apply-templates select="physical_interface"/>
            <xsl:apply-templates select="ssl_vpn_node"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- Gateway Settings: remove obsolete attributes and add new ones -->
    <xsl:template match="gateway_settings">
        <xsl:copy>
            <xsl:attribute name="mobike_before_sa_update"><xsl:text>false</xsl:text></xsl:attribute>
            <xsl:attribute name="mobike_after_sa_update"><xsl:text>false</xsl:text></xsl:attribute>
            <xsl:attribute name="mobike_no_rrc"><xsl:text>true</xsl:text></xsl:attribute>
            <xsl:apply-templates select="@*[name(.)!='anti_clogging_local_secret_creation' 
                                        and name(.)!='anti_clogging_token_digest_algorithm'
                                        and name(.)!='tunnel_recovery_entry_max_size'
                                        and name(.)!='tunnel_recovery_pool_interval'
                                        and name(.)!='tunnel_recovery_ttl_before'
                                        and name(.)!='tunnel_recovery_ttl_after'
                                        and name(.)!='tunnel_recovery_min_hit_number'
                                        and name(.)!='encryption_key_max_lenth'
                                        and name(.)!='tunnel_recovery_enable'
                                        and name(.)!='ike_sa_max_number'
                                        and name(.)!='fips_enable']|node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="service_ethernet">
        <xsl:copy>
            <xsl:if test="@type">
                <xsl:attribute name="value1"><xsl:value-of select="@type"/></xsl:attribute>
            </xsl:if>
            <xsl:if test="@llc_ssap">
                <xsl:attribute name="value1"><xsl:value-of select="@llc_ssap"/></xsl:attribute>            
            </xsl:if>
            <xsl:if test="@llc_dsap">
                <xsl:attribute name="value2"><xsl:value-of select="@llc_dsap"/></xsl:attribute>            
            </xsl:if>
            <xsl:if test="@snap_vendor">
                <xsl:attribute name="value1"><xsl:value-of select="@snap_vendor"/></xsl:attribute>            
            </xsl:if>
            <xsl:if test="@snap_type">
                <xsl:attribute name="value2"><xsl:value-of select="@snap_type"/></xsl:attribute>            
            </xsl:if>
            
            <xsl:apply-templates select="@*[    name(.) != 'type' 
                                            and name(.) != 'llc_ssap'
                                            and name(.) != 'llc_dsap'
                                            and name(.) != 'snap_vendor'
                                            and name(.) != 'snap_type' ]|node()"/>        
        </xsl:copy>
    </xsl:template>

    <xsl:template match="service_ref|category_ref|certificate_authority_ref">
        <xsl:copy>
            <xsl:if test="@value">
                <xsl:attribute name="ref"><xsl:value-of select="@value"/></xsl:attribute>
            </xsl:if> 
            <xsl:apply-templates select="@*[ name(.) != 'value' and name(.) != 'type' ]|node()"/>        
        </xsl:copy>
    </xsl:template>

    <xsl:template match="task_schedule">
        <xsl:copy>
            <xsl:if test="not(@final_action)">
                <xsl:attribute name="final_action">ALERT_FAILURE</xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>

	<!-- remove tool_list level in tools_profile . -->
	<xsl:template match="tools_profile">
        <xsl:copy>
            <xsl:apply-templates select="@*|node() [ name(.) != 'tool_list']"/>
            <xsl:apply-templates select="tool_list/*"/>
        </xsl:copy>
	</xsl:template>

    <!-- merge first_address/last_address for address_range into ip_range -->
    <xsl:template match="address_range">
        <xsl:copy>
            <xsl:if test="@first_address and @last_address">
                <xsl:attribute name="ip_range"><xsl:value-of select="@first_address"/>-<xsl:value-of select="@last_address"/></xsl:attribute>
            </xsl:if>
            
            <xsl:apply-templates select="@*[name(.) != 'first_address' and name(.) != 'last_address']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- merge IPv4 and IPv6 address + netmask into networks -->
    <xsl:template match="network">
        <xsl:copy>
            <xsl:if test="@ipaddress">
                <xsl:attribute name="ipv4_network"><xsl:value-of select="smc_converter_util:getNetworkValue(@ipaddress, @netmask)" disable-output-escaping="yes"/></xsl:attribute>
            </xsl:if>

            <xsl:if test="@ipv6_address">
                <xsl:attribute name="ipv6_network"><xsl:value-of select="@ipv6_address"/>/<xsl:value-of select="@ipv6_netmask"/></xsl:attribute>
            </xsl:if>

            <xsl:apply-templates select="@*[name(.) != 'ipaddress' and name(.) != 'netmask' and name(.) != 'ipv6_address' and name(.) != 'ipv6_netmask']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!--  End point attribute standby replaced by mode. -->
    <xsl:template match="end_point">  
        <xsl:copy>
            <xsl:choose>
               <xsl:when test="@standby='false'">
                   <xsl:attribute name="mode">active</xsl:attribute>
               </xsl:when>
               <xsl:otherwise>
                   <xsl:attribute name="mode">standby</xsl:attribute>                 
               </xsl:otherwise>          
           </xsl:choose>
           <xsl:apply-templates select="@*[(name(.) != 'standby')]|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!--  id xml attribute removal from situation. -->
    <xsl:template match="situation">  
        <xsl:copy>
           <xsl:apply-templates select="@*[(name(.) != 'id')]|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- Site attributes related to Client 2.x are removed. -->
    <xsl:template match="vpn_site">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.)!='primary_dns_server_address' 
                                        and name(.)!='secondary_dns_server_address'] |
                                node()[    name(.) != 'dns_domain_name'
                                       and name(.) != 'IPSec_client_access_site_ref']"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- Move the certificate_authority_ref node after the local_security_checks node. -->
    <xsl:template match="vpn_profile">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()[name(.) != 'certificate_authority_ref']"/>
        </xsl:copy>
         <xsl:for-each select="certificate_authority_ref">
            <xsl:apply-templates select="certificate_authority_ref"/>
         </xsl:for-each>
    </xsl:template>
    
    <!-- Fix ALERT_SEVERITY guitype to less strict to allow update package activation. -->
    <xsl:template match="logfield[@key='602']/display-hints[@guitype='constants']/@guitype">
        <xsl:attribute name="guitype">severity</xsl:attribute>
    </xsl:template>
    
 	<!-- copy everything else -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	
</xsl:stylesheet>
