<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:smc_logging_profile_util="com.stonesoft.thirdparty.ie.importer.LoggingProfileXSLUtil"
                exclude-result-prefixes="smc_migration smc_logging_profile_util">
    <xsl:output doctype-system="generic_import_export_v5.2.dtd" indent="yes"/>
    <!-- converter, when importing a file using 5.1 dtd: transform into 5.2 dtd -->
    <!-- when importing older file, it will pass through older converters first -->

    <xsl:template match="filter_expression//literal/@type[../@type = 'INTEGER']">
        <xsl:attribute name="type">LONG</xsl:attribute>
    </xsl:template>
    <xsl:template match="filter_expression//literal/@type[../@type = 'FLOAT']">
        <xsl:attribute name="type">DOUBLE</xsl:attribute>
    </xsl:template>
    <xsl:template match="filter_expression//literal/@type[../@type = 'IPV4_ADDRESS' or ../@type = 'IPV4_NETWORK' or ../@type = 'IPV6_ADDRESS']">
        <xsl:attribute name="type">IPV6_NETWORK</xsl:attribute>
    </xsl:template>

    <xsl:template match="logging_profile[position() = 1]">
        <xsl:value-of select="smc_logging_profile_util:getLoggingProfiles( /generic_import_export/logging_profile )" disable-output-escaping="yes"/>
        <xsl:value-of select="smc_logging_profile_util:getResolvers( /generic_import_export/resolver )" disable-output-escaping="yes"/>
    </xsl:template>
    <xsl:template match="logging_profile[position() > 1]">
    </xsl:template>
    <xsl:template match="resolver">
    </xsl:template>

    <xsl:template match="task_schedule[@owner='3' and (@key = '2' or @key='4' or @key='6' or @key='8' or @key='10' or @key='12' or @key='14' or @key='16' or @key='18' or @key='20')]|storable_task_definition[@key='7' or @key='13']">
      <xsl:copy>
          <xsl:apply-templates select="@*[name(.)!='owner']"/>
          <xsl:attribute name="owner">1</xsl:attribute>
          <xsl:apply-templates select="node()"/>
      </xsl:copy>
    </xsl:template>

    <xsl:template match="storable_task_definition[(@key='7' or @key='13')]//task_resource_entry[@resource_ref='3']">
      <xsl:copy>
          <xsl:apply-templates select="@*[name(.)!='resource_ref']"/>
          <xsl:attribute name="resource_ref">1</xsl:attribute>
      </xsl:copy>
    </xsl:template>

    <xsl:template match="task_definition[(@key='17' or @key='15' or @key='11' or @key='9' or @key='5' or @key='3' or @key='1') and ((@resource_class='18' and @resource_key='3') and (@owner_class='18' and @owner_key='3'))]">
      <xsl:copy>
          <xsl:apply-templates select="@*[name(.)!='resource_key' and name(.)!='owner_key' and name(.)!='resource_class' and name(.)!='owner_class']"/>
          <xsl:attribute name="resource_key">1</xsl:attribute>
          <xsl:attribute name="resource_class">11</xsl:attribute>
          <xsl:attribute name="owner_key">1</xsl:attribute>
          <xsl:attribute name="owner_class">11</xsl:attribute>
      </xsl:copy>
    </xsl:template>
    <xsl:template match="task_schedule[(@key = '2' or @key='4' or @key='6' or @key='8' or @key='10' or @key='12' or @key='14' or @key='16' or @key='18' or @key='20') and (@owner_class='18' and @owner_key='3')]|task_definition[(not(@resource_class='18' and @resource_key='3')) and (@owner_class='18' and @owner_key='3')]">
      <xsl:copy>
          <xsl:apply-templates select="@*[name(.)!='owner_key' and name(.)!='owner_class']"/>
          <xsl:attribute name="owner_key">1</xsl:attribute>
          <xsl:attribute name="owner_class">11</xsl:attribute>
      </xsl:copy>
    </xsl:template>
    <xsl:template match="task_definition[(@resource_class='18' and @resource_key='3') and (not (@owner_class='18' and @owner_key='3'))]">
      <xsl:copy>
          <xsl:apply-templates select="@*[name(.)!='resource_key' and name(.)!='resource_class']"/>
          <xsl:attribute name="resource_key">1</xsl:attribute>
          <xsl:attribute name="resource_class">11</xsl:attribute>
      </xsl:copy>
    </xsl:template>
    
    <xsl:template match="ne_list[@ref_key='3']">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.)!='ref_key']|node()"/>
        </xsl:copy>
    </xsl:template>
       
    <xsl:template match="network_element_ref[@ref_key='3']|granted_blacklister_ref[@type='network_element' and @ref_key='3']|match_destination_ref[@type='network_element' and @ref_key='3']|match_source_ref[@type='network_element' and @ref_key='3']|lens_attribute[@type='network_element' and @ref_key='3']|match_sender_ref[@type='network_element' and @ref_key='3']">
        <xsl:copy>
          <xsl:apply-templates select="@*[name(.)!='ref_key']|node()"/>
        </xsl:copy>
    </xsl:template>
       
    <xsl:template match="packet_description_new[@ne_ref_key='3']|packet_description[@ne_ref_key='3']|expression_value[@ne_ref_key='3']|storable_asn_level[@ne_ref_key='3']|any_rn_level[@ne_ref_key='3']|gateway_rn_level[@ne_ref_key='3']|default_alias_value[@ne_ref_key='3']">
      <xsl:copy>
        <xsl:apply-templates select="@*[name(.)!='ne_ref_key']|node()"/>
      </xsl:copy>
    </xsl:template>

    <xsl:template match="filter_expression//reference[@ref_key='3' and @type='network_element']">
      <xsl:copy>
          <xsl:apply-templates select="@*[name(.)!='ref_key']|node()"/>
      </xsl:copy>
    </xsl:template>
    
    <xsl:template match="diagram/lens_data[@type='LogicalEdge']/lens_attribute[@name = 'EDGETYPE_NAME' and @value = 'noconnectivityedge']/@value">
      <xsl:attribute name="value">normal</xsl:attribute>
    </xsl:template>
    <xsl:template match="diagram/lens_data[@type='LogicalEdge']/lens_attribute[@name = 'EDGETYPE_NAME' and @value = 'defaultipsedge']/@value">
      <xsl:attribute name="value">capture</xsl:attribute>
    </xsl:template>
    <xsl:template match="diagram/lens_data[@type='LogicalEdge']/lens_attribute[@name = 'EDGETYPE_NAME' and @value = 'redundantenoconnectivitydge']/@value">
      <xsl:attribute name="value">redundant</xsl:attribute>
    </xsl:template>
    <xsl:template match="diagram[@type='ip']/lens_data[@type='LogicalEdge']/lens_attribute[@name = 'EDGETYPE_NAME' and @value = 'defaultedge']/@value">
      <xsl:attribute name="value">normal</xsl:attribute>
    </xsl:template>
    <xsl:template match="diagram[@type='platform']/lens_data[@type='LogicalEdge']/lens_attribute[@name = 'EDGETYPE_NAME' and @value = 'defaultedge']/@value">
      <xsl:attribute name="value">connectivity</xsl:attribute>
    </xsl:template>
    <xsl:template match="diagram[@type='vpn']/lens_data[@type='LogicalEdge']/lens_attribute[@name = 'EDGETYPE_NAME' and @value = 'defaultedge']/@value">
      <xsl:attribute name="value">vpn_connectivity</xsl:attribute>
    </xsl:template>
    <xsl:template match="diagram[@type='ip']/lens_data[@type='LogicalEdge']/lens_attribute[@name = 'EDGETYPE_NAME' and @value = 'redundantedge']/@value">
      <xsl:attribute name="value">redundant</xsl:attribute>
    </xsl:template>
    <xsl:template match="diagram[@type='platform']/lens_data[@type='LogicalEdge']/lens_attribute[@name = 'EDGETYPE_NAME' and @value = 'redundantedge']/@value">
      <xsl:attribute name="value">redundant_connectivity</xsl:attribute>
    </xsl:template>
    
    <!-- antispoofing node : add bootp element instead of boolean value-->
    <xsl:template match="interface_asn_level|dyn_interface_asn_level">
        <xsl:copy>
        	<xsl:apply-templates select="@*[name(.)!='dhcp_bootp_enabled']"/>
            <xsl:element name="storable_asn_level">
                <xsl:attribute name="ne_ref"><xsl:text>Bootp/DHCP Client: 0.0.0.0</xsl:text></xsl:attribute>
                <xsl:attribute name="ne_ref_key">42</xsl:attribute>
                <xsl:attribute name="auto_generated">system</xsl:attribute>
        		<xsl:choose>
	        		<xsl:when test="@dhcp_bootp_enabled='true'">
						<xsl:attribute name="validity">absolute</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="validity">disable</xsl:attribute>
					</xsl:otherwise>
        		</xsl:choose>
            </xsl:element>
            <xsl:apply-templates select="node()"/>
        </xsl:copy>
    </xsl:template>

    <!-- convert 2 service_icmp (system) into service_icmpv6  -->
    <xsl:template match="service_icmp[@key='27']">
        <service_icmpv6>
			<xsl:apply-templates select="@*|node()"/>
        </service_icmpv6>
    </xsl:template>
    <xsl:template match="service_icmp[@key='28']">
        <service_icmpv6>
			<xsl:apply-templates select="@*|node()"/>
        </service_icmpv6>
    </xsl:template>
    
    <!-- replace protocol_agent_ref in protocol_agent_ref_key -->
    <xsl:template match="service_ethernet|service_ip|service_udp|service_tcp">
        <xsl:copy>
            <xsl:if test="@protocol_agent_ref != ''">
                <xsl:attribute name="protocol_agent_ref_key"><xsl:value-of select="@protocol_agent_ref"/></xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="@*[name(.)!='protocol_agent_ref']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- any_rn_level remove obsolete attribute: ipaddress -->
    <xsl:template match="any_rn_level">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.)!='ipaddress']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- set correct default value for mirrored capabilities values -->
    <xsl:template match="capabilities">
       <xsl:choose>
            <xsl:when test="(parent::gateway_type)">
               <xsl:copy>
                   <xsl:attribute name="vpn_client_dss_signature_for_ike"><xsl:value-of select="@dss_signature_for_ike"/></xsl:attribute>
                   <xsl:attribute name="vpn_client_rsa_signature_for_ike"><xsl:value-of select="@rsa_signature_for_ike"/></xsl:attribute>
                   <xsl:attribute name="vpn_client_sa_per_host"><xsl:value-of select="@sa_per_host"/></xsl:attribute>
                   <xsl:attribute name="vpn_client_sa_per_net"><xsl:value-of select="@sa_per_net"/></xsl:attribute>
                   <xsl:attribute name="vpn_client_gost_signature_for_ike"><xsl:value-of select="@gost_signature_for_ike"/></xsl:attribute>
                   
                   <xsl:apply-templates select="@*[name(.)!='vpn_client_gost_signature_for_ike' and name(.)!='vpn_client_dss_signature_for_ike' and name(.)!='vpn_client_rsa_signature_for_ike' and name(.)!='vpn_client_sa_per_host' and name(.)!='vpn_client_sa_per_net']|node()"/>
               </xsl:copy>
           </xsl:when>
           <xsl:otherwise>
               <xsl:copy>
                   <xsl:apply-templates select="@*|node()"/>
               </xsl:copy>
           </xsl:otherwise>
       </xsl:choose>
   </xsl:template>

    <!-- soho_firewall remove obsolete attribute -->
    <xsl:template match="soho_firewall">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.)!='corporate_static_dns' and name(.)!='guest_static_dns']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- vpn_action remove obsolete attribute -->
    <xsl:template match="vpn_action">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.)!='drop_unencrypted']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- tcp_client|tcp_server remove obsolete attribute -->
    <xsl:template match="tcp_client|tcp_server">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.)!='tcp_handshake_required']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!--  Gateway type 'StoneGate 2.5 - 3.x' replaced by 'StoneGate 3.x'-->
    <xsl:template match="client_gateway | external_gateway">  
        <xsl:copy>
            <xsl:choose>
               <xsl:when test="@gateway_type_ref='StoneGate 2.5 - 3.x'">
                   <xsl:attribute name="gateway_type_ref_key">1</xsl:attribute>
                   <xsl:apply-templates select="@*[(name(.) != 'gateway_type_ref')]|node()"/>
               </xsl:when>
               <xsl:when test="@gateway_type_ref='StoneGate 2.5 - 3.x FIPS'">
                   <xsl:attribute name="gateway_type_ref_key">6</xsl:attribute>
                   <xsl:apply-templates select="@*[(name(.) != 'gateway_type_ref')]|node()"/>
               </xsl:when>
               <xsl:otherwise>
                   <xsl:apply-templates select="@*|node()"/>
               </xsl:otherwise>
           </xsl:choose>
        </xsl:copy>
    </xsl:template>
    
    <!-- transform category from situation to group -->
    <xsl:template match="category">  
        <xsl:copy>
            <xsl:choose>
               <xsl:when test="(@key='79000000' or @key='77000000' or @key='78000000' or @key='12000000' or @key='12000001' or @key='73000000' or @key='13000000' or @key='74000000' or @key='13000001' or @key='70000000' or @key='12000002' or @key='71000000' or @key='13000002' or @key='12000003' or @key='72000000' or @key='12000004' or @key='12000005' or @key='36000000' or @key='51400000' or not(@key) or (number(@key)&gt;=100000000 and number(@key)&lt;=200000000)) and @type='situation'">
                   <xsl:attribute name="type">group</xsl:attribute>
                   <xsl:apply-templates select="@*[(name(.) != 'type')]|node()"/>
               </xsl:when>
               <xsl:otherwise>
                   <xsl:apply-templates select="@*|node()"/>
               </xsl:otherwise>
           </xsl:choose>
        </xsl:copy>
    </xsl:template>

    <!-- LDAP & AD server: remove obsolete attributes and add new ones -->
    <xsl:template match="ldap_server">
        <xsl:copy>
            <xsl:attribute name="ldap_protocol"><xsl:text>true</xsl:text></xsl:attribute>
            <xsl:attribute name="ldaps_protocol"><xsl:text>false</xsl:text></xsl:attribute>
            <xsl:attribute name="start_tls_protocol"><xsl:text>false</xsl:text></xsl:attribute>
            <xsl:apply-templates select="@*[name(.)!='is_master' and name(.)!='protocol']|node()"/>
        </xsl:copy>
    </xsl:template>
    
   <xsl:template match="active_directory_server">
        <xsl:copy>
            <xsl:attribute name="ldap_protocol"><xsl:text>true</xsl:text></xsl:attribute>
            <xsl:attribute name="ldaps_protocol"><xsl:text>false</xsl:text></xsl:attribute>
            <xsl:attribute name="start_tls_protocol"><xsl:text>false</xsl:text></xsl:attribute>
            <xsl:apply-templates select="@*[name(.)!='protocol']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="fw_single|fw_cluster">
        <xsl:copy>
            <xsl:attribute name="multicast_routing_mode">
                <xsl:choose>
                   <xsl:when test="static_multicast_route">
                       <xsl:text>static</xsl:text>
                   </xsl:when>
                   <xsl:otherwise>
                       <xsl:text>none</xsl:text>
                   </xsl:otherwise>
               </xsl:choose>
           </xsl:attribute>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- VPN Profile: remove obsolete attributes and add new one -->
    <xsl:template match="vpn_profile">
        <xsl:copy>
            <xsl:attribute name="disable_anti_replay"><xsl:text>false</xsl:text></xsl:attribute>
            <xsl:apply-templates select="@*[name(.)!='keep_ipsec_tunnel_alive' and name(.)!='disable_padding_verification']|node()"/>
        </xsl:copy>
    </xsl:template>    

    <!-- inspection rule: add situation ANY if there is no situation -->
    <xsl:template match="match_part">
       <xsl:choose>
            <xsl:when test="(parent::inspection_rule) and not(match_situations)">
               <xsl:copy>
               <!--  keep order: match_situations is in the middle -->
                   <xsl:apply-templates select="@*|node()[name(.)!='rule_time_range' and name(.)!='user_match' and name(.)!='match_vpn' and name(.)!='match_logical_interfaces']"/>
                   <xsl:element name="match_situations">
                       <xsl:element name="match_situation_ref">
                           <xsl:attribute name="type">situation</xsl:attribute>
                           <xsl:attribute name="value">ANY</xsl:attribute>
                       </xsl:element>
                   </xsl:element>
                   <xsl:apply-templates select="node()[name(.)='rule_time_range' or name(.)='user_match' or name(.)='match_vpn' or name(.)='match_logical_interfaces']"/>
               </xsl:copy>
           </xsl:when>
           <xsl:otherwise>
               <xsl:copy>
                   <xsl:apply-templates select="@*|node()"/>
               </xsl:copy>
           </xsl:otherwise>
       </xsl:choose>
   </xsl:template>
   
    <!-- Gateway Profile Cleanup: replace references to StoneGate 3.x / StoneGate 3.x FIPS in
       - external_gateway\gateway_type_ref_key
       - client_gateway\gateway_type_ref_key
     by a non system reference -->
    <xsl:template match="client_gateway | external_gateway">  
        <xsl:copy>
            <xsl:variable name="ref_key_value"><xsl:value-of select="@gateway_type_ref_key"/></xsl:variable>
            <xsl:apply-templates select="@*[(name(.) != 'gateway_type_ref_key') or (($ref_key_value != '1') and ($ref_key_value != '6'))]|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- Remove dynamic CVIs from analyser and combined_sensor_analyzer -->
    <xsl:template match="analyzer | combined_sensor_analyzer">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()[name(.)!='blacklisting_fw_cvi' or @interface_ip!='dynamic']"/>
        </xsl:copy>
   </xsl:template>

    <!-- copy everything else -->
    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
    
</xsl:stylesheet>
