<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:smc_migration="com.stonesoft.h2a.mgtserver.xsl.MigrationTo_5_1"
                exclude-result-prefixes="smc_migration">

    <xsl:output doctype-system="generic_import_export_v5.1.dtd" indent="yes"/>
    <!-- converter, when importing a file using 5.0 dtd: transform into 5.1 dtd -->
    <!-- when importing older file, it will pass through older converters first -->

	<!-- filter routing and anstipoofing nodes-->
    <xsl:template match="dyn_interface_rn_level|dyn_network_rn_level|dyn_gateway_rn_level|dyn_interface_asn_level|dyn_storable_asn_level">
        <xsl:copy>
            <xsl:variable name="dyn_ip">
        		<xsl:value-of select="@dynamic_ip"/>
    		</xsl:variable>
        	<xsl:attribute name="dynamic_ip">
				<xsl:value-of select="smc_migration:getNICIdFromDynamicIPValue( string($dyn_ip ))"/>
			</xsl:attribute>
        	<xsl:attribute name="dynamic_field">
				<xsl:value-of select="smc_migration:getFieldFromDynamicIPValue( string($dyn_ip ))"/>
			</xsl:attribute>
        	<xsl:attribute name="dynamic_index">
				<xsl:value-of select="smc_migration:getIndexFromDynamicIPValue( string($dyn_ip ))"/>
			</xsl:attribute>
            <xsl:apply-templates select="@*[name(.)!='dynamic_ip']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- remove useless arithmetic attribute from filter_expression and query_data_filter -->
    <xsl:template match="filter_expression|query_data_filter">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.)!='arithmetic']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- remove useless inactive attribute from monitoring_server -->
    <xsl:template match="monitoring_server">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.)!='inactive']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- remove useless overriden_gateway_settings attribute from internal_gateway -->
    <xsl:template match="internal_gateway">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.)!='overriden_gateway_settings']|node()"/>
        </xsl:copy>
    </xsl:template>


    <!-- remove useless send_gratuitous_arp attribute from dhcp_relay_over_ipsec -->
    <xsl:template match="dhcp_relay_over_ipsec">
        <xsl:copy>
            <xsl:apply-templates select="@*[(name(.)!='send_gratuitous_arp') and (name(.)!='send_unarp')]|node()"/>
        </xsl:copy>
    </xsl:template>    
    
    <!-- remove useless is_master attribute from active_directory_server -->
    <xsl:template match="active_directory_server">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.)!='is_master']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- add site mode in vpn_site_ref element -->
    <xsl:template match="vpn_site_ref">
       <xsl:choose>
            <xsl:when test="(parent::gateway_node)">
               <xsl:copy>
                   <xsl:attribute name="site_mode"><xsl:text>normal</xsl:text></xsl:attribute>
                   <xsl:apply-templates select="@*|node()"/>
               </xsl:copy>
           </xsl:when>
       </xsl:choose>
   </xsl:template>

    <!-- remove user_attribute and add email flag in ldap_server -->
    <xsl:template match="ldap_server">
        <xsl:copy>
            <xsl:attribute name="user_id_attr"><xsl:text>cn</xsl:text></xsl:attribute>
            <xsl:attribute name="group_member_attr"><xsl:text>sgmember</xsl:text></xsl:attribute>
            <xsl:apply-templates select="@*[name(.) != 'user_attribute']|node()"/>
        </xsl:copy>
    </xsl:template>
    
        <!-- rename service references -->
    <!-- rename service references in filters: replace Oracle TNS inspection by Oracle TNS (10052 by 363)-->
    <xsl:template match="reference[@type='service']">
       <xsl:copy>
           <xsl:attribute name="ref_object_name">
                <xsl:call-template name="replace-old-service-name">
                <xsl:with-param name="oldservicename" select="@ref_object_name"/>
               </xsl:call-template>
           </xsl:attribute>
           <xsl:apply-templates select="@*[name(.) != 'ref_object_name']|node()"/>
       </xsl:copy>
    </xsl:template>
    
    <!-- rename service references  in group: replace Oracle TNS inspection by Oracle TNS (10052 by 363) -->
    <xsl:template match="service_ref">
       <xsl:copy>
           <xsl:attribute name="value">
                <xsl:call-template name="replace-old-service-name">
                   <xsl:with-param name="oldservicename" select="@value"/>
               </xsl:call-template>
            </xsl:attribute>
            <xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
       </xsl:copy>
    </xsl:template>

    <!-- rename service references in policy: replace Oracle TNS inspection by Oracle TNS (10052 by 363) -->
    <xsl:template match="match_service_ref">
       <xsl:copy>
           <xsl:attribute name="value">
            <xsl:call-template name="replace-old-service-name">
            <xsl:with-param name="oldservicename" select="@value"/>
             </xsl:call-template>
           </xsl:attribute>
           <xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
       </xsl:copy>  
    </xsl:template>
    
    <!-- rename service reference template  -->
    <xsl:template name="replace-old-service-name">
      <xsl:param name="oldservicename"/>
        <xsl:choose>
            <xsl:when test="$oldservicename = 'MSRPC (Outlook/Exchange)'"><xsl:text>MSRPC (TCP)</xsl:text></xsl:when>
            <xsl:when test="$oldservicename = 'TFTP Control'"><xsl:text>TFTP</xsl:text></xsl:when>
        <xsl:otherwise><xsl:value-of select="$oldservicename"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
   <!-- copy everything else -->
   <xsl:template match="@*|node()">
       <xsl:copy>
           <xsl:apply-templates select="@*|node()"/>
       </xsl:copy>
   </xsl:template>

</xsl:stylesheet>
