<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" doctype-system="generic_import_export_v5.0.dtd" indent="yes"/>
    <!-- converter, when importing a file using 4.3 dtd: transform into 5.0 dtd -->
    <!-- when importing 2.1 file, it will pass through v2.1 converter and then through v4.2 converter -->

    <!-- removal of implied xml policy attributes (creator/creator_time/modifier/modification_time/is_modifiable) -->
    <xsl:template match="fw_policy|fw_template_policy|fw_sub_policy|ips_policy|ips_template_policy|ips_sub_policy|alert_policy|alert_chain|qos_policy">
    	<xsl:copy>
			<xsl:apply-templates select="@*[(name(.)!='creator') and (name(.)!='creator_time') and (name(.)!='modifier') and (name(.)!='modification_time') and (name(.)!='is_modifiable')]|node()"/>
		</xsl:copy>
    </xsl:template>

	<!-- $$ Local Cluster/Local... have new alias type
	   - alias_value internal children attributes moving in fw/ips xml def  
	   -->
	<xsl:template match="alias"> 
		<xsl:copy>
			<xsl:attribute name="type">
				<xsl:choose>
					<xsl:when test="@key = '22'"><xsl:text>local_cluster_ndi_mgt</xsl:text></xsl:when>
					<xsl:when test="@key = '23'"><xsl:text>local_cluster_ndi_hb</xsl:text></xsl:when>
					<xsl:when test="@key = '24'"><xsl:text>local_cluster_ndi</xsl:text></xsl:when>
					<xsl:when test="@key = '25'"><xsl:text>local_cluster_cvi</xsl:text></xsl:when>
					<xsl:when test="@key = '26'"><xsl:text>log_servers</xsl:text></xsl:when>
					<xsl:when test="@key = '27'"><xsl:text>mgt_servers</xsl:text></xsl:when>
					<xsl:when test="@key = '28'"><xsl:text>local_cluster</xsl:text></xsl:when>
					<xsl:otherwise><xsl:value-of select="@type"/></xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>
			<xsl:apply-templates select="@*[name(.)!='type']|node()[(name(.) != 'alias_value')]"/>
		</xsl:copy>
	</xsl:template>

    <!-- LENS, DBConvert_50_0_3: Collapse clusters, Expand dynamic composites, update locations, delete size -->

    <!-- static composites to visible layer -->
	<xsl:template match="lens_data[@type='LogicalCompositeNode' and lens_attribute[@name='IS_STATIC' and @value='true']]/lens_attribute[@name='LAYER_INDEX']/@value">
    	<xsl:attribute name="value">0</xsl:attribute>
   	</xsl:template>
	<!-- static composite children to invisible layer -->
	<xsl:template match="lens_data[@type='LogicalNode' and lens_attribute[@name='PARENT_NODE_ID']/@value = ../lens_data[@type='LogicalCompositeNode' and lens_attribute[@name='IS_STATIC' and @value='true']]/@lens_id]/lens_attribute[@name='LAYER_INDEX']/@value">
    	<xsl:attribute name="value">1</xsl:attribute>
   	</xsl:template>

    <!-- delete dynamic composite nodes -->	
	<xsl:template match="lens_data[@type='LogicalCompositeNode' and lens_attribute[@name='IS_STATIC' and @value='false']]"/>
	<!-- delete parent pointers to dynamic composite nodes -->
	<xsl:template match="lens_data[@type='LogicalNode' or @type='LogicalCompositeNode']/lens_attribute[@name='PARENT_NODE_ID' and @value = ../../lens_data[@type='LogicalCompositeNode' and lens_attribute[@name='IS_STATIC' and @value='false']]/@lens_id]/@value"/>
	<!-- dynamic composite children to visible layer -->
	<xsl:template match="lens_data[(@type='LogicalNode' or @type='LogicalCompositeNode') and lens_attribute[@name='PARENT_NODE_ID']/@value = ../lens_data[@type='LogicalCompositeNode' and lens_attribute[@name='IS_STATIC' and @value='false']]/@lens_id]/lens_attribute[@name='LAYER_INDEX']/@value">
    	<xsl:attribute name="value">0</xsl:attribute>
   	</xsl:template>
   	<!-- delete dynamic composite edges -->
	<xsl:template match="lens_data[(@type='LogicalEdge' or @type='LogicalRedundantEdge') and lens_attribute[@name='STARTNODE_ID' or @name='ENDNODE_ID']/@value = ../lens_data[@type='LogicalCompositeNode' and lens_attribute[@name='IS_STATIC' and @value='false']]/@lens_id]"/>
   	<!-- delete dynamic composite edge children parent pointers -->
	<xsl:template match="lens_data[@type='LogicalEdge' or @type='LogicalRedundantEdge']/lens_attribute[(@name='START_PARENT_EDGE_ID' or @name='END_PARENT_EDGE_ID') and @value = ../../lens_data[(@type='LogicalEdge' or @type='LogicalRedundantEdge') and lens_attribute[@name='STARTNODE_ID' or @name='ENDNODE_ID']/@value = ../lens_data[@type='LogicalCompositeNode' and lens_attribute[@name='IS_STATIC' and @value='false']]/@lens_id]/@lens_id]/@value"/>

	<!-- force layer redetermination for all edges -->
	<xsl:template match="lens_data[@type='LogicalEdge' or @type='LogicalRedundantEdge']/lens_attribute[@name='LAYER_INDEX']/@value">
    	<xsl:attribute name="value">-1</xsl:attribute>
   	</xsl:template>

	<!-- Drop lens LogicalNode and LogicalCompositeNode WIDTH and HEIGHT attributes. -->
    <xsl:template match="lens_data[@type='LogicalNode' or @type='LogicalCompositeNode']/lens_attribute[@name='WIDTH' or @name='HEIGHT']"/>

    <!-- Update locations -->
    <xsl:template match="lens_data/lens_attribute/@value[../../@type = 'LogicalNode' and ../@name = 'X']">
    	<xsl:attribute name="value"><xsl:value-of select="current() + ../../lens_attribute[@name='WIDTH']/@value div 2"/></xsl:attribute>
   	</xsl:template>
    <xsl:template match="lens_data/lens_attribute/@value[../../@type = 'LogicalNode' and ../@name = 'Y']">
    	<xsl:attribute name="value"><xsl:value-of select="current() + ../../lens_attribute[@name='HEIGHT']/@value div 2"/></xsl:attribute>
   	</xsl:template>

    <!-- Update alert policy time range -->
    <xsl:template match="alert_match_part/rule_time_range">
		<xsl:element name="alert_rule_time_range">
			<xsl:element name="alert_rule_day_range">
				<xsl:apply-templates select="node()[name(.)='rule_day_range']/@*[name(.)!='week_day_range']"/>
				<xsl:attribute name="week_day_list">
					<xsl:call-template name="replace-week-day-range-into-list">
					    <xsl:with-param name="oldweekday" select="node()[name(.)='rule_day_range']/@week_day_range"/>
		    		</xsl:call-template>
				</xsl:attribute>
			</xsl:element>
		</xsl:element>
    </xsl:template>


    <!-- alert policy: replace week day range by week day list  -->    
    <xsl:template name="replace-week-day-range-into-list">
		  <xsl:param name="oldweekday"/>
			<xsl:choose>
				<xsl:when test="$oldweekday = 'mon to sun'"><xsl:text>Mo,Tu,We,Th,Fr,Sa,Su</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'tue to sun'"><xsl:text>Tu,We,Th,Fr,Sa,Su</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'wed to sun'"><xsl:text>We,Th,Fr,Sa,Su</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'thu to sun'"><xsl:text>Th,Fr,Sa,Su</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'fri to sun'"><xsl:text>Fr,Sa,Su</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'sat to sun'"><xsl:text>Sa,Su</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'sun to sun'"><xsl:text>Su</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'mon to sat'"><xsl:text>Mo,Tu,We,Th,Fr,Sa</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'tue to sat'"><xsl:text>Tu,We,Th,Fr,Sa</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'wed to sat'"><xsl:text>We,Th,Fr,Sa</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'thu to sat'"><xsl:text>Th,Fr,Sa</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'fri to sat'"><xsl:text>Fr,Sa</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'sat to sat'"><xsl:text>Sa</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'mon to fri'"><xsl:text>Mo,Tu,We,Th,Fr</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'tue to fri'"><xsl:text>Tu,We,Th,Fr</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'wed to fri'"><xsl:text>We,Th,Fr</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'thu to fri'"><xsl:text>Th,Fr</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'fri to fri'"><xsl:text>Fr</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'mon to thu'"><xsl:text>Mo,Tu,We,Th</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'tue to thu'"><xsl:text>Tu,We,Th</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'wed to thu'"><xsl:text>We,Th</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'thu to thu'"><xsl:text>Th</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'mon to wed'"><xsl:text>Mo,Tu,We</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'tue to wed'"><xsl:text>Tu,We</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'wed to wed'"><xsl:text>We</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'mon to tue'"><xsl:text>Mo,Tu</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'tue to tue'"><xsl:text>Tu</xsl:text></xsl:when>
				<xsl:when test="$oldweekday = 'mon to mon'"><xsl:text>Mo</xsl:text></xsl:when>
			</xsl:choose>
	    </xsl:template>   

    <xsl:template match="alias_value">
        <xsl:copy>
            <xsl:attribute name="alias_ref"><xsl:value-of select="parent::alias/@name"/></xsl:attribute>
            <xsl:if test='(parent::alias/@key)'>
                <xsl:attribute name="alias_ref_key"><xsl:value-of select="parent::alias/@key"/></xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="@*[(name(.) != 'fw_ref') and (name(.) != 'fw_ref_key')]|node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="fw_single|fw_cluster|single_sensor|sensor_cluster|analyzer|combined_sensor_analyzer">
        <xsl:copy>
            <xsl:variable name="ref_fw_name"><xsl:value-of select="@name"/></xsl:variable>
            <xsl:variable name="ref_fw_key"><xsl:value-of select="@key"/></xsl:variable>
            <xsl:apply-templates select="@*|node()"/>
            <xsl:if test='(../alias/alias_value[@fw_ref = $ref_fw_name]) or (../alias/alias_value[@fw_ref_key = $ref_fw_key])'>
                <xsl:apply-templates select="../alias/alias_value[@fw_ref = $ref_fw_name]"/>
                <xsl:apply-templates select="../alias/alias_value[@fw_ref_key = $ref_fw_key]"/>
            </xsl:if>
        </xsl:copy>
    </xsl:template>

    <!-- removal of useless valid_fw_ref/valid_fw_ref_key attributes from
         all rules except nat_rule 
      -->
    <xsl:template match="access_rule|inspection_rule|ethernet_rule|ipv6_rule">
        <xsl:copy>
            <xsl:apply-templates select="@*[(name(.) != 'valid_fw_ref') and (name(.) != 'valid_fw_ref_key')]|node()"/>
        </xsl:copy>
    </xsl:template>        


    <!-- update connection tracking mode information from true to yes and false to no 
      -->
    <xsl:template match="option">
		<xsl:copy>
			<xsl:choose>
				<xsl:when test="parent::access_rule">
					<xsl:choose>
						<xsl:when test="@conn_tracking='true'">
							<xsl:attribute name="conn_tracking">
								<xsl:text>yes</xsl:text>
							</xsl:attribute>
							<xsl:apply-templates select="@*[name(.)!='conn_tracking']|node()"/>
						</xsl:when>
						<xsl:when test="@conn_tracking='false'">
							<xsl:attribute name="conn_tracking">
								<xsl:text>no</xsl:text>
							</xsl:attribute>
							<xsl:apply-templates select="@*[name(.)!='conn_tracking']|node()"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:apply-templates select="@*|node()"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="@*|node()"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:copy>
    </xsl:template> 

    <!-- mvia_location change dtd format -->
    <xsl:template match="mvia_location">
        <xsl:copy>
            <xsl:if test="loc_name">
                <xsl:attribute name="loc_ref">
                    <xsl:value-of select="loc_name/@name"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:if test="loc_id">
                <xsl:attribute name="loc_ref_key">
                    <xsl:value-of select="loc_id/@id"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates select="@*|node()[(name(.) != 'loc_name') and (name(.) != 'loc_id')]"/>
        </xsl:copy>
    </xsl:template>


    <!-- add GOST related algorithms in capabilities, remove gost_g28147_imit_for_ike attribute -->
    <xsl:template match="capabilities">
        <xsl:copy>
        	<xsl:attribute name="gost_g3411_for_ike"><xsl:text>false</xsl:text></xsl:attribute>
			<xsl:attribute name="gost_g3411_for_ipsec"><xsl:text>false</xsl:text></xsl:attribute>
			<xsl:attribute name="gost_signature_for_ike"><xsl:text>false</xsl:text></xsl:attribute>
			<xsl:attribute name="vpn_client_gost_signature_for_ike"><xsl:text>false</xsl:text></xsl:attribute>
			<xsl:attribute name="sha256_for_ike"><xsl:text>false</xsl:text></xsl:attribute>
			<xsl:attribute name="sha256_for_ipsec"><xsl:text>false</xsl:text></xsl:attribute>
			<xsl:attribute name="aes_gcm_for_ipsec"><xsl:text>false</xsl:text></xsl:attribute>
			 <xsl:attribute name="forward_client_vpn"><xsl:text>false</xsl:text></xsl:attribute>
			<xsl:apply-templates select="@*[name(.) != 'gost_g28147_imit_for_ike']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- add use_local_relay attribute in dhcp_relay_over_ipsec element -->
    <xsl:template match="dhcp_relay_over_ipsec">
        <xsl:copy>
            <xsl:attribute name="use_local_relay"><xsl:text>false</xsl:text></xsl:attribute>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>


    <!-- add Local Security Checks in VPN Profiles (DB Migration Step 50_0_68) -->
    <xsl:template match="vpn_profile">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
            <!--
            <xsl:element name="local_security_checks">
                <xsl:attribute name="antivirus"><xsl:text>false</xsl:text></xsl:attribute>
                <xsl:attribute name="firewall"><xsl:text>false</xsl:text></xsl:attribute>
                <xsl:attribute name="windows-update"><xsl:text>false</xsl:text></xsl:attribute>
            </xsl:element>
            -->
            <local_security_checks antivirus="false" firewall="false" windows-update="false"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="static_multicast_route">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.) != 'dest_interface']|node()"/>
            <xsl:element name="dest_interface">
                <xsl:attribute name="interface_id"><xsl:value-of select="@dest_interface"/></xsl:attribute>
            </xsl:element>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="resolve_method">
        <xsl:choose>
            <xsl:when test="text()='NE_RESOLVING'">
                <xsl:element name="resolve_method">ELEMENT_RESOLVING</xsl:element>
            </xsl:when>
            <xsl:otherwise>
                <xsl:element name="resolve_method"><xsl:value-of select="text()"/></xsl:element>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- copy everything else except (alert_chain_insert_point_rule) -->
    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()[(name(.) != 'alert_chain_insert_point_rule')]"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- Gateway Profile Cleanup: replace references to StoneGate 2.2.x / StoneGate 2.2.x FIPS in
             - external_gateway\gateway_type_ref_key
             - client_gateway\gateway_type_ref_key
          by a non system reference -->
    <xsl:template match="client_gateway | external_gateway">  
        <xsl:copy>
            <xsl:variable name="ref_key_value"><xsl:value-of select="@gateway_type_ref_key"/></xsl:variable>
            <xsl:apply-templates select="@*[(name(.) != 'gateway_type_ref_key') or (($ref_key_value != '4') and ($ref_key_value != '5'))]|node()"/>
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>
