<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output doctype-system="generic_import_export_v4.3.dtd" indent="yes"/>
    <!-- converter, when importing a file using 4.2 dtd: transform into 4.3 dtd -->
    <!-- when importing 2.1 file, it will pass through v2.1 converter and then through v4.2 converter -->

    <!-- remove flag forward_vpn_client and add gost_for_ike, gost_for_ipsec in capabilities -->
    <xsl:template match="capabilities">
        <xsl:copy>
        	<xsl:attribute name="gost_for_ike"><xsl:text>false</xsl:text></xsl:attribute>
			<xsl:attribute name="gost_for_ipsec"><xsl:text>false</xsl:text></xsl:attribute>
			<xsl:attribute name="gost_g28147_imit_for_ike"><xsl:text>false</xsl:text></xsl:attribute>
			<xsl:attribute name="gost_g28147_imit_for_ipsec"><xsl:text>false</xsl:text></xsl:attribute>
            <xsl:apply-templates select="@*[name(.) != 'forward_vpn_client']|node()"/>
        </xsl:copy>
    </xsl:template>    

    <!-- remove tag nic_id in vpn_site_interface
        remove network element from interface of (automatic) VPN site: remove child node -->
    <xsl:template match="vpn_site_interface">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.) != 'nic_id']"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- remove tag dynamic in end_point -->
    <xsl:template match="end_point">
        <xsl:copy>
            <xsl:apply-templates select="@*[name(.) != 'dynamic']|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <xsl:template match="diagram">
        <xsl:copy>
            <xsl:attribute name="type"><xsl:text>ip</xsl:text></xsl:attribute>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
    
    <!-- rename service references -->
    <!-- rename service references in filters: replace Oracle TNS inspection by Oracle TNS (10052 by 363)-->
    <xsl:template match="reference[@type='service']">
    	<xsl:choose>
     		<xsl:when test="@ref_key =  '10052'">
     		    <xsl:copy>
            		<xsl:attribute name="ref_key">
            			<xsl:text>363</xsl:text>
            		</xsl:attribute>
            		<xsl:attribute name="ref_object_name">
            			<xsl:text>Oracle TNS</xsl:text>
            		</xsl:attribute>
            		<xsl:apply-templates select="@*[name(.) != 'ref_key' and name(.) != 'ref_object_name']|node()"/>
        		</xsl:copy>
     		</xsl:when>
     		<xsl:when test="@ref_key =  '10015'">
     		    <xsl:copy>
            		<xsl:attribute name="ref_key">
            			<xsl:text>439</xsl:text>
            		</xsl:attribute>
            		<xsl:attribute name="ref_object_name">
            			<xsl:text>TFTP</xsl:text>
            		</xsl:attribute>
            		<xsl:apply-templates select="@*[name(.) != 'ref_key' and name(.) != 'ref_object_name']|node()"/>
        		</xsl:copy>
     		</xsl:when>
     		<xsl:otherwise>
        		<xsl:copy>
            		<xsl:attribute name="ref_object_name">
               			 <xsl:call-template name="replace-old-service-name">
                   		 <xsl:with-param name="oldservicename" select="@ref_object_name"/>
                		</xsl:call-template>
            		</xsl:attribute>
            		<xsl:apply-templates select="@*[name(.) != 'ref_object_name']|node()"/>
        		</xsl:copy>
            </xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    
    <!-- rename service references  in group: replace Oracle TNS inspection by Oracle TNS (10052 by 363) -->
    <xsl:template match="service_ref">
        <xsl:choose>
     		<xsl:when test="@ref_key =  '10052'">
     		    <xsl:copy>
            		<xsl:attribute name="ref_key">
            			<xsl:text>363</xsl:text>
            		</xsl:attribute>
            		<xsl:attribute name="value">
            			<xsl:text>Oracle TNS</xsl:text>
            		</xsl:attribute>
            		<xsl:apply-templates select="@*[name(.) != 'ref_key' and name(.) != 'value']|node()"/>
        		</xsl:copy>
     		</xsl:when>
     		<xsl:when test="@ref_key =  '10015'">
     		    <xsl:copy>
            		<xsl:attribute name="ref_key">
            			<xsl:text>439</xsl:text>
            		</xsl:attribute>
            		<xsl:attribute name="value">
            			<xsl:text>TFTP</xsl:text>
            		</xsl:attribute>
            		<xsl:apply-templates select="@*[name(.) != 'ref_key' and name(.) != 'value']|node()"/>
        		</xsl:copy>
     		</xsl:when>
     		<xsl:otherwise>
        		<xsl:copy>
            		<xsl:attribute name="value">
           				 <xsl:call-template name="replace-old-service-name">
                			<xsl:with-param name="oldservicename" select="@value"/>
            			</xsl:call-template>
           			 </xsl:attribute>
           			 <xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
        		</xsl:copy>
            </xsl:otherwise>
		</xsl:choose>
    </xsl:template>

    <!-- rename service references in policy: replace Oracle TNS inspection by Oracle TNS (10052 by 363) -->
    <xsl:template match="match_service_ref">
       <xsl:choose>
     		<xsl:when test="@ref_key =  '10052'">
     		    <xsl:copy>
            		<xsl:attribute name="ref_key">
            			<xsl:text>363</xsl:text>
            		</xsl:attribute>
            		<xsl:attribute name="value">
            			<xsl:text>Oracle TNS</xsl:text>
            		</xsl:attribute>
            		<xsl:apply-templates select="@*[name(.) != 'ref_key' and name(.) != 'value']|node()"/>
        		</xsl:copy>
     		</xsl:when>
     		<xsl:when test="@ref_key =  '10015'">
     		    <xsl:copy>
            		<xsl:attribute name="ref_key">
            			<xsl:text>439</xsl:text>
            		</xsl:attribute>
            		<xsl:attribute name="value">
            			<xsl:text>TFTP</xsl:text>
            		</xsl:attribute>
            		<xsl:apply-templates select="@*[name(.) != 'ref_key' and name(.) != 'value']|node()"/>
        		</xsl:copy>
     		</xsl:when>
     		<xsl:otherwise>
        		<xsl:copy>
            		<xsl:attribute name="value">
               		 <xsl:call-template name="replace-old-service-name">
               		 <xsl:with-param name="oldservicename" select="@value"/>
              		  </xsl:call-template>
            		</xsl:attribute>
            		<xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
        		</xsl:copy>  
            </xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    
    <!-- rename service reference template  -->
    <xsl:template name="replace-old-service-name">
      <xsl:param name="oldservicename"/>
        <xsl:choose>
            <xsl:when test="$oldservicename = 'MSRPC (TCP)'"><xsl:text>MSRPC (Outlook/Exchange)</xsl:text></xsl:when>
            <xsl:when test="$oldservicename = 'MSRPC Endpoint Mapper (TCP)'"><xsl:text>MSRPC (TCP)</xsl:text></xsl:when>
            <xsl:when test="$oldservicename = 'NAT-T'"><xsl:text>NAT-T (Destination)</xsl:text></xsl:when>
        <xsl:otherwise><xsl:value-of select="$oldservicename"/></xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- add MatchAll filter for SSL VPN Log for AdminUser -->
        <xsl:template match="admin_user_filter_expression">
            <xsl:copy>
                <xsl:attribute name="sslvpn_log_filter_ref"><xsl:text>Match All</xsl:text></xsl:attribute>
                <xsl:apply-templates select="@*|node()"/>
            </xsl:copy>
        </xsl:template>
    
    <!-- remove associated_ip from certificate 
    (note: for certificate_request, see template on certificate_request) -->
    <xsl:template match="associated_ip">
        <xsl:if test="parent::certificate_request">
            <xsl:copy-of select="."/>
        </xsl:if>
    </xsl:template>
    
    <!-- Move Certificate to top-level:
        file_name becomes name
        add gateway reference to gateway's certificates.
        Note: certificate can only be part of a CA. -->
    <xsl:template match="certificate">
        <xsl:choose>
            <xsl:when test="parent::internal_gateway">
                <xsl:copy>
                    <xsl:attribute name="internal_gateway_ref"><xsl:value-of select="../@name"/></xsl:attribute>
                    <xsl:attribute name="name"><xsl:value-of select="@file_name"/></xsl:attribute>
                    <xsl:apply-templates select="@*[(name(.) != 'file_name') and (name(.) != 'sequence_id')]|node()"/>
                </xsl:copy>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:attribute name="name"><xsl:value-of select="@file_name"/></xsl:attribute>
                    <xsl:apply-templates select="@*[(name(.) != 'file_name') and (name(.) != 'sequence_id')]|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Move Certificate Request to top-level:
        file_name becomes name
        add gateway reference to certificate requests.
        certificate_file_name is removed.
        child node (associated_ip) is removed.
        Note: certificate request exists only in internal gateway. -->
    <xsl:template match="certificate_request">
        <xsl:copy>
            <xsl:attribute name="internal_gateway_ref"><xsl:value-of select="../@name"/></xsl:attribute>
            <xsl:attribute name="name"><xsl:value-of select="@file_name"/></xsl:attribute>
            <xsl:apply-templates select="@*[(name(.) != 'file_name') and (name(.) != 'certificate_file_name')]"/>
        </xsl:copy>
    </xsl:template>

    <!-- VPN Only Cleanup: do not import, from old Update Packages, elements that will be deleted in the future, as old Update Packages are not consistent. 
         Distinguish IPsec VPN and SSL VPN: Rename the following system Aliases
     		 - '$ DHCP Servers for Mobile VPN' becomes '$ DHCP Servers for IPsec VPN'
			 - '$ DHCP Address Pools for Mobile VPN' becomes '$ DHCP Address Pools for IPsec VPN'
			 - '$$ Valid DHCP Address Pools for Mobile VPN'' becomes '$$ Valid DHCP Address Pools for IPsec VPN'
			 - '$$ Valid DHCP Servers for Mobile VPN' becomes '$$ Valid DHCP Servers for IPsec VPN' -->
    <!-- Aliases -->
    <xsl:template match="alias">
        <xsl:choose>
            <xsl:when test="@key = '10'"></xsl:when><!-- Ignore "$ Local Protected Sites for Mobile Users" -->
            <xsl:when test="@key = '13'"></xsl:when><!-- Ignore "$ Remote Protected Sites" -->
            <xsl:when test="@key = '15'"></xsl:when><!-- Ignore "$ Remote Destinations That Local Gateway Must Encrypt" -->
            <xsl:when test="@key = '21'"></xsl:when><!-- Ignore "$ Local Protected Sites" -->
            <xsl:otherwise><!-- Copy other elements -->
                <xsl:copy>
                	<xsl:attribute name="name">
						<xsl:call-template name="replace-old-Mobile-VPN-DHCP-Alias-name">
			    		<xsl:with-param name="olddhcpaliasname" select="@name"/>
			    		</xsl:call-template>
					</xsl:attribute>
					<xsl:apply-templates select="@*[name(.) != 'name']|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Expressions -->
    <xsl:template match="expression">
        <xsl:choose>
            <xsl:when test="@key = '60'"></xsl:when><!-- Ignore "DHCP Enabled Interface Addresses In Local Sites" -->
            <xsl:when test="@key = '61'"></xsl:when><!-- Ignore "NOT $ Local Protected Sites" -->
            <xsl:otherwise><!-- Copy other elements -->
                 <xsl:copy>
                	<xsl:attribute name="name">
						<xsl:call-template name="replace-old-Mobile-VPN-DHCP-Alias-name">
			    		<xsl:with-param name="olddhcpaliasname" select="@name"/>
			    		</xsl:call-template>
					</xsl:attribute>
					<xsl:apply-templates select="@*[name(.) != 'name']|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Firewall Policies -->
    <xsl:template match="fw_policy">
        <xsl:choose>
            <xsl:when test="@key = '3'"></xsl:when><!-- Ignore "Security Policy for VPN only" -->
            <xsl:otherwise><!-- Copy other elements -->
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- Sub Policies -->
    <xsl:template match="fw_sub_policy">
        <xsl:choose>
            <xsl:when test="@key = '4'"></xsl:when><!-- Ignore "DHCP Relay (VPN-Only License)" -->
            <xsl:otherwise><!-- Copy other elements -->
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- VPNs -->
    <xsl:template match="vpn">
        <xsl:choose>
            <xsl:when test="@key = '1'"></xsl:when><!-- Ignore "Mobile User VPN" -->
            <xsl:when test="@key = '2'"></xsl:when><!-- Ignore "Corporate VPN" -->
            <xsl:otherwise><!-- Copy other elements -->
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

     <!-- Distinguish IPsec VPN and SSL VPN: Rename Client Gateway -->
     <xsl:template match="gateway_node">
        <xsl:choose>
             <xsl:when test="(parent::vpn_topology)">
                <xsl:copy>
                	<xsl:attribute name="gateway_ref">
						<xsl:call-template name="replace-old-Client-Gateway-name">
			    			<xsl:with-param name="oldclientgatewayname" select="@gateway_ref"/>
			    		</xsl:call-template>
					</xsl:attribute>
					<xsl:apply-templates select="@*[name(.) != 'gateway_ref']|node()"/>
                </xsl:copy>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

     <!-- Distinguish IPsec VPN and SSL VPN: Rename Client Gateway -->
     <xsl:template match="vpn_site_ref">
        <xsl:choose>
             <xsl:when test="(parent::gateway_node)">
                <xsl:copy>
                	<xsl:attribute name="value">
						<xsl:call-template name="replace-old-Client-Gateway-name">
			    			<xsl:with-param name="oldclientgatewayname" select="@value"/>
			    		</xsl:call-template>
					</xsl:attribute>
					<xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
                </xsl:copy>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

     <!-- Distinguish IPsec VPN and SSL VPN: Rename Client Gateway -->
     <xsl:template match="vpn_gw_gw|vpn_ep_ep">
        <xsl:choose>
             <xsl:when test="(parent::vpn_topology)">
                <xsl:copy>
                    <xsl:attribute name="gateway_1_ref">
                        <xsl:call-template name="replace-old-Client-Gateway-name">
                            <xsl:with-param name="oldclientgatewayname" select="@gateway_1_ref"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:attribute name="gateway_2_ref">
                        <xsl:call-template name="replace-old-Client-Gateway-name">
                            <xsl:with-param name="oldclientgatewayname" select="@gateway_2_ref"/>
                        </xsl:call-template>
                    </xsl:attribute>
                    <xsl:apply-templates select="@*[(name(.) != 'gateway_1_ref') and (name(.) != 'gateway_2_ref')]|node()"/>
                </xsl:copy>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

	<!-- Distinguish IPsec VPN and SSL VPN: Rename Client Gateway -->
     <xsl:template match="client_gateway">
        <xsl:copy>
            <xsl:attribute name="name">
                <xsl:call-template name="replace-old-Client-Gateway-name">
                    <xsl:with-param name="oldclientgatewayname" select="@name"/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:apply-templates select="@*[name(.) != 'name']|node()"/>
        </xsl:copy>
    </xsl:template>

    <!-- VPN Only Cleanup: replace references to
              DHCP Relay (VPN-Only License) [4]
          in
             - fw_policy\access_entry\rule_entry\access_rule\action
             - fw_sub_policy\access_entry\rule_entry\access_rule\action
             - fw_template_policy\access_entry\rule_entry\access_rule\action
          by a non system reference -->
    <xsl:template match="action">
        <xsl:choose>
            <xsl:when test="(parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_policy) or (parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_sub_policy) or (parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_template_policy)">
                <xsl:copy>
                    <xsl:variable name="sub_ref_key_value"><xsl:value-of select="@subrule_ref_key"/></xsl:variable>
                    <xsl:apply-templates select="@*[(name(.) != 'subrule_ref_key') or ($sub_ref_key_value != '4')]|node()"/>
                </xsl:copy>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- VPN Only Cleanup: replace references to 
             - "Mobile User VPN" [1]
             - "Corporate VPN" [2]
          in
             - fw_policy\access_entry\rule_entry\access_rule\vpn_action\vpn_ref
             - fw_policy\access_entry\rule_entry\access_rule\match_part\match_vpn\vpn_ref
             - fw_sub_policy\access_entry\rule_entry\access_rule\vpn_action\vpn_ref
             - fw_sub_policy\access_entry\rule_entry\access_rule\match_part\match_vpn\vpn_ref
             - fw_template_policy\access_entry\rule_entry\access_rule\vpn_action\vpn_ref
             - fw_template_policy\access_entry\rule_entry\access_rule\match_part\match_vpn\vpn_ref
          by a non system reference -->
    <xsl:template match="vpn_ref">
        <xsl:choose>
            <xsl:when test="(parent::vpn_action/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_policy) or (parent::match_vpn/parent::match_part/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_policy) or (parent::vpn_action/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_sub_policy) or (parent::match_vpn/parent::match_part/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_sub_policy) or (parent::vpn_action/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_template_policy) or (parent::match_vpn/parent::match_part/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_template_policy)">
                <xsl:copy>
                    <xsl:variable name="ref_key_value"><xsl:value-of select="@ref_key"/></xsl:variable>
                    <xsl:apply-templates select="@*[(name(.) != 'ref_key') or (($ref_key_value != '1') and ($ref_key_value != '2'))]|node()"/>
                </xsl:copy>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- VPN Only Cleanup: replace references to the following system Aliases and Expressions
             - $ Local Protected Sites for Mobile Users [10]
             - $ Remote Protected Sites [13]
             - $ Remote Destinations That Local Gateway Must Encrypt [15]
             - $ Local Protected Sites [21]
             - DHCP Enabled Interface Addresses In Local Sites [60]
             - NOT $ Local Protected Sites [61]
     Distinguish IPsec VPN and SSL VPN: Rename the following system Aliases
     		 - '$ DHCP Servers for Mobile VPN' becomes '$ DHCP Servers for IPsec VPN'
			 - '$ DHCP Address Pools for Mobile VPN' becomes '$ DHCP Address Pools for IPsec VPN'
			 - '$$ Valid DHCP Address Pools for Mobile VPN'' becomes '$$ Valid DHCP Address Pools for IPsec VPN'
			 - '$$ Valid DHCP Servers for Mobile VPN' becomes '$$ Valid DHCP Servers for IPsec VPN'
          in
             - fw_policy\access_entry\rule_entry\access_rule\match_part\match_sources\match_source_ref
             - fw_policy\access_entry\rule_entry\access_rule\match_part\match_destinations\match_destination_ref
             - fw_policy\inspection_entry\rule_entry\inspection_rule\match_part\match_sources\match_source_ref
             - fw_policy\inspection_entry\rule_entry\inspection_rule\match_part\match_destinations\match_destination_ref
             - fw_policy\nat_entry\rule_entry\nat_rule\match_part\match_sources\match_source_ref
             - fw_policy\nat_entry\rule_entry\nat_rule\match_part\match_destinations\match_destination_ref
             - fw_policy\nat_entry\rule_entry\nat_rule\option\nat_src\dynamic_nat\packet_description
             - fw_policy\nat_entry\rule_entry\nat_rule\option\nat_src\static_nat\packet_description
             - fw_policy\nat_entry\rule_entry\nat_rule\option\nat_src\static_nat\packet_description_new
             - fw_policy\nat_entry\rule_entry\nat_rule\option\nat_dst\static_nat\packet_description
             - fw_policy\nat_entry\rule_entry\nat_rule\option\nat_dst\static_nat\packet_description_new
             - + fw_sub_policy
             - + fw_template_policy
          by a non system reference -->
    <xsl:template match="match_source_ref">
        <xsl:choose>
            <xsl:when test="(parent::match_sources/parent::match_part/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_policy) or (parent::match_sources/parent::match_part/parent::inspection_rule/parent::rule_entry/parent::inspection_entry/parent::fw_policy) or (parent::match_sources/parent::match_part/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_policy) or (parent::match_sources/parent::match_part/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_sub_policy) or (parent::match_sources/parent::match_part/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_template_policy) or (parent::match_sources/parent::match_part/parent::inspection_rule/parent::rule_entry/parent::inspection_entry/parent::fw_template_policy) or (parent::match_sources/parent::match_part/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_template_policy)">
                <xsl:copy>
                    <xsl:variable name="ref_key_value"><xsl:value-of select="@ref_key"/></xsl:variable>
             	    <xsl:attribute name="value">
					<xsl:call-template name="replace-old-Mobile-VPN-DHCP-Alias-name">
					    <xsl:with-param name="olddhcpaliasname" select="@value"/>
		    		</xsl:call-template>
					</xsl:attribute>
                    <xsl:apply-templates select="@*[((name(.) != 'ref_key') or (($ref_key_value != '10') and ($ref_key_value != '13') and ($ref_key_value != '15') and ($ref_key_value != '21') and ($ref_key_value != '60') and ($ref_key_value != '61'))) and (name(.) != 'value')]|node()"/>
                </xsl:copy>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="match_destination_ref">
        <xsl:choose>
            <xsl:when test="(parent::match_destinations/parent::match_part/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_policy) or (parent::match_destinations/parent::match_part/parent::inspection_rule/parent::rule_entry/parent::inspection_entry/parent::fw_policy) or (parent::match_destinations/parent::match_part/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_policy) or (parent::match_destinations/parent::match_part/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_sub_policy) or (parent::match_destinations/parent::match_part/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_template_policy) or (parent::match_destinations/parent::match_part/parent::inspection_rule/parent::rule_entry/parent::inspection_entry/parent::fw_template_policy) or (parent::match_destinations/parent::match_part/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_template_policy)">
            	<xsl:copy>
                    <xsl:variable name="ref_key_value"><xsl:value-of select="@ref_key"/></xsl:variable>
             	    <xsl:attribute name="value">
					<xsl:call-template name="replace-old-Mobile-VPN-DHCP-Alias-name">
					    <xsl:with-param name="olddhcpaliasname" select="@value"/>
		    		</xsl:call-template>
					</xsl:attribute>
                    <xsl:apply-templates select="@*[((name(.) != 'ref_key') or (($ref_key_value != '10') and ($ref_key_value != '13') and ($ref_key_value != '15') and ($ref_key_value != '21') and ($ref_key_value != '60') and ($ref_key_value != '61'))) and (name(.) != 'value')]|node()"/>
			    </xsl:copy>	
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="granted_blacklister_ref">
        <xsl:choose>
          <xsl:when test="(parent::granted_blacklisters/parent::option/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_policy) or (parent::granted_blacklisters/parent::option/parent::inspection_rule/parent::rule_entry/parent::inspection_entry/parent::fw_policy) or (parent::granted_blacklisters/parent::option/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_policy) or (parent::granted_blacklisters/parent::option/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_sub_policy) or (parent::granted_blacklisters/parent::option/parent::access_rule/parent::rule_entry/parent::access_entry/parent::fw_template_policy) or (parent::granted_blacklisters/parent::option/parent::inspection_rule/parent::rule_entry/parent::inspection_entry/parent::fw_template_policy) or (parent::granted_blacklisters/parent::option/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_template_policy)">
        	<xsl:copy>
          	    <xsl:attribute name="value">
				<xsl:call-template name="replace-old-Mobile-VPN-DHCP-Alias-name">
			    <xsl:with-param name="olddhcpaliasname" select="@value"/>
	    		</xsl:call-template>
				</xsl:attribute>
             <xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
			</xsl:copy>	
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="packet_description">
        <xsl:choose>
            <xsl:when test="(parent::dynamic_nat/parent::nat_src/parent::option/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_policy)  or (parent::static_nat/parent::nat_src/parent::option/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_policy) or (parent::static_nat/parent::nat_dst/parent::option/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_policy) or (parent::dynamic_nat/parent::nat_src/parent::option/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_template_policy)  or (parent::static_nat/parent::nat_src/parent::option/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_template_policy) or (parent::static_nat/parent::nat_dst/parent::option/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_template_policy)">
            	<xsl:copy>
                    <xsl:variable name="ref_key_value"><xsl:value-of select="@ne_ref_key"/></xsl:variable>
             	    <xsl:attribute name="ne_ref">
					<xsl:call-template name="replace-old-Mobile-VPN-DHCP-Alias-name">
					    <xsl:with-param name="olddhcpaliasname" select="@ne_ref"/>
		    		</xsl:call-template>
					</xsl:attribute>
                    <xsl:apply-templates select="@*[((name(.) != 'ne_ref_key') or (($ref_key_value != '10') and ($ref_key_value != '13') and ($ref_key_value != '15') and ($ref_key_value != '21') and ($ref_key_value != '60') and ($ref_key_value != '61'))) and (name(.) != 'ne_ref')]|node()"/>
			    </xsl:copy>	
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="packet_description_new">
        <xsl:choose>
            <xsl:when test="(parent::static_nat/parent::nat_src/parent::option/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_policy) or (parent::static_nat/parent::nat_dst/parent::option/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_policy) or (parent::static_nat/parent::nat_src/parent::option/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_template_policy) or (parent::static_nat/parent::nat_dst/parent::option/parent::nat_rule/parent::rule_entry/parent::nat_entry/parent::fw_template_policy)">
            	<xsl:copy>
                    <xsl:variable name="ref_key_value"><xsl:value-of select="@ne_ref_key"/></xsl:variable>
             	    <xsl:attribute name="ne_ref">
					<xsl:call-template name="replace-old-Mobile-VPN-DHCP-Alias-name">
					    <xsl:with-param name="olddhcpaliasname" select="@ne_ref"/>
		    		</xsl:call-template>
					</xsl:attribute>
                    <xsl:apply-templates select="@*[((name(.) != 'ne_ref_key') or (($ref_key_value != '10') and ($ref_key_value != '13') and ($ref_key_value != '15') and ($ref_key_value != '21') and ($ref_key_value != '60') and ($ref_key_value != '61'))) and (name(.) != 'ne_ref')]|node()"/>
			    </xsl:copy>	
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="expression_value">
         <xsl:copy>
         	<xsl:variable name="ref_key_value"><xsl:value-of select="@ne_ref_key"/></xsl:variable>
            <xsl:attribute name="ne_ref">
			<xsl:call-template name="replace-old-Mobile-VPN-DHCP-Alias-name">
			    <xsl:with-param name="olddhcpaliasname" select="@ne_ref"/>
		   	</xsl:call-template>
			</xsl:attribute>
            <xsl:apply-templates select="@*[((name(.) != 'ne_ref_key') or (($ref_key_value != '10') and ($ref_key_value != '13') and ($ref_key_value != '15') and ($ref_key_value != '21') and ($ref_key_value != '60') and ($ref_key_value != '61'))) and (name(.) != 'ne_ref')]|node()"/>
        </xsl:copy>	
    </xsl:template>

    <!-- VPN Only Cleanup: replace references to the following system Aliases and Expressions
             - $ Local Protected Sites for Mobile Users [10]
             - $ Remote Protected Sites [13]
             - $ Remote Destinations That Local Gateway Must Encrypt [15]
             - $ Local Protected Sites [21]
             - DHCP Enabled Interface Addresses In Local Sites [60]
             - NOT $ Local Protected Sites [61]
     Distinguish IPsec VPN and SSL VPN: Rename the following system Aliases
     		 - '$ DHCP Servers for Mobile VPN' becomes '$ DHCP Servers for IPsec VPN'
			 - '$ DHCP Address Pools for Mobile VPN' becomes '$ DHCP Address Pools for IPsec VPN'
			 - '$$ Valid DHCP Address Pools for Mobile VPN'' becomes '$$ Valid DHCP Address Pools for IPsec VPN'
			 - '$$ Valid DHCP Servers for Mobile VPN' becomes '$$ Valid DHCP Servers for IPsec VPN'
          in
             - alias\default_alias_value
             - alias\alias_value\ne_list
             - group\ne_list
          by a non system reference -->
    <xsl:template match="default_alias_value">
        <xsl:choose>
            <xsl:when test="(parent::alias)">
            	<xsl:copy>
                    <xsl:variable name="ref_key_value"><xsl:value-of select="@ne_ref_key"/></xsl:variable>
             	    <xsl:attribute name="ne_ref">
					<xsl:call-template name="replace-old-Mobile-VPN-DHCP-Alias-name">
					    <xsl:with-param name="olddhcpaliasname" select="@ne_ref"/>
		    		</xsl:call-template>
					</xsl:attribute>
                    <xsl:apply-templates select="@*[((name(.) != 'ne_ref_key') or (($ref_key_value != '10') and ($ref_key_value != '13') and ($ref_key_value != '15') and ($ref_key_value != '21') and ($ref_key_value != '60') and ($ref_key_value != '61'))) and (name(.) != 'ne_ref')]|node()"/>
			    </xsl:copy>	
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    <xsl:template match="ne_list">
        <xsl:choose>
            <xsl:when test="(parent::alias_value/parent::alias) or (parent::group)">
            	<xsl:copy>
                    <xsl:variable name="ref_key_value"><xsl:value-of select="@ref_key"/></xsl:variable>
             	    <xsl:attribute name="ref">
					<xsl:call-template name="replace-old-Mobile-VPN-DHCP-Alias-name">
					    <xsl:with-param name="olddhcpaliasname" select="@ref"/>
		    		</xsl:call-template>
					</xsl:attribute>
                    <xsl:apply-templates select="@*[((name(.) != 'ref_key') or (($ref_key_value != '10') and ($ref_key_value != '13') and ($ref_key_value != '15') and ($ref_key_value != '21') and ($ref_key_value != '60') and ($ref_key_value != '61'))) and (name(.) != 'ref')]|node()"/>
			    </xsl:copy>	
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="network_element_ref">
        <xsl:choose>
            <xsl:when test="(parent::vpn_site)">
                <xsl:copy>
                <xsl:attribute name="value">
					<xsl:call-template name="replace-old-Mobile-VPN-DHCP-Alias-name">
			    		<xsl:with-param name="olddhcpaliasname" select="@value"/>
			    	</xsl:call-template>
				</xsl:attribute>
                </xsl:copy>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="@*|node()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
	
   <!-- Rename DHCP system Alias in filters-->
    <xsl:template match="reference[@type='network_element']">
        <xsl:copy>
            <xsl:attribute name="ref_object_name">
                <xsl:call-template name="replace-old-Mobile-VPN-DHCP-Alias-name">
                    <xsl:with-param name="olddhcpaliasname" select="@ref_object_name"/>
                </xsl:call-template>
            </xsl:attribute>
            <xsl:apply-templates select="@*[name(.) != 'ref_object_name']|node()"/>
        </xsl:copy>
    </xsl:template>

    <!-- rename Mobile-VPN-DHCP-Alias reference template  -->    
    <xsl:template name="replace-old-Mobile-VPN-DHCP-Alias-name">
		  <xsl:param name="olddhcpaliasname"/>
			<xsl:choose>
				<xsl:when test="$olddhcpaliasname = '$ DHCP Servers for Mobile VPN'"><xsl:text>$ DHCP Servers for IPsec VPN clients</xsl:text></xsl:when>
				<xsl:when test="$olddhcpaliasname = '$ DHCP Address Pools for Mobile VPN'"><xsl:text>$ DHCP Address Pools for IPsec VPN clients</xsl:text></xsl:when>
				<xsl:when test="$olddhcpaliasname = '$$ Valid DHCP Address Pools for Mobile VPN'"><xsl:text>$$ Valid DHCP Address Pools for IPsec VPN clients</xsl:text></xsl:when>
				<xsl:when test="$olddhcpaliasname = '$$ Valid DHCP Servers for Mobile VPN'"><xsl:text>$$ Valid DHCP Servers for IPsec VPN clients</xsl:text></xsl:when>
			<xsl:otherwise><xsl:value-of select="$olddhcpaliasname"/></xsl:otherwise>
			</xsl:choose>
	    </xsl:template>   
	    
	    	 <!-- rename Client Gateway -->    
    	<xsl:template name="replace-old-Client-Gateway-name">
		  <xsl:param name="oldclientgatewayname"/>
			<xsl:choose>
				<xsl:when test="$oldclientgatewayname = 'Client'"><xsl:text>IPsec Client</xsl:text></xsl:when>
				<xsl:otherwise><xsl:value-of select="$oldclientgatewayname"/></xsl:otherwise>
			</xsl:choose>
	    </xsl:template>   
	    
    <!-- copy everything else; move internal_gateway's certificate and certificate request to top-level -->
    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="internal_gateway/certificate"/>
            <xsl:apply-templates select="internal_gateway/certificate_request"/>
            <xsl:apply-templates select="@*|node()[((name(.) != 'certificate') or not(parent::internal_gateway)) and (name(.) != 'certificate_request')]"/>
        </xsl:copy>
    </xsl:template>
	
</xsl:stylesheet>
