<?xml version="1.0" encoding="UTF-8"?>
		
	<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
		<xsl:output doctype-system="generic_import_export_v4.2.dtd" indent="yes"/>
		<!-- converter, when importing a file using 2.1 dtd: transform into 4.2 dtd -->
		<!-- when importing 2.0 file, it will pass through v2.0 converter and then through v4.2 converter -->
		
		
		
		<!-- add flags use_arp_proxy_enabled and restricted_address_enabled in dhcp_relay_over_ipsec (VPN Internal Gateway)-->
		<xsl:template match="dhcp_relay_over_ipsec">
			<xsl:copy>
				<xsl:choose>
					<xsl:when test="restricted_address_ref">
						<xsl:attribute name="restricted_address_enabled"><xsl:text>true</xsl:text></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="restricted_address_enabled"><xsl:text>false</xsl:text></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="proxy_arp_address_ref">
						<xsl:attribute name="use_arp_proxy_enabled"><xsl:text>true</xsl:text></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="use_arp_proxy_enabled"><xsl:text>false</xsl:text></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:apply-templates select="@*|node()"/>
			</xsl:copy>
		</xsl:template>
		
		<!-- add flags in Capabilities (VPN Profile and Gateway Profile)-->
		<xsl:template match="capabilities">
			<xsl:copy>
				<xsl:attribute name="aes_xcbc_for_ipsec"><xsl:text>false</xsl:text></xsl:attribute>
				<xsl:attribute name="pfs_dh_group_14_for_ipsec"><xsl:text>false</xsl:text></xsl:attribute>
				<xsl:attribute name="dh_group_14_for_ike"><xsl:text>false</xsl:text></xsl:attribute>
				<xsl:attribute name="des_for_ipsec"><xsl:value-of select="@des_for_ike_for_ipsec"/></xsl:attribute>
				<xsl:apply-templates select="@*[name(.) != 'des_for_ike_for_ipsec']|node()"/>
			</xsl:copy>
		</xsl:template>
		
		<!-- add tcp_tunneling flag in end point -->
		<xsl:template match="end_point">
			<xsl:copy>
				<xsl:attribute name="tcp_tunneling"><xsl:text>false</xsl:text></xsl:attribute>
				<xsl:apply-templates select="@*|node()"/>
			</xsl:copy>
		</xsl:template>	
		
		<!-- add auto_certificate flag in InternalGateway -->
		<xsl:template match="internal_gateway">
			<xsl:copy>
				<xsl:attribute name="auto_certificate"><xsl:text>false</xsl:text></xsl:attribute>
				<xsl:apply-templates select="@*|node()"/>
			</xsl:copy>
		</xsl:template>		
		
		<!-- ENGINE XLST CONVERSTION -->
		
		<xsl:template match="combined_interface">
			<xsl:copy>
				<xsl:apply-templates select="@*[(name(.) != 'mtu')]|node()"/>
			</xsl:copy>		
		</xsl:template>
		
		<xsl:template match="analyzer_interface">
			<xsl:copy>
				<xsl:apply-templates select="@*[(name(.) != 'mtu')]|node()"/>
			</xsl:copy>		
		</xsl:template>
		
		<xsl:template match="sensor_node_interface">
			<xsl:copy>
				<xsl:apply-templates select="@*[(name(.) != 'mtu')]|node()"/>
			</xsl:copy>		
		</xsl:template>
		
		<xsl:template match="firewall_node_interface">
			<xsl:copy>
				<xsl:apply-templates select="@*[(name(.) != 'mtu') and (name(.) != 'remote_ipaddress') and (name(.) != 'macaddress') and (name(.) != 'qos_policy_ref') and (name(.) != 'qos_policy_ref_key') and (name(.) != 'qos_limit')]|node()[(name(.) != 'sync_parameter')]"/>
			</xsl:copy>		
		</xsl:template>
		
		<xsl:template match="sensor_single_interface">
			<xsl:copy>
				<xsl:apply-templates select="@*[(name(.) != 'mtu')]|node()"/>
			</xsl:copy>		
		</xsl:template>						
		
		<xsl:template match="inline_interface">
			<xsl:copy>
				<xsl:apply-templates select="@*[(name(.) != 'mtu') and (name(.) != 'nicid') and (name(.) != 'name')]|node()"/>
				<xsl:choose>
					<xsl:when test="contains(@nicid, 'Other VLANs')">
						<xsl:attribute name='nicid'><xsl:value-of select="concat(substring-before(@nicid, '.Other VLANs'), substring-before(substring-after(@nicid, '.Other VLANs'), '.Other VLANs'))"></xsl:value-of></xsl:attribute>
						<xsl:attribute name='name'><xsl:value-of select="concat(substring-before(@name, '.Other VLANs'), substring-before(substring-after(@name, '.Other VLANs'), '.Other VLANs'))"></xsl:value-of></xsl:attribute>
						<xsl:attribute name='inspect_unspecified_vlans'>true</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name='nicid'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
						<xsl:attribute name='name'><xsl:value-of select="@name"></xsl:value-of></xsl:attribute>
						<xsl:attribute name='inspect_unspecified_vlans'>false</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:copy>		
		</xsl:template>
		
		<xsl:template match="capture_interface">
			<xsl:copy>
				<xsl:apply-templates select="@*[(name(.) != 'mtu') and (name(.) != 'mode') and (name(.) != 'nicid') and (name(.) != 'name')]|node()"/>
				<xsl:choose>
					<xsl:when test="contains(@nicid, 'Other VLANs')">
						<xsl:attribute name='nicid'><xsl:value-of select="substring-before(@nicid, '.Other VLANs')"></xsl:value-of></xsl:attribute>
						<xsl:attribute name='name'><xsl:value-of select="substring-before(@name, '.Other VLANs')"></xsl:value-of></xsl:attribute>
						<xsl:attribute name='inspect_unspecified_vlans'>true</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name='nicid'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
						<xsl:attribute name='name'>
							<xsl:choose>
								<xsl:when test="contains(@name, '-span')">
									<xsl:value-of select="substring-before(@name, '-span')"></xsl:value-of>
								</xsl:when>
								<xsl:when test="contains(@name, '-tap')">
									<xsl:value-of select="substring-before(@name, '-tap')"></xsl:value-of>
								</xsl:when>								
								<xsl:otherwise>
									<xsl:value-of select="@name"></xsl:value-of>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:attribute>
						<xsl:attribute name='inspect_unspecified_vlans'>false</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:copy>		
		</xsl:template>
		
		<xsl:template match="cluster_virtual_interface">
			<xsl:copy>
				<xsl:if test="dhcp_relay/@enabled='true'">
					<xsl:attribute name="relayed_by_dhcp">true</xsl:attribute>
				</xsl:if>
				
				<xsl:apply-templates select="@*[(name(.) != 'mtu') and (name(.) != 'macaddress') and (name(.) != 'mode') and (name(.) != 'qos_policy_ref') and (name(.) != 'qos_policy_ref_key') and (name(.) != 'qos_limit') and (name(.) != 'multicast_ip')]|node()[(name(.) != 'dhcp_relay')]"/>
			</xsl:copy>			
		</xsl:template>
		
		<xsl:template match="fw_single_interface">
			<xsl:copy>
				<xsl:apply-templates select="@*[(name(.) != 'mtu') and (name(.) != 'remote_ipaddress') and (name(.) != 'used_for_auth_request') and (name(.) != 'qos_policy_ref') and (name(.) != 'qos_policy_ref_key') and (name(.) != 'qos_limit')]|node()[(name(.) != 'dhcp_relay')]"/>
			</xsl:copy>			
		</xsl:template>			
		
		<xsl:template match="combined_sensor_analyzer">
			<xsl:copy>
				<xsl:apply-templates select="@*|node()[(name(.) != 'vlan') and (name(.) != 'vlan_nic')]"/>
				<xsl:for-each select="combined_interface|capture_interface|inline_interface">
					<xsl:element name="physical_interface">
						<xsl:choose>
								<xsl:when test="contains(@nicid, '.')">
									<xsl:attribute name='interface_id'><xsl:value-of select="substring-before(@nicid, '.')"></xsl:value-of></xsl:attribute>
								</xsl:when>
								<xsl:when test="contains(@nicid, '-')">
									<xsl:attribute name='interface_id'><xsl:value-of select="substring-before(@nicid, '-')"></xsl:value-of></xsl:attribute>
								</xsl:when>								
								<xsl:otherwise>
									<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
								</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="@macaddress"><xsl:attribute name='macaddress'><xsl:value-of select="@mac_address"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="@mtu"><xsl:attribute name='mtu'><xsl:value-of select="@mtu"></xsl:value-of></xsl:attribute></xsl:if>
					</xsl:element>
				</xsl:for-each>
				<xsl:for-each select="vlan">
					<xsl:element name="physical_interface">
						<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
						<xsl:element name="physical_interface">
							<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>					
							<xsl:attribute name='vlan_id'><xsl:value-of select="@vlanid"></xsl:value-of></xsl:attribute>
							<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>	
						</xsl:element>									
					</xsl:element>				
				</xsl:for-each>
			</xsl:copy>
		</xsl:template>			
		
		<xsl:template match="sensor_cluster">
			<xsl:copy>
				<xsl:apply-templates select="@*|node()[(name(.) != 'vlan') and (name(.) != 'vlan_nic')]"/>
				<xsl:for-each select="capture_interface|inline_interface">
					<xsl:element name="physical_interface">
						<xsl:choose>
								<xsl:when test="contains(@nicid, '.')">
									<xsl:attribute name='interface_id'><xsl:value-of select="substring-before(@nicid, '.')"></xsl:value-of></xsl:attribute>
								</xsl:when>
								<xsl:when test="contains(@nicid, '-')">
									<xsl:attribute name='interface_id'><xsl:value-of select="substring-before(@nicid, '-')"></xsl:value-of></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
								</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="@macaddress"><xsl:attribute name='macaddress'><xsl:value-of select="@macaddress"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="@mtu"><xsl:attribute name='mtu'><xsl:value-of select="@mtu"></xsl:value-of></xsl:attribute></xsl:if>
					</xsl:element>
				</xsl:for-each>
				<xsl:for-each select="vlan">
					<xsl:element name="physical_interface">
						<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
						<xsl:element name="physical_interface">
							<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>					
							<xsl:attribute name='vlan_id'><xsl:value-of select="@vlanid"></xsl:value-of></xsl:attribute>
							<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>
						</xsl:element>									
					</xsl:element>				
				</xsl:for-each>
				<xsl:for-each select="sensor_node/sensor_node_interface">
					<xsl:element name="physical_interface">
						<xsl:choose>
								<xsl:when test="contains(@nicid, '.')">
									<xsl:attribute name='interface_id'><xsl:value-of select="substring-before(@nicid, '.')"></xsl:value-of></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
								</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>
					</xsl:element>				
				</xsl:for-each>
			</xsl:copy>
		</xsl:template>
		
		<xsl:template match="single_sensor">
			<xsl:copy>
				<xsl:apply-templates select="@*|node()[(name(.) != 'vlan') and (name(.) != 'vlan_nic')]"/>
				<xsl:for-each select="sensor_single_interface|capture_interface|inline_interface">
					<xsl:element name="physical_interface">
						<xsl:choose>
								<xsl:when test="contains(@nicid, '.')">
									<xsl:attribute name='interface_id'><xsl:value-of select="substring-before(@nicid, '.')"></xsl:value-of></xsl:attribute>
								</xsl:when>
								<xsl:when test="contains(@nicid, '-')">
									<xsl:attribute name='interface_id'><xsl:value-of select="substring-before(@nicid, '-')"></xsl:value-of></xsl:attribute>
								</xsl:when>								
								<xsl:otherwise>
									<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
								</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="@macaddress"><xsl:attribute name='macaddress'><xsl:value-of select="@macaddress"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="@mtu"><xsl:attribute name='mtu'><xsl:value-of select="@mtu"></xsl:value-of></xsl:attribute></xsl:if>
					</xsl:element>
				</xsl:for-each>
				<xsl:for-each select="vlan">
					<xsl:element name="physical_interface">
						<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
						<xsl:element name="physical_interface">
							<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>					
							<xsl:attribute name='vlan_id'><xsl:value-of select="@vlanid"></xsl:value-of></xsl:attribute>
							<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>
						</xsl:element>									
					</xsl:element>				
				</xsl:for-each>	
			</xsl:copy>		
		</xsl:template>	
		
		<xsl:template match="analyzer">
			<xsl:copy>
				<xsl:apply-templates select="@*|node()"/>
				<xsl:for-each select="analyzer_interface">
					<xsl:element name="physical_interface">
						<xsl:choose>
								<xsl:when test="contains(@nicid, '.')">
									<xsl:attribute name='interface_id'><xsl:value-of select="substring-before(@nicid, '.')"></xsl:value-of></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
								</xsl:otherwise>
						</xsl:choose>
						<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="@macaddress"><xsl:attribute name='macaddress'><xsl:value-of select="@macaddress"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="@mtu"><xsl:attribute name='mtu'><xsl:value-of select="@mtu"></xsl:value-of></xsl:attribute></xsl:if>
					</xsl:element>
				</xsl:for-each>
			</xsl:copy>
		</xsl:template>	
		
		<xsl:template match="fw_cluster">
			<xsl:copy>
			
				<xsl:attribute name="tcp_tunneling_port"><xsl:text>80</xsl:text></xsl:attribute>
				
				<xsl:apply-templates select="@*|node()[(name(.) != 'vlan') and (name(.) != 'vlan_nic')]"/>
					<xsl:for-each select="cluster_virtual_interface">
						<xsl:element name="physical_interface">
							<xsl:choose>
									<xsl:when test="contains(@nicid, '.')">
										<xsl:attribute name='interface_id'><xsl:value-of select="substring-before(@nicid, '.')"></xsl:value-of></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
									</xsl:otherwise>
							</xsl:choose>
							<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:choose>
								<xsl:when test="@mode='ipaddresstakeover'">
									<xsl:attribute name='cvi_mode'><xsl:text>none</xsl:text></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:if test="@mode">
										<xsl:attribute name='cvi_mode'><xsl:value-of select="@mode"></xsl:value-of></xsl:attribute>
									</xsl:if>
								</xsl:otherwise>
							</xsl:choose>						
							<xsl:if test="@macaddress"><xsl:attribute name='macaddress'><xsl:value-of select="@macaddress"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:if test="@multicast_ip"><xsl:attribute name='multicast_ip'><xsl:value-of select="@multicast_ip"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:if test="@qos_policy_ref"><xsl:attribute name='qos_policy_ref'><xsl:value-of select="@qos_policy_ref"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:if test="@qos_policy_ref_key"><xsl:attribute name='qos_policy_ref_key'><xsl:value-of select="@qos_policy_ref_key"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:if test="@qos_limit"><xsl:attribute name='qos_limit'><xsl:value-of select="@qos_limit"></xsl:value-of></xsl:attribute></xsl:if>	
							<xsl:if test="@mtu"><xsl:attribute name='mtu'><xsl:value-of select="@mtu"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:if test="not(contains(@nicid, '.'))">
							<xsl:if test="dhcp_relay/@enabled = 'true'">
								<xsl:for-each select="dhcp_relay">
									<xsl:copy>
										<xsl:apply-templates select="@*|node()"/>
									</xsl:copy>
								</xsl:for-each>
								</xsl:if>
							</xsl:if>
						</xsl:element>
					</xsl:for-each>
					
					<xsl:for-each select="vlan">
						<xsl:element name="physical_interface">
							<xsl:variable name="nic_id"><xsl:value-of select="@nicid"/></xsl:variable>
							<xsl:variable name="vlan_id"><xsl:value-of select="@vlanid"/></xsl:variable>
							<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
							<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:element name="physical_interface">
								<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>					
								<xsl:attribute name='vlan_id'><xsl:value-of select="@vlanid"></xsl:value-of></xsl:attribute>
								<xsl:if test="../vlan_nic[@nicid = $nic_id]/@comment"><xsl:attribute name='comment'><xsl:value-of select="../vlan_nic[@nicid = $nic_id]/@comment"></xsl:value-of></xsl:attribute></xsl:if>
								<xsl:if test="../vlan_nic[@nicid = $nic_id]/@mode">
									<xsl:choose>
										<xsl:when test="../vlan_nic[@nicid = $nic_id]/@mode = 'unicast'">
											<xsl:attribute name='cvi_mode'><xsl:text>unicast</xsl:text></xsl:attribute>
											<xsl:if test="../vlan_nic[@nicid = $nic_id]/@address"><xsl:attribute name='macaddress'><xsl:value-of select="../vlan_nic[@nicid = $nic_id]/@address"></xsl:value-of></xsl:attribute></xsl:if>									
										</xsl:when>
										<xsl:when test="../vlan_nic[@nicid = $nic_id]/@mode = 'multicast'">
											<xsl:attribute name='cvi_mode'><xsl:text>multicast</xsl:text></xsl:attribute>
											<xsl:if test="../vlan_nic[@nicid = $nic_id]/@address"><xsl:attribute name='macaddress'><xsl:value-of select="../vlan_nic[@nicid = $nic_id]/@address"></xsl:value-of></xsl:attribute></xsl:if>									
										</xsl:when>
										<xsl:when test="../vlan_nic[@nicid = $nic_id]/@mode = 'igmp'">
											<xsl:attribute name='cvi_mode'><xsl:text>multicastigmp</xsl:text></xsl:attribute>
											<xsl:if test="../vlan_nic[@nicid = $nic_id]/@address"><xsl:attribute name='multicast_ip'><xsl:value-of select="../vlan_nic[@nicid = $nic_id]/@address"></xsl:value-of></xsl:attribute></xsl:if>									
										</xsl:when>
										<xsl:when test="../vlan_nic[@nicid = $nic_id]/@mode = 'packet_dispatch'">
											<xsl:attribute name='cvi_mode'><xsl:text>packetdispatch</xsl:text></xsl:attribute>
											<xsl:if test="../vlan_nic[@nicid = $nic_id]/@address"><xsl:attribute name='macaddress'><xsl:value-of select="../vlan_nic[@nicid = $nic_id]/@address"></xsl:value-of></xsl:attribute></xsl:if>									
										</xsl:when>								
										<xsl:otherwise>
											<xsl:attribute name='cvi_mode'><xsl:text>none</xsl:text></xsl:attribute>
										</xsl:otherwise>								
									</xsl:choose>
								</xsl:if>
								
							<xsl:if test="../cluster_virtual_interface[($nic_id=substring-before(@nicid, '.')) and ($vlan_id=substring-after(@nicid, '.'))]/dhcp_relay/@enabled = 'true'">
								<xsl:for-each select="../cluster_virtual_interface[($nic_id=substring-before(@nicid, '.')) and ($vlan_id=substring-after(@nicid, '.'))]/dhcp_relay">
									<xsl:copy>
										<xsl:apply-templates select="@*|node()"/>
									</xsl:copy>
								</xsl:for-each>
								</xsl:if>
							</xsl:element>									
						</xsl:element>				
					</xsl:for-each>
					
					<xsl:for-each select="firewall_node/firewall_node_interface">
						<xsl:element name="physical_interface">
							<xsl:choose>
									<xsl:when test="contains(@nicid, '.')">
										<xsl:attribute name='interface_id'><xsl:value-of select="substring-before(@nicid, '.')"></xsl:value-of></xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
									</xsl:otherwise>
							</xsl:choose>
							<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:if test="@macaddress"><xsl:attribute name='macaddress'><xsl:value-of select="@macaddress"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:if test="@qos_policy_ref"><xsl:attribute name='qos_policy_ref'><xsl:value-of select="@qos_policy_ref"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:if test="@qos_policy_ref_key"><xsl:attribute name='qos_policy_ref_key'><xsl:value-of select="@qos_policy_ref_key"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:if test="@qos_limit"><xsl:attribute name='qos_limit'><xsl:value-of select="@qos_limit"></xsl:value-of></xsl:attribute></xsl:if>	
							<xsl:if test="@mtu"><xsl:attribute name='mtu'><xsl:value-of select="@mtu"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:for-each select="sync_parameter">
									<xsl:copy>
										<xsl:apply-templates select="@*|node()"/>
										<xsl:if test="not(@statesync_group_ip)"><xsl:attribute name="statesync_group_ip"><xsl:text>225.1.1.2</xsl:text></xsl:attribute></xsl:if>
										<xsl:if test="not(@heartbeat_group_ip)"><xsl:attribute name="heartbeat_group_ip"><xsl:text>225.1.1.1</xsl:text></xsl:attribute></xsl:if>
									</xsl:copy>
							</xsl:for-each>
						</xsl:element>				
					</xsl:for-each>	
								
			</xsl:copy>		
		</xsl:template>	
		
		<xsl:template match="fw_single">
			<xsl:copy>
			
				<xsl:attribute name="tcp_tunneling_port"><xsl:text>80</xsl:text></xsl:attribute>
				
				<xsl:apply-templates select="@*|node()[(name(.) != 'vlan') and (name(.) != 'vlan_nic')]"/>
				
				<xsl:for-each select="fw_single_interface">
					<xsl:element name="physical_interface">
						<xsl:choose>
								<xsl:when test="contains(@nicid, '.')">
									<xsl:attribute name='interface_id'><xsl:value-of select="substring-before(@nicid, '.')"></xsl:value-of></xsl:attribute>
								</xsl:when>
								<xsl:otherwise>
									<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
								</xsl:otherwise>
						</xsl:choose>
						
						<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="@macaddress"><xsl:attribute name='macaddress'><xsl:value-of select="@macaddress"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="@qos_policy_ref"><xsl:attribute name='qos_policy_ref'><xsl:value-of select="@qos_policy_ref"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="@qos_policy_ref_key"><xsl:attribute name='qos_policy_ref_key'><xsl:value-of select="@qos_policy_ref_key"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="@qos_limit"><xsl:attribute name='qos_limit'><xsl:value-of select="@qos_limit"></xsl:value-of></xsl:attribute></xsl:if>	
						<xsl:if test="@mtu"><xsl:attribute name='mtu'><xsl:value-of select="@mtu"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:if test="dhcp_relay/@enabled = 'true'">
							<xsl:for-each select="dhcp_relay">
								<xsl:copy>
										<xsl:apply-templates select="@*|node()"/>
								</xsl:copy>
							</xsl:for-each>
						</xsl:if>
					</xsl:element>					
				</xsl:for-each>
				
				<xsl:for-each select="vlan">
					<xsl:element name="physical_interface">
						<xsl:variable name="nic_id"><xsl:value-of select="@nicid"/></xsl:variable>
						<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>
						<xsl:if test="@comment"><xsl:attribute name='comment'><xsl:value-of select="@comment"></xsl:value-of></xsl:attribute></xsl:if>
						<xsl:element name="physical_interface">
							<xsl:attribute name='interface_id'><xsl:value-of select="@nicid"></xsl:value-of></xsl:attribute>					
							<xsl:attribute name='vlan_id'><xsl:value-of select="@vlanid"></xsl:value-of></xsl:attribute>
							<xsl:if test="../vlan_nic[@nicid = $nic_id]/@comment"><xsl:attribute name='comment'><xsl:value-of select="../vlan_nic[@nicid = $nic_id]/@comment"></xsl:value-of></xsl:attribute></xsl:if>
							<xsl:if test="../vlan_nic[@nicid = $nic_id]/@address"><xsl:attribute name='macaddress'><xsl:value-of select="../vlan_nic[@nicid = $nic_id]/@address"></xsl:value-of></xsl:attribute></xsl:if>						
						</xsl:element>									
					</xsl:element>				
				</xsl:for-each>

			</xsl:copy>				
		</xsl:template>									
				
		
		<!-- 'point_to_point' notion removal -->
		<xsl:template match="single_fw_ndi_mode">
			<xsl:copy>
				<xsl:apply-templates select="@*[name(.) != 'point_to_point']|node()"/>
				<xsl:if test="../dhcp_relay/@enabled = 'true'">
					<xsl:attribute name='relayed_by_dhcp'><xsl:text>true</xsl:text></xsl:attribute>
				</xsl:if>
			</xsl:copy>			
		</xsl:template>
		
		<!-- 'point_to_point' notion removal -->
		<xsl:template match="firewall_ndi_mode">
			<xsl:copy>
				<xsl:apply-templates select="@*[name(.) != 'point_to_point']|node()"/>
			</xsl:copy>			
		</xsl:template>		


		<!-- ignore vpn client (system key = 9) gateway type and old version of element referencing to it -->
		<xsl:template match="gateway_type[@key='9']"/>
		<xsl:template match="client_gateway[@key='2']"/>

        <!-- management and Log Servers now support multiple contact addresses per location. -->
        <xsl:template match="mvia_association" mode="multi">
          <xsl:element name="mvia_location">

            <xsl:choose>
              <xsl:when test="@ne_ref_key">
                <xsl:element name='loc_id'>
                  <xsl:attribute name='id'>
                    <xsl:value-of select="@ne_ref_key"/>
                  </xsl:attribute>
                </xsl:element>
              </xsl:when>
              <xsl:otherwise>
                <xsl:if test="@ne_ref">
                  <xsl:element name='loc_name'>
                    <xsl:attribute name='name'>
                      <xsl:value-of select="@ne_ref"/>
                    </xsl:attribute>
                  </xsl:element>
                </xsl:if>
              </xsl:otherwise>
            </xsl:choose>

            <xsl:element name="loc_address">
              <xsl:attribute name='ip'>
                <xsl:value-of select="@ipaddress"/>
              </xsl:attribute>
            </xsl:element>
          </xsl:element>
        </xsl:template>
		
		<xsl:template match="mvia_address" mode="multi">
			<xsl:element name="multi_contact_mvia">
				<xsl:attribute name='address'>
					<xsl:value-of select="@address"/>
				</xsl:attribute>
				<xsl:apply-templates select="mvia_association" mode="multi"/>
			</xsl:element>
		</xsl:template>
		
		<xsl:template match="mgt_server|log_server">
			<xsl:copy>
				<xsl:apply-templates select="@*|node()[name(.) != 'mvia_address' and name(.) != 'channel_parameter']"/>
				<xsl:apply-templates select="mvia_address" mode="multi"/>
				<xsl:apply-templates select="node()[name(.) = 'channel_parameter']"/>
			</xsl:copy>
		</xsl:template>

        <!-- Get rid of NO_VALUE_OR_NOT -->		
		<xsl:template match="filter_expression[node()//logical/@type='NO_VALUE_OR_NOT']">
			<xsl:copy>
                <xsl:attribute name='default_value'>2</xsl:attribute>
				<xsl:apply-templates select="@*[name(.) != 'default_value']|node()"/>
			</xsl:copy>
		</xsl:template>
		<xsl:template match="logical[@type='NO_VALUE_OR_NOT']">
			<xsl:copy>
                <xsl:attribute name='type'>NOT</xsl:attribute>
				<xsl:apply-templates select="@*[name(.) != 'type']|node()"/>
			</xsl:copy>
		</xsl:template>
		
		
		<!-- rename sg Monitoring backup tcp service -->
		<xsl:template match="reference[@type='service']">
			<xsl:copy>
				<xsl:attribute name="ref_object_name">
					<xsl:call-template name="replace-old-service-name">
					    <xsl:with-param name="oldservicename" select="@ref_object_name"/>
		    		</xsl:call-template>
				</xsl:attribute>
				<xsl:apply-templates select="@*[name(.) != 'ref_object_name']|node()"/>
			</xsl:copy>
		</xsl:template>
	
    	<!-- deleted system services are also managed by removing -->
		<xsl:template match="service_ref">
			<xsl:copy>
				<xsl:attribute name="value">
				<xsl:call-template name="replace-old-service-name">
			    	<xsl:with-param name="oldservicename" select="@value"/>
			    </xsl:call-template>
				</xsl:attribute>
				<xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
			</xsl:copy>
		</xsl:template>
	
		<!-- deleted system services are also managed by removing -->
		<xsl:template match="match_service_ref">
			<xsl:copy>
				<xsl:attribute name="value">
					<xsl:call-template name="replace-old-service-name">
				    <xsl:with-param name="oldservicename" select="@value"/>
				    </xsl:call-template>
				</xsl:attribute>
				<xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
			</xsl:copy>							
		</xsl:template>
	
		<xsl:template name="replace-old-service-name">
		  <xsl:param name="oldservicename"/>
			<xsl:choose>
				<xsl:when test="$oldservicename = 'SG Monitoring Backup'"><xsl:text>SG Reverse Monitoring</xsl:text></xsl:when>
			<xsl:otherwise><xsl:value-of select="$oldservicename"/></xsl:otherwise>
			</xsl:choose>
	    </xsl:template>
	    
		<!-- copy everything else -->
		<xsl:template match="@*|node()">
			<xsl:copy>
				<xsl:apply-templates select="@*|node()"/>
			</xsl:copy>
		</xsl:template>
</xsl:stylesheet>
