<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output
		doctype-system="generic_import_export_v2.1.dtd"
		indent="yes"/>
		
	<!-- converter, when importing a file using 2.0 dtd: transform into 2.1 dtd -->
	<!-- when importing 1.1 file, it will pass through v1.1 converter and then through v2.0 converter -->

	<!-- add flags vpn_client_* in Capabilities (VPN Profile and Gateway Profile)-->
	<xsl:template match="capabilities">
			<xsl:copy>
				<xsl:choose>
					<xsl:when test="@dss_signature_for_ike='true'">
						<xsl:attribute name="vpn_client_dss_signature_for_ike"><xsl:text>true</xsl:text></xsl:attribute>
						<xsl:attribute name="vpn_client_rsa_signature_for_ike"><xsl:text>false</xsl:text></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="vpn_client_dss_signature_for_ike"><xsl:text>false</xsl:text></xsl:attribute>
						<xsl:attribute name="vpn_client_rsa_signature_for_ike"><xsl:text>true</xsl:text></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="@sa_per_net='true'">
						<xsl:attribute name="vpn_client_sa_per_net"><xsl:text>true</xsl:text></xsl:attribute>
						<xsl:attribute name="vpn_client_sa_per_host"><xsl:text>false</xsl:text></xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="vpn_client_sa_per_net"><xsl:text>false</xsl:text></xsl:attribute>
						<xsl:attribute name="vpn_client_sa_per_host"><xsl:text>true</xsl:text></xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	
	
		<!-- manage all system services renaming -->
	<xsl:template match="reference[@type='service']">
		<xsl:choose>
			<xsl:when test="@value =  'SG-mgmt-log-1'"></xsl:when>
			<xsl:when test="@value =  'SG-mgmt-log-2'"></xsl:when>
	  	    <xsl:when test="@value =  'SG-mgmt-log-3'"></xsl:when>
   	  	    <xsl:when test="@value =  'SG-Log-to-Mgt'"></xsl:when>  	  	       	  	    
				
			<xsl:otherwise>
				<xsl:copy>
					<xsl:attribute name="ref_object_name">
						<xsl:call-template name="replace-old-service-name">
						    <xsl:with-param name="oldservicename" select="@ref_object_name"/>
			    		</xsl:call-template>
					</xsl:attribute>
					<xsl:apply-templates select="@*[name(.) != 'ref_object_name']|node()"/>
				</xsl:copy>
		   </xsl:otherwise>
		</xsl:choose>		
	</xsl:template>
	
    <!-- deleted system services are also managed by removing -->
	<xsl:template match="service_ref">
		<xsl:choose>
			<xsl:when test="@value =  '10012'"></xsl:when>
			<xsl:when test="@value =  '10003'"></xsl:when>
			<xsl:when test="@value =  '10017'"></xsl:when>
			<xsl:when test="@value =  '421'"></xsl:when>
			<xsl:when test="@value =  '10044'"></xsl:when>
			<xsl:when test="@value =  '10014'"></xsl:when>
			<xsl:when test="@value =  '440'"></xsl:when>
			
			<xsl:when test="@value =  '298'"></xsl:when>
			<xsl:when test="@value =  '299'"></xsl:when>
			<xsl:when test="@value =  '300'"></xsl:when>
			
	  		<xsl:when test="@value =  '10002'"></xsl:when>
			<xsl:when test="@value =  '10029'"></xsl:when>
			<xsl:when test="@value =  '10037'"></xsl:when>
			<xsl:when test="@value =  '354'"></xsl:when>
			<xsl:when test="@value =  '10046'"></xsl:when>
			<xsl:when test="@value =  '10024'"></xsl:when>
			<xsl:when test="@value =  '10031'"></xsl:when>
			<xsl:when test="@value =  '10019'"></xsl:when>
  			<xsl:when test="@value =  '10020'"></xsl:when>
			<xsl:when test="@value =  '10004'"></xsl:when>
			<xsl:when test="@value =  '10027'"></xsl:when>
			<xsl:when test="@value =  '10005'"></xsl:when>
			<xsl:when test="@value =  '10045'"></xsl:when>
			<xsl:when test="@value =  '10023'"></xsl:when>
			<xsl:when test="@value =  '10030'"></xsl:when>
			<xsl:when test="@value =  '10036'"></xsl:when>
			<xsl:when test="@value =  '10035'"></xsl:when>
			<xsl:when test="@value =  '10008'"></xsl:when>
			<xsl:when test="@value =  '10009'"></xsl:when>
			<xsl:when test="@value =  '10025'"></xsl:when>
			<xsl:when test="@value =  '10032'"></xsl:when>
			
    		<xsl:when test="@value =  '298'"></xsl:when>
			<xsl:when test="@value =  '299'"></xsl:when>
	  	    <xsl:when test="@value =  '300'"></xsl:when>
   	  	    <xsl:when test="@value =  '456'"></xsl:when>
   	  	    <xsl:when test="@value =  '10006'"></xsl:when>
   	  	    <xsl:when test="@value =  '10010'"></xsl:when>
   	  	    <xsl:when test="@value =  '10011'"></xsl:when>
   	  	    <xsl:when test="@value =  '10051'"></xsl:when>
   	  	    
   	  	    <xsl:when test="@value =  'SG-mgmt-log-1'"></xsl:when>
			<xsl:when test="@value =  'SG-mgmt-log-2'"></xsl:when>
	  	    <xsl:when test="@value =  'SG-mgmt-log-3'"></xsl:when>
   	  	    <xsl:when test="@value =  'SG-Log-to-Mgt'"></xsl:when>
			
			<xsl:otherwise>
				<xsl:copy>
					<xsl:attribute name="value">
					<xsl:call-template name="replace-old-service-name">
				    	<xsl:with-param name="oldservicename" select="@value"/>
				    </xsl:call-template>
					</xsl:attribute>
					<xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>	
	</xsl:template>
	
	<!-- deleted system services are also managed by removing -->
	<xsl:template match="match_service_ref">
		<xsl:choose>
			<xsl:when test="@value =  '10012'"></xsl:when>
			<xsl:when test="@value =  '10003'"></xsl:when>
			<xsl:when test="@value =  '10017'"></xsl:when>
			<xsl:when test="@value =  '421'"></xsl:when>
			<xsl:when test="@value =  '10044'"></xsl:when>
			<xsl:when test="@value =  '10014'"></xsl:when>
			<xsl:when test="@value =  '440'"></xsl:when>
			
			<xsl:when test="@value =  '298'"></xsl:when>
			<xsl:when test="@value =  '299'"></xsl:when>
			<xsl:when test="@value =  '300'"></xsl:when>
			
	  		<xsl:when test="@value =  '10002'"></xsl:when>
			<xsl:when test="@value =  '10029'"></xsl:when>
			<xsl:when test="@value =  '10037'"></xsl:when>
			<xsl:when test="@value =  '354'"></xsl:when>
			<xsl:when test="@value =  '10046'"></xsl:when>
			<xsl:when test="@value =  '10024'"></xsl:when>
			<xsl:when test="@value =  '10031'"></xsl:when>
			<xsl:when test="@value =  '10019'"></xsl:when>
  			<xsl:when test="@value =  '10020'"></xsl:when>
			<xsl:when test="@value =  '10004'"></xsl:when>
			<xsl:when test="@value =  '10027'"></xsl:when>
			<xsl:when test="@value =  '10005'"></xsl:when>
			<xsl:when test="@value =  '10045'"></xsl:when>
			<xsl:when test="@value =  '10023'"></xsl:when>
			<xsl:when test="@value =  '10030'"></xsl:when>
			<xsl:when test="@value =  '10036'"></xsl:when>
			<xsl:when test="@value =  '10035'"></xsl:when>
			<xsl:when test="@value =  '10008'"></xsl:when>
			<xsl:when test="@value =  '10009'"></xsl:when>
			<xsl:when test="@value =  '10025'"></xsl:when>
			<xsl:when test="@value =  '10032'"></xsl:when>			
	    		<xsl:when test="@value =  '298'"></xsl:when>
			<xsl:when test="@value =  '299'"></xsl:when>
		        <xsl:when test="@value =  '300'"></xsl:when>
   	  	        <xsl:when test="@value =  '456'"></xsl:when>
	  	    
	  	  	<xsl:when test="@value =  '10006'"></xsl:when>
   	  		<xsl:when test="@value =  '10010'"></xsl:when>
	 	  	<xsl:when test="@value =  '10011'"></xsl:when>
   	  		<xsl:when test="@value =  '10051'"></xsl:when>
   	  		
   	  	  	<xsl:when test="@value =  'SG-mgmt-log-1'"></xsl:when>
			<xsl:when test="@value =  'SG-mgmt-log-2'"></xsl:when>
	  	    <xsl:when test="@value =  'SG-mgmt-log-3'"></xsl:when>
   	  	    <xsl:when test="@value =  'SG-Log-to-Mgt'"></xsl:when>  	
	  	    
			<xsl:otherwise>
				<xsl:copy>
					<xsl:attribute name="value">
						<xsl:call-template name="replace-old-service-name">
					    <xsl:with-param name="oldservicename" select="@value"/>
					    </xsl:call-template>
					</xsl:attribute>
					<xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
				</xsl:copy>		
			</xsl:otherwise>
		</xsl:choose>					
	</xsl:template>
	
	<xsl:template name="replace-old-service-name">
	  <xsl:param name="oldservicename"/>
		<xsl:choose>
			<xsl:when test="$oldservicename = 'IPv4 inspection'"><xsl:text>IPv4</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Tacacs+'"><xsl:text>TACACS+</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-auth'"><xsl:text>SG User Authentication</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-Log-to-Mgt'"><xsl:text>SG Log to Management</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = '32 Bit Rollover missing and ACK set'"><xsl:text>Datagram Conv. Error (32 Bit Rollover Missing)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Address Mask Reply (no code)'"><xsl:text>Address Mask Reply (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Address Mask Reply'"><xsl:text>Address Mask Reply (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Address Mask Request (no code)'"><xsl:text>Address Mask Request (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Address Mask Request'"><xsl:text>Address Mask Request (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Alternate Address for Host'"><xsl:text>Alternate Host Address (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Alternate Host Address'"><xsl:text>Alternate Host Address (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Bad Length'"><xsl:text>Parameter Problem (Bad Length)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Communication administratively prohibited by filtering'"><xsl:text>Dest. Unreachable (Administratively Prohibited)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Datagram Conversion Error'"><xsl:text>Datagram Conv. Error (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Destination host administratively prohibited'"><xsl:text>Dest. Unreachable (Host Prohibited)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Destination host unknown'"><xsl:text>Dest. Unreachable (Host Unknown)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Destination network administratively prohibited'"><xsl:text>Dest. Unreachable (Network Prohibited)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Destination network unknown'"><xsl:text>Dest. Unreachable (Network Unknown)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Destination Unreachable'"><xsl:text>Dest. Unreachable (Any Code)</xsl:text></xsl:when>
			<xsl:when test='$oldservicename = "Don&apos;t Convert option present"'><xsl:text>Datagram Conv. Error (Don't Convert Set)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Echo reply (no code)'"><xsl:text>Echo Reply (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Echo reply'"><xsl:text>Echo Reply (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Echo request (no code)'"><xsl:text>Echo Request (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Echo request'"><xsl:text>Echo Request (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Fragmentation needed but dont-fragment bit set'"><xsl:text>Dest. Unreachable (Fragmentation Needed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Fragment Reassembly Time Exceeded'"><xsl:text>Time Exceeded (Fragment Reassembly)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Host precedence violation'"><xsl:text>Dest. Unreachable (Host Precedence Violation)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Host unreachable for TOS'"><xsl:text>Dest. Unreachable (Host Unreachable for ToS)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Host unreachable'"><xsl:text>Dest. Unreachable (Host Unreachable)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Information Reply (no code)'"><xsl:text>Information Reply (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Information Reply'"><xsl:text>Information Reply (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Information Request (no code)'"><xsl:text>Information Request (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Information Request'"><xsl:text>Information Request (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IP header length exceeded'"><xsl:text>Datagram Conv. Error (IP Header Length Exceeded)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Known unsupported option present'"><xsl:text>Datagram Conv. Error (Known Unsupported Option)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Missing a Required Option'"><xsl:text>Parameter Problem (Missing Option)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Network unreachable for TOS'"><xsl:text>Dest. Unreachable (Net Unreachable for ToS)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Network unreachable'"><xsl:text>Dest. Unreachable (Net Unreachable)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'No route for Outbound Packet; packet discarded'"><xsl:text>Traceroute Status (No Route)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Outbound Packet successfully forwarded'"><xsl:text>Traceroute Status (Successfully Forwarded)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Overall length exceeded'"><xsl:text>Datagram Conv. Error (Length Exceeded)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Parameter Problem'"><xsl:text>Parameter Problem (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Photuris (reserved)'"><xsl:text>Photuris (Bad SPI)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Photuris (unknown security parameters index)'"><xsl:text>Photuris (Authentication Failed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Photuris (valid security parameters, but authentication failed)'"><xsl:text>Photuris (Decompression Failed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Photuris (valid security parameters, but decryption failed)'"><xsl:text>Photuris (Decryption Failed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Photuris'"><xsl:text>Photuris (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Pointer indicates the error'"><xsl:text>Parameter Problem (Pointer Indicates Error)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Port conversion out of range'"><xsl:text>Datagram Conv. Error (Port Out of Range)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Port unreachable'"><xsl:text>Dest. Unreachable (Port Unreachable)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Precedence cutoff in effect'"><xsl:text>Dest. Unreachable (Precedence Cutoff)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Protocol unreachable'"><xsl:text>Dest. Unreachable (Protocol Unreachable)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Redirect for host'"><xsl:text>Redirect (for Host)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Redirect for network'"><xsl:text>Redirect (for Network)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Redirect for type-of-service and host'"><xsl:text>Redirect (for ToS and Host)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Redirect for type-of-service and network'"><xsl:text>Redirect (for ToS and Network)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Redirect'"><xsl:text>Redirect (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Router advertisement (no code)'"><xsl:text>Router Advertisement (Normal)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Router advertisement'"><xsl:text>Router Advertisement (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Router selection (no code)'"><xsl:text>Router Selection (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Router selection'"><xsl:text>Router Selection (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Skip (ICMP)'"><xsl:text>SKIP (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Skip (reserved)'"><xsl:text>SKIP (Reserved)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Skip (unknown security parameters index)'"><xsl:text>SKIP (Unknown SPI)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Skip (valid security parameters, but authentication failed)'"><xsl:text>SKIP (Authentication Failed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Skip (valid security parameters, but decryption failed)'"><xsl:text>SKIP (Decryption Failed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Source host isolated'"><xsl:text>Dest. Unreachable (Source Isolated)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Source quench (no code)'"><xsl:text>Source Quench (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Source quench'"><xsl:text>Source Quench (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Source route failed'"><xsl:text>Dest. Unreachable (Source Route Failed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Time Exceeded'"><xsl:text>Time Exceeded (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Timestamp (no code)'"><xsl:text>Timestamp (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Timestamp Reply (no code)'"><xsl:text>Timestamp Reply (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Timestamp Reply'"><xsl:text>Timestamp Reply (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Timestamp'"><xsl:text>Timestamp (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Time to Live exceeded in Transit'"><xsl:text>Time Exceeded (TTL Exceeded)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Transport header length exceeded'"><xsl:text>Datagram Conv. Error (Transport Header Length Exceeded)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Transport protocol > 255'"><xsl:text>Datagram Conv. Error (Protocol > 255)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Unknown mandatory option present'"><xsl:text>Datagram Conv. Error (Unknown Mandatory Option)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Unknown mandatory transport option present'"><xsl:text>Datagram Conv. Error (Unknown Transport Option)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Unknown/unspecified error'"><xsl:text>Datagram Conv. Error (Unknown/Unspecified)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Unsupported transport protocol'"><xsl:text>Datagram Conv. Error (Unsupported Protocol)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = '3PC (Third Party Connect Protocol)'"><xsl:text>3PC</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'AH (Authentication Header for IPv6)'"><xsl:text>AH</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'A/N (Active Networks)'"><xsl:text>A/N</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Any private encryption scheme'"><xsl:text>Private Encryption Schemes</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ARIS (ARIS)'"><xsl:text>ARIS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'AX.25 (AX.25 Frames)'"><xsl:text>AX.25</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'BBN-RCC-MON (BBN RCC Monitoring)'"><xsl:text>BBN-RCC-MON</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'BNA (BNA)'"><xsl:text>BNA</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'BR-SAT-MON (Backroom SATNET Monitoring)'"><xsl:text>BR-SAT-MON</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'CFTP (CFTP)'"><xsl:text>CFTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'CHAOS (Chaos)'"><xsl:text>CHAOS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Compaq Peer (Compaq Peer Protocol)'"><xsl:text>Compaq Peer</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'CPHB (Computer Protocol Heart Beat)'"><xsl:text>CPHB</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'CPNX (Computer Protocol Network Executive)'"><xsl:text>CPNX</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'CRTP (Combat Radio Transport Protocol)'"><xsl:text>CRTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'CRUDP (Combat Radio User Datagram)'"><xsl:text>CRUDP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'DCN-MEAS (DCN Measurement Subsystems)'"><xsl:text>DCN-MEAS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'DDP (Datagram Delivery Protocol)'"><xsl:text>DDP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'DDX (D-II Data Exchange )'"><xsl:text>DDX</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'DGP (Dissimilar Gateway Protocol)'"><xsl:text>DGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'EGP (Exterior Gateway Protocol)'"><xsl:text>EGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'EIGRP (EIGRP)'"><xsl:text>EIGRP/IGRP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ENCAP (Encapsulation Header)'"><xsl:text>ENCAP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ESP (Encapsulation Security Payload for IPv4/IPv6)'"><xsl:text>ESP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ETHERIP (Ethernet-within-IP Encapsulation Protocol)'"><xsl:text>ETHERIP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'FC (Fibre Channel)'"><xsl:text>FC</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'GGP (Gateway-to-Gateway Protocol)'"><xsl:text>GGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'GMTP (GMTP)'"><xsl:text>GMTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'GRE (General Routing Encapsulation)'"><xsl:text>GRE</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'HMP (Host Monitoring Protocol)'"><xsl:text>HMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'HOPOPT (IPv6 Hop-by-Hop Option)'"><xsl:text>HOPOPT</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IATP (Interactive Agent Transfer Protocol)'"><xsl:text>IATP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ICMP (Internet Control Message Protocol)'"><xsl:text>ICMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IDPR-CMTP (IDPR Control Message Transport Protocol)'"><xsl:text>IDPR-CMTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IDPR (Inter-Domain Policy Routing Protocol)'"><xsl:text>IDPR</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IDRP (Inter-Domain Routing Protocol)'"><xsl:text>IDRP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IFMP (Ipsilon Flow Management Protocol)'"><xsl:text>IFMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IGMP (Internet Group Management Protocol)'"><xsl:text>IGMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IGP (Interior Gateway Protocol)'"><xsl:text>IGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IL (IL Transport Protocol)'"><xsl:text>IL</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'I-NLSP (Integrated Net Layer Security TUBA)'"><xsl:text>I-NLSP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPComp (IP Payload Compression Protocol)'"><xsl:text>IPComp</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPCV (Internet Packet Core Utility)'"><xsl:text>IPCV</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPIP (IP-within-IP Encapsulation Protocol)'"><xsl:text>IPIP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPX-in-IP (IPX in IP)'"><xsl:text>IPX-in-IP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPPC (Internet Pluribus Packet Core)'"><xsl:text>IPPC</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPv6--FRAG (Fragment Header for IPv6)'"><xsl:text>IPv6-FRAG</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPv6-ICMP (ICMP for IPv6)'"><xsl:text>IPv6-ICMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPv6-NoNxt (No Next Header for IPv6)'"><xsl:text>IPv6-NoNxt</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPv6-Opts (Destination Options for IPv6)'"><xsl:text>IPv6 Options</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPv6-Route (Routing Header for IPv6)'"><xsl:text>IPv6 Route</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPv6'"><xsl:text>IPv6 Encapsulation</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IRTP (Internet Reliable Transaction Protocol)'"><xsl:text>IRTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ISIS (ISIS over IPv4)'"><xsl:text>IS-IS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ISO-IP (ISO Internet Protocol)'"><xsl:text>ISO-IP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ISO-TP4 (ISO Transport Protocol Class 4)'"><xsl:text>ISO-TP4</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'KRYPTOLAN (Kryptolan)'"><xsl:text>Kryptolan</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'L2TP (Layer Two Tunneling Protocol)'"><xsl:text>L2TP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'LARP (Locus Address Resolution Protocol)'"><xsl:text>LARP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'LEAF-1 (Leaf-1)'"><xsl:text>Leaf-1</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'LEAF-2 (Leaf-2)'"><xsl:text>LEAF-2</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MERIT-NSP (MERIT Internodal Protocol)'"><xsl:text>MERIT-NSP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MFE-NSP (MFE Network Services Protocol)'"><xsl:text>MFE-NSP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MHRP (Mobile Host Routing Protocol)'"><xsl:text>MHRP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MICP (Mobile Internetworking Control Protocol)'"><xsl:text>MICP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MOBILE (IP Mobility)'"><xsl:text>MOBILE</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MTP (Multicast Transport Protocol)'"><xsl:text>MTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MUX (Multiplexing)'"><xsl:text>MUX</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'NARP (NBMA Address Resolution Protocol)'"><xsl:text>NARP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'NETBLT (Bulk Data Transfer Protocol)'"><xsl:text>NETBLT</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'NSFNET-IGP (NSFNET-IGP)'"><xsl:text>NSFNET-IGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'NVP-II (Network Voice Protocol)'"><xsl:text>NVP-II</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'OSPFIGP (OSPFIGP)'"><xsl:text>OSPFIGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PGM (PGM Reliable Transport Protocol)'"><xsl:text>PGM</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PIM (Protocol Independent Multicast)'"><xsl:text>PIM</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PIPE (Private IP Encapsulation within IP)'"><xsl:text>PIPE</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PNNI (PNNI over IP)'"><xsl:text>PNNI</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PRM (Packet Radio Measurement)'"><xsl:text>PRM</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PTP (Performance Transparency Protocol)'"><xsl:text>PTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PVP (Packet Video Protocol)'"><xsl:text>PVP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'QNX (QNX)'"><xsl:text>QNX</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'RDP (Reliable Data Protocol)'"><xsl:text>RDP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'RSVP (Reservation Protocol)'"><xsl:text>RSVP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'RVD (MIT Remote Virtual Disk Protocol)'"><xsl:text>RVD</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SAT-EXPAK (SATNET and Backroom EXPAK)'"><xsl:text>SAT-EXPAK</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SAT-MON (SATNET Monitoring)'"><xsl:text>SAT-MON</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SCC-SP (Semaphore Communication Sec. Protocol)'"><xsl:text>SCC-SP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SCPS (SCPS)'"><xsl:text>SCPS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SCTP (Stream Control Transmission Protocol)'"><xsl:text>SCTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SDRP (Source Demand Routing Protocol)'"><xsl:text>SDRP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SECURE-VMTP (SECURE-VMTP)'"><xsl:text>SECURE-VMTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SEP (Sequential Exchange Protocol)'"><xsl:text>SEP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SMP (Simple Message Protocol)'"><xsl:text>SMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SM (SM)'"><xsl:text>SM</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SNP (Sitara Networks Protocol)'"><xsl:text>SNP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Sprite-RPC (Sprite RPC Protocol)'"><xsl:text>Sprite-RPC</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SPS (Secure Packet Shield)'"><xsl:text>SPS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SRP (SpectraLink Radio Protocol)'"><xsl:text>SRP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'STP (Schedule Transfer Protocol)'"><xsl:text>STP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ST (Stream)'"><xsl:text>ST</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SUN-ND (SUN-ND PROTOCOL-Temporary)'"><xsl:text>SUN-ND</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SWIPE (IP with Encryption)'"><xsl:text>SWIPE</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TCF (TCF)'"><xsl:text>TCF</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TCP (Transmission Control Protocol)'"><xsl:text>TCP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TLSP (Transport Layer Security Protocol using Kryptonet key management)'"><xsl:text>TLSP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TP++ (TP++ Transport Protocol)'"><xsl:text>TP++</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TRUNK-1 (Trunk-1)'"><xsl:text>Trunk-1</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TRUNK-2 (Trunk-2)'"><xsl:text>Trunk-2</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TTP (TTP)'"><xsl:text>TTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'UDP (User Datagram Protocol)'"><xsl:text>UDP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'UTI (UTI)'"><xsl:text>UTI</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'VINES (VINES)'"><xsl:text>VINES</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'VISA (VISA Protocol)'"><xsl:text>VISA</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'VMTP (VMTP)'"><xsl:text>VMTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'VRRP (Virtual Router Redundancy Protocol)'"><xsl:text>VRRP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'WB-EXPAK (WIDEBAND EXPAK)'"><xsl:text>WB-EXPAK</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'WB-MON (WIDEBAND Monitoring)'"><xsl:text>WB-MON</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'WSN (Wang Span Network)'"><xsl:text>WSN</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'XNET (Cross Net Debugger)'"><xsl:text>XNET</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'XNS-IDP (XEROX NS IDP)'"><xsl:text>XNS-IDP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = '3270_mapper'"><xsl:text>IBM 3270 Portmapper</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'activity'"><xsl:text>Activity</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'alis'"><xsl:text>Alis</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'amd'"><xsl:text>Amd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bootparam'"><xsl:text>Bootparam</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bugtraqd'"><xsl:text>Bugtraqd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bwnfsd'"><xsl:text>Bwnfsd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'database_svc'"><xsl:text>Database_svc</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'debug_svc'"><xsl:text>Debug_svc</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'etherif'"><xsl:text>Etherif</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'etherstatd'"><xsl:text>Etherstatd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'event'"><xsl:text>Event</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'fypxfrd'"><xsl:text>Fypxfrd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'hostif'"><xsl:text>Hostif</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'hostmem'"><xsl:text>Hostmem</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'hostperf'"><xsl:text>Hostperf</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ioadmd'"><xsl:text>Ioadmd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'iproutes'"><xsl:text>Iproutes</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kerbd'"><xsl:text>Kerbd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'keyserv'"><xsl:text>Keyserv</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'layers'"><xsl:text>Layers</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'llockmgr'"><xsl:text>Llockmgr</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'logger'"><xsl:text>Logger</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'mountd'"><xsl:text>Mountd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netlicense'"><xsl:text>Netlicense</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nfs_acl'"><xsl:text>Nfs_acl</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nfs (RPC)'"><xsl:text>NFS (RPC)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nisd'"><xsl:text>Nisd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nispasswd'"><xsl:text>Nispasswd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nlockmgr'"><xsl:text>Nlockmgr</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nsed'"><xsl:text>Nsed</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nsemntd'"><xsl:text>Nsemntd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'pcnfsd'"><xsl:text>Pcnfsd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ping (RPC)'"><xsl:text>Ping (RPC)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'portmapper (RPC)'"><xsl:text>Pmap</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rexd'"><xsl:text>Rexd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rje_mapper'"><xsl:text>Rje_mapper</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rpcnfs'"><xsl:text>Rpcnfs</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rquotad'"><xsl:text>Rquotad</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rstatd'"><xsl:text>Rstatd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rusersd'"><xsl:text>Rusersd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sadmind'"><xsl:text>Sadmind</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sample'"><xsl:text>Sample</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sched'"><xsl:text>Sched</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'selection_svc'"><xsl:text>Selection_svc</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'showfhd'"><xsl:text>Showfhd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'snmp'"><xsl:text>SNMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'statmon'"><xsl:text>Status (1)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'status'"><xsl:text>Status (2)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sunisamd'"><xsl:text>Sunisamd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sunlink_mapper'"><xsl:text>SunLink Mapper</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sync'"><xsl:text>Sync</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tfsd'"><xsl:text>Tfsd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'traffic'"><xsl:text>Traffic</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ufsd'"><xsl:text>Ufsd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'walld'"><xsl:text>Walld</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'x25.inr'"><xsl:text>X25.inr</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'x25'"><xsl:text>X25</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ypbind'"><xsl:text>Ypbind</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'yppasswdd'"><xsl:text>Yppasswdd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ypserv'"><xsl:text>Ypserv</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ypupdated'"><xsl:text>Ypupdated</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ypxfrd'"><xsl:text>Ypxfrd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'aol (America-Online)'"><xsl:text>AOL</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bgmp (BGMP)'"><xsl:text>BGMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bgp (Border Gateway Protocol)'"><xsl:text>BGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'BitKeeper bkd inspection'"><xsl:text>BitKeeper</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bootpc (Bootstrap Protocol Client) (TCP)'"><xsl:text>BOOTPC (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bootps (Bootstrap Protocol Server) (TCP)'"><xsl:text>BOOTPS (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ccso inspection (TCP)'"><xsl:text>CCSO (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'chargen (Character Generator) (TCP)'"><xsl:text>CHARGEN (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'cmip-agent (CMIP Agent) (TCP)'"><xsl:text>CMIP-Agent (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'cmip-man (CMIP Manager) (TCP)'"><xsl:text>CMIP-Manager (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'compaq Web-Based Management'"><xsl:text>Compaq WBEM</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'creativepartnr (CreativePartnr)'"><xsl:text>CreativePartnr</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'creativeserver (CreativeServer)'"><xsl:text>CreativeServer</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'cvs inspection'"><xsl:text>CVS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'daytime (TCP)'"><xsl:text>Daytime (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'discard (TCP)'"><xsl:text>Discard Protocol (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'dns (TCP)'"><xsl:text>DNS (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'echo (TCP)'"><xsl:text>Echo (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'exec (remote process execution)'"><xsl:text>Exec</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'finger (Finger)'"><xsl:text>Finger</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ftp-data (File Transfer [Default Data])'"><xsl:text>FTP (Data)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ftp (File Transfer [Control])'"><xsl:text>FTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ftps-data (ftp protocol, data, over TLS/SSL)'"><xsl:text>FTPS (Data)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ftps (ftp protocol, control, over TLS/SSL)'"><xsl:text>FTPS (Control)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'General Inter-ORB Protocol'"><xsl:text>Oracle GIOP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'unspecified service inspection (TCP)'"><xsl:text>Any TCP Service</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'gopher (Gopher)'"><xsl:text>Gopher</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'https (http protocol over TLS/SSL)'"><xsl:text>HTTPS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'http with URL logging (World Wide Web HTTP)'"><xsl:text>HTTP (with URL Logging)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'http (World Wide Web HTTP)'"><xsl:text>HTTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ident'"><xsl:text>Ident</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'imap3 (Interactive Mail Access Protocol v3)'"><xsl:text>IMAP3</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'imap (Internet Message Access Protocol)'"><xsl:text>IMAP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'imaps (imap4 protocol over TLS/SSL)'"><xsl:text>IMAPS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ingres-net (INGRES-NET Service)'"><xsl:text>INGRES-NET</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ipp (Internet Printing Protocol) (TCP)'"><xsl:text>IPP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'irc (Internet Relay Chat Protocol)'"><xsl:text>IRC</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'irc-serv (IRC-SERV)'"><xsl:text>IRC-SERV</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ircs (irc protocol over TLS/SSL)'"><xsl:text>IRCS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'isakmp (isakmp)'"><xsl:text>ISAKMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kerberos-adm (kerberos administration) (TCP)'"><xsl:text>Kerberos Administration (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kerberos (Kerberos)'"><xsl:text>Kerberos</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kpasswd (kpasswd)'"><xsl:text>Kpasswd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kshell (krcmd)'"><xsl:text>Kshell</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ldap (Lightweight Directory Access Protocol)'"><xsl:text>LDAP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ldaps (ldap protocol over TLS/SSL)'"><xsl:text>LDAPS (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'login (remote login a la telnet)'"><xsl:text>Rlogin</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'lotusnotes (Lotus Notes)'"><xsl:text>Lotus Notes</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'microsoft-ds'"><xsl:text>Microsoft-DS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Microsoft Remote Desktop'"><xsl:text>Remote Desktop</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Microsoft RPC/End-point Mapper over TCP'"><xsl:text>MSRPC (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'mosaicsyssvc1 (mosaicsyssvc1)'"><xsl:text>mosaicsyssvc1</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MSSQL inspection (TCP)'"><xsl:text>MSSQL (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ms-streaming (ms-streaming)'"><xsl:text>MS-Streaming (ms-streaming)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'mysql inspection (TCP)'"><xsl:text>MySQL</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netbios-ns (NETBIOS Name Service) (TCP)'"><xsl:text>NetBIOS-NS (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netbios-ssn (NETBIOS Session Service)'"><xsl:text>NetBIOS-SSN</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netnews (readnews)'"><xsl:text>Netnews</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netwall (for emergency broadcasts)'"><xsl:text>Netwall</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nmap (TCP)'"><xsl:text>NMAP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nntp (Network News Transfer Protocol)'"><xsl:text>NNTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nntps (nntp protocol over TLS/SSL (was snntp))'"><xsl:text>NNTPS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ntp (Network Time Protocol) (TCP)'"><xsl:text>NTP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'oracle TNS'"><xsl:text>Oracle TNS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'orasrv (oracle)'"><xsl:text>Orasrv</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'photuris (proturis)'"><xsl:text>Photuris (ICMP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'pop2 (Post Office Protocol - Version 2)'"><xsl:text>POP2</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'pop3 (Post Office Protocol - Version 3)'"><xsl:text>POP3</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'pop3s (pop3 protocol over TLS/SSL (was spop3))'"><xsl:text>POP3S</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'pptp (TCP)'"><xsl:text>PPTP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'printer (spooler) (TCP)'"><xsl:text>Printer Spooler (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Q.931'"><xsl:text>H.323 (Call Signaling)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'qotd (Quote of the Day)'"><xsl:text>QOTD</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netbios-epmap inspection (NETBIOS DCE-RPC endpoint mapper) (TCP)'"><xsl:text>MSRPC Endpoint Mapper (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rsvp_tunnel (RSVP Tunnel)'"><xsl:text>RSVP Tunnel</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rsync (rsync)'"><xsl:text>Rsync</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'set (Secure Electronic Transaction) (TCP)'"><xsl:text>SET (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-blacklist'"><xsl:text>SG Blacklisting</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-datasync'"><xsl:text>SG Data Sync</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-dynamic-control'"><xsl:text>SG Dynamic Control</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-Gui-to-Log'"><xsl:text>SG Data Browsing</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-Gui-to-Mgt'"><xsl:text>SG Control</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-init-ticket'"><xsl:text>SG Log Initial Contact</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-init'"><xsl:text>SG Initial Contact</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-ips-event'"><xsl:text>SG Event Transfer</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-log-backup'"><xsl:text>SG Monitoring Backup</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-log'"><xsl:text>SG Log</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-mgmt-analyzer'"><xsl:text>SG Commands (Analyzer)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-mgmt-sensor'"><xsl:text>SG Commands (Sensor)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-mgmt'"><xsl:text>SG Commands</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-MonClient-to-MonServer'"><xsl:text>SG Control (Monitoring Client)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-monitor'"><xsl:text>SG Monitoring</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-MonServer-to-Log'"><xsl:text>SG Data Browsing (Monitoring Server)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-remote-upgrade'"><xsl:text>SG Remote Upgrade</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-statesync-uni'"><xsl:text>SG State Sync (Unicast)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-vpnclient-cfg'"><xsl:text>SG VPN Client Configuration</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'shell (cmd)'"><xsl:text>Shell (cmd)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sip inspection (TCP)'"><xsl:text>SIP Control (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'smtp (Simple Mail Transfer)'"><xsl:text>SMTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'snagas (SNA Gateway Access Server)'"><xsl:text>SNAGAS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'snmp (TCP)'"><xsl:text>SNMP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'snmptrap (SNMPTRAP) (TCP)'"><xsl:text>SNMP Trap (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sshell (SSLshell)'"><xsl:text>SShell</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ssh (SSH Remote Login Protocol)'"><xsl:text>SSH</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sunrpc (SUN Remote Procedure Call) (TCP)'"><xsl:text>Sun RPC (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'svn inspection (TCP)'"><xsl:text>SVN</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'systat (Active Users)'"><xsl:text>Systat (Active Users)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tacacs-ds (TACACS-Database Service)'"><xsl:text>TACACS-DS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tacacs (Login Host Protocol) (TCP)'"><xsl:text>TACACS (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'talk (like tenex link, but across)'"><xsl:text>Talk</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tcpmux (TCP Port Service Multiplexer)'"><xsl:text>TCPMux</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'telnets (telnet protocol over TLS/SSL)'"><xsl:text>Telnets</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'telnet (Telnet)'"><xsl:text>Telnet</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'timed (timeserver)'"><xsl:text>Timed</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'time (TCP)'"><xsl:text>Time (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tlisrv (oracle)'"><xsl:text>TLISRV</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'uucp-rlogin (uucp-rlogin)'"><xsl:text>UUCP-rlogin</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'uucp (uucpd)'"><xsl:text>UUCP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'whoami (whoami)'"><xsl:text>Whoami</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'wins server replication'"><xsl:text>WINS Replication</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'x11 (X Window System)'"><xsl:text>X11</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'xdmcp (X Display Manager Control Protocol)'"><xsl:text>XDMCP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'biff (used by mail system to notify users)'"><xsl:text>Biff</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bootpc (Bootstrap Protocol Client) (UDP)'"><xsl:text>BOOTPC (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bootps (Bootstrap Protocol Server) (UDP)'"><xsl:text>BOOTPS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ccso inspection (UDP)'"><xsl:text>CCSO (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'chargen (Character Generator) (UDP)'"><xsl:text>CHARGEN (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'cmip-man (CMIP/TCP Manager) (UDP)'"><xsl:text>CMIP-Manager (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'daytime (UDP)'"><xsl:text>Daytime (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'discard (UDP)'"><xsl:text>Discard Protocol (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'dns (UDP)'"><xsl:text>DNS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'echo (UDP)'"><xsl:text>Echo (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'unspecified service inspection (UDP)'"><xsl:text>Any UDP Service</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ipp (Internet Printing Protocol) (UDP)'"><xsl:text>IPP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'isakmp'"><xsl:text>ISAKMP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'isakmp (UDP)'"><xsl:text>ISAKMP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kerberos-adm (kerberos administration) (UDP)'"><xsl:text>Kerberos Administration (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kerberos-iv (kerberos version iv)'"><xsl:text>Kerberos IV</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ldap (Lightweight Directory Access Protocol) (UDP)'"><xsl:text>LDAP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ldaps (ldap protocol over TLS/SSL) (UDP)'"><xsl:text>LDAPS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MSSQL inspection (UDP)'"><xsl:text>MSSQL (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netbios-dgm (NETBIOS Datagram Service)'"><xsl:text>NetBIOS Datagram</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netbios-ns (NETBIOS Name Service) (UDP)'"><xsl:text>NetBIOS-NS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nfs (Network File System - Sun Microsystems)'"><xsl:text>NFS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nmap (UDP)'"><xsl:text>NMAP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ntp (Network Time Protocol) (UDP)'"><xsl:text>NTP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ontime (Ontime)'"><xsl:text>Ontime Calendar</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'printer (spooler) (UDP)'"><xsl:text>Printer Spooler (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'radius-acct-old'"><xsl:text>RADIUS Accounting (Old)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'radius-acct'"><xsl:text>RADIUS (Accounting)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'radius-old'"><xsl:text>RADIUS (Old)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'radius'"><xsl:text>RADIUS (Authentication)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rip (Routing Information Protocol)'"><xsl:text>RIP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netbios-epmap inspection (NETBIOS DCE-RPC endpoint mapper) (UDP)'"><xsl:text>MSRPC (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'set (Secure Electronic Transaction) (UDP)'"><xsl:text>SET (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-IPSec-UDP encapsulation'"><xsl:text>SG UDP Encapsulation</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-monitor-agent'"><xsl:text>SG Server Pool Monitoring</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-statesync-multi'"><xsl:text>SG State Sync (Multicast)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sip inspection (UDP)'"><xsl:text>SIP Control (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-monitor-agent'"><xsl:text>SG Server Pool Monitoring</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-statesync-multi'"><xsl:text>SG State Sync (Multicast)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'smip-agent (CMIP/TCP Agent) (UDP)'"><xsl:text>CMIP Agent (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'snmptrap (UDP)'"><xsl:text>SNMP Trap (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'snmp (UDP)'"><xsl:text>SNMP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Source Port isakmp'"><xsl:text>Source Port ISAKMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sunrpc (SUN Remote Procedure Call) (UDP)'"><xsl:text>Sun RPC (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Syslog'"><xsl:text>Syslog (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tacacs (Login Host Protocol) (UDP)'"><xsl:text>TACACS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tftp inspection'"><xsl:text>TFTP Control</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tftp'"><xsl:text>TFTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'time (UDP)'"><xsl:text>Time (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'vocaltec-phone (Vocaltec Internet Phone Scott Petrack)'"><xsl:text>VocalTec-phone</xsl:text></xsl:when>
			<xsl:when test='$oldservicename = "who (maintains data bases showing who&apos;s)"'><xsl:text>Who</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'utime (unixtime)'"><xsl:text>Utime</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sprayd'"><xsl:text>Sprayd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'skip'"><xsl:text>Skip</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nfs'"><xsl:text>nfs (RPC)</xsl:text></xsl:when>
			
			<!-- manage all deleted system services : to be changed with merge service -->
			<xsl:when test="$oldservicename =  'UDP inspection'"><xsl:text>UDP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'TCP inspection'"><xsl:text>TCP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'ICMP inspection'"><xsl:text>ICMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'dns inspection (TCP)'"><xsl:text>DNS (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'finger inspection (Finger)'"><xsl:text>Finger</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'ftp inspection'"><xsl:text>FTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'https inspection (http protocol over TLS/SSL)'"><xsl:text>HTTPS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'http inspection'"><xsl:text>HTTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'ident inspection'"><xsl:text>Ident</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'imap inspection (Internet Message Access Protocol) (TCP)'"><xsl:text>IMAP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'ldap inspection (Lightweight Directory Access Protocol) (TCP)'"><xsl:text>LDAP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'netbios-epmap (NETBIOS DCE-RPC endpoint mapper) (TCP)'"><xsl:text>MSRPC (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'netbios-ssn inspection (NETBIOS Session Service)'"><xsl:text>NetBIOS-SSN</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'nntp inspection (Network News Transfer Protocol)'"><xsl:text>NNTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'pop3 inspection (Post Office Protocol - Version 3) (TCP)'"><xsl:text>POP3</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'pptp inspection'"><xsl:text>PPTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'printer inspection (spooler)'"><xsl:text>Printer Spooler (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'microsoft-ds inspection (TCP)'"><xsl:text>MSRPC (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'smtp inspection'"><xsl:text>SMTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'snmp inspection (TCP)'"><xsl:text>SNMP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'ssh inspection'"><xsl:text>SSH</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'telnet inspection (Telnet)'"><xsl:text>Telnet</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'wins server replication inspection'"><xsl:text>WINS Replication</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'x11 inspection (X Window System) (TCP)'"><xsl:text>X11</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'bootp inspection'"><xsl:text>BOOTPS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'dns inspection (UDP)'"><xsl:text>DNS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'ldap inspection (Lightweight Directory Access Protocol) (UDP)'"><xsl:text>LDAP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'netbios-epmap (NETBIOS DCE-RPC endpoint mapper) (UDP)'"><xsl:text>MSRPC (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'netbios-dgm inspection (NETBIOS Datagram Service)'"><xsl:text>NetBIOS Datagram</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'snmp inspection (UDP)'"><xsl:text>SNMP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'tftp (Trivial File Transfer)'"><xsl:text>TFTP Control</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'SG Log to Management Server'"><xsl:text>SG Log to Management</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'Rlogin inspection (TCP)'"><xsl:text>Rlogin</xsl:text></xsl:when>
      		<xsl:otherwise><xsl:value-of select="$oldservicename"/></xsl:otherwise>
		</xsl:choose>
    </xsl:template>
	
	<!-- copy everything else -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	
</xsl:stylesheet>
