<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:output
		doctype-system="generic_import_export_v2.0.dtd"
		indent="yes"/>

	<!-- remove user_profile xml definition -->
	<xsl:template match="user_profile">
	</xsl:template>
	
	<!-- remove protocolagent xml definition -->
	<xsl:template match="protocolagent">
	</xsl:template>
	<!-- remove pattern_protocolagent xml definition -->
	<xsl:template match="pattern_protocolagent">
	</xsl:template>
	<!-- remove protocolagent_group xml definition -->
	<xsl:template match="protocolagent_group">
	</xsl:template>
	
	<!-- remove pa_link xml definition -->
	<xsl:template match="pa_link">
	</xsl:template>
	
	
	<!-- update module into protocol_agent xml definition -->
	<xsl:template match="module">
		<xsl:element name="protocol_agent" >
			<!-- set basic attributes -->
			<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
			<xsl:attribute name="comment"><xsl:value-of select="@comment"/></xsl:attribute>
			<xsl:attribute name="version"><xsl:value-of select="@version"/></xsl:attribute>
			<xsl:attribute name="key"><xsl:value-of select="@key"/></xsl:attribute>
			<xsl:attribute name="module_type"><xsl:value-of select="@type"/></xsl:attribute>
			<xsl:attribute name="carrier"><xsl:value-of select="@carrier"/></xsl:attribute>
			
			<!-- set class_id depending on name -->
			<xsl:choose>
				<!-- SIP -->
				<xsl:when test="@key='51200'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>107</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- SSH -->
				<xsl:when test="@key='9200'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>2</xsl:text></xsl:attribute>
				</xsl:when>	
				<!-- SMTP -->
				<xsl:when test="@key='10201'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>12</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- FTP -->
				<xsl:when test="@key='8200'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>1</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- TFTP -->
				<xsl:when test="@key='40200004'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>102</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- HTTP -->
				<xsl:when test="@key='7200'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>8</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- TCP Proxy -->
				<xsl:when test="@key='115'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>105</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- NETBIOS (UDP) -->
				<xsl:when test="@key = '40200010'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>5</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- MSRPC (TCP) -->
				<xsl:when test="@key = '60200026'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>103</xsl:text></xsl:attribute>
				</xsl:when>
				
				<!-- new fw protocol agents moved to combined -->
				<!-- H323 -->
				<xsl:when test="@key='102'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>11</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- Oracle -->
				<xsl:when test="@key='108'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>10</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- Shell -->
				<xsl:when test="@key='110'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>7</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- TCP Proxy -->
				<xsl:when test="@key='115'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>105</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- Services in firewall -->
				<xsl:when test="@key='109'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>9</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- Sunrpc (TCP) -->
				<xsl:when test="@key='60200004'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>3</xsl:text></xsl:attribute>
				</xsl:when>
				<!-- Sunrpc (UDP) -->				
				<xsl:when test="@key='40200002'">
					<xsl:attribute name='class_id'><xsl:text>combined</xsl:text></xsl:attribute>
					<xsl:attribute name='registration_number'><xsl:text>4</xsl:text></xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name='class_id'><xsl:text>inspection</xsl:text></xsl:attribute>
				</xsl:otherwise>	
			</xsl:choose>
			

			<!-- add parameters list + parameter values -->
			<xsl:choose>
				<!-- SIP -->
				<xsl:when test="@key='51200'">
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>enforce_client</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>Yes</xsl:attribute>
						<xsl:attribute name='explanation'>Enforce client side media stream address</xsl:attribute>
						<xsl:attribute name='type'>string</xsl:attribute>
						<xsl:attribute name='description'>Enforce client side media</xsl:attribute>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>no</xsl:attribute>
							<xsl:attribute name='description'>No</xsl:attribute>
						</xsl:element>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>yes</xsl:attribute>
							<xsl:attribute name='description'>Yes</xsl:attribute>
						</xsl:element>
					</xsl:element>

					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>enforce_server</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>Yes</xsl:attribute>
						<xsl:attribute name='explanation'>Enforce server side media stream address</xsl:attribute>
						<xsl:attribute name='type'>string</xsl:attribute>
						<xsl:attribute name='description'>Enforce server side media</xsl:attribute>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>no</xsl:attribute>
							<xsl:attribute name='description'>No</xsl:attribute>
						</xsl:element>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>yes</xsl:attribute>
							<xsl:attribute name='description'>Yes</xsl:attribute>
						</xsl:element>
					</xsl:element>

					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>max_num_of_calls</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>0</xsl:attribute>
						<xsl:attribute name='explanation'>Maximum number of calls allowed by the access rule. Value 0 means no limit.</xsl:attribute>
						<xsl:attribute name='type'>integer</xsl:attribute>
						<xsl:attribute name='max'>999999999</xsl:attribute>
						<xsl:attribute name='description'>Maximum number of calls</xsl:attribute>
						<xsl:attribute name='min'>0</xsl:attribute>
					</xsl:element>
					
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>allow_related_connections</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>true</xsl:attribute>
						<xsl:attribute name='explanation'>Allows related connections</xsl:attribute>
						<xsl:attribute name='type'>boolean</xsl:attribute>
						<xsl:attribute name='description'>Allow related connections</xsl:attribute>
					</xsl:element>	

					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>Yes</xsl:attribute>
						<xsl:attribute name='param_description'>Enforce client side media</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>Yes</xsl:attribute>
						<xsl:attribute name='param_description'>Enforce server side media</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>0</xsl:attribute>
						<xsl:attribute name='param_description'>Maximum number of calls</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>true</xsl:attribute>
						<xsl:attribute name='param_description'>Allow related connections</xsl:attribute>
					</xsl:element>

				</xsl:when>		
				<!-- SSH case -->
				<xsl:when test="@key='9200'">
					<xsl:element name="pa_parameter">
						<xsl:attribute name='name'>clndata_sid</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>0</xsl:attribute>
						<xsl:attribute name='explanation'>Limits how much data the client can send to the server before the server sends its own identification string</xsl:attribute>
						<xsl:attribute name='type'>integer</xsl:attribute>
						<xsl:attribute name='max'>2147483647</xsl:attribute>
						<xsl:attribute name='description'>Bytes allowed from client before Server ID</xsl:attribute>
						<xsl:attribute name='min'>0</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>srvdata_cid</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>0</xsl:attribute>
						<xsl:attribute name='explanation'>Limits how much data the server can send to client before the client sends its own identification string</xsl:attribute>
						<xsl:attribute name='type'>integer</xsl:attribute>
						<xsl:attribute name='max'>2147483647</xsl:attribute>
						<xsl:attribute name='description'>Bytes allowed from server before Client ID</xsl:attribute>
						<xsl:attribute name='min'>0</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>srvdata_sid</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>0</xsl:attribute>
						<xsl:attribute name='explanation'>Limits how much data the server can send to the client before the server sends its own identification string</xsl:attribute>
						<xsl:attribute name='type'>integer</xsl:attribute>
						<xsl:attribute name='max'>2147483647</xsl:attribute>
						<xsl:attribute name='description'>Bytes allowed from server before Server ID</xsl:attribute>
						<xsl:attribute name='min'>0</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>protocol_validation</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>true</xsl:attribute>
						<xsl:attribute name='explanation'>Make protocol validation</xsl:attribute>
						<xsl:attribute name='type'>boolean</xsl:attribute>
						<xsl:attribute name='description'>Make protocol validation</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>0</xsl:attribute>
						<xsl:attribute name='param_description'>Bytes allowed from client before Server ID</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>0</xsl:attribute>
						<xsl:attribute name='param_description'>Bytes allowed from server before Client ID</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>0</xsl:attribute>
						<xsl:attribute name='param_description'>Bytes allowed from server before Server ID</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>true</xsl:attribute>
						<xsl:attribute name='param_description'>Make protocol validation</xsl:attribute>
					</xsl:element>
				</xsl:when>	
				
				<!-- SMTP case -->
				<xsl:when test="@key='10201'">
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>redir_cis</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='explanation'>Redirects connections via an external Content Inspecting Server which acts as a proxy. SMTP client and CIS have to be in different networks to ensure that they communicate always through the firewall</xsl:attribute>
						<xsl:attribute name='type'>cis</xsl:attribute>
						<xsl:attribute name='description'>Redirect connections to CIS</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='cisserver_name'>NONE</xsl:attribute>
						<xsl:attribute name='param_description'>Redirect connections to CIS</xsl:attribute>
					</xsl:element>
				</xsl:when>
				
				<!-- FTP case -->
				<xsl:when test="@key='8200'">
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>act</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>Yes</xsl:attribute>
						<xsl:attribute name='explanation'>Allows active mode FTP connections where the server will open the data connection to the client</xsl:attribute>
						<xsl:attribute name='type'>string</xsl:attribute>
						<xsl:attribute name='description'>Allow active mode</xsl:attribute>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>no</xsl:attribute>
							<xsl:attribute name='description'>No</xsl:attribute>
						</xsl:element>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>yes</xsl:attribute>
							<xsl:attribute name='description'>Yes</xsl:attribute>
						</xsl:element>
					</xsl:element>

					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>pasv</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>Yes</xsl:attribute>
						<xsl:attribute name='explanation'>Allows passive mode FTP connections where the client will open the data connection to the server</xsl:attribute>
						<xsl:attribute name='type'>string</xsl:attribute>
						<xsl:attribute name='description'>Allow passive mode</xsl:attribute>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>no</xsl:attribute>
							<xsl:attribute name='description'>No</xsl:attribute>
						</xsl:element>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>yes</xsl:attribute>
							<xsl:attribute name='description'>Yes</xsl:attribute>
						</xsl:element>
					</xsl:element>

					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>inspectmode</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>Loose</xsl:attribute>
						<xsl:attribute name='explanation'>Indicates which FTP commands are allowed in control connection</xsl:attribute>
						<xsl:attribute name='type'>string</xsl:attribute>
						<xsl:attribute name='description'>Control data inspection mode</xsl:attribute>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>loose</xsl:attribute>
							<xsl:attribute name='description'>Loose</xsl:attribute>
						</xsl:element>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>strict</xsl:attribute>
							<xsl:attribute name='description'>Strict</xsl:attribute>
						</xsl:element>
					</xsl:element>
					
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>ftp_srvdatasport_high</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>0</xsl:attribute>
						<xsl:attribute name='explanation'>Limits the range of allowed source ports of data connection on the server side, if the FTP server does not follow standard port numbering. If the server uses standard port, both the lower and upper bound of the port range have to be 0</xsl:attribute>
						<xsl:attribute name='type'>integer</xsl:attribute>
						<xsl:attribute name='max'>65535</xsl:attribute>
						<xsl:attribute name='description'>Highest allowed source port for Active data connection</xsl:attribute>
						<xsl:attribute name='min'>0</xsl:attribute>
					</xsl:element>

					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>ftp_srvdatasport_low</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>0</xsl:attribute>
						<xsl:attribute name='explanation'>Limits the range of allowed source ports of data connection on the server, if the FTP server does not follow standard port numbering. Value 0 means that the server always uses the port number immediately preceding the destination port</xsl:attribute>
						<xsl:attribute name='type'>integer</xsl:attribute>
						<xsl:attribute name='max'>65535</xsl:attribute>
						<xsl:attribute name='description'>Lowest allowed source port for Active data connection</xsl:attribute>
						<xsl:attribute name='min'>0</xsl:attribute>
					</xsl:element>
					
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>redir_cis</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='explanation'>Redirects connections via an external Content Inspection Server which acts as FTP proxy. FTP client and CIS have to be in different networks to ensure they communicate always through the firewall</xsl:attribute>
						<xsl:attribute name='type'>cis</xsl:attribute>
						<xsl:attribute name='description'>Redirect connections to CIS</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>allow_related_connections</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>true</xsl:attribute>
						<xsl:attribute name='explanation'>Allows related connections</xsl:attribute>
						<xsl:attribute name='type'>boolean</xsl:attribute>
						<xsl:attribute name='description'>Allow related connections</xsl:attribute>
					</xsl:element>	
					
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>Yes</xsl:attribute>
						<xsl:attribute name='param_description'>Allow active mode</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>Yes</xsl:attribute>
						<xsl:attribute name='param_description'>Allow passive mode</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>Loose</xsl:attribute>
						<xsl:attribute name='param_description'>Control data inspection mode</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>0</xsl:attribute>
						<xsl:attribute name='param_description'>Highest allowed source port for Active data connection</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>0</xsl:attribute>
						<xsl:attribute name='param_description'>Lowest allowed source port for Active data connection</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='cisserver_name'>NONE</xsl:attribute>
						<xsl:attribute name='param_description'>Redirect connections to CIS</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>true</xsl:attribute>
						<xsl:attribute name='param_description'>Allow related connections</xsl:attribute>
					</xsl:element>
				</xsl:when>	

				<!-- TFTP case -->
				<xsl:when test="@key='40200004'">
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>tftp_allow_read</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>Yes</xsl:attribute>
						<xsl:attribute name='explanation'>Allows reading files</xsl:attribute>
						<xsl:attribute name='type'>string</xsl:attribute>
						<xsl:attribute name='description'>Allow read</xsl:attribute>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>no</xsl:attribute>
							<xsl:attribute name='description'>No</xsl:attribute>
						</xsl:element>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>yes</xsl:attribute>
							<xsl:attribute name='description'>Yes</xsl:attribute>
						</xsl:element>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>tftp_allow_write</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>Yes</xsl:attribute>
						<xsl:attribute name='explanation'>Allows writing files</xsl:attribute>
						<xsl:attribute name='type'>string</xsl:attribute>
						<xsl:attribute name='description'>Allow write</xsl:attribute>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>no</xsl:attribute>
							<xsl:attribute name='description'>No</xsl:attribute>
						</xsl:element>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>yes</xsl:attribute>
							<xsl:attribute name='description'>Yes</xsl:attribute>
						</xsl:element>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>tftp_log_requests</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>No</xsl:attribute>
						<xsl:attribute name='explanation'>Controls whether or not to log names and paths of transferred files</xsl:attribute>
						<xsl:attribute name='type'>string</xsl:attribute>
						<xsl:attribute name='description'>Log filenames and paths</xsl:attribute>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>no</xsl:attribute>
							<xsl:attribute name='description'>No</xsl:attribute>
						</xsl:element>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>yes</xsl:attribute>
							<xsl:attribute name='description'>Yes</xsl:attribute>
						</xsl:element>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>allow_related_connections</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>true</xsl:attribute>
						<xsl:attribute name='explanation'>Allows related connections</xsl:attribute>
						<xsl:attribute name='type'>boolean</xsl:attribute>
						<xsl:attribute name='description'>Allow related connections</xsl:attribute>
					</xsl:element>


					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>Yes</xsl:attribute>
						<xsl:attribute name='param_description'>Allow read</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>Yes</xsl:attribute>
						<xsl:attribute name='param_description'>Allow write</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>No</xsl:attribute>
						<xsl:attribute name='param_description'>Log filenames and paths</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>true</xsl:attribute>
						<xsl:attribute name='param_description'>Allow related connections</xsl:attribute>
					</xsl:element>

				</xsl:when>	

				<!-- HTTP case -->
				<xsl:when test="@key='7200'">			
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>redir_cis</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='explanation'>Redirects connections via an external Content Inspection Server which acts as HTTP proxy</xsl:attribute>
						<xsl:attribute name='type'>cis</xsl:attribute>
						<xsl:attribute name='description'>Redirect connections to CIS</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>http_url_logging</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>Yes</xsl:attribute>
						<xsl:attribute name='explanation'>Controls whether or not to log requested URLs (regardless of redirection to a CIS)</xsl:attribute>
						<xsl:attribute name='type'>string</xsl:attribute>
						<xsl:attribute name='description'>Logging of accessed URLs</xsl:attribute>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>no</xsl:attribute>
							<xsl:attribute name='description'>No</xsl:attribute>
						</xsl:element>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>yes</xsl:attribute>
							<xsl:attribute name='description'>Yes</xsl:attribute>
						</xsl:element>
					</xsl:element>

					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>Yes</xsl:attribute>
						<xsl:attribute name='param_description'>Logging of accessed URLs</xsl:attribute>
					</xsl:element>

					<xsl:element name='pa_value'>
						<xsl:attribute name='cisserver_name'>NONE</xsl:attribute>
						<xsl:attribute name='param_description'>Redirect connections to CIS</xsl:attribute>
					</xsl:element>

				</xsl:when>	

				<!-- TCP case -->
				<xsl:when test="@key='115'">
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>Abort</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>0</xsl:attribute>
						<xsl:attribute name='explanation'>A partially closed TCP connection is aborted with a TCP Reset segment after the specified amount of seconds. Value 0 disables the abort feature</xsl:attribute>
						<xsl:attribute name='type'>integer</xsl:attribute>
						<xsl:attribute name='max'>999999999</xsl:attribute>
						<xsl:attribute name='description'>Abort on close</xsl:attribute>
						<xsl:attribute name='min'>0</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>Timeout</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>1500</xsl:attribute>
						<xsl:attribute name='explanation'>A TCP connection that has been idle for the specified number of seconds is closed by the firewall. Value 0 disables the feature. The value should be smaller than the timeout value specified for the connection in connection tracking</xsl:attribute>
						<xsl:attribute name='type'>integer</xsl:attribute>
						<xsl:attribute name='max'>999999999</xsl:attribute>
						<xsl:attribute name='description'>Idle timeout</xsl:attribute>
						<xsl:attribute name= 'min'>0</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>use_proxy</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>false</xsl:attribute>
						<xsl:attribute name='explanation'>Use proxy</xsl:attribute>
						<xsl:attribute name='type'>boolean</xsl:attribute>
						<xsl:attribute name='description'>Use proxy</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>0</xsl:attribute>
						<xsl:attribute name='param_description'>Abort on close</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>1500</xsl:attribute>
						<xsl:attribute name='param_description'>Idle timeout</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>false</xsl:attribute>
						<xsl:attribute name='param_description'>Use proxy</xsl:attribute>
					</xsl:element>
				</xsl:when>

				<!-- NETBIOS case -->
				<xsl:when test="@key='40200010'">
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>make_corresponding_nat</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>true</xsl:attribute>
						<xsl:attribute name='explanation'>Make corresponding NAT modifications to payload</xsl:attribute>
						<xsl:attribute name='type'>boolean</xsl:attribute>
						<xsl:attribute name='description'>Make corresponding NAT modifications to payload</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>true</xsl:attribute>
						<xsl:attribute name='param_description'>Make corresponding NAT modifications to payload</xsl:attribute>
					</xsl:element>

				</xsl:when>
				
				<!-- MSRPC case -->
				<xsl:when test="@key='60200026'">
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>msrpcepm_allow_exchange_admin</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>Yes</xsl:attribute>
						<xsl:attribute name='explanation'>This is required for remote administration use of Exchange. It includes Exchange System Attendant Service</xsl:attribute>
						<xsl:attribute name='type'>string</xsl:attribute>
						<xsl:attribute name='description'>Allow MS Exchange Remote administration service</xsl:attribute>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>no</xsl:attribute>
							<xsl:attribute name='description'>No</xsl:attribute>
						</xsl:element>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>yes</xsl:attribute>
							<xsl:attribute name='description'>Yes</xsl:attribute>
						</xsl:element>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>msrpcepm_allow_exchange_user</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>Yes</xsl:attribute>
						<xsl:attribute name='explanation'>This is required for normal use of MS Outlook. It includes allowing Exchange Database Service, Directory Service, Information Store Service, MTA Service and Store Service</xsl:attribute>
						<xsl:attribute name='type'>string</xsl:attribute>
						<xsl:attribute name='description'>Allow MS Exchange user services</xsl:attribute>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>no</xsl:attribute>
							<xsl:attribute name='description'>No</xsl:attribute>
						</xsl:element>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>yes</xsl:attribute>
							<xsl:attribute name='description'>Yes</xsl:attribute>
						</xsl:element>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>msrpcepm_compatibility_mode</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>No</xsl:attribute>
						<xsl:attribute name='explanation'>Allows valid RPC message types that are unsupported by the Protocol Agent to bypass. However, no extra related connections are allowed based on these messages</xsl:attribute>
						<xsl:attribute name='type'>string</xsl:attribute>
						<xsl:attribute name='description'>Allow unsupported MS RPC message types</xsl:attribute>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>no</xsl:attribute>
							<xsl:attribute name='description'>No</xsl:attribute>
						</xsl:element>
						<xsl:element name='pa_alternative'>
							<xsl:attribute name='name'>yes</xsl:attribute>
							<xsl:attribute name='description'>Yes</xsl:attribute>
						</xsl:element>
					</xsl:element>
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>allow_related_connections</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>true</xsl:attribute>
						<xsl:attribute name='explanation'>Allows related connections</xsl:attribute>
						<xsl:attribute name='type'>boolean</xsl:attribute>
						<xsl:attribute name='description'>Allow related connections</xsl:attribute>
					</xsl:element>
					
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>Yes</xsl:attribute>
						<xsl:attribute name='param_description'>Allow MS Exchange Remote administration service</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>Yes</xsl:attribute>
						<xsl:attribute name='param_description'>Allow MS Exchange user services</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>No</xsl:attribute>
						<xsl:attribute name='param_description'>Allow unsupported MS RPC message types</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>true</xsl:attribute>
						<xsl:attribute name='param_description'>Allow related connections</xsl:attribute>
					</xsl:element>

				</xsl:when>	
				
				<!-- Sunrpc (TCP) case -->
				<xsl:when test="@key='60200004'">
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>learn_rpc</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>Yes</xsl:attribute>
						<xsl:attribute name='explanation'>Learn RPC program number to port mapping for future RPC service matches</xsl:attribute>
						<xsl:attribute name='type'>boolean</xsl:attribute>
						<xsl:attribute name='description'>Learn RPC program number to port mapping for future RPC service matches</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>true</xsl:attribute>
						<xsl:attribute name='param_description'>Learn RPC program number to port mapping for future RPC service matches</xsl:attribute>
					</xsl:element>
				</xsl:when>	
				
				<!-- Sunrpc (UDP) case -->
				<xsl:when test="@key='40200002'">
					<xsl:element name='pa_parameter'>
						<xsl:attribute name='name'>learn_rpc</xsl:attribute>
						<xsl:attribute name='min_pa_version'>0</xsl:attribute>
						<xsl:attribute name='default_value'>Yes</xsl:attribute>
						<xsl:attribute name='explanation'>Learn RPC program number to port mapping for future RPC service matches</xsl:attribute>
						<xsl:attribute name='type'>boolean</xsl:attribute>
						<xsl:attribute name='description'>Learn RPC program number to port mapping for future RPC service matches</xsl:attribute>
					</xsl:element>
					<xsl:element name='pa_value'>
						<xsl:attribute name='value'>true</xsl:attribute>
						<xsl:attribute name='param_description'>Learn RPC program number to port mapping for future RPC service matches</xsl:attribute>
					</xsl:element>					
				</xsl:when>	
				
				<!-- no parameters	-->	
				<xsl:otherwise>
				</xsl:otherwise>	
			</xsl:choose>	
			
			<!-- copy binary files	-->
			<xsl:apply-templates select="binary"/>
		</xsl:element>		
	</xsl:template>
	
	
	<!-- update services : replace inspection_mod_ref by protocol_agent_ref-->
	<xsl:template match="service_ethernet[@inspection_mod_ref]">
		<xsl:copy>
			<xsl:attribute name="protocol_agent_ref"><xsl:value-of select="@inspection_mod_ref"/></xsl:attribute>				
			<xsl:apply-templates select="@*[name(.) != 'inspection_mod_ref']|node()"/>
		</xsl:copy>
	</xsl:template>	
	
	<xsl:template match="service_ip">
		<xsl:choose>
			<xsl:when test="@key = '10006'"></xsl:when><!-- ICMP inspection -->
			<xsl:when test="@key = '10010'"></xsl:when><!-- TCP inspection -->
			<xsl:when test="@key = '10011'"></xsl:when><!-- UDP inspection -->
			
			<xsl:when test="@inspection_mod_ref">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref"><xsl:value-of select="@inspection_mod_ref"/></xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'inspection_mod_ref']|node()"/>
				</xsl:copy>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*|node()"/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>	
	</xsl:template>	
	
	<xsl:template match="service_tcp">
		<xsl:choose>
            <xsl:when test="@key=  '298'"></xsl:when><!-- SG-mgmt-log-1 -->
            <xsl:when test="@key=  '299'"></xsl:when><!-- SG-mgmt-log-2 -->
            <xsl:when test="@key=  '300'"></xsl:when><!-- SG-mgmt-log-3 -->
            <xsl:when test="@key=  '354'"></xsl:when><!-- netbios-epmap (NETBIOS DCE-RPC endpoint mapper) (TCP) -->
            <xsl:when test="@key='10002'"></xsl:when><!-- dns inspection (TCP) -->
            <xsl:when test="@key='10004'"></xsl:when><!-- ftp inspection -->
            <xsl:when test="@key='10005'"></xsl:when><!-- http inspection -->
            <xsl:when test="@key='10008'"></xsl:when><!-- smtp inspection -->
            <xsl:when test="@key='10009'"></xsl:when><!-- ssh inspection -->
            <xsl:when test="@key='10019'"></xsl:when><!-- x11 inspection (X Window System) (TCP) -->
            <xsl:when test="@key='10020'"></xsl:when><!-- finger inspection (Finger) -->
            <xsl:when test="@key='10023'"></xsl:when><!-- netbios-ssn inspection (NETBIOS Session Service) -->
            <xsl:when test="@key='10024'"></xsl:when><!-- microsoft-ds inspection (TCP) -->
            <xsl:when test="@key='10025'"></xsl:when><!-- telnet inspection (Telnet) -->
            <xsl:when test="@key='10027'"></xsl:when><!-- https inspection (http protocol over TLS/SSL) -->
            <xsl:when test="@key='10029'"></xsl:when><!-- imap inspection (Internet Message Access Protocol) (TCP) -->
            <xsl:when test="@key='10030'"></xsl:when><!-- nntp inspection (Network News Transfer Protocol) -->
            <xsl:when test="@key='10031'"></xsl:when><!-- snmp inspection (TCP) -->
            <xsl:when test="@key='10068'"></xsl:when><!-- snmptrap inspection (TCP) -->
            <xsl:when test="@key='10032'"></xsl:when><!-- wins server replication inspection -->
            <xsl:when test="@key='10035'"></xsl:when><!-- printer inspection (spooler) -->
            <xsl:when test="@key='10036'"></xsl:when><!-- pptp inspection -->
            <xsl:when test="@key='10037'"></xsl:when><!-- ldap inspection (Lightweight Directory Access Protocol) (TCP) -->
            <xsl:when test="@key='10045'"></xsl:when><!-- ident inspection -->
            <xsl:when test="@key='10046'"></xsl:when><!-- pop3 inspection (Post Office Protocol - Version 3) (TCP) -->
            <xsl:when test="@key='10051'"></xsl:when><!-- Rlogin inspection (TCP) -->
		
			<xsl:when test="@inspection_mod_ref">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref"><xsl:value-of select="@inspection_mod_ref"/></xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'inspection_mod_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<!-- change reference if protocol_agent_ref refers to MSRPC that has been renamed-->
			<xsl:when test="contains(@protocol_agent_ref, 'Microsoft RPC-EPM')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">60200026</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="contains(@protocol_agent_ref, 'FTP')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">8200</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<xsl:when test="contains(@protocol_agent_ref, 'H323')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">102</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<xsl:when test="contains(@protocol_agent_ref, 'HTTP')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">7200</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<xsl:when test="contains(@protocol_agent_ref, 'Oracle')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">108</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<xsl:when test="contains(@protocol_agent_ref, 'Services in firewall')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">40200010</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<xsl:when test="contains(@protocol_agent_ref, 'Shell')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">110</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<xsl:when test="contains(@protocol_agent_ref, 'SSH')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">9200</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<xsl:when test="contains(@protocol_agent_ref, 'Sunrpc')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">60200004</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<xsl:when test="contains(@protocol_agent_ref, 'SMTP')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">10201</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="contains(@protocol_agent_ref, 'TCP proxy')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">115</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
		    <xsl:when test="contains(@protocol_agent_ref, 'SIP')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">51200</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*|node()"/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- SG-Log-to-Mgt -->
	<xsl:template match="tcp_service_group[@key='456']">
	</xsl:template>

	<xsl:template match="service_udp">
		<xsl:choose>
            <xsl:when test="@key=  '421'"></xsl:when><!-- netbios-epmap (NETBIOS DCE-RPC endpoint mapper) (UDP) -->
            <xsl:when test="@key=  '440'"></xsl:when><!-- tftp (Trivial File Transfer) -->
            <xsl:when test="@key='10003'"></xsl:when><!-- dns inspection (UDP) -->
            <xsl:when test="@key='10012'"></xsl:when><!-- bootp inspection -->
            <xsl:when test="@key='10014'"></xsl:when><!-- snmp inspection (UDP) -->
            <xsl:when test="@key='10067'"></xsl:when><!-- snmptrap inspection (UDP) -->            
            <xsl:when test="@key='10017'"></xsl:when><!-- ldap inspection (Lightweight Directory Access Protocol) (UDP) -->
            <xsl:when test="@key='10044'"></xsl:when><!-- netbios-dgm inspection (NETBIOS Datagram Service) -->

			<xsl:when test="@inspection_mod_ref">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref"><xsl:value-of select="@inspection_mod_ref"/></xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'inspection_mod_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<!-- change reference if protocol_agent_ref refers to Netbios that has been renamed-->
			<xsl:when test="contains(@protocol_agent_ref, 'Netbios')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">40200010</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<xsl:when test="contains(@protocol_agent_ref, 'Sunrpc')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">40200002</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<xsl:when test="contains(@protocol_agent_ref, 'Services in firewall')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">109</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>
			<xsl:when test="contains(@protocol_agent_ref, 'SIP')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">51200</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			<xsl:when test="contains(@protocol_agent_ref, 'TFTP')">
				<xsl:copy>
					<xsl:attribute name="protocol_agent_ref">40200004</xsl:attribute>				
					<xsl:apply-templates select="@*[name(.) != 'protocol_agent_ref']|node()"/>
				</xsl:copy>
			</xsl:when>	
			
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*|node()"/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>	
	
		
	<!-- rename some attributes in situation element -->
	<xsl:template match="situation">
		<xsl:copy>
			<xsl:attribute name="attacker"><xsl:value-of select="@protocol_name"/></xsl:attribute>
			<xsl:attribute name="victim"><xsl:value-of select="@operating_system"/></xsl:attribute>
			<xsl:attribute name="replacing_sid"><xsl:value-of select="@applications"/></xsl:attribute>
			<xsl:apply-templates select="@*[name(.) != 'protocol_name' and name(.) != 'operating_system' and name(.) != 'applications']|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<!-- manage all system services renaming -->
	<xsl:template match="reference[@type='service']">
		<xsl:choose>
			<xsl:when test="@value =  'SG-mgmt-log-1'"></xsl:when>
			<xsl:when test="@value =  'SG-mgmt-log-2'"></xsl:when>
	  	    <xsl:when test="@value =  'SG-mgmt-log-3'"></xsl:when>
   	  	    <xsl:when test="@value =  'SG-Log-to-Mgt'"></xsl:when>
   	  	    <xsl:when test="@value =  'snmptrap inspection (SNMPTRAP) (TCP)'"></xsl:when>
   	  	    <xsl:when test="@value =  '10068'"></xsl:when>
   	  	    <xsl:when test="@value =  'snmptrap inspection (UDP)'"></xsl:when>
 	  	    <xsl:when test="@value =  '10067'"></xsl:when>
	
			<xsl:otherwise>
				<xsl:copy>
					<xsl:attribute name="ref_object_name">
						<xsl:call-template name="replace-old-service-name">
						    <xsl:with-param name="oldservicename" select="@ref_object_name"/>
			    		</xsl:call-template>
					</xsl:attribute>
					<xsl:apply-templates select="@*[name(.) != 'ref_object_name']|node()"/>
				</xsl:copy>
		   </xsl:otherwise>
		</xsl:choose>		
	</xsl:template>
	
    <!-- deleted system services are also managed by removing -->
	<xsl:template match="service_ref">
		<xsl:choose>
			<xsl:when test="@value =  '10012'"></xsl:when>
			<xsl:when test="@value =  '10003'"></xsl:when>
			<xsl:when test="@value =  '10017'"></xsl:when>
			<xsl:when test="@value =  '421'"></xsl:when>
			<xsl:when test="@value =  '10044'"></xsl:when>
			<xsl:when test="@value =  '10014'"></xsl:when>
			<xsl:when test="@value =  '440'"></xsl:when>
			
			<xsl:when test="@value =  '298'"></xsl:when>
			<xsl:when test="@value =  '299'"></xsl:when>
			<xsl:when test="@value =  '300'"></xsl:when>
			
	  		<xsl:when test="@value =  '10002'"></xsl:when>
			<xsl:when test="@value =  '10029'"></xsl:when>
			<xsl:when test="@value =  '10037'"></xsl:when>
			<xsl:when test="@value =  '354'"></xsl:when>
			<xsl:when test="@value =  '10046'"></xsl:when>
			<xsl:when test="@value =  '10024'"></xsl:when>
			<xsl:when test="@value =  '10031'"></xsl:when>
			<xsl:when test="@value =  '10019'"></xsl:when>
  			<xsl:when test="@value =  '10020'"></xsl:when>
			<xsl:when test="@value =  '10004'"></xsl:when>
			<xsl:when test="@value =  '10027'"></xsl:when>
			<xsl:when test="@value =  '10005'"></xsl:when>
			<xsl:when test="@value =  '10045'"></xsl:when>
			<xsl:when test="@value =  '10023'"></xsl:when>
			<xsl:when test="@value =  '10030'"></xsl:when>
			<xsl:when test="@value =  '10036'"></xsl:when>
			<xsl:when test="@value =  '10035'"></xsl:when>
			<xsl:when test="@value =  '10008'"></xsl:when>
			<xsl:when test="@value =  '10009'"></xsl:when>
			<xsl:when test="@value =  '10025'"></xsl:when>
			<xsl:when test="@value =  '10032'"></xsl:when>
			
    		<xsl:when test="@value =  '298'"></xsl:when>
			<xsl:when test="@value =  '299'"></xsl:when>
	  	    <xsl:when test="@value =  '300'"></xsl:when>
   	  	    <xsl:when test="@value =  '456'"></xsl:when>
   	  	    <xsl:when test="@value =  '10006'"></xsl:when>
   	  	    <xsl:when test="@value =  '10010'"></xsl:when>
   	  	    <xsl:when test="@value =  '10011'"></xsl:when>
   	  	    <xsl:when test="@value =  '10051'"></xsl:when>
   	  	    
   	  	    <xsl:when test="@value =  'SG-mgmt-log-1'"></xsl:when>
			<xsl:when test="@value =  'SG-mgmt-log-2'"></xsl:when>
	  	    <xsl:when test="@value =  'SG-mgmt-log-3'"></xsl:when>
   	  	    <xsl:when test="@value =  'SG-Log-to-Mgt'"></xsl:when>
  	  	    <xsl:when test="@value =  'snmptrap inspection (SNMPTRAP) (TCP)'"></xsl:when>
   	  	    <xsl:when test="@value =  '10068'"></xsl:when>
   	  	    <xsl:when test="@value =  'snmptrap inspection (UDP)'"></xsl:when>
  	  	    <xsl:when test="@value =  '10067'"></xsl:when>
			
			<xsl:otherwise>
				<xsl:copy>
					<xsl:attribute name="value">
					<xsl:call-template name="replace-old-service-name">
				    	<xsl:with-param name="oldservicename" select="@value"/>
				    </xsl:call-template>
					</xsl:attribute>
					<xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>	
	</xsl:template>
	
	<!-- deleted system services are also managed by removing -->
	<xsl:template match="match_service_ref">
		<xsl:choose>
			<xsl:when test="@value =  '10012'"></xsl:when>
			<xsl:when test="@value =  '10003'"></xsl:when>
			<xsl:when test="@value =  '10017'"></xsl:when>
			<xsl:when test="@value =  '421'"></xsl:when>
			<xsl:when test="@value =  '10044'"></xsl:when>
			<xsl:when test="@value =  '10014'"></xsl:when>
			<xsl:when test="@value =  '440'"></xsl:when>
			
			<xsl:when test="@value =  '298'"></xsl:when>
			<xsl:when test="@value =  '299'"></xsl:when>
			<xsl:when test="@value =  '300'"></xsl:when>
			
	  		<xsl:when test="@value =  '10002'"></xsl:when>
			<xsl:when test="@value =  '10029'"></xsl:when>
			<xsl:when test="@value =  '10037'"></xsl:when>
			<xsl:when test="@value =  '354'"></xsl:when>
			<xsl:when test="@value =  '10046'"></xsl:when>
			<xsl:when test="@value =  '10024'"></xsl:when>
			<xsl:when test="@value =  '10031'"></xsl:when>
			<xsl:when test="@value =  '10019'"></xsl:when>
  			<xsl:when test="@value =  '10020'"></xsl:when>
			<xsl:when test="@value =  '10004'"></xsl:when>
			<xsl:when test="@value =  '10027'"></xsl:when>
			<xsl:when test="@value =  '10005'"></xsl:when>
			<xsl:when test="@value =  '10045'"></xsl:when>
			<xsl:when test="@value =  '10023'"></xsl:when>
			<xsl:when test="@value =  '10030'"></xsl:when>
			<xsl:when test="@value =  '10036'"></xsl:when>
			<xsl:when test="@value =  '10035'"></xsl:when>
			<xsl:when test="@value =  '10008'"></xsl:when>
			<xsl:when test="@value =  '10009'"></xsl:when>
			<xsl:when test="@value =  '10025'"></xsl:when>
			<xsl:when test="@value =  '10032'"></xsl:when>
			
    		<xsl:when test="@value =  '298'"></xsl:when>
			<xsl:when test="@value =  '299'"></xsl:when>
	  	    <xsl:when test="@value =  '300'"></xsl:when>
   	  	    <xsl:when test="@value =  '456'"></xsl:when>
	  	    
   	  	    <xsl:when test="@value =  '10006'"></xsl:when>
   	  	    <xsl:when test="@value =  '10010'"></xsl:when>
   	  	    <xsl:when test="@value =  '10011'"></xsl:when>
   	  	    <xsl:when test="@value =  '10051'"></xsl:when>
   	  	    
   	  	    <xsl:when test="@value =  'SG-mgmt-log-1'"></xsl:when>
			<xsl:when test="@value =  'SG-mgmt-log-2'"></xsl:when>
	  	    <xsl:when test="@value =  'SG-mgmt-log-3'"></xsl:when>
   	  	    <xsl:when test="@value =  'SG-Log-to-Mgt'"></xsl:when>
   	  	    <xsl:when test="@value =  'snmptrap inspection (SNMPTRAP) (TCP)'"></xsl:when>
  	  	    <xsl:when test="@value =  '10068'"></xsl:when>
   	  	    <xsl:when test="@value =  'snmptrap inspection (UDP)'"></xsl:when>
   	  	    <xsl:when test="@value =  '10067'"></xsl:when>
	  	    
			<xsl:otherwise>
				<xsl:copy>
					<xsl:attribute name="value">
						<xsl:call-template name="replace-old-service-name">
					    <xsl:with-param name="oldservicename" select="@value"/>
					    </xsl:call-template>
					</xsl:attribute>
					<xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
				</xsl:copy>		
			</xsl:otherwise>
		</xsl:choose>					
	</xsl:template>
	
	<!-- RENAMING OF match_protocol_ref module type into protocol_agent -->
    <xsl:template match="match_protocol_ref">
		<xsl:copy>
			<xsl:attribute name="type">
		        <xsl:text>protocol_agent</xsl:text>
			</xsl:attribute>
			<xsl:apply-templates select="@*[name(.) != 'type']|node()"/>
		</xsl:copy>		
	</xsl:template>
	
	<!-- DELETION of mobile_vpn attribute and encryption_policy nodes in vpn XML definition -->
	<!-- vpn_profile_ref required attribute adding and referenced on default vpn profile -->
	<xsl:template match="vpn">
		<xsl:variable name="vpn_name"><xsl:value-of select="@name"/></xsl:variable>
		<xsl:copy>
			<xsl:attribute name="vpn_profile_ref"><xsl:text>VPN-A Suite</xsl:text></xsl:attribute>
			<xsl:apply-templates select="@*[name(.) != 'mobile_vpn']|node()[name(.) != 'encryption_policy']"/>
			<xsl:apply-templates select="../vpn_topology[@vpn_ref=$vpn_name]"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="vpn_topology">
		<xsl:copy>
			<xsl:apply-templates select="@*[name(.) != 'vpn_ref']|node()"/>
		</xsl:copy>
	</xsl:template>	

	<!-- gateway_ref adding in gateway_node vpn_topology node which references the gateway of the referenced site -->
	<!-- central='false' attribute adding on gateway_node when one site ref has been marked as spoke -->
	<!-- gateway_parent_ref => parent_gateway_ref attribute -->
	<!-- level gateway_node attribute removal -->
	<xsl:template match="gateway_node">
		<xsl:copy>
			<xsl:variable name="site_ref"><xsl:value-of select="vpn_site_ref/@value"/></xsl:variable>
			<xsl:if test="$site_ref">
				<xsl:choose>
					<xsl:when test="vpn_site_ref/@state='spoke'">
						<xsl:attribute name="central"><xsl:text>false</xsl:text></xsl:attribute>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
				<xsl:attribute name="gateway_ref"><xsl:value-of select="../../vpn_site[@name=$site_ref]/@gateway_ref"/></xsl:attribute>
			</xsl:if>
			<xsl:if test="@gateway_parent_ref">
				<xsl:attribute name="parent_gateway_ref"><xsl:value-of select="@gateway_parent_ref"/></xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="@*[name(.) != 'level' and name(.) != 'gateway_parent_ref']|node()"/>
		</xsl:copy>
	</xsl:template>

	<!-- enabled='false' attribute adding on vpn_site_ref when state was marked as disabled -->
	<!-- state vpn_site_ref attribute removal -->
	<xsl:template match="vpn_site_ref">
		<xsl:copy>
				<xsl:choose>
					<xsl:when test="@state='disabled'">
						<xsl:attribute name="enabled"><xsl:text>false</xsl:text></xsl:attribute>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			<xsl:apply-templates select="@*[name(.) != 'state']|node()"/>
		</xsl:copy>
	</xsl:template>

	<!-- Client Site node removal because now system -->
	<xsl:template match="vpn_site">
		<xsl:choose>
			<xsl:when test="@name='Client'">
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*|node()"/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<!-- rsa_encryption_for_ike capabilities attribute removal -->	
	<xsl:template match="capabilities">
		<xsl:copy>
			<xsl:apply-templates select="@*[name(.) != 'rsa_encryption_for_ike']|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<!-- ike_proposal node removal -->
	<xsl:template match="ike_proposal">
	</xsl:template>	
	
	<!-- ipsec_proposal node removal -->	
	<xsl:template match="ipsec_proposal">
	</xsl:template>
	
	<!-- vpn_tunnel node removal -->
	<xsl:template match="vpn_tunnel">
	</xsl:template>
	
	<!-- capabilities external_gateway node removal -->
	<xsl:template match="external_gateway">
		<xsl:copy>
			<xsl:attribute name="gateway_type_ref">
				<xsl:call-template name="replace-old-gateway-type-name">
				    <xsl:with-param name="oldgatewaytypename" select="@gateway_type_ref"/>
		  		</xsl:call-template>
			</xsl:attribute>
			<xsl:apply-templates select="@*[(name(.) != 'gateway_type_ref')]|node()[name(.) != 'capabilities']"/>
		</xsl:copy>
	</xsl:template>

	<!-- gateway profiles have been renamed -->
	<xsl:template name="replace-old-gateway-type-name">
		<xsl:param name="oldgatewaytypename"/>
		<xsl:choose>
			<xsl:when test="$oldgatewaytypename =  'StoneGate'"><xsl:text>StoneGate 2.5 - 3.x</xsl:text></xsl:when>
      		<xsl:otherwise><xsl:value-of select="$oldgatewaytypename"/></xsl:otherwise>
		</xsl:choose>
    </xsl:template>

	<!-- capabilities internal_gateway node removal -->	
	<xsl:template match="internal_gateway">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()[name(.) != 'capabilities' and name(.) != 'nat_pool']"/>
		</xsl:copy>
	</xsl:template>

	<!-- Internal IPSEC CA certificate_authority node removal because become system -->
	<xsl:template match="certificate_authority">
		<xsl:choose>
			<xsl:when test="@name='Internal IPSEC CA'">
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*|node()"/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<!-- copy everything else -->
	<xsl:template match="@*|node()">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<!-- remove vpn_topology -->
	<xsl:template match="generic_import_export">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()[name(.) != 'vpn_topology']"/>
		</xsl:copy>
	</xsl:template>

    <xsl:template name="replace-old-service-name">
			<xsl:param name="oldservicename"/>
		<xsl:choose>
			<xsl:when test="$oldservicename = 'IPv4 inspection'"><xsl:text>IPv4</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Tacacs+'"><xsl:text>TACACS+</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-auth'"><xsl:text>SG User Authentication</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-Log-to-Mgt'"><xsl:text>SG Log to Management</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = '32 Bit Rollover missing and ACK set'"><xsl:text>Datagram Conv. Error (32 Bit Rollover Missing)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Address Mask Reply (no code)'"><xsl:text>Address Mask Reply (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Address Mask Reply'"><xsl:text>Address Mask Reply (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Address Mask Request (no code)'"><xsl:text>Address Mask Request (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Address Mask Request'"><xsl:text>Address Mask Request (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Alternate Address for Host'"><xsl:text>Alternate Host Address (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Alternate Host Address'"><xsl:text>Alternate Host Address (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Bad Length'"><xsl:text>Parameter Problem (Bad Length)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Communication administratively prohibited by filtering'"><xsl:text>Dest. Unreachable (Administratively Prohibited)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Datagram Conversion Error'"><xsl:text>Datagram Conv. Error (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Destination host administratively prohibited'"><xsl:text>Dest. Unreachable (Host Prohibited)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Destination host unknown'"><xsl:text>Dest. Unreachable (Host Unknown)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Destination network administratively prohibited'"><xsl:text>Dest. Unreachable (Network Prohibited)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Destination network unknown'"><xsl:text>Dest. Unreachable (Network Unknown)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Destination Unreachable'"><xsl:text>Dest. Unreachable (Any Code)</xsl:text></xsl:when>
			<xsl:when test='$oldservicename = "Don&apos;t Convert option present"'><xsl:text>Datagram Conv. Error (Don't Convert Set)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Echo reply (no code)'"><xsl:text>Echo Reply (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Echo reply'"><xsl:text>Echo Reply (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Echo request (no code)'"><xsl:text>Echo Request (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Echo request'"><xsl:text>Echo Request (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Fragmentation needed but dont-fragment bit set'"><xsl:text>Dest. Unreachable (Fragmentation Needed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Fragment Reassembly Time Exceeded'"><xsl:text>Time Exceeded (Fragment Reassembly)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Host precedence violation'"><xsl:text>Dest. Unreachable (Host Precedence Violation)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Host unreachable for TOS'"><xsl:text>Dest. Unreachable (Host Unreachable for ToS)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Host unreachable'"><xsl:text>Dest. Unreachable (Host Unreachable)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Information Reply (no code)'"><xsl:text>Information Reply (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Information Reply'"><xsl:text>Information Reply (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Information Request (no code)'"><xsl:text>Information Request (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Information Request'"><xsl:text>Information Request (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IP header length exceeded'"><xsl:text>Datagram Conv. Error (IP Header Length Exceeded)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Known unsupported option present'"><xsl:text>Datagram Conv. Error (Known Unsupported Option)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Missing a Required Option'"><xsl:text>Parameter Problem (Missing Option)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Network unreachable for TOS'"><xsl:text>Dest. Unreachable (Net Unreachable for ToS)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Network unreachable'"><xsl:text>Dest. Unreachable (Net Unreachable)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'No route for Outbound Packet; packet discarded'"><xsl:text>Traceroute Status (No Route)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Outbound Packet successfully forwarded'"><xsl:text>Traceroute Status (Successfully Forwarded)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Overall length exceeded'"><xsl:text>Datagram Conv. Error (Length Exceeded)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Parameter Problem'"><xsl:text>Parameter Problem (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Photuris (reserved)'"><xsl:text>Photuris (Bad SPI)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Photuris (unknown security parameters index)'"><xsl:text>Photuris (Authentication Failed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Photuris (valid security parameters, but authentication failed)'"><xsl:text>Photuris (Decompression Failed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Photuris (valid security parameters, but decryption failed)'"><xsl:text>Photuris (Decryption Failed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Photuris'"><xsl:text>Photuris (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Pointer indicates the error'"><xsl:text>Parameter Problem (Pointer Indicates Error)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Port conversion out of range'"><xsl:text>Datagram Conv. Error (Port Out of Range)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Port unreachable'"><xsl:text>Dest. Unreachable (Port Unreachable)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Precedence cutoff in effect'"><xsl:text>Dest. Unreachable (Precedence Cutoff)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Protocol unreachable'"><xsl:text>Dest. Unreachable (Protocol Unreachable)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Redirect for host'"><xsl:text>Redirect (for Host)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Redirect for network'"><xsl:text>Redirect (for Network)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Redirect for type-of-service and host'"><xsl:text>Redirect (for ToS and Host)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Redirect for type-of-service and network'"><xsl:text>Redirect (for ToS and Network)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Redirect'"><xsl:text>Redirect (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Router advertisement (no code)'"><xsl:text>Router Advertisement (Normal)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Router advertisement'"><xsl:text>Router Advertisement (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Router selection (no code)'"><xsl:text>Router Selection (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Router selection'"><xsl:text>Router Selection (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Skip (ICMP)'"><xsl:text>SKIP (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Skip (reserved)'"><xsl:text>SKIP (Reserved)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Skip (unknown security parameters index)'"><xsl:text>SKIP (Unknown SPI)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Skip (valid security parameters, but authentication failed)'"><xsl:text>SKIP (Authentication Failed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Skip (valid security parameters, but decryption failed)'"><xsl:text>SKIP (Decryption Failed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Source host isolated'"><xsl:text>Dest. Unreachable (Source Isolated)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Source quench (no code)'"><xsl:text>Source Quench (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Source quench'"><xsl:text>Source Quench (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Source route failed'"><xsl:text>Dest. Unreachable (Source Route Failed)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Time Exceeded'"><xsl:text>Time Exceeded (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Timestamp (no code)'"><xsl:text>Timestamp (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Timestamp Reply (no code)'"><xsl:text>Timestamp Reply (No Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Timestamp Reply'"><xsl:text>Timestamp Reply (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Timestamp'"><xsl:text>Timestamp (Any Code)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Time to Live exceeded in Transit'"><xsl:text>Time Exceeded (TTL Exceeded)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Transport header length exceeded'"><xsl:text>Datagram Conv. Error (Transport Header Length Exceeded)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Transport protocol > 255'"><xsl:text>Datagram Conv. Error (Protocol > 255)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Unknown mandatory option present'"><xsl:text>Datagram Conv. Error (Unknown Mandatory Option)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Unknown mandatory transport option present'"><xsl:text>Datagram Conv. Error (Unknown Transport Option)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Unknown/unspecified error'"><xsl:text>Datagram Conv. Error (Unknown/Unspecified)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Unsupported transport protocol'"><xsl:text>Datagram Conv. Error (Unsupported Protocol)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = '3PC (Third Party Connect Protocol)'"><xsl:text>3PC</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'AH (Authentication Header for IPv6)'"><xsl:text>AH</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'A/N (Active Networks)'"><xsl:text>A/N</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Any private encryption scheme'"><xsl:text>Private Encryption Schemes</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ARIS (ARIS)'"><xsl:text>ARIS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'AX.25 (AX.25 Frames)'"><xsl:text>AX.25</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'BBN-RCC-MON (BBN RCC Monitoring)'"><xsl:text>BBN-RCC-MON</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'BNA (BNA)'"><xsl:text>BNA</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'BR-SAT-MON (Backroom SATNET Monitoring)'"><xsl:text>BR-SAT-MON</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'CFTP (CFTP)'"><xsl:text>CFTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'CHAOS (Chaos)'"><xsl:text>CHAOS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Compaq Peer (Compaq Peer Protocol)'"><xsl:text>Compaq Peer</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'CPHB (Computer Protocol Heart Beat)'"><xsl:text>CPHB</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'CPNX (Computer Protocol Network Executive)'"><xsl:text>CPNX</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'CRTP (Combat Radio Transport Protocol)'"><xsl:text>CRTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'CRUDP (Combat Radio User Datagram)'"><xsl:text>CRUDP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'DCN-MEAS (DCN Measurement Subsystems)'"><xsl:text>DCN-MEAS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'DDP (Datagram Delivery Protocol)'"><xsl:text>DDP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'DDX (D-II Data Exchange )'"><xsl:text>DDX</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'DGP (Dissimilar Gateway Protocol)'"><xsl:text>DGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'EGP (Exterior Gateway Protocol)'"><xsl:text>EGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'EIGRP (EIGRP)'"><xsl:text>EIGRP/IGRP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ENCAP (Encapsulation Header)'"><xsl:text>ENCAP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ESP (Encapsulation Security Payload for IPv4/IPv6)'"><xsl:text>ESP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ETHERIP (Ethernet-within-IP Encapsulation Protocol)'"><xsl:text>ETHERIP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'FC (Fibre Channel)'"><xsl:text>FC</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'GGP (Gateway-to-Gateway Protocol)'"><xsl:text>GGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'GMTP (GMTP)'"><xsl:text>GMTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'GRE (General Routing Encapsulation)'"><xsl:text>GRE</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'HMP (Host Monitoring Protocol)'"><xsl:text>HMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'HOPOPT (IPv6 Hop-by-Hop Option)'"><xsl:text>HOPOPT</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IATP (Interactive Agent Transfer Protocol)'"><xsl:text>IATP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ICMP (Internet Control Message Protocol)'"><xsl:text>ICMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IDPR-CMTP (IDPR Control Message Transport Protocol)'"><xsl:text>IDPR-CMTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IDPR (Inter-Domain Policy Routing Protocol)'"><xsl:text>IDPR</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IDRP (Inter-Domain Routing Protocol)'"><xsl:text>IDRP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IFMP (Ipsilon Flow Management Protocol)'"><xsl:text>IFMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IGMP (Internet Group Management Protocol)'"><xsl:text>IGMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IGP (Interior Gateway Protocol)'"><xsl:text>IGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IL (IL Transport Protocol)'"><xsl:text>IL</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'I-NLSP (Integrated Net Layer Security TUBA)'"><xsl:text>I-NLSP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPComp (IP Payload Compression Protocol)'"><xsl:text>IPComp</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPCV (Internet Packet Core Utility)'"><xsl:text>IPCV</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPIP (IP-within-IP Encapsulation Protocol)'"><xsl:text>IPIP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPX-in-IP (IPX in IP)'"><xsl:text>IPX-in-IP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPPC (Internet Pluribus Packet Core)'"><xsl:text>IPPC</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPv6--FRAG (Fragment Header for IPv6)'"><xsl:text>IPv6-FRAG</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPv6-ICMP (ICMP for IPv6)'"><xsl:text>IPv6-ICMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPv6-NoNxt (No Next Header for IPv6)'"><xsl:text>IPv6-NoNxt</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPv6-Opts (Destination Options for IPv6)'"><xsl:text>IPv6 Options</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPv6-Route (Routing Header for IPv6)'"><xsl:text>IPv6 Route</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IPv6'"><xsl:text>IPv6 Encapsulation</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'IRTP (Internet Reliable Transaction Protocol)'"><xsl:text>IRTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ISIS (ISIS over IPv4)'"><xsl:text>IS-IS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ISO-IP (ISO Internet Protocol)'"><xsl:text>ISO-IP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ISO-TP4 (ISO Transport Protocol Class 4)'"><xsl:text>ISO-TP4</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'KRYPTOLAN (Kryptolan)'"><xsl:text>Kryptolan</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'L2TP (Layer Two Tunneling Protocol)'"><xsl:text>L2TP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'LARP (Locus Address Resolution Protocol)'"><xsl:text>LARP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'LEAF-1 (Leaf-1)'"><xsl:text>Leaf-1</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'LEAF-2 (Leaf-2)'"><xsl:text>LEAF-2</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MERIT-NSP (MERIT Internodal Protocol)'"><xsl:text>MERIT-NSP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MFE-NSP (MFE Network Services Protocol)'"><xsl:text>MFE-NSP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MHRP (Mobile Host Routing Protocol)'"><xsl:text>MHRP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MICP (Mobile Internetworking Control Protocol)'"><xsl:text>MICP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MOBILE (IP Mobility)'"><xsl:text>MOBILE</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MTP (Multicast Transport Protocol)'"><xsl:text>MTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MUX (Multiplexing)'"><xsl:text>MUX</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'NARP (NBMA Address Resolution Protocol)'"><xsl:text>NARP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'NETBLT (Bulk Data Transfer Protocol)'"><xsl:text>NETBLT</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'NSFNET-IGP (NSFNET-IGP)'"><xsl:text>NSFNET-IGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'NVP-II (Network Voice Protocol)'"><xsl:text>NVP-II</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'OSPFIGP (OSPFIGP)'"><xsl:text>OSPFIGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PGM (PGM Reliable Transport Protocol)'"><xsl:text>PGM</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PIM (Protocol Independent Multicast)'"><xsl:text>PIM</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PIPE (Private IP Encapsulation within IP)'"><xsl:text>PIPE</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PNNI (PNNI over IP)'"><xsl:text>PNNI</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PRM (Packet Radio Measurement)'"><xsl:text>PRM</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PTP (Performance Transparency Protocol)'"><xsl:text>PTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'PVP (Packet Video Protocol)'"><xsl:text>PVP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'QNX (QNX)'"><xsl:text>QNX</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'RDP (Reliable Data Protocol)'"><xsl:text>RDP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'RSVP (Reservation Protocol)'"><xsl:text>RSVP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'RVD (MIT Remote Virtual Disk Protocol)'"><xsl:text>RVD</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SAT-EXPAK (SATNET and Backroom EXPAK)'"><xsl:text>SAT-EXPAK</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SAT-MON (SATNET Monitoring)'"><xsl:text>SAT-MON</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SCC-SP (Semaphore Communication Sec. Protocol)'"><xsl:text>SCC-SP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SCPS (SCPS)'"><xsl:text>SCPS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SCTP (Stream Control Transmission Protocol)'"><xsl:text>SCTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SDRP (Source Demand Routing Protocol)'"><xsl:text>SDRP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SECURE-VMTP (SECURE-VMTP)'"><xsl:text>SECURE-VMTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SEP (Sequential Exchange Protocol)'"><xsl:text>SEP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SMP (Simple Message Protocol)'"><xsl:text>SMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SM (SM)'"><xsl:text>SM</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SNP (Sitara Networks Protocol)'"><xsl:text>SNP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Sprite-RPC (Sprite RPC Protocol)'"><xsl:text>Sprite-RPC</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SPS (Secure Packet Shield)'"><xsl:text>SPS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SRP (SpectraLink Radio Protocol)'"><xsl:text>SRP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'STP (Schedule Transfer Protocol)'"><xsl:text>STP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ST (Stream)'"><xsl:text>ST</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SUN-ND (SUN-ND PROTOCOL-Temporary)'"><xsl:text>SUN-ND</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SWIPE (IP with Encryption)'"><xsl:text>SWIPE</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TCF (TCF)'"><xsl:text>TCF</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TCP (Transmission Control Protocol)'"><xsl:text>TCP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TLSP (Transport Layer Security Protocol using Kryptonet key management)'"><xsl:text>TLSP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TP++ (TP++ Transport Protocol)'"><xsl:text>TP++</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TRUNK-1 (Trunk-1)'"><xsl:text>Trunk-1</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TRUNK-2 (Trunk-2)'"><xsl:text>Trunk-2</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'TTP (TTP)'"><xsl:text>TTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'UDP (User Datagram Protocol)'"><xsl:text>UDP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'UTI (UTI)'"><xsl:text>UTI</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'VINES (VINES)'"><xsl:text>VINES</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'VISA (VISA Protocol)'"><xsl:text>VISA</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'VMTP (VMTP)'"><xsl:text>VMTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'VRRP (Virtual Router Redundancy Protocol)'"><xsl:text>VRRP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'WB-EXPAK (WIDEBAND EXPAK)'"><xsl:text>WB-EXPAK</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'WB-MON (WIDEBAND Monitoring)'"><xsl:text>WB-MON</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'WSN (Wang Span Network)'"><xsl:text>WSN</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'XNET (Cross Net Debugger)'"><xsl:text>XNET</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'XNS-IDP (XEROX NS IDP)'"><xsl:text>XNS-IDP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = '3270_mapper'"><xsl:text>IBM 3270 Portmapper</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'activity'"><xsl:text>Activity</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'alis'"><xsl:text>Alis</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'amd'"><xsl:text>Amd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bootparam'"><xsl:text>Bootparam</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bugtraqd'"><xsl:text>Bugtraqd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bwnfsd'"><xsl:text>Bwnfsd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'database_svc'"><xsl:text>Database_svc</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'debug_svc'"><xsl:text>Debug_svc</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'etherif'"><xsl:text>Etherif</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'etherstatd'"><xsl:text>Etherstatd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'event'"><xsl:text>Event</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'fypxfrd'"><xsl:text>Fypxfrd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'hostif'"><xsl:text>Hostif</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'hostmem'"><xsl:text>Hostmem</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'hostperf'"><xsl:text>Hostperf</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ioadmd'"><xsl:text>Ioadmd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'iproutes'"><xsl:text>Iproutes</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kerbd'"><xsl:text>Kerbd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'keyserv'"><xsl:text>Keyserv</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'layers'"><xsl:text>Layers</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'llockmgr'"><xsl:text>Llockmgr</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'logger'"><xsl:text>Logger</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'mountd'"><xsl:text>Mountd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netlicense'"><xsl:text>Netlicense</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nfs_acl'"><xsl:text>Nfs_acl</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nfs (RPC)'"><xsl:text>NFS (RPC)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nisd'"><xsl:text>Nisd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nispasswd'"><xsl:text>Nispasswd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nlockmgr'"><xsl:text>Nlockmgr</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nsed'"><xsl:text>Nsed</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nsemntd'"><xsl:text>Nsemntd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'pcnfsd'"><xsl:text>Pcnfsd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ping (RPC)'"><xsl:text>Ping (RPC)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'portmapper (RPC)'"><xsl:text>Pmap</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rexd'"><xsl:text>Rexd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rje_mapper'"><xsl:text>Rje_mapper</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rpcnfs'"><xsl:text>Rpcnfs</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rquotad'"><xsl:text>Rquotad</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rstatd'"><xsl:text>Rstatd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rusersd'"><xsl:text>Rusersd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sadmind'"><xsl:text>Sadmind</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sample'"><xsl:text>Sample</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sched'"><xsl:text>Sched</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'selection_svc'"><xsl:text>Selection_svc</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'showfhd'"><xsl:text>Showfhd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'snmp'"><xsl:text>SNMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'statmon'"><xsl:text>Status (1)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'status'"><xsl:text>Status (2)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sunisamd'"><xsl:text>Sunisamd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sunlink_mapper'"><xsl:text>SunLink Mapper</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sync'"><xsl:text>Sync</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tfsd'"><xsl:text>Tfsd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'traffic'"><xsl:text>Traffic</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ufsd'"><xsl:text>Ufsd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'walld'"><xsl:text>Walld</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'x25.inr'"><xsl:text>X25.inr</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'x25'"><xsl:text>X25</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ypbind'"><xsl:text>Ypbind</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'yppasswdd'"><xsl:text>Yppasswdd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ypserv'"><xsl:text>Ypserv</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ypupdated'"><xsl:text>Ypupdated</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ypxfrd'"><xsl:text>Ypxfrd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'aol (America-Online)'"><xsl:text>AOL</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bgmp (BGMP)'"><xsl:text>BGMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bgp (Border Gateway Protocol)'"><xsl:text>BGP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'BitKeeper bkd inspection'"><xsl:text>BitKeeper</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bootpc (Bootstrap Protocol Client) (TCP)'"><xsl:text>BOOTPC (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bootps (Bootstrap Protocol Server) (TCP)'"><xsl:text>BOOTPS (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ccso inspection (TCP)'"><xsl:text>CCSO (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'chargen (Character Generator) (TCP)'"><xsl:text>CHARGEN (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'cmip-agent (CMIP Agent) (TCP)'"><xsl:text>CMIP-Agent (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'cmip-man (CMIP Manager) (TCP)'"><xsl:text>CMIP-Manager (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'compaq Web-Based Management'"><xsl:text>Compaq WBEM</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'creativepartnr (CreativePartnr)'"><xsl:text>CreativePartnr</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'creativeserver (CreativeServer)'"><xsl:text>CreativeServer</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'cvs inspection'"><xsl:text>CVS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'daytime (TCP)'"><xsl:text>Daytime (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'discard (TCP)'"><xsl:text>Discard Protocol (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'dns (TCP)'"><xsl:text>DNS (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'echo (TCP)'"><xsl:text>Echo (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'exec (remote process execution)'"><xsl:text>Exec</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'finger (Finger)'"><xsl:text>Finger</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ftp-data (File Transfer [Default Data])'"><xsl:text>FTP (Data)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ftp (File Transfer [Control])'"><xsl:text>FTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ftps-data (ftp protocol, data, over TLS/SSL)'"><xsl:text>FTPS (Data)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ftps (ftp protocol, control, over TLS/SSL)'"><xsl:text>FTPS (Control)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'General Inter-ORB Protocol'"><xsl:text>Oracle GIOP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'unspecified service inspection (TCP)'"><xsl:text>Any TCP Service</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'gopher (Gopher)'"><xsl:text>Gopher</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'https (http protocol over TLS/SSL)'"><xsl:text>HTTPS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'http with URL logging (World Wide Web HTTP)'"><xsl:text>HTTP (with URL Logging)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'http (World Wide Web HTTP)'"><xsl:text>HTTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ident'"><xsl:text>Ident</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'imap3 (Interactive Mail Access Protocol v3)'"><xsl:text>IMAP3</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'imap (Internet Message Access Protocol)'"><xsl:text>IMAP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'imaps (imap4 protocol over TLS/SSL)'"><xsl:text>IMAPS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ingres-net (INGRES-NET Service)'"><xsl:text>INGRES-NET</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ipp (Internet Printing Protocol) (TCP)'"><xsl:text>IPP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'irc (Internet Relay Chat Protocol)'"><xsl:text>IRC</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'irc-serv (IRC-SERV)'"><xsl:text>IRC-SERV</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ircs (irc protocol over TLS/SSL)'"><xsl:text>IRCS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'isakmp (isakmp)'"><xsl:text>ISAKMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kerberos-adm (kerberos administration) (TCP)'"><xsl:text>Kerberos Administration (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kerberos (Kerberos)'"><xsl:text>Kerberos</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kpasswd (kpasswd)'"><xsl:text>Kpasswd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kshell (krcmd)'"><xsl:text>Kshell</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ldap (Lightweight Directory Access Protocol)'"><xsl:text>LDAP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ldaps (ldap protocol over TLS/SSL)'"><xsl:text>LDAPS (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'login (remote login a la telnet)'"><xsl:text>Rlogin</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'lotusnotes (Lotus Notes)'"><xsl:text>Lotus Notes</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'microsoft-ds'"><xsl:text>Microsoft-DS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Microsoft Remote Desktop'"><xsl:text>Remote Desktop</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Microsoft RPC/End-point Mapper over TCP'"><xsl:text>MSRPC (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'mosaicsyssvc1 (mosaicsyssvc1)'"><xsl:text>mosaicsyssvc1</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MSSQL inspection (TCP)'"><xsl:text>MSSQL (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ms-streaming (ms-streaming)'"><xsl:text>MS-Streaming (ms-streaming)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'mysql inspection (TCP)'"><xsl:text>MySQL</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netbios-ns (NETBIOS Name Service) (TCP)'"><xsl:text>NetBIOS-NS (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netbios-ssn (NETBIOS Session Service)'"><xsl:text>NetBIOS-SSN</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netnews (readnews)'"><xsl:text>Netnews</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netwall (for emergency broadcasts)'"><xsl:text>Netwall</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nmap (TCP)'"><xsl:text>NMAP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nntp (Network News Transfer Protocol)'"><xsl:text>NNTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nntps (nntp protocol over TLS/SSL (was snntp))'"><xsl:text>NNTPS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ntp (Network Time Protocol) (TCP)'"><xsl:text>NTP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'oracle TNS'"><xsl:text>Oracle TNS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'orasrv (oracle)'"><xsl:text>Orasrv</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'photuris (proturis)'"><xsl:text>Photuris (ICMP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'pop2 (Post Office Protocol - Version 2)'"><xsl:text>POP2</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'pop3 (Post Office Protocol - Version 3)'"><xsl:text>POP3</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'pop3s (pop3 protocol over TLS/SSL (was spop3))'"><xsl:text>POP3S</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'pptp (TCP)'"><xsl:text>PPTP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'printer (spooler) (TCP)'"><xsl:text>Printer Spooler (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Q.931'"><xsl:text>H.323 (Call Signaling)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'qotd (Quote of the Day)'"><xsl:text>QOTD</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netbios-epmap inspection (NETBIOS DCE-RPC endpoint mapper) (TCP)'"><xsl:text>MSRPC Endpoint Mapper (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rsvp_tunnel (RSVP Tunnel)'"><xsl:text>RSVP Tunnel</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rsync (rsync)'"><xsl:text>Rsync</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'set (Secure Electronic Transaction) (TCP)'"><xsl:text>SET (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-blacklist'"><xsl:text>SG Blacklisting</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-datasync'"><xsl:text>SG Data Sync</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-dynamic-control'"><xsl:text>SG Dynamic Control</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-Gui-to-Log'"><xsl:text>SG Data Browsing</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-Gui-to-Mgt'"><xsl:text>SG Control</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-init-ticket'"><xsl:text>SG Log Initial Contact</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-init'"><xsl:text>SG Initial Contact</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-ips-event'"><xsl:text>SG Event Transfer</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-log-backup'"><xsl:text>SG Monitoring Backup</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-log'"><xsl:text>SG Log</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-mgmt-analyzer'"><xsl:text>SG Commands (Analyzer)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-mgmt-sensor'"><xsl:text>SG Commands (Sensor)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-mgmt'"><xsl:text>SG Commands</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-MonClient-to-MonServer'"><xsl:text>SG Control (Monitoring Client)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-monitor'"><xsl:text>SG Monitoring</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-MonServer-to-Log'"><xsl:text>SG Data Browsing (Monitoring Server)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-remote-upgrade'"><xsl:text>SG Remote Upgrade</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-statesync-uni'"><xsl:text>SG State Sync (Unicast)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-vpnclient-cfg'"><xsl:text>SG VPN Client Configuration</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'shell (cmd)'"><xsl:text>Shell (cmd)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sip inspection (TCP)'"><xsl:text>SIP Control (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'smtp (Simple Mail Transfer)'"><xsl:text>SMTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'snagas (SNA Gateway Access Server)'"><xsl:text>SNAGAS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'snmp (TCP)'"><xsl:text>SNMP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'snmptrap (SNMPTRAP) (TCP)'"><xsl:text>SNMP Trap (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sshell (SSLshell)'"><xsl:text>SShell</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ssh (SSH Remote Login Protocol)'"><xsl:text>SSH</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sunrpc (SUN Remote Procedure Call) (TCP)'"><xsl:text>Sun RPC (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'svn inspection (TCP)'"><xsl:text>SVN</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'systat (Active Users)'"><xsl:text>Systat (Active Users)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tacacs-ds (TACACS-Database Service)'"><xsl:text>TACACS-DS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tacacs (Login Host Protocol) (TCP)'"><xsl:text>TACACS (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'talk (like tenex link, but across)'"><xsl:text>Talk</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tcpmux (TCP Port Service Multiplexer)'"><xsl:text>TCPMux</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'telnets (telnet protocol over TLS/SSL)'"><xsl:text>Telnets</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'telnet (Telnet)'"><xsl:text>Telnet</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'timed (timeserver)'"><xsl:text>Timed</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'time (TCP)'"><xsl:text>Time (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tlisrv (oracle)'"><xsl:text>TLISRV</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'uucp-rlogin (uucp-rlogin)'"><xsl:text>UUCP-rlogin</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'uucp (uucpd)'"><xsl:text>UUCP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'whoami (whoami)'"><xsl:text>Whoami</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'wins server replication'"><xsl:text>WINS Replication</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'x11 (X Window System)'"><xsl:text>X11</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'xdmcp (X Display Manager Control Protocol)'"><xsl:text>XDMCP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'biff (used by mail system to notify users)'"><xsl:text>Biff</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bootpc (Bootstrap Protocol Client) (UDP)'"><xsl:text>BOOTPC (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'bootps (Bootstrap Protocol Server) (UDP)'"><xsl:text>BOOTPS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ccso inspection (UDP)'"><xsl:text>CCSO (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'chargen (Character Generator) (UDP)'"><xsl:text>CHARGEN (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'cmip-man (CMIP/TCP Manager) (UDP)'"><xsl:text>CMIP-Manager (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'daytime (UDP)'"><xsl:text>Daytime (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'discard (UDP)'"><xsl:text>Discard Protocol (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'dns (UDP)'"><xsl:text>DNS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'echo (UDP)'"><xsl:text>Echo (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'unspecified service inspection (UDP)'"><xsl:text>Any UDP Service</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ipp (Internet Printing Protocol) (UDP)'"><xsl:text>IPP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'isakmp'"><xsl:text>ISAKMP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'isakmp (UDP)'"><xsl:text>ISAKMP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kerberos-adm (kerberos administration) (UDP)'"><xsl:text>Kerberos Administration (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'kerberos-iv (kerberos version iv)'"><xsl:text>Kerberos IV</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ldap (Lightweight Directory Access Protocol) (UDP)'"><xsl:text>LDAP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ldaps (ldap protocol over TLS/SSL) (UDP)'"><xsl:text>LDAPS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'MSSQL inspection (UDP)'"><xsl:text>MSSQL (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netbios-dgm (NETBIOS Datagram Service)'"><xsl:text>NetBIOS Datagram</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netbios-ns (NETBIOS Name Service) (UDP)'"><xsl:text>NetBIOS-NS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nfs (Network File System - Sun Microsystems)'"><xsl:text>NFS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nmap (UDP)'"><xsl:text>NMAP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ntp (Network Time Protocol) (UDP)'"><xsl:text>NTP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'ontime (Ontime)'"><xsl:text>Ontime Calendar</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'printer (spooler) (UDP)'"><xsl:text>Printer Spooler (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'radius-acct-old'"><xsl:text>RADIUS Accounting (Old)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'radius-acct'"><xsl:text>RADIUS (Accounting)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'radius-old'"><xsl:text>RADIUS (Old)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'radius'"><xsl:text>RADIUS (Authentication)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'rip (Routing Information Protocol)'"><xsl:text>RIP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'netbios-epmap inspection (NETBIOS DCE-RPC endpoint mapper) (UDP)'"><xsl:text>MSRPC (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'set (Secure Electronic Transaction) (UDP)'"><xsl:text>SET (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-IPSec-UDP encapsulation'"><xsl:text>SG UDP Encapsulation</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-monitor-agent'"><xsl:text>SG Server Pool Monitoring</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-statesync-multi'"><xsl:text>SG State Sync (Multicast)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sip inspection (UDP)'"><xsl:text>SIP Control (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-monitor-agent'"><xsl:text>SG Server Pool Monitoring</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'SG-statesync-multi'"><xsl:text>SG State Sync (Multicast)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'smip-agent (CMIP/TCP Agent) (UDP)'"><xsl:text>CMIP Agent (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'snmptrap (UDP)'"><xsl:text>SNMP Trap (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'snmp (UDP)'"><xsl:text>SNMP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Source Port isakmp'"><xsl:text>Source Port ISAKMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sunrpc (SUN Remote Procedure Call) (UDP)'"><xsl:text>Sun RPC (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'Syslog'"><xsl:text>Syslog (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tacacs (Login Host Protocol) (UDP)'"><xsl:text>TACACS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tftp inspection'"><xsl:text>TFTP Control</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'tftp'"><xsl:text>TFTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'time (UDP)'"><xsl:text>Time (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'vocaltec-phone (Vocaltec Internet Phone Scott Petrack)'"><xsl:text>VocalTec-phone</xsl:text></xsl:when>
			<xsl:when test='$oldservicename = "who (maintains data bases showing who&apos;s)"'><xsl:text>Who</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'utime (unixtime)'"><xsl:text>Utime</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'sprayd'"><xsl:text>Sprayd</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'skip'"><xsl:text>Skip</xsl:text></xsl:when>
			<xsl:when test="$oldservicename = 'nfs'"><xsl:text>nfs (RPC)</xsl:text></xsl:when>
			
			<!-- manage all deleted system services : to be changed with merge service -->
			<xsl:when test="$oldservicename =  'UDP inspection'"><xsl:text>UDP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'TCP inspection'"><xsl:text>TCP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'ICMP inspection'"><xsl:text>ICMP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'dns inspection (TCP)'"><xsl:text>DNS (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'finger inspection (Finger)'"><xsl:text>Finger</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'ftp inspection'"><xsl:text>FTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'https inspection (http protocol over TLS/SSL)'"><xsl:text>HTTPS</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'http inspection'"><xsl:text>HTTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'ident inspection'"><xsl:text>Ident</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'imap inspection (Internet Message Access Protocol) (TCP)'"><xsl:text>IMAP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'ldap inspection (Lightweight Directory Access Protocol) (TCP)'"><xsl:text>LDAP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'netbios-epmap (NETBIOS DCE-RPC endpoint mapper) (TCP)'"><xsl:text>MSRPC (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'netbios-ssn inspection (NETBIOS Session Service)'"><xsl:text>NetBIOS-SSN</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'nntp inspection (Network News Transfer Protocol)'"><xsl:text>NNTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'pop3 inspection (Post Office Protocol - Version 3) (TCP)'"><xsl:text>POP3</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'pptp inspection'"><xsl:text>PPTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'printer inspection (spooler)'"><xsl:text>Printer Spooler (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'microsoft-ds inspection (TCP)'"><xsl:text>MSRPC (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'smtp inspection'"><xsl:text>SMTP</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'snmp inspection (TCP)'"><xsl:text>SNMP (TCP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'ssh inspection'"><xsl:text>SSH</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'telnet inspection (Telnet)'"><xsl:text>Telnet</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'wins server replication inspection'"><xsl:text>WINS Replication</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'x11 inspection (X Window System) (TCP)'"><xsl:text>X11</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'bootp inspection'"><xsl:text>BOOTPS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'dns inspection (UDP)'"><xsl:text>DNS (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'ldap inspection (Lightweight Directory Access Protocol) (UDP)'"><xsl:text>LDAP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'netbios-epmap (NETBIOS DCE-RPC endpoint mapper) (UDP)'"><xsl:text>MSRPC (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'netbios-dgm inspection (NETBIOS Datagram Service)'"><xsl:text>NetBIOS Datagram</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'snmp inspection (UDP)'"><xsl:text>SNMP (UDP)</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'tftp (Trivial File Transfer)'"><xsl:text>TFTP Control</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'SG Log to Management Server'"><xsl:text>SG Log to Management</xsl:text></xsl:when>
			<xsl:when test="$oldservicename =  'Rlogin inspection (TCP)'"><xsl:text>Rlogin</xsl:text></xsl:when>
      		<xsl:otherwise><xsl:value-of select="$oldservicename"/></xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    
    
	<!-- renamed network elements -->
	<xsl:template match="single_sensor|sensor_cluster|analyzer|combined_sensor_analyzer">
		<xsl:copy>
			<xsl:if test="@mgt_server_ref">
				<xsl:attribute name="mgt_server_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@mgt_server_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>
    		<xsl:if test="@recording_log_server_ref">
				<xsl:attribute name="recording_log_server_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@recording_log_server_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>
    		<xsl:if test="@log_server_ref">
				<xsl:attribute name="log_server_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@log_server_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>
    		<xsl:if test="@alert_server_ref">
				<xsl:attribute name="alert_server_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@alert_server_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>
    		<xsl:if test="@analyzer_ref">
				<xsl:attribute name="analyzer_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@analyzer_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="@*[(name(.) != 'mgt_server_ref') and (name(.) != 'recording_log_server_ref') and (name(.) != 'log_server_ref') and (name(.) != 'alert_server_ref') and (name(.) != 'analyzer_ref')]|node()"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="fw_single|fw_cluster">
		<xsl:variable name="fw_name"><xsl:value-of select="@name"/></xsl:variable>
		<xsl:copy>
			<xsl:if test="@mgt_server_ref">
				<xsl:attribute name="mgt_server_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@mgt_server_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>

    		<xsl:if test="@log_server_ref">
				<xsl:attribute name="log_server_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@log_server_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>
			
			<xsl:apply-templates select="@*[(name(.) != 'mgt_server_ref') and (name(.) != 'log_server_ref')]|node()"/>
			<xsl:for-each select="../internal_gateway[@fw_ref=$fw_name][1]/nat_pool">
				<xsl:if test="@nat_pool_enabled='true'">
					<xsl:apply-templates select="."/>
				</xsl:if>
			</xsl:for-each>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="server_pool">
		<xsl:copy>
			<xsl:if test="@dns_server_ref">
				<xsl:attribute name="dns_server_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@dns_server_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="@*[(name(.) != 'dns_server_ref')]|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="netlink">
		<xsl:copy>
			<xsl:attribute name="gateway_ref">
				<xsl:call-template name="replace-old-network-element-name">
			    	<xsl:with-param name="oldnetworkelementname" select="@gateway_ref"/>
			    </xsl:call-template>
			</xsl:attribute>
			<xsl:apply-templates select="@*[(name(.) != 'gateway_ref')]|node()"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="network_rn_level|gateway_rn_level|any_rn_level|storable_asn_level|default_alias_value|expression_value|packet_description|packet_description_new|mvia_association">
		<xsl:copy>
			<xsl:if test="@ne_ref">
				<xsl:attribute name="ne_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@ne_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="@*[(name(.) != 'ne_ref')]|node()"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="network_list|dhcp_server_list|ne_list|auth_service">
		<xsl:copy>
			<xsl:if test="@ref">
				<xsl:attribute name="ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="@*[(name(.) != 'ref')]|node()"/>
		</xsl:copy>
	</xsl:template>
					
	<xsl:template match="netlink_address|ip_netlink_weight">
		<xsl:copy>
			<xsl:if test="@netlink_ref">
				<xsl:attribute name="netlink_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@netlink_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
   			</xsl:if>
			<xsl:if test="@network_ref">
				<xsl:attribute name="network_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@network_ref"/>
				    </xsl:call-template>
				</xsl:attribute>			
			</xsl:if>
			<xsl:apply-templates select="@*[(name(.) != 'netlink_ref') and (name(.) != 'network_ref')]|node()"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="alias_value">
		<xsl:copy>
			<xsl:attribute name="fw_ref">
				<xsl:call-template name="replace-old-network-element-name">
			    	<xsl:with-param name="oldnetworkelementname" select="@fw_ref"/>
			    </xsl:call-template>
			</xsl:attribute>
			<xsl:apply-templates select="@*[(name(.) != 'fw_ref')]|node()"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="blacklisting_fw_cvi|granted_policy_ref">
		<xsl:copy>
			<xsl:if test="@engine_ref">
				<xsl:attribute name="engine_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@engine_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="@*[(name(.) != 'engine_ref')]|node()"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="authentication_server">
		<xsl:copy>
			<xsl:if test="@auth_server_ref">
				<xsl:attribute name="auth_server_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@auth_server_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>			
			<xsl:apply-templates select="@*[(name(.) != 'auth_server_ref')]|node()"/>
		</xsl:copy>
	</xsl:template>

	<xsl:template match="ldap_ref">
		<xsl:copy>
			<xsl:if test="@value">
				<xsl:attribute name="value">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@value"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>
			<xsl:apply-templates select="@*[(name(.) != 'value')]|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="access_rule|nat_rule">
		<xsl:copy>
			<xsl:if test="@valid_fw_ref">
				<xsl:attribute name="valid_fw_ref">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@valid_fw_ref"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>				
			<xsl:apply-templates select="@*[(name(.) != 'valid_fw_ref')]|node()"/>
		</xsl:copy>
	</xsl:template>
	
	<xsl:template match="match_source_ref|match_destination_ref|granted_blacklister_ref|match_sender_ref|list_entry">
		<xsl:choose>
			<xsl:when test="@type='network_element'">
				<xsl:copy>
					<xsl:attribute name="value">
						<xsl:call-template name="replace-old-network-element-name">
						    <xsl:with-param name="oldnetworkelementname" select="@value"/>
			    		</xsl:call-template>
					</xsl:attribute>
					<xsl:apply-templates select="@*[name(.) != 'value']|node()"/>
				</xsl:copy>
			</xsl:when>
			<xsl:otherwise>
				<xsl:copy>
					<xsl:apply-templates select="@*|node()"/>
				</xsl:copy>
			</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>
	
	<xsl:template match="reference[@type='network_element']">
		<xsl:copy>
			<xsl:if test="@ref_subobject_name">
				<xsl:attribute name="ref_subobject_name">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@ref_subobject_name"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>				
			<xsl:if test="@ref_object_name">
				<xsl:attribute name="ref_object_name">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@ref_object_name"/>
				    </xsl:call-template>
				</xsl:attribute>			
			</xsl:if>				
			<xsl:apply-templates select="@*[(name(.) != 'ref_subobject_name') and (name(.) != 'ref_object_name')]|node()"/>
		</xsl:copy>
	</xsl:template>			
	
	<xsl:template match="mgt_server|alias">
		<xsl:copy>
			<xsl:if test="@name">
				<xsl:attribute name="name">
					<xsl:call-template name="replace-old-network-element-name">
				    	<xsl:with-param name="oldnetworkelementname" select="@name"/>
				    </xsl:call-template>
				</xsl:attribute>
			</xsl:if>				
			<xsl:apply-templates select="@*[(name(.) != 'name')]|node()"/>
		</xsl:copy>
	</xsl:template>

    <xsl:template name="replace-old-network-element-name">
			<xsl:param name="oldnetworkelementname"/>
		<xsl:choose>
			<xsl:when test="$oldnetworkelementname = 'Local Management Server'"><xsl:text>Management Server</xsl:text></xsl:when>
			<xsl:when test="$oldnetworkelementname = '$$ Management Server'"><xsl:text>$$ Management Servers</xsl:text></xsl:when>
			<xsl:when test="$oldnetworkelementname = '$$ Log Server'"><xsl:text>$$ Log Servers</xsl:text></xsl:when>
			<xsl:otherwise><xsl:value-of select="$oldnetworkelementname"/></xsl:otherwise>
		</xsl:choose>
    </xsl:template>
    
    <!-- Filter Type 'System IPS 1.2' and the elements in it deleted -->
    <xsl:template match="category[@key='10030002']">
    </xsl:template>
    <xsl:template match="filter_expression[category_ref/@value='10030002']">
    </xsl:template>
</xsl:stylesheet>
