/*
 * Decompiled with CFR 0.152.
 */
package com.portwise.mvpnms.authentication.certificate;

import com.portwise.core.e.rb;
import com.portwise.core.e.u;
import com.portwise.core.logging.b;
import com.portwise.mvpnms.authentication.certificate.a;
import com.portwise.mvpnms.authentication.certificate.g;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Principal;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;

public class e {
    private static final String a = "serialnumber";
    private static final String c = "subjectaltname-";
    private static final String b = "subject-";
    private static final String d = "1.3.6.1.4.1.311.20.2.3";
    private static b e = new b();

    public static String retrieveAttributeValue(X509Certificate x509Certificate, String string) throws g {
        String string2 = null;
        if (string.startsWith(b)) {
            String string3 = string.substring(b.length());
            string2 = com.portwise.mvpnms.authentication.certificate.e.c(x509Certificate, string3);
        } else if (string.startsWith(c)) {
            String string4 = string.substring(c.length());
            string2 = com.portwise.mvpnms.authentication.certificate.e.a(x509Certificate, string4);
        } else if (string.startsWith(a)) {
            String string5 = string.substring(a.length());
            string2 = com.portwise.mvpnms.authentication.certificate.e.b(x509Certificate, string5);
        } else {
            string2 = com.portwise.mvpnms.authentication.certificate.e.c(x509Certificate, string);
        }
        if (string2 == null) {
            com.portwise.mvpnms.authentication.certificate.e.e.m.b("Certificate contained no " + string);
            throw new g("Certificate contained no " + string);
        }
        return string2;
    }

    private static String b(X509Certificate x509Certificate, String string) {
        BigInteger bigInteger = x509Certificate.getSerialNumber();
        com.portwise.mvpnms.authentication.certificate.e.e.m.e("Retrieved serial number {0}.", bigInteger);
        if (string.startsWith("-")) {
            string = string.substring(1);
        }
        int n2 = 10;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        com.portwise.mvpnms.authentication.certificate.e.e.m.e("Returning {0} (radix {1}).", new Object[]{bigInteger.toString(n2), new Integer(n2)});
        return bigInteger.toString(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String a(X509Certificate x509Certificate, String string) throws g {
        boolean bl = com.portwise.mvpnms.authentication.certificate.a.g;
        com.portwise.mvpnms.authentication.certificate.e.e.m.e("Retrieve subjectaltname for {0}.", string);
        Collection<List<?>> collection = null;
        try {
            collection = x509Certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        if (collection == null) {
            com.portwise.mvpnms.authentication.certificate.e.e.m.b("Certificate contained no SubjectAltName.");
            throw new g("Certificate contained no SubjectAltName.");
        }
        String string2 = null;
        for (List<?> list : collection) {
            Integer n2 = (Integer)list.get(0);
            com.portwise.mvpnms.authentication.certificate.e.e.m.e("SubjectAltName, Type: {0}.", n2);
            switch (n2) {
                case 0: {
                    byte[] byArray = (byte[])list.get(1);
                    if (!string.equalsIgnoreCase("principalname")) break;
                    string2 = com.portwise.mvpnms.authentication.certificate.e.retrievePrincipalNameValue(byArray);
                    if (!bl) break;
                }
                case 1: {
                    if (!string.equalsIgnoreCase("emailaddress") && !string.equalsIgnoreCase("rfc822name")) break;
                    string2 = (String)list.get(1);
                    if (!bl) break;
                }
                case 2: {
                    if (!string.equalsIgnoreCase("dnsname")) break;
                    string2 = (String)list.get(1);
                    if (!bl) break;
                }
                case 3: {
                    throw new g("SubjectAltName X400 is not supported");
                }
                case 4: {
                    if (!string.equalsIgnoreCase("directoryname")) break;
                    string2 = (String)list.get(1);
                    if (!bl) break;
                }
                case 5: {
                    throw new g("SubjectAltName EDI is not supported");
                }
                case 6: {
                    if (!string.equalsIgnoreCase("uniformResourceIdentifier")) break;
                    string2 = (String)list.get(1);
                    if (!bl) break;
                }
                case 7: {
                    if (!string.equalsIgnoreCase("ipaddress")) break;
                    byte[] byArray = (byte[])list.get(1);
                    try {
                        InetAddress inetAddress = InetAddress.getByAddress(byArray);
                        string2 = inetAddress.getHostAddress();
                    }
                    catch (UnknownHostException unknownHostException) {
                        com.portwise.mvpnms.authentication.certificate.e.e.m.e("Unable to get IP from quad-dotted byte array.");
                        throw new g("Unable to parse SubjectAltName IPAddress. IP byte array:" + new String(byArray));
                    }
                    if (!bl) break;
                }
                case 8: {
                    if (!string.equalsIgnoreCase("registeredid")) break;
                    string2 = (String)list.get(1);
                    if (!bl) break;
                }
                default: {
                    throw new g("Unsupported type " + n2 + " in SubjectAltName.");
                }
            }
            com.portwise.mvpnms.authentication.certificate.e.e.m.e("Retrieved attribute {0} with value {1}.", new Object[]{string, string2});
            if (!bl) continue;
        }
        if (string2 == null) {
            com.portwise.mvpnms.authentication.certificate.e.e.m.b("Attribute name not found.");
            throw new g("SubjectAltName did not contain attribute name: " + string);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String retrievePrincipalNameValue(byte[] byArray) throws g {
        boolean bl = com.portwise.mvpnms.authentication.certificate.a.g;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        DERSequence dERSequence = null;
        boolean bl2 = false;
        String string = null;
        try {
            dERSequence = (DERSequence)aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new g("Caught " + iOException + " when reading DER object from SubjectAltName type 0.");
        }
        catch (Exception exception) {
            com.portwise.mvpnms.authentication.certificate.e.e.m.e("Received an exception. E: {0}", exception.getMessage());
            throw new g("Caught " + exception + " when parsing DER sequence from SubjectAltName type 0.");
        }
        Enumeration enumeration = dERSequence.getObjects();
        while (enumeration.hasMoreElements()) {
            DERObjectIdentifier dERObjectIdentifier;
            Object e2 = enumeration.nextElement();
            if (e2 instanceof DERObjectIdentifier) {
                dERObjectIdentifier = (DERObjectIdentifier)e2;
                com.portwise.mvpnms.authentication.certificate.e.e.m.b("oid: " + dERObjectIdentifier.getId());
                if (dERObjectIdentifier.getId().equalsIgnoreCase(d)) {
                    bl2 = true;
                }
                if (!bl) continue;
            }
            if (!(e2 instanceof DERTaggedObject)) continue;
            try {
                dERObjectIdentifier = (DERTaggedObject)e2;
                DERTaggedObject dERTaggedObject = (DERTaggedObject)dERObjectIdentifier.getObject();
                DERUTF8String dERUTF8String = (DERUTF8String)dERTaggedObject.getObject();
                com.portwise.mvpnms.authentication.certificate.e.e.m.b("dus: " + dERUTF8String.getString());
                if (!bl2) continue;
                string = dERUTF8String.getString();
                break;
            }
            catch (Exception exception) {
                com.portwise.mvpnms.authentication.certificate.e.e.m.e("Received an exception. E: {0}", exception.getMessage());
                throw new g("Caught " + exception + " when parsing DER object from SubjectAltName type 0.");
            }
        }
        if (string == null) {
            throw new g("SubjectAltName did not contain principalname value.");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String c(X509Certificate x509Certificate, String string) throws g {
        boolean bl = com.portwise.mvpnms.authentication.certificate.a.g;
        String string2 = null;
        Principal principal = x509Certificate.getSubjectDN();
        String string3 = ((Object)principal).toString().trim();
        com.portwise.mvpnms.authentication.certificate.e.e.m.e("Subject DN: " + string3);
        rb rb2 = new rb(string3);
        Vector vector = rb2.d();
        if (string.equalsIgnoreCase("subject") || string.length() == 0) {
            string2 = string3;
            com.portwise.mvpnms.authentication.certificate.e.e.m.e("Entire Subject DN retrieved: " + string2);
            return string2;
        }
        for (int i2 = 0; vector != null && i2 < vector.size(); ++i2) {
            u u2 = (u)vector.get(i2);
            boolean bl2 = u2.c();
            String[] stringArray = u2.b();
            String[] stringArray2 = u2.getValues();
            for (int n2 = 0; stringArray != null && stringArray2 != null && n2 < stringArray.length; ++n2) {
                if (!stringArray[n2].equalsIgnoreCase(string)) continue;
                string2 = stringArray2[n2];
                if (string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
                    string2 = string2.substring(1, string2.length() - 1);
                }
                com.portwise.mvpnms.authentication.certificate.e.e.m.e("Subject DN sub-set attribute retrieved: " + string2);
                return string2;
            }
            if (!bl) continue;
        }
        throw new g("Subject DN did not contain attribute name: " + string);
    }
}

