/*
 * Decompiled with CFR 0.152.
 */
package com.portwise.mvpnms.authentication.certificate;

import com.portwise.core.controller.authentication.MechanismConfiguration;
import com.portwise.core.controller.authentication.a.b;
import com.portwise.core.d.c;
import com.portwise.core.e.z;
import com.portwise.core.logging.cb;
import com.portwise.core.logging.o;
import com.portwise.core.session.i;
import com.portwise.core.session.j;
import com.portwise.core.storage.DirectoryConfiguration;
import com.portwise.core.storage.gb;
import com.portwise.core.storage.u;
import com.portwise.mvpnms.authentication.BaseAuthenticationPlugin;
import com.portwise.mvpnms.authentication.certificate.a;
import com.portwise.mvpnms.authentication.certificate.d;
import com.portwise.mvpnms.authentication.certificate.e;
import com.portwise.mvpnms.authentication.certificate.g;
import com.portwise.mvpnms.authentication.certificate.h;
import com.portwise.mvpnms.authentication.f;
import com.portwise.mvpnms.authentication.n;
import java.io.ByteArrayInputStream;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Certificate
extends BaseAuthenticationPlugin {
    private static final String Y = "log enabled";
    private static final String X = "log folder";
    private static final String ab = "log count";
    private static final String U = "log limit";
    private static final String S = "log only on success";
    private static final String Z = "send certificate error";
    private static final String R = "|";
    private static final int W = 1001;
    private static final int T = 1002;
    private static final int V = 2001;
    private Logger mCertificateLogger = null;
    private boolean mLogOnlyOnSuccess = true;
    private boolean mSendCertError = false;
    private String mCaKey;
    private boolean mMapping = false;
    private String mUserAttribute = null;
    private String mCertificateAttribute = null;
    private boolean mAllowUnknownUser = false;
    private d mOcspClientValidator;
    private String mOcspResponderURL;
    private String mOcspCertificateName;
    private boolean mOscpAIA = false;

    @Override
    public boolean a(n n2, f f2) {
        super.a(n2, f2);
        if (!com.portwise.core.k.e.a("Authentication Method/Certificate", true)) {
            return false;
        }
        return this.b(n2, f2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean b(n n2, f f2) {
        block90: {
            void var15_21;
            c c2;
            block94: {
                block95: {
                    Object object;
                    boolean bl;
                    block92: {
                        block93: {
                            boolean bl2;
                            block91: {
                                String string;
                                String string2;
                                String string3;
                                block87: {
                                    int n3;
                                    int n4;
                                    String string4;
                                    String string5;
                                    String string6;
                                    block86: {
                                        bl = a.g;
                                        Vector vector = n2.j();
                                        boolean bl3 = false;
                                        string6 = this.e().h();
                                        string5 = "logs/cert%g.log, 3, 1000000";
                                        string4 = "logs";
                                        n4 = 3;
                                        n3 = 1000;
                                        this.mLogOnlyOnSuccess = true;
                                        string3 = this.e().i();
                                        string2 = null;
                                        string = null;
                                        bl2 = false;
                                        for (int i2 = 0; i2 < vector.size(); ++i2) {
                                            Certificate.Q.m.b("Reading Extended Properties...");
                                            MechanismConfiguration mechanismConfiguration = (MechanismConfiguration)vector.get(i2);
                                            object = mechanismConfiguration.getKey().trim();
                                            String string7 = mechanismConfiguration.getValue().trim();
                                            if (((String)object).equalsIgnoreCase(Y)) {
                                                if (string7.equalsIgnoreCase("false")) continue;
                                                bl3 = true;
                                                if (!bl) continue;
                                            }
                                            if (((String)object).equalsIgnoreCase(X)) {
                                                string4 = string7;
                                                if (!bl) continue;
                                            }
                                            if (((String)object).equalsIgnoreCase(ab)) {
                                                try {
                                                    n4 = Integer.parseInt(string7);
                                                    continue;
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    Certificate.Q.m.a("Authentication Mechanism start: Illegal value for log rotation count ({0}). Must be an integer.", string7);
                                                    return false;
                                                }
                                            }
                                            if (((String)object).equalsIgnoreCase(U)) {
                                                try {
                                                    n3 = Integer.parseInt(string7);
                                                    continue;
                                                }
                                                catch (NumberFormatException numberFormatException) {
                                                    Certificate.Q.m.a("Authentication Mechanism start: Illegal value for log rotation limit ({0}). Must be an integer.", string7);
                                                    return false;
                                                }
                                            }
                                            if (((String)object).equalsIgnoreCase(S)) {
                                                if (!string7.equalsIgnoreCase("false")) continue;
                                                this.mLogOnlyOnSuccess = false;
                                                if (!bl) continue;
                                            }
                                            if (((String)object).equalsIgnoreCase(Z)) {
                                                if (!string7.equalsIgnoreCase("true")) continue;
                                                this.mSendCertError = true;
                                                if (!bl) continue;
                                            }
                                            if (((String)object).equalsIgnoreCase("user attribute mapping")) {
                                                if (!string7.equalsIgnoreCase("disabled") && string7.length() != 0) {
                                                    string2 = string7;
                                                    Certificate.Q.m.d("Read user attribute mapping: {0}", string2);
                                                    if (!bl) continue;
                                                }
                                                Certificate.Q.m.e("User attribute mapping disabled.");
                                                if (!bl) continue;
                                            }
                                            if (((String)object).equalsIgnoreCase("certificate attribute mapping")) {
                                                if (!string7.equalsIgnoreCase("disabled") && string7.length() != 0) {
                                                    string = string7;
                                                    Certificate.Q.m.d("Read certificate attribute mapping: {0}", string);
                                                    if (!bl) continue;
                                                }
                                                Certificate.Q.m.e("Certificate attribute mapping disabled.");
                                                if (!bl) continue;
                                            }
                                            if (((String)object).equalsIgnoreCase("allow unknown user")) {
                                                if (!string7.equalsIgnoreCase("false")) {
                                                    bl2 = true;
                                                    Certificate.Q.m.e("Allow unknown user certificate authentication.");
                                                    if (!bl) continue;
                                                }
                                                Certificate.Q.m.e("Do NOT allow unknown user certificate authentication.");
                                                if (!bl) continue;
                                            }
                                            if (((String)object).equalsIgnoreCase("ocsp responder url")) {
                                                if (string7 != null && string7.length() > 0) {
                                                    this.mOcspResponderURL = string7;
                                                    Certificate.Q.m.c("OCSP Responder URL {0}", this.mOcspResponderURL);
                                                    if (!bl) continue;
                                                }
                                                this.mOcspResponderURL = null;
                                                Certificate.Q.m.e("No OCSP Responder URL configured.");
                                                if (!bl) continue;
                                            }
                                            if (((String)object).equalsIgnoreCase("ocsp certificate name")) {
                                                if (string7 != null && string7.length() > 0) {
                                                    this.mOcspCertificateName = string7;
                                                    Certificate.Q.m.c("OCSP certificate {0}", this.mOcspCertificateName);
                                                    if (!bl) continue;
                                                }
                                                this.mOcspCertificateName = null;
                                                Certificate.Q.m.e("No OCSP certificate configured.");
                                                if (!bl) continue;
                                            }
                                            if (!((String)object).equalsIgnoreCase("ocsp aia only")) continue;
                                            if (!string7.equalsIgnoreCase("false")) {
                                                this.mOscpAIA = true;
                                                Certificate.Q.m.c("OCSP AIA is enabled.");
                                                if (!bl) continue;
                                            }
                                            Certificate.Q.m.e("OCSP AIA is disabled.");
                                            if (!bl) continue;
                                        }
                                        if (bl3) break block86;
                                        this.mCertificateLogger = null;
                                        Certificate.Q.m.c("Certificate logging disabled");
                                        if (!bl) break block87;
                                    }
                                    try {
                                        block89: {
                                            block88: {
                                                if (n4 <= 0) break block88;
                                                string5 = string4 + "/" + string6 + "-%g.log, " + n4 + ", " + n3 * 1000;
                                                if (!bl) break block89;
                                            }
                                            string5 = string4 + "/" + string6 + ".log";
                                        }
                                        this.mCertificateLogger = this.a(string6, string5);
                                    }
                                    catch (com.portwise.core.logging.a a2) {
                                        Certificate.Q.m.a("Authentication Mechanism start: Couldn't set target for certificate logging: {0}", a2.getMessage());
                                        return false;
                                    }
                                    Certificate.Q.m.c("Certificate log enabled");
                                    Certificate.Q.m.c("Certificate log target = {0}", string5);
                                    Certificate.Q.m.c("Certificate log only on success = {0}", new Boolean(this.mLogOnlyOnSuccess));
                                }
                                c2 = null;
                                if (string3 == null || string3.length() <= 0) break block90;
                                this.mCaKey = string3;
                                c2 = this.g();
                                if (c2 == null) {
                                    Certificate.Q.m.a("Authentication Mechanism start: Received no CA. Check configuration parameter CA name.");
                                    return false;
                                }
                                if (c2.f() == 0) {
                                    Certificate.Q.m.c("Authentication Mechanism start: CA {0} is disabled. Not able to perform authentication.", c2.e());
                                    return false;
                                }
                                if (string != null) {
                                    this.mCertificateAttribute = string;
                                    Certificate.Q.m.c("Authentication Mechanism start: certificate attribute {0}.", this.mCertificateAttribute);
                                }
                                if (string2 != null) {
                                    this.mUserAttribute = string2;
                                    Certificate.Q.m.c("Authentication Mechanism start: username attribute {0}.", this.mUserAttribute);
                                }
                                if (string2 == null || this.mCertificateAttribute == null) break block91;
                                this.mMapping = true;
                                Certificate.Q.m.c("Authentication Mechanism start: Configured for certificate/user attribute mapping with user attribute {0} and certificate attribute {1}.", new Object[]{this.mUserAttribute, this.mCertificateAttribute});
                                if (!bl) break block92;
                            }
                            if (!bl2) break block93;
                            Certificate.Q.m.c("Authentication Mechanism start: Configured for 'allow unknown user certificate'-to-user binding.");
                            this.mAllowUnknownUser = true;
                            if (!bl) break block92;
                        }
                        Certificate.Q.m.c("Authentication Mechanism start: Configured for default certificate-to-user binding.");
                    }
                    if (this.mOcspResponderURL == null && this.mOcspCertificateName == null) {
                        if (!this.mOscpAIA) return true;
                    }
                    X509Certificate x509Certificate = c2.g();
                    if (this.mOcspCertificateName == null) break block94;
                    object = this.e(this.mOcspCertificateName);
                    if (object == null) break block95;
                    X509Certificate x509Certificate2 = ((c)object).g();
                    if (!bl) break block94;
                }
                Certificate.Q.m.a("Failed to load OCSP certificate with name: {0}", this.mOcspCertificateName);
                return false;
            }
            boolean bl = Integer.parseInt(System.getProperty("com.portwise.mvpnms.authentication.certificate.ocsp_providers", "0")) > 1;
            this.mOcspClientValidator = new d(this.mOcspResponderURL, c2.g(), (X509Certificate)var15_21, bl);
            Security.setProperty("ocsp.enable", "true");
            Certificate.Q.m.c("OCSP validation enabled.");
            return true;
        }
        Certificate.Q.m.a("Authentication Mechanism start: Received no CA. Check configuration parameter CA name.");
        return false;
    }

    private Logger a(String string, String string2) throws com.portwise.core.logging.a {
        Logger logger = Logger.getLogger(string);
        logger.setUseParentHandlers(false);
        o o2 = this.b(logger);
        if (o2 != null) {
            o2.close();
        }
        this.a(logger);
        o2 = new o();
        o2.setFormatter(new cb("%t %L %M", false));
        o2.a(string2);
        logger.addHandler(o2);
        return logger;
    }

    private o b(Logger logger) {
        boolean bl = a.g;
        Handler[] handlerArray = logger.getHandlers();
        for (int i2 = 0; i2 < handlerArray.length; ++i2) {
            if (!(handlerArray[i2] instanceof o)) continue;
            return (o)handlerArray[i2];
        }
        return null;
    }

    private void a(Logger logger) {
        boolean bl = a.g;
        Handler[] handlerArray = logger.getHandlers();
        for (int i2 = 0; i2 < handlerArray.length; ++i2) {
            logger.removeHandler(handlerArray[i2]);
            if (!bl) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public com.portwise.mvpnms.controller.authentication.d a(com.portwise.mvpnms.controller.authentication.c c2) {
        Object object;
        Object object2;
        String string;
        com.portwise.mvpnms.controller.authentication.d d2;
        X509Certificate x509Certificate;
        block27: {
            block25: {
                boolean bl;
                block28: {
                    block26: {
                        bl = a.g;
                        byte[] byArray = this.b(c2);
                        if (byArray == null) {
                            Certificate.Q.m.e("Challenge user");
                            return this.a(2, "Challenge for client certificate", null);
                        }
                        x509Certificate = this.a(byArray);
                        if (x509Certificate == null) {
                            Certificate.Q.m.e("Unable to parse client certificate");
                            return this.a(1, "Invalid user certificate", null);
                        }
                        d2 = this.e(x509Certificate);
                        if (d2.j() == 0) break block26;
                        Certificate.Q.m.e("The certificate was not approved.");
                        if (!bl) break block27;
                    }
                    if ((d2 = this.b(x509Certificate)).j() == 0) break block28;
                    Certificate.Q.m.e("The certificate was not associated to a user.");
                    if (!bl) break block27;
                }
                d2.a("User '" + d2.l() + "' authenticated.");
                string = c2.c();
                if (string == null) {
                    object2 = i.C().b();
                    try {
                        object = null;
                        object = ((j)object2).c();
                        if (object == null) {
                            Certificate.Q.m.a("Session limit reached. Trying to store Certificate attributes on session.");
                            if (!bl) break block25;
                        }
                        ((j)object2).a((com.portwise.core.session.e)object);
                        d2.e(((com.portwise.core.session.e)object).j());
                        string = ((com.portwise.core.session.e)object).j();
                        i.C().b((com.portwise.core.session.e)object);
                    }
                    finally {
                        i.C().a((j)object2);
                    }
                }
            }
            if (string != null) {
                try {
                    object2 = this.g();
                    object = null;
                    if (object2 != null) {
                        object = ((c)object2).g();
                    }
                    b.a(string, x509Certificate, (X509Certificate)object);
                }
                catch (Exception exception) {
                    object = "Could not persist certificate information in session. " + exception.getMessage();
                    Certificate.Q.m.a((String)object);
                }
            }
        }
        if (this.mCertificateLogger == null) return d2;
        if (d2.j() != 0) {
            if (this.mLogOnlyOnSuccess) return d2;
        }
        string = z.b(x509Certificate.getNotBefore());
        object2 = z.b(x509Certificate.getNotAfter());
        object = new StringBuffer();
        ((StringBuffer)object).append(com.portwise.core.logging.d.d(this.e().h()));
        ((StringBuffer)object).append(' ');
        ((StringBuffer)object).append(com.portwise.core.logging.d.d(x509Certificate.getIssuerDN().getName()));
        ((StringBuffer)object).append(' ');
        ((StringBuffer)object).append(com.portwise.core.logging.d.d(((Object)x509Certificate.getSubjectDN()).toString()));
        ((StringBuffer)object).append(' ');
        ((StringBuffer)object).append(string);
        ((StringBuffer)object).append(' ');
        ((StringBuffer)object).append((String)object2);
        String string2 = ((StringBuffer)object).toString();
        try {
            x509Certificate.checkValidity();
            this.mCertificateLogger.log(Level.INFO, string2);
            return d2;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            this.mCertificateLogger.log(Level.WARNING, string2);
            return d2;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            this.mCertificateLogger.log(Level.WARNING, string2);
        }
        return d2;
    }

    protected byte[] b(com.portwise.mvpnms.controller.authentication.c c2) {
        com.portwise.mvpnms.controller.authentication.h h2 = c2.a();
        byte[] byArray = h2.a("usercertificate");
        if (byArray == null) {
            byArray = h2.a("certificate");
        }
        if (byArray == null) {
            return null;
        }
        return byArray;
    }

    protected com.portwise.mvpnms.controller.authentication.d e(X509Certificate x509Certificate) {
        Object object;
        c c2 = this.g();
        if (c2 == null) {
            Certificate.Q.m.a("Authentication Mechanism authenticate: Unknown CA");
            return this.a(3, "Unknown CA", c2, null);
        }
        ArrayList<c> arrayList = new ArrayList<c>();
        arrayList.add(c2);
        try {
            object = new com.portwise.core.d.b.c(x509Certificate, null, arrayList);
            ((com.portwise.core.d.b.c)object).a();
        }
        catch (com.portwise.core.d.b.g g2) {
            return this.a(1, g2.getMessage(), c2, x509Certificate, g2.a());
        }
        catch (com.portwise.core.d.b.f f2) {
            return this.a(1, f2.getMessage(), c2, x509Certificate, 2001);
        }
        if (this.mOcspClientValidator != null) {
            Certificate.Q.m.e("Performing OCSP validation...");
            object = this.mOcspClientValidator.a(x509Certificate);
            Certificate.Q.m.e("OCSP reply: " + (String)object);
            if (object != null) {
                return this.a(1, "OCSP reply: " + (String)object, this.g(), x509Certificate);
            }
            Certificate.Q.m.e("OCSP certificate validation succeeded.");
        }
        Certificate.Q.m.e("Certificate is validated. Returning success.");
        return new com.portwise.mvpnms.controller.authentication.d(0);
    }

    private c g() {
        c c2 = null;
        try {
            c2 = com.portwise.mvpnms.controller.authentication.a.a.b().a(this.mCaKey);
        }
        catch (gb gb2) {
            c2 = null;
        }
        return c2;
    }

    private c e(String string) {
        c c2 = null;
        try {
            c2 = com.portwise.mvpnms.controller.authentication.a.a.b().b(string);
        }
        catch (gb gb2) {
            Certificate.Q.m.b("Failed to load CA with name {0}, {1}", new Object[]{string, gb2.getMessage()});
            c2 = null;
        }
        return c2;
    }

    protected com.portwise.mvpnms.controller.authentication.d b(X509Certificate x509Certificate) {
        h h2;
        c c2;
        block10: {
            block11: {
                Object object;
                c2 = this.g();
                if (c2 == null) {
                    Certificate.Q.m.a("Authentication Mechanism authenticate: Unknown CA");
                    return this.a(3, "Unknown CA", c2, null);
                }
                Certificate.Q.m.e("Fetching username based on certificate.");
                h2 = this.d(x509Certificate);
                if (h2.a()) break block10;
                if (!this.mAllowUnknownUser) break block11;
                Certificate.Q.m.e("Allowing unknown user.");
                String string = null;
                if (this.mCertificateAttribute != null) {
                    try {
                        object = e.retrieveAttributeValue(x509Certificate, this.mCertificateAttribute);
                        if (object != null) {
                            string = object;
                            Certificate.Q.m.a("Setting username to certificate attribute {0}: {1}.", new Object[]{this.mCertificateAttribute, string});
                        }
                    }
                    catch (g g2) {
                        Certificate.Q.m.b("Could not assign username based on certificate attribute {0}, {1}", new Object[]{this.mCertificateAttribute, g2});
                    }
                }
                if (string == null) {
                    string = x509Certificate.getSubjectDN().getName();
                    Certificate.Q.m.d("Setting username to subject DN: {0}.", string);
                }
                object = this.a(0, "Unknown user. Returning Subject DN as username.", c2, x509Certificate);
                ((com.portwise.mvpnms.controller.authentication.d)object).d(string);
                return object;
            }
            Certificate.Q.m.e("Client certificate not bound to an user. Reply not authenticated.");
            return this.a(1, h2.c(), c2, null);
        }
        String string = h2.b();
        Certificate.Q.m.d("User {0} successfully bound to certificate.", string);
        com.portwise.mvpnms.controller.authentication.d d2 = this.a(0, null, c2, x509Certificate);
        d2.d(string);
        return d2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected h d(X509Certificate x509Certificate) {
        h h2;
        boolean bl = a.g;
        if (DirectoryConfiguration.R().W()) {
            h2 = new h(1);
            h2.b("No Directory Service registered.");
            if (!bl) return h2;
        }
        if (!this.mMapping) return this.c(x509Certificate);
        h2 = this.a(x509Certificate);
        if (!bl) return h2;
        return this.c(x509Certificate);
    }

    private h c(X509Certificate x509Certificate) {
        h h2 = new h();
        try {
            Certificate.Q.m.e("Retrieving user based on certificate with normal user bind.");
            com.portwise.mvpnms.controller.e.a a2 = com.portwise.mvpnms.controller.e.a.a(x509Certificate);
            if (a2 != null) {
                h2.a(a2.d().n());
                Certificate.Q.m.d("Username: {0}", a2.d().n());
                return h2;
            }
            Certificate.Q.m.e("No user found.");
        }
        catch (gb gb2) {
            // empty catch block
        }
        h2.b("Client certificate not associated with a user");
        return h2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected h a(X509Certificate x509Certificate) {
        h h2 = new h();
        if (x509Certificate != null && this.mMapping && this.mUserAttribute != null && this.mCertificateAttribute != null) {
            return this.a(x509Certificate, this.mCertificateAttribute, this.mUserAttribute);
        }
        h2.b("Client certificate did not qualify for mapping to an user");
        return h2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private h a(X509Certificate x509Certificate, String string, String string2) {
        h h2 = new h();
        Certificate.Q.m.e("User/Certificate attribute mapping.");
        String string3 = null;
        boolean bl = false;
        String string4 = null;
        try {
            string3 = e.retrieveAttributeValue(x509Certificate, string);
            bl = true;
        }
        catch (g g2) {
            string4 = g2.getMessage();
            bl = false;
        }
        if (!bl) {
            Certificate.Q.m.a("Retrieving cert.attr. {0} received error message: {1}.", new Object[]{string, string4});
            h2.b("Client certificate failed 'user/certificate' attribute mapping" + this.a(x509Certificate, x509Certificate.getSubjectDN().getName()) + ". MSG: " + string4);
            return h2;
        }
        com.portwise.core.storage.n n2 = null;
        try {
            n2 = u.h().a(string2, string3);
        }
        catch (gb gb2) {
            n2 = null;
        }
        if (n2 == null) {
            Certificate.Q.m.a("Found no unique connection element for user with user attribute: '{0}' set to value: '{1}'", new Object[]{this.mUserAttribute, string3});
            Certificate.Q.m.e("User/Certificate attribute mapping failed.");
            h2.b("No unique user found for certificate/user attribute mapping" + this.a(x509Certificate, x509Certificate.getSubjectDN().getName()));
            return h2;
        }
        if (n2.b() != null && n2.b().length() > 0) {
            Certificate.Q.m.e("User/Certificate attributes matched.");
            h2.a(n2.b());
            return h2;
        }
        h2.b("Client certificate did not qualify for mapping to an user" + this.a(x509Certificate, x509Certificate.getSubjectDN().getName()));
        return h2;
    }

    private String a(X509Certificate x509Certificate, String string) {
        return ". Subject DN: " + string + ". Serial nr: " + x509Certificate.getSerialNumber().toString(16);
    }

    protected com.portwise.mvpnms.controller.authentication.d a(int n2, String string, X509Certificate x509Certificate) {
        return this.a(n2, string, this.g(), x509Certificate);
    }

    private com.portwise.mvpnms.controller.authentication.d a(int n2, String string, c c2, X509Certificate x509Certificate) {
        return this.a(n2, string, c2, x509Certificate, 2001);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private com.portwise.mvpnms.controller.authentication.d a(int var1_1, String var2_2, c var3_3, X509Certificate var4_4, int var5_5) {
        var11_6 = a.g;
        var6_7 = new com.portwise.mvpnms.controller.authentication.d(var1_1);
        var7_8 = var2_2;
        switch (var1_1) {
            case 3: {
                if (!var11_6) break;
            }
            case 1: {
                if (this.mSendCertError) {
                    var8_9 = new com.portwise.mvpnms.controller.authentication.h();
                    var7_8 = var5_5 + "|" + var7_8;
                    var8_9.a("certError", var7_8.getBytes());
                    var6_7.a((com.portwise.mvpnms.controller.authentication.h)var8_9);
                }
                if (var4_4 == null) break;
                var8_9 = this.d(var4_4);
                var9_10 = var8_9.b();
                if (!var8_9.a() || var9_10 == null) ** GOTO lbl23
                var10_11 = var6_7.e();
                if (var10_11 == null) {
                    var10_11 = new com.portwise.mvpnms.controller.authentication.h();
                }
                var10_11.a("username", var9_10.getBytes());
                var6_7.a((com.portwise.mvpnms.controller.authentication.h)var10_11);
                if (!var11_6) ** GOTO lbl30
lbl23:
                // 2 sources

                var7_8 = var7_8 == null ? "" : var7_8;
                var10_11 = new StringBuffer(var7_8);
                var10_11.append(". ");
                var10_11.append(var8_9.c());
                var7_8 = var10_11.toString();
lbl30:
                // 2 sources

                if (!var11_6) break;
            }
            case 2: {
                var6_7.c(var3_3.e());
                break;
            }
        }
        var6_7.a(var7_8);
        return var6_7;
    }

    @Override
    public boolean b() {
        return true;
    }

    protected X509Certificate a(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
            return x509Certificate;
        }
        catch (CertificateException certificateException) {
            return null;
        }
    }

    private CertificateException a(X509Certificate x509Certificate, boolean bl) {
        try {
            x509Certificate.checkValidity(new Date(System.currentTimeMillis()));
        }
        catch (CertificateExpiredException certificateExpiredException) {
            return certificateExpiredException;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return certificateNotYetValidException;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String b(CertificateException certificateException, boolean bl) {
        if (certificateException instanceof CertificateExpiredException) {
            if (bl) {
                return "CA certificate expired";
            }
            return "Client certificate expired";
        }
        if (!(certificateException instanceof CertificateNotYetValidException)) {
            throw new RuntimeException("Invalid certificate exception (" + certificateException.getClass().getSimpleName() + ")");
        }
        if (bl) {
            return "CA certificate not yet valid";
        }
        return "Client certificate not yet valid";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int a(CertificateException certificateException, boolean bl) {
        if (certificateException instanceof CertificateExpiredException && !bl) {
            return 1001;
        }
        return 2001;
    }

    private boolean a(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        try {
            x509Certificate.verify(x509Certificate2.getPublicKey());
        }
        catch (Exception exception) {
            Certificate.Q.m.d("Verification of certificate failed ({0})", exception);
            return false;
        }
        return true;
    }

    @Override
    public String a() {
        return "Certificate";
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mCertificateLogger != null) {
            o o2 = this.b(this.mCertificateLogger);
            if (o2 != null) {
                o2.flush();
            }
        }
    }
}

