/*
 * Decompiled with CFR 0.152.
 */
package com.portwise.mid.controller.oath;

import com.portwise.core.controller.oath.OATHToken;
import com.portwise.core.controller.oath.d;
import com.portwise.core.controller.oath.f;
import com.portwise.core.e.b.f.l;
import com.portwise.core.e.m.c.e;
import com.portwise.core.logging.b;
import com.portwise.mid.controller.oath.ProviderEntity;
import com.portwise.mid.controller.oath.RevocationStatusEntity;
import com.portwise.mid.controller.oath.c;
import com.portwise.mid.controller.oath.h;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;

@Entity
@Table(name="OATH_TOKEN", uniqueConstraints={@UniqueConstraint(columnNames={"TOKENID", "PROVIDER_ID"})})
@NamedQueries(value={@NamedQuery(name="OATHTokenEntity.deleteAllTokens", query="delete from OATHTokenEntity"), @NamedQuery(name="OATHTokenEntity.countRows", query="select count(id), max(id) from OATHTokenEntity")})
public class OATHTokenEntity
extends OATHToken<ProviderEntity, RevocationStatusEntity>
implements c {
    public static final String k = "OATHTokenEntity.deleteAllTokens";
    public static final String e = "OATHTokenEntity.countRows";
    private static final int i = 2;
    public static final String f = "OATH_TOKEN";
    public static final String g = "PROVIDER_ID";
    public static final String h = "TOKENID";
    private static final int b = 32;
    private static final int j = 4;
    private static final long serialVersionUID = -4223303039075908645L;
    private static b c = new b();
    private Long id;
    private String mCounter;
    private boolean mDoReEncrypt = false;
    private Date mLastAccessed;
    private String mRevocationReason;
    private String mSeed;
    private int mUseOffset;
    private boolean mAddChecksum;
    private final String sDelimiter = ";";
    public static int d;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] a(byte[] byArray) throws f {
        int n2 = d;
        List list = com.portwise.core.storage.b.b().b("internal");
        if (list == null) {
            OATHTokenEntity.c.f.a(null, null, "No keys found for decryption of seed.");
            throw new f(com.portwise.core.controller.oath.h.FAILED_QUERY, "Failed to decrypt seed. No keys found to decrypt");
        }
        if (byArray == null || byArray.length == 0) {
            OATHTokenEntity.c.f.a(null, null, "No seed associated with token.");
            throw new f(com.portwise.core.controller.oath.h.FAILED_QUERY, "Failed to decrypt seed. No seed to decrypt");
        }
        byte[] byArray2 = ByteBuffer.allocate(32).put(byArray, 0, 32).array();
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        ByteBuffer byteBuffer = null;
        ByteBuffer byteBuffer2 = null;
        ByteBuffer byteBuffer3 = null;
        com.portwise.core.e.m.a.c c2 = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            byArray4 = ByteBuffer.allocate(byArray.length - 32).put(byArray, 32, byArray.length - 32).array();
            byArray3 = (byte[])list.get(0);
            com.portwise.core.e.m.c.b b2 = new com.portwise.core.e.m.c.b(byArray3, byArray2);
            byte[] byArray5 = b2.b(byArray4, byArray4);
            byteBuffer = ByteBuffer.allocate(4).put(byArray5, 0, 4);
            byteBuffer2 = ByteBuffer.allocate(byArray5.length - 4).put(byArray5, 4, byArray5.length - 4);
            c2 = new com.portwise.core.e.m.a.c();
            byte[] byArray6 = c2.b(byteBuffer2.array());
            byteBuffer3 = ByteBuffer.allocate(4);
            byteBuffer3.put(byArray6, 0, 4);
            byteBuffer3.position(0);
            byteBuffer.position(0);
            if (byteBuffer3.equals(byteBuffer)) {
                return byteBuffer2.array();
            }
            this.mDoReEncrypt = true;
            if (n2 == 0) continue;
        }
        OATHTokenEntity.c.f.a(null, null, "No matching key, this might be a larger problem");
        throw new f(com.portwise.core.controller.oath.h.FAILED_QUERY, "Failed to decrypt seed. No key found to be used for decryption.");
    }

    private byte[] b(byte[] byArray) throws f {
        List list = com.portwise.core.storage.b.b().b("internal");
        if (list == null) {
            OATHTokenEntity.c.f.a(null, null, "No internal keys found for encryptation of seed.");
            throw new f(com.portwise.core.controller.oath.h.FAILED_UPDATE, "Failed to encrypt seed. No key found to use for encryption");
        }
        byte[] byArray2 = (byte[])list.get(0);
        if (byArray2 == null) {
            OATHTokenEntity.c.f.a(null, null, "Internal key for encryptation of seed missing.");
            throw new f(com.portwise.core.controller.oath.h.FAILED_UPDATE, "Failed to encrypt seed. No key found to use for encryption");
        }
        byte[] byArray3 = com.portwise.core.storage.b.b().a(32);
        com.portwise.core.e.m.a.c c2 = new com.portwise.core.e.m.a.c();
        byte[] byArray4 = c2.b(byArray);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + byArray.length);
        byteBuffer.put(byArray4, 0, 4);
        byteBuffer.put(byArray);
        byte[] byArray5 = byteBuffer.array();
        com.portwise.core.e.m.c.b b2 = new com.portwise.core.e.m.c.b(byArray2, byArray3);
        byte[] byArray6 = b2.a(byArray5, byArray5);
        byteBuffer = ByteBuffer.allocate(byArray3.length + byArray6.length);
        byteBuffer.put(byArray3);
        byteBuffer.put(byArray6);
        return byteBuffer.array();
    }

    @Transient
    public Long getCounter() throws f {
        byte[] byArray = this.a(com.portwise.core.e.m.c.e.a(this.c()));
        if (byArray == null) {
            throw new f(com.portwise.core.controller.oath.h.FAILED_UPDATE, "Failed to decrypt counter");
        }
        return new BigInteger(byArray).longValue();
    }

    @Column(nullable=false, name="COUNTER")
    protected String c() {
        return this.mCounter;
    }

    @Id
    public Long getId() {
        return this.id;
    }

    @Column(nullable=false)
    public Date getLastAccessed() {
        return this.mLastAccessed;
    }

    @Override
    @ManyToOne
    @JoinColumn(nullable=false)
    public ProviderEntity getProvider() {
        return (ProviderEntity)super.getProvider();
    }

    public String getRevocationReason() {
        return this.mRevocationReason;
    }

    @Override
    @ManyToOne
    @JoinColumn(nullable=false)
    public RevocationStatusEntity getRevocationStatus() {
        return (RevocationStatusEntity)super.getRevocationStatus();
    }

    @Transient
    public byte[] getSeed() throws f {
        return this.a(com.portwise.core.e.m.c.e.a(this.a()));
    }

    @Column(nullable=false, name="SEED")
    protected String a() {
        return this.mSeed;
    }

    @Override
    @Column(nullable=false)
    @Index(name="tokenIdIndex")
    public String getTokenId() {
        return super.getTokenId();
    }

    @Column(nullable=false)
    public int getUseOffset() {
        return this.mUseOffset;
    }

    @Column(nullable=false)
    public boolean isAddChecksum() {
        return this.mAddChecksum;
    }

    public void setAddChecksum(boolean bl) {
        this.mAddChecksum = bl;
    }

    @Transient
    public void setCounter(Long l2) throws f {
        int n2 = d;
        byte[] byArray = new byte[8];
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            byArray[i2] = (byte)(l2 & 0xFFL);
            l2 = l2 >> 8;
            if (n2 == 0) continue;
        }
        byArray = this.b(byArray);
        if (byArray == null) {
            throw new f(com.portwise.core.controller.oath.h.FAILED_UPDATE, "Failed to encrypt counter");
        }
        this.a(com.portwise.core.e.m.c.e.a(byArray));
        if (this.mDoReEncrypt) {
            this.setSeed(this.getSeed());
        }
    }

    protected void a(String string) {
        this.mCounter = string;
    }

    public void setId(Long l2) {
        this.id = l2;
    }

    public void setLastAccessed(Date date) {
        this.mLastAccessed = date;
    }

    public void setRevocationReason(String string) {
        this.mRevocationReason = string;
    }

    @Override
    public void setRevocationStatus(RevocationStatusEntity revocationStatusEntity) {
        super.setRevocationStatus(revocationStatusEntity);
    }

    @Transient
    public void setSeed(byte[] byArray) throws f {
        this.b(com.portwise.core.e.m.c.e.a(this.b(byArray)));
    }

    protected void b(String string) {
        this.mSeed = string;
    }

    public void setUseOffset(int n2) {
        this.mUseOffset = n2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OATHTokenEntity)) {
            return false;
        }
        OATHTokenEntity oATHTokenEntity = (OATHTokenEntity)object;
        return new l().b(this.id, oATHTokenEntity.id).a();
    }

    @Override
    public int hashCode() {
        return this.id.toString().hashCode();
    }

    @Override
    @Transient
    public int getTableVersion() {
        return 1;
    }

    @Override
    @Transient
    public String getAnnotatedTableName() {
        return f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean decode(String string) throws Exception {
        int n2 = d;
        String[] stringArray = string.split(";");
        if (stringArray.length < 9) {
            OATHTokenEntity.c.m.a("Failed to decode an OATH Token to perform restore. The row to restore is {0}.", string);
            return false;
        }
        this.setId(null);
        try {
            this.setTokenId(new String(com.portwise.core.e.m.c.e.a(stringArray[1]), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            OATHTokenEntity.c.m.a("Failed to decode an OATH Token to perform restore. The token id did not fit in the UTF-8 encoding. The tokenID that failed was: ", stringArray[1]);
            return false;
        }
        try {
            this.setRevocationStatus(com.portwise.mid.controller.oath.h.c().a(new d(Integer.parseInt(stringArray[2])).getStatus()));
        }
        catch (f f2) {
            f2.printStackTrace();
            OATHTokenEntity.c.m.a("Failed to fetch Revocation Status from OATH database when restoring an OATH token. Message: " + f2.getMessage());
            return false;
        }
        this.setUseOffset(new Integer(stringArray[3]));
        this.a(stringArray[4]);
        this.setLastAccessed(new Date(Long.parseLong(stringArray[5])));
        try {
            List list = com.portwise.mid.controller.oath.h.c().g();
            for (ProviderEntity providerEntity : list) {
                if (providerEntity.getId() == Long.parseLong(stringArray[6])) {
                    this.setProvider(providerEntity);
                    if (n2 == 0) break;
                }
                if (n2 == 0) continue;
                break;
            }
        }
        catch (f f3) {
            f3.printStackTrace();
            OATHTokenEntity.c.m.b("Failed to fetch providerId {0}to restore OATH token data for tokenId {2}, Message: {2}", new Object[]{stringArray[5], this.getTokenId(), f3.getMessage()});
            return false;
        }
        this.b(stringArray[7]);
        if (Integer.parseInt(stringArray[8]) != this.getTableVersion()) {
            OATHTokenEntity.c.m.a("Version of token to restore did not match the required version");
            return false;
        }
        return true;
    }

    @Override
    public String encode() {
        try {
            return this.getId().toString() + ";" + com.portwise.core.e.m.c.e.a(this.getTokenId().getBytes("UTF-8")) + ";" + this.getRevocationStatus().getStatus().ordinal() + ";" + this.getUseOffset() + ";" + this.c() + ";" + this.getLastAccessed().getTime() + ";" + this.getProvider().getId() + ";" + this.a() + ";" + this.getTableVersion() + ";";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            OATHTokenEntity.c.m.b("Failed to encode token {0} for backup. Message {1}", new Object[]{this.getTokenId(), unsupportedEncodingException.getMessage()});
            return null;
        }
    }

    @Override
    @Transient
    public int getTypeId() {
        return 2;
    }
}

