/*
 * Decompiled with CFR 0.152.
 */
package skt.swing.tree;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import skt.swing.tree.ChildrenEnumeration;

public class PreorderEnumeration
implements Enumeration {
    private TreeModel model;
    protected Stack stack = new Stack();

    public PreorderEnumeration(TreePath path, TreeModel model) {
        this(Collections.enumeration(Collections.singletonList(path)), model);
    }

    public PreorderEnumeration(Enumeration enumer, TreeModel model) {
        this.model = model;
        this.stack.push(enumer);
    }

    public boolean hasMoreElements() {
        return !this.stack.empty() && ((Enumeration)this.stack.peek()).hasMoreElements();
    }

    public Object nextElement() {
        Enumeration enumer = (Enumeration)this.stack.peek();
        TreePath path = (TreePath)enumer.nextElement();
        if (!enumer.hasMoreElements()) {
            this.stack.pop();
        }
        if (this.model.getChildCount(path.getLastPathComponent()) > 0) {
            this.stack.push(new ChildrenEnumeration(path, this.model));
        }
        return path;
    }
}

