/*
 * Decompiled with CFR 0.152.
 */
package skt.swing.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class CurrentLineHighlighter {
    private static final String LINE_HIGHLIGHT = "linehilight";
    private static final String PREVIOUS_CARET = "previousCaret";
    private static Color col = new Color(255, 255, 204);
    private static CaretListener caretListener = new CaretListener(){

        public void caretUpdate(CaretEvent e) {
            CurrentLineHighlighter.currentLineChanged((JTextComponent)e.getSource());
        }
    };
    private static MouseInputAdapter mouseListener = new MouseInputAdapter(){

        public void mousePressed(MouseEvent e) {
            CurrentLineHighlighter.currentLineChanged((JTextComponent)e.getSource());
        }

        public void mouseDragged(MouseEvent e) {
            CurrentLineHighlighter.currentLineChanged((JTextComponent)e.getSource());
        }
    };
    private static Highlighter.HighlightPainter painter = new Highlighter.HighlightPainter(){

        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
            try {
                Rectangle r = c.modelToView(c.getCaretPosition());
                g.setColor(col);
                g.fillRect(0, r.y, c.getWidth(), r.height);
            }
            catch (BadLocationException ignore) {
                // empty catch block
            }
        }
    };

    private CurrentLineHighlighter() {
    }

    public static void install(JTextComponent c) {
        try {
            Object obj = c.getHighlighter().addHighlight(0, 0, painter);
            c.putClientProperty(LINE_HIGHLIGHT, obj);
            c.putClientProperty(PREVIOUS_CARET, new Integer(c.getCaretPosition()));
            c.addCaretListener(caretListener);
            c.addMouseListener(mouseListener);
            c.addMouseMotionListener(mouseListener);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void uninstall(JTextComponent c) {
        c.putClientProperty(LINE_HIGHLIGHT, null);
        c.putClientProperty(PREVIOUS_CARET, null);
        c.removeCaretListener(caretListener);
        c.removeMouseListener(mouseListener);
        c.removeMouseMotionListener(mouseListener);
    }

    private static void currentLineChanged(JTextComponent c) {
        try {
            int previousCaret = (Integer)c.getClientProperty(PREVIOUS_CARET);
            Rectangle prev = c.modelToView(previousCaret);
            Rectangle r = c.modelToView(c.getCaretPosition());
            c.putClientProperty(PREVIOUS_CARET, new Integer(c.getCaretPosition()));
            if (prev.y != r.y) {
                c.repaint(0, prev.y, c.getWidth(), r.height);
                c.repaint(0, r.y, c.getWidth(), r.height);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

