/*
 * Decompiled with CFR 0.152.
 */
package skt.swing.table;

import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.MouseInputAdapter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import skt.swing.table.TableColumnAutoResizer;
import skt.swing.table.TableColumnResizer;
import skt.swing.table.TableRowResizer;

public class MyTable
extends JTable {
    private static TableColumnAutoResizer columnAutoResizer = new TableColumnAutoResizer();
    protected MouseInputAdapter rowResizer;
    protected MouseInputAdapter columnResizer = null;

    public MyTable() {
    }

    public MyTable(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public MyTable(TableModel dm) {
        super(dm);
    }

    public MyTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
    }

    public MyTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
    }

    public MyTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
    }

    public MyTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
    }

    public void addNotify() {
        super.addNotify();
        this.getTableHeader().addMouseListener(columnAutoResizer);
    }

    public void removeNotify() {
        super.removeNotify();
        this.getTableHeader().removeMouseListener(columnAutoResizer);
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.getTableHeader() != null) {
            this.getTableHeader().removeMouseListener(columnAutoResizer);
        }
        super.setTableHeader(tableHeader);
        if (tableHeader != null && this.isShowing()) {
            tableHeader.addMouseListener(columnAutoResizer);
        }
    }

    public void setResizable(boolean row, boolean column) {
        if (row) {
            if (this.rowResizer == null) {
                this.rowResizer = new TableRowResizer(this);
            }
        } else if (this.rowResizer != null) {
            this.removeMouseListener(this.rowResizer);
            this.removeMouseMotionListener(this.rowResizer);
            this.rowResizer = null;
        }
        if (column) {
            if (this.columnResizer == null) {
                this.columnResizer = new TableColumnResizer(this);
            }
        } else if (this.columnResizer != null) {
            this.removeMouseListener(this.columnResizer);
            this.removeMouseMotionListener(this.columnResizer);
            this.columnResizer = null;
        }
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        if (this.getCursor() == TableColumnResizer.resizeCursor || this.getCursor() == TableRowResizer.resizeCursor) {
            return false;
        }
        return super.editCellAt(row, column, e);
    }

    public void changeSelection(int row, int column, boolean toggle, boolean extend) {
        if (this.getCursor() == TableColumnResizer.resizeCursor || this.getCursor() == TableRowResizer.resizeCursor) {
            return;
        }
        super.changeSelection(row, column, toggle, extend);
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }
}

