/*
 * Decompiled with CFR 0.152.
 */
package skt.swing.search;

import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;
import skt.swing.StringConvertor;
import skt.swing.search.FindAction;

public class TreeFindAction
extends FindAction {
    static /* synthetic */ Class class$skt$swing$StringConvertor;

    public TreeFindAction(boolean ignoreCase) {
        super(ignoreCase);
    }

    protected boolean changed(JComponent comp, String searchString, Position.Bias bias) {
        TreePath path;
        int startingRow;
        JTree tree = (JTree)comp;
        boolean startingFromSelection = true;
        int max = tree.getRowCount();
        int increment = 0;
        if (bias != null) {
            int n = increment = bias == Position.Bias.Forward ? 1 : -1;
        }
        if ((startingRow = (tree.getLeadSelectionRow() + increment + max) % max) < 0 || startingRow >= tree.getRowCount()) {
            startingFromSelection = false;
            startingRow = 0;
        }
        if ((path = this.getNextMatch(tree, searchString, startingRow, bias)) != null) {
            this.changeSelection(tree, path);
            return true;
        }
        if (startingFromSelection && (path = this.getNextMatch(tree, searchString, 0, bias)) != null) {
            this.changeSelection(tree, path);
            return true;
        }
        return false;
    }

    protected void changeSelection(JTree tree, TreePath path) {
        if (this.controlDown) {
            tree.addSelectionPath(path);
        } else {
            tree.setSelectionPath(path);
        }
        tree.scrollPathToVisible(path);
    }

    public TreePath getNextMatch(JTree tree, String prefix, int startingRow, Position.Bias bias) {
        int max = tree.getRowCount();
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (startingRow < 0 || startingRow >= max) {
            throw new IllegalArgumentException();
        }
        if (this.ignoreCase) {
            prefix = prefix.toUpperCase();
        }
        int increment = bias == null || bias == Position.Bias.Forward ? 1 : -1;
        int row = startingRow;
        do {
            String text;
            TreePath path = tree.getPathForRow(row);
            StringConvertor convertor = (StringConvertor)this.comp.getClientProperty(class$skt$swing$StringConvertor == null ? TreeFindAction.class$("skt.swing.StringConvertor") : class$skt$swing$StringConvertor);
            String string = text = convertor != null ? convertor.toString(path) : tree.convertValueToText(path.getLastPathComponent(), tree.isRowSelected(row), tree.isExpanded(row), true, row, false);
            if (this.ignoreCase) {
                text = text.toUpperCase();
            }
            if (!text.startsWith(prefix)) continue;
            return path;
        } while ((row = (row + increment + max) % max) != startingRow);
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

