/*
 * Decompiled with CFR 0.152.
 */
package skt.swing.search;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import skt.swing.search.FindAction;

public class TextComponentFindAction
extends FindAction
implements FocusListener {
    public TextComponentFindAction(boolean ignoreCase) {
        super(ignoreCase);
    }

    protected void initSearch(ActionEvent ae) {
        super.initSearch(ae);
        JTextComponent textComp = (JTextComponent)ae.getSource();
        String selectedText = textComp.getSelectedText();
        if (selectedText != null) {
            this.searchField.setText(selectedText);
        }
        this.searchField.removeFocusListener(this);
        this.searchField.addFocusListener(this);
    }

    protected boolean changed(JComponent comp, String str, Position.Bias bias) {
        JTextComponent textComp = (JTextComponent)comp;
        int offset = bias == Position.Bias.Forward ? textComp.getCaretPosition() : textComp.getCaret().getMark() - 1;
        int index = this.getNextMatch(textComp, str, offset, bias);
        if (index != -1) {
            textComp.select(index, index + str.length());
            return true;
        }
        offset = bias == null || bias == Position.Bias.Forward ? 0 : textComp.getDocument().getLength();
        index = this.getNextMatch(textComp, str, offset, bias);
        if (index != -1) {
            textComp.select(index, index + str.length());
            return true;
        }
        return false;
    }

    protected int getNextMatch(JTextComponent textComp, String str, int startingOffset, Position.Bias bias) {
        String text = null;
        try {
            text = textComp.getDocument().getText(0, textComp.getDocument().getLength());
        }
        catch (BadLocationException e) {
            throw new RuntimeException("This should never happen!");
        }
        if (this.ignoreCase) {
            str = str.toUpperCase();
            text = text.toUpperCase();
        }
        return bias == null || bias == Position.Bias.Forward ? text.indexOf(str, startingOffset) : text.lastIndexOf(str, startingOffset);
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        super.popupMenuWillBecomeVisible(e);
        Caret caret = ((JTextComponent)this.comp).getCaret();
        caret.setVisible(true);
        caret.setSelectionVisible(true);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }
}

