/*
 * Decompiled with CFR 0.152.
 */
package skt.swing.search;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.text.Position;
import skt.swing.StringConvertor;
import skt.swing.search.FindAction;

public class TableFindAction
extends FindAction {
    static /* synthetic */ Class class$skt$swing$StringConvertor;

    public TableFindAction(boolean ignoreCase) {
        super(ignoreCase);
    }

    protected boolean changed(JComponent comp, String searchString, Position.Bias bias) {
        int index;
        int startingRow;
        JTable table = (JTable)comp;
        boolean startingFromSelection = true;
        int max = table.getRowCount();
        int increment = 0;
        if (bias != null) {
            int n = increment = bias == Position.Bias.Forward ? 1 : -1;
        }
        if ((startingRow = (table.getSelectionModel().getLeadSelectionIndex() + increment + max) % max) < 0 || startingRow >= table.getRowCount()) {
            startingFromSelection = false;
            startingRow = 0;
        }
        if ((index = this.getNextMatch(table, searchString, startingRow, bias)) != -1) {
            this.changeSelection(table, index);
            return true;
        }
        if (startingFromSelection && (index = this.getNextMatch(table, searchString, 0, bias)) != -1) {
            this.changeSelection(table, index);
            return true;
        }
        return false;
    }

    protected void changeSelection(JTable table, int index) {
        if (this.controlDown) {
            table.addRowSelectionInterval(index, index);
        } else {
            table.setRowSelectionInterval(index, index);
        }
        int column = table.getSelectedColumn();
        if (column == -1) {
            column = 0;
        }
        table.scrollRectToVisible(table.getCellRect(index, column, true));
    }

    public int getNextMatch(JTable table, String prefix, int startIndex, Position.Bias bias) {
        int column = table.getSelectedColumn();
        if (column == -1) {
            column = 0;
        }
        int max = table.getRowCount();
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (startIndex < 0 || startIndex >= max) {
            throw new IllegalArgumentException();
        }
        if (this.ignoreCase) {
            prefix = prefix.toUpperCase();
        }
        int increment = bias == null || bias == Position.Bias.Forward ? 1 : -1;
        int index = startIndex;
        do {
            String text;
            Object item;
            if ((item = table.getValueAt(index, column)) == null) continue;
            StringConvertor convertor = (StringConvertor)this.comp.getClientProperty(class$skt$swing$StringConvertor == null ? TableFindAction.class$("skt.swing.StringConvertor") : class$skt$swing$StringConvertor);
            String string = text = convertor != null ? convertor.toString(item) : item.toString();
            if (this.ignoreCase) {
                text = text.toUpperCase();
            }
            if (text == null || !text.startsWith(prefix)) continue;
            return index;
        } while ((index = (index + increment + max) % max) != startIndex);
        return -1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

