/*
 * Decompiled with CFR 0.152.
 */
package skt.swing.search;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Position;

public abstract class FindAction
extends AbstractAction
implements DocumentListener,
KeyListener,
PopupMenuListener {
    private JPanel searchPanel = new JPanel(new FlowLayout(0, 0, 0));
    private JPopupMenu popup = new JPopupMenu();
    protected JTextField searchField = new JTextField();
    protected boolean ignoreCase;
    protected JComponent comp = null;
    protected boolean shiftDown = false;
    protected boolean controlDown = false;

    public FindAction(boolean ignoreCase) {
        super("incremantal-search-case" + (ignoreCase ? "in" : "") + "sensitive");
        this.ignoreCase = ignoreCase;
        int modifiers = 2;
        if (ignoreCase) {
            modifiers |= 1;
        }
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, modifiers));
        this.createSearchPanel();
    }

    private void createSearchPanel() {
        this.searchPanel.setBackground(UIManager.getColor("ToolTip.background"));
        this.searchField.setOpaque(false);
        JLabel label = new JLabel("Search for:");
        label.setFont(new Font("DialogInput", 1, 12));
        this.searchPanel.add(label);
        this.searchPanel.add(this.searchField);
        this.searchField.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.searchPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
        this.popup.add(this.searchPanel);
        this.popup.addPopupMenuListener(this);
        this.searchField.setFont(new Font("DialogInput", 0, 12));
        this.searchField.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FindAction.this.popup.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.searchField) {
            this.popup.setVisible(false);
            this.comp = null;
        } else {
            this.comp = (JComponent)ae.getSource();
            this.searchField.removeActionListener(this);
            this.searchField.removeKeyListener(this);
            this.searchField.getDocument().removeDocumentListener(this);
            this.initSearch(ae);
            this.searchField.addActionListener(this);
            this.searchField.addKeyListener(this);
            this.searchField.getDocument().addDocumentListener(this);
            Rectangle rect = this.comp.getVisibleRect();
            this.popup.show(this.comp, rect.x, rect.y - this.popup.getPreferredSize().height - 5);
            this.searchField.requestFocus();
        }
    }

    protected void initSearch(ActionEvent ae) {
        this.searchField.setText("");
        this.searchField.setForeground(Color.black);
    }

    private void changed(Position.Bias bias) {
        this.popup.setVisible(false);
        this.popup.setVisible(true);
        this.searchField.requestFocus();
        this.searchField.setForeground(this.changed(this.comp, this.searchField.getText(), bias) ? Color.black : Color.red);
    }

    protected abstract boolean changed(JComponent var1, String var2, Position.Bias var3);

    public void insertUpdate(DocumentEvent e) {
        this.changed(null);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changed(null);
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void keyPressed(KeyEvent ke) {
        this.shiftDown = ke.isShiftDown();
        this.controlDown = ke.isControlDown();
        switch (ke.getKeyCode()) {
            case 38: {
                this.changed(Position.Bias.Backward);
                break;
            }
            case 40: {
                this.changed(Position.Bias.Forward);
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.comp.requestFocus();
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
        System.err.println("cancelled");
    }
}

