/*
 * Decompiled with CFR 0.152.
 */
package skt.swing.scroll;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JViewport;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;
import skt.swing.SwingUtil;
import skt.swing.scroll.ScrollGestureRecognizer;

class ScrollGlassPane
extends JPanel
implements ActionListener,
MouseInputListener,
SwingConstants {
    private static final Image AUTOSCROLL_IMG = Toolkit.getDefaultToolkit().createImage((class$skt$swing$scroll$ScrollGlassPane == null ? (class$skt$swing$scroll$ScrollGlassPane = ScrollGlassPane.class$("skt.swing.scroll.ScrollGlassPane")) : class$skt$swing$scroll$ScrollGlassPane).getResource("autoscroll.png"));
    private static final Image HORIZ_AUTOSCROLL_IMG = Toolkit.getDefaultToolkit().createImage((class$skt$swing$scroll$ScrollGlassPane == null ? (class$skt$swing$scroll$ScrollGlassPane = ScrollGlassPane.class$("skt.swing.scroll.ScrollGlassPane")) : class$skt$swing$scroll$ScrollGlassPane).getResource("horiz_autoscroll.png"));
    private static final Image VERT_AUTOSCROLL_IMG = Toolkit.getDefaultToolkit().createImage((class$skt$swing$scroll$ScrollGlassPane == null ? (class$skt$swing$scroll$ScrollGlassPane = ScrollGlassPane.class$("skt.swing.scroll.ScrollGlassPane")) : class$skt$swing$scroll$ScrollGlassPane).getResource("vert_autoscroll.png"));
    private static final int IMG_WIDTH = 32;
    private static final int IMG_HEIGHT = 32;
    Component oldGlassPane = null;
    public Point location = null;
    Timer movingTimer;
    private Point mouseLocation;
    private JViewport viewport;
    private Image img;
    private Rectangle imgBounds;
    private boolean ignoreMousePress = false;
    private boolean dragged = false;
    static /* synthetic */ Class class$skt$swing$scroll$ScrollGlassPane;

    public ScrollGlassPane(Component oldGlassPane, JViewport viewport, Point location) {
        this.oldGlassPane = oldGlassPane;
        this.viewport = viewport;
        this.location = this.mouseLocation = location;
        this.imgBounds = new Rectangle(location.x - 16, location.y - 16, 32, 32);
        boolean canHScroll = SwingUtil.canHScroll(viewport);
        boolean canVScroll = SwingUtil.canVScroll(viewport);
        this.img = canHScroll && canVScroll ? AUTOSCROLL_IMG : (canHScroll ? HORIZ_AUTOSCROLL_IMG : VERT_AUTOSCROLL_IMG);
        this.setOpaque(false);
        ScrollGestureRecognizer.getInstance().stop();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.movingTimer = new Timer(100, this);
        this.movingTimer.setRepeats(true);
    }

    protected void paintComponent(Graphics g) {
        g.drawImage(this.img, this.location.x - 15, this.location.y - 15, this);
    }

    public void actionPerformed(ActionEvent e) {
        int deltax = (this.mouseLocation.x - this.location.x) / 4;
        int deltay = (this.mouseLocation.y - this.location.y) / 4;
        Point p = this.viewport.getViewPosition();
        p.translate(deltax, deltay);
        if (p.x < 0) {
            p.x = 0;
        } else if (p.x >= this.viewport.getView().getWidth() - this.viewport.getWidth()) {
            p.x = this.viewport.getView().getWidth() - this.viewport.getWidth();
        }
        if (p.y < 0) {
            p.y = 0;
        } else if (p.y >= this.viewport.getView().getHeight() - this.viewport.getHeight()) {
            p.y = this.viewport.getView().getHeight() - this.viewport.getHeight();
        }
        this.viewport.setViewPosition(p);
        this.setCursor(this.imgBounds.contains(this.mouseLocation) ? Cursor.getPredefinedCursor(13) : null);
    }

    public void mousePressed(MouseEvent e) {
        if (this.ignoreMousePress) {
            this.ignoreMousePress = false;
            return;
        }
        if (this.movingTimer.isRunning()) {
            this.movingTimer.stop();
            try {
                new Robot().mouseRelease(8);
            }
            catch (AWTException ignore) {
                // empty catch block
            }
            this.setVisible(false);
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            rootPane.setGlassPane(this.oldGlassPane);
            ScrollGestureRecognizer.getInstance().start();
        } else {
            this.movingTimer.start();
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.dragged) {
            this.mousePressed(e);
        } else {
            try {
                this.ignoreMousePress = true;
                Robot robot = new Robot();
                robot.mousePress(8);
            }
            catch (AWTException ignore) {
                this.mousePressed(e);
            }
        }
    }

    public void mouseMoved(MouseEvent e) {
        this.mouseLocation = e.getPoint();
    }

    public void mouseDragged(MouseEvent e) {
        this.dragged = true;
        this.mouseLocation = e.getPoint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

