/*
 * Decompiled with CFR 0.152.
 */
package skt.swing.progress;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import skt.swing.ActiveWindowTracker;
import skt.swing.progress.ProgressDialog;
import skt.swing.progress.ProgressMonitor;

public class ProgressUtil {
    public static ProgressMonitor createModalProgressMonitor(int total, boolean indeterminate) {
        ProgressMonitor monitor = new ProgressMonitor(total, indeterminate);
        monitor.addChangeListener(new MonitorListener(monitor));
        return monitor;
    }

    public static ProgressMonitor createModalProgressMonitor(int total, boolean indeterminate, int milliSecondsToWait) {
        ProgressMonitor monitor = new ProgressMonitor(total, indeterminate, milliSecondsToWait);
        monitor.addChangeListener(new MonitorListener(monitor));
        return monitor;
    }

    static class MonitorListener
    implements ChangeListener,
    ActionListener {
        private ProgressMonitor monitor;
        private Timer timer;

        public MonitorListener(ProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void stateChanged(ChangeEvent ce) {
            ProgressMonitor monitor = (ProgressMonitor)ce.getSource();
            if (!monitor.isFinished()) {
                if (this.timer == null) {
                    this.timer = new Timer(monitor.getMilliSecondsToWait(), this);
                    this.timer.setRepeats(false);
                    this.timer.start();
                }
            } else {
                if (this.timer != null && this.timer.isRunning()) {
                    this.timer.stop();
                }
                monitor.removeChangeListener(this);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.monitor.removeChangeListener(this);
            if (!this.monitor.isFinished()) {
                Window owner = ActiveWindowTracker.findActiveWindow();
                ProgressDialog dlg = owner instanceof Frame ? new ProgressDialog((Frame)owner, this.monitor) : new ProgressDialog((Dialog)owner, this.monitor);
                dlg.pack();
                dlg.setLocationRelativeTo(null);
                if (!this.monitor.isFinished()) {
                    dlg.setVisible(true);
                }
            }
        }
    }
}

