/*
 * Decompiled with CFR 0.152.
 */
package skt.swing.icon;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class ColoredIcon
implements Icon {
    private Icon delegate;
    private BufferedImage mask;
    private boolean colorPainted = true;

    public ColoredIcon(Icon delegate) {
        this(delegate, UIManager.getColor("textHighlight"), 0.5f);
    }

    public ColoredIcon(Icon delegate, Color color) {
        this(delegate, color, 0.5f);
    }

    public ColoredIcon(Icon delegate, Color color, float alpha) {
        this.delegate = delegate;
        this.createMask(color, alpha);
    }

    private void createMask(Color color, float alpha) {
        this.mask = new BufferedImage(this.delegate.getIconWidth(), this.delegate.getIconHeight(), 2);
        Graphics2D gbi = (Graphics2D)this.mask.getGraphics();
        this.delegate.paintIcon(new JLabel(), gbi, 0, 0);
        gbi.setComposite(AlphaComposite.getInstance(5, alpha));
        gbi.setColor(color);
        gbi.fillRect(0, 0, this.mask.getWidth() - 1, this.mask.getHeight() - 1);
    }

    public boolean isColorPainted() {
        return this.colorPainted;
    }

    public void setColorPainted(boolean colorPainted) {
        this.colorPainted = colorPainted;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.delegate.paintIcon(c, g, x, y);
        if (this.colorPainted) {
            g.drawImage(this.mask, x, y, c);
        }
    }

    public int getIconWidth() {
        return this.delegate.getIconWidth();
    }

    public int getIconHeight() {
        return this.delegate.getIconHeight();
    }
}

