/*
 * Decompiled with CFR 0.152.
 */
package skt.swing;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Stack;
import javax.swing.JDialog;

public class ActiveWindowTracker {
    static Stack showingWindows = new Stack();
    private static WindowListener windowListener = new WindowAdapter(){

        public void windowDeactivated(WindowEvent we) {
            if (!we.getWindow().isShowing()) {
                this.windowHiddenOrClosed(we);
            }
        }

        public void windowClosed(WindowEvent we) {
            this.windowHiddenOrClosed(we);
        }

        private void windowHiddenOrClosed(WindowEvent we) {
            we.getWindow().removeWindowListener(windowListener);
            showingWindows.remove(we.getWindow());
        }
    };
    private static PropertyChangeListener propListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() != null) {
                Window window = (Window)evt.getNewValue();
                if (!showingWindows.contains(window)) {
                    window.addWindowListener(windowListener);
                    showingWindows.remove(window);
                }
                showingWindows.push(window);
            }
        }
    };

    public static Window findActiveWindow() {
        if (!showingWindows.isEmpty()) {
            return (Window)showingWindows.peek();
        }
        JDialog dlg = new JDialog();
        Window owner = dlg.getOwner();
        dlg.dispose();
        return owner;
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", propListener);
    }
}

