/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaDirContext;
import com.netscape.jndi.ldap.schema.SchemaElementBindingEnum;
import com.netscape.jndi.ldap.schema.SchemaElementContainer;
import com.netscape.jndi.ldap.schema.SchemaElementNameEnum;
import com.netscape.jndi.ldap.schema.SchemaManager;
import com.netscape.jndi.ldap.schema.SchemaObjectClass;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import netscape.ldap.LDAPObjectClassSchema;

public class SchemaObjectClassContainer
extends SchemaElementContainer {
    public SchemaObjectClassContainer(SchemaManager schemaManager) throws NamingException {
        super(schemaManager, "ClassDefinition");
    }

    public DirContext createSchemaElement(String string, Attributes attributes) throws NamingException {
        if (string.length() == 0) {
            throw new NamingException("Empty name for schema objectclass");
        }
        LDAPObjectClassSchema lDAPObjectClassSchema = SchemaObjectClass.parseDefAttributes(attributes);
        this.m_schemaMgr.createObjectClass(lDAPObjectClassSchema);
        return new SchemaObjectClass(lDAPObjectClassSchema, this.m_schemaMgr);
    }

    public NamingEnumeration getBindingsList(String string) throws NamingException {
        SchemaDirContext schemaDirContext = (SchemaDirContext)this.lookup(string);
        if (schemaDirContext == this) {
            return new SchemaElementBindingEnum(this.m_schemaMgr.getObjectClasses(), this.m_schemaMgr);
        }
        throw new NotContextException(string);
    }

    public NamingEnumeration getNameList(String string) throws NamingException {
        SchemaDirContext schemaDirContext = (SchemaDirContext)this.lookup(string);
        if (schemaDirContext == this) {
            return new SchemaElementNameEnum(this.m_schemaMgr.getObjectClassNames());
        }
        throw new NotContextException(string);
    }

    public Object lookupSchemaElement(String string) throws NamingException {
        if (string.length() == 0) {
            return this;
        }
        LDAPObjectClassSchema lDAPObjectClassSchema = this.m_schemaMgr.getObjectClass(string);
        if (lDAPObjectClassSchema == null) {
            throw new NameNotFoundException(string);
        }
        return new SchemaObjectClass(lDAPObjectClassSchema, this.m_schemaMgr);
    }

    public void removeSchemaElement(String string) throws NamingException {
        if (string.length() == 0) {
            throw new NamingException("Can not delete schema object container");
        }
        this.m_schemaMgr.removeObjectClass(string);
    }
}

