/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaElement;
import com.netscape.jndi.ldap.schema.SchemaManager;
import java.util.Enumeration;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPObjectClassSchema;

public class SchemaObjectClass
extends SchemaElement {
    LDAPObjectClassSchema m_ldapObjectClass;
    private static String[] m_allAttrIds = new String[]{"NUMERICOID", "NAME", "DESC", "OBSOLETE", "SUP", "ABSTRACT", "STRUCTURAL", "AUXILIARY", "MUST", "MAY"};

    public SchemaObjectClass(Attributes attributes, SchemaManager schemaManager) throws NamingException {
        super(schemaManager);
        this.m_ldapObjectClass = SchemaObjectClass.parseDefAttributes(attributes);
        this.m_path = "ClassDefinition/" + this.m_ldapObjectClass.getName();
    }

    public SchemaObjectClass(LDAPObjectClassSchema lDAPObjectClassSchema, SchemaManager schemaManager) {
        super(schemaManager);
        this.m_ldapObjectClass = lDAPObjectClassSchema;
        this.m_path = "ClassDefinition/" + this.m_ldapObjectClass.getName();
    }

    Attributes extractAttributeIds(String[] stringArray) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes();
        String string = null;
        Object var4_4 = null;
        int n = 0;
        while (n < stringArray.length) {
            Enumeration enumeration;
            BasicAttribute basicAttribute;
            if (stringArray[n].equals("NUMERICOID")) {
                string = this.m_ldapObjectClass.getID();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("NUMERICOID", string));
                }
            } else if (stringArray[n].equals("NAME")) {
                string = this.m_ldapObjectClass.getName();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("NAME", string));
                }
            } else if (stringArray[n].equals("DESC")) {
                string = this.m_ldapObjectClass.getDescription();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("DESC", string));
                }
            } else if (stringArray[n].equals("SUP")) {
                string = this.m_ldapObjectClass.getSuperior();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("SUP", string));
                }
            } else if (stringArray[n].equals("MAY")) {
                basicAttribute = new BasicAttribute("MAY");
                enumeration = this.m_ldapObjectClass.getOptionalAttributes();
                while (enumeration.hasMoreElements()) {
                    basicAttribute.add(enumeration.nextElement());
                }
                if (basicAttribute.size() != 0) {
                    basicAttributes.put(basicAttribute);
                }
            } else if (stringArray[n].equals("MUST")) {
                basicAttribute = new BasicAttribute("MUST");
                enumeration = this.m_ldapObjectClass.getRequiredAttributes();
                while (enumeration.hasMoreElements()) {
                    basicAttribute.add(enumeration.nextElement());
                }
                if (basicAttribute.size() != 0) {
                    basicAttributes.put(basicAttribute);
                }
            } else if (stringArray[n].equals("OBSOLETE")) {
                if (this.m_ldapObjectClass.getQualifier("OBSOLETE") != null) {
                    basicAttributes.put(new BasicAttribute("OBSOLETE", "true"));
                }
            } else if (stringArray[n].equals("ABSTRACT")) {
                if (this.m_ldapObjectClass.getQualifier("ABSTRACT") != null) {
                    basicAttributes.put(new BasicAttribute("ABSTRACT", "true"));
                }
            } else if (stringArray[n].equals("STRUCTURAL")) {
                if (this.m_ldapObjectClass.getQualifier("STRUCTURAL") != null) {
                    basicAttributes.put(new BasicAttribute("STRUCTURAL", "true"));
                }
            } else if (stringArray[n].equals("AUXILIARY")) {
                if (this.m_ldapObjectClass.getQualifier("AUXILIARY") != null) {
                    basicAttributes.put(new BasicAttribute("AUXILIARY", "true"));
                }
            } else {
                throw new NamingException("Invalid schema attribute type for object class definition " + stringArray[n]);
            }
            ++n;
        }
        return basicAttributes;
    }

    public Attributes getAttributes(String string) throws NamingException {
        if (string.length() != 0) {
            throw new NameNotFoundException(string);
        }
        return this.extractAttributeIds(m_allAttrIds);
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        if (string.length() != 0) {
            throw new NameNotFoundException(string);
        }
        return this.extractAttributeIds(stringArray);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        return this.getAttributes(name.toString(), stringArray);
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        if (string.length() != 0) {
            throw new NameNotFoundException(string);
        }
        Attributes attributes2 = this.extractAttributeIds(m_allAttrIds);
        this.modifySchemaElementAttrs(attributes2, n, attributes);
        LDAPObjectClassSchema lDAPObjectClassSchema = SchemaObjectClass.parseDefAttributes(attributes2);
        this.m_schemaMgr.modifyObjectClass(this.m_ldapObjectClass, lDAPObjectClassSchema);
        this.m_ldapObjectClass = lDAPObjectClassSchema;
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        if (string.length() != 0) {
            throw new NameNotFoundException(string);
        }
        Attributes attributes = this.extractAttributeIds(m_allAttrIds);
        this.modifySchemaElementAttrs(attributes, modificationItemArray);
        LDAPObjectClassSchema lDAPObjectClassSchema = SchemaObjectClass.parseDefAttributes(attributes);
        this.m_schemaMgr.modifyObjectClass(this.m_ldapObjectClass, lDAPObjectClassSchema);
        this.m_ldapObjectClass = lDAPObjectClassSchema;
    }

    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        this.modifyAttributes(name.toString(), n, attributes);
    }

    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        this.modifyAttributes(name.toString(), modificationItemArray);
    }

    static LDAPObjectClassSchema parseDefAttributes(Attributes attributes) throws NamingException {
        Attribute attribute;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMoreElements()) {
            NamingEnumeration<?> namingEnumeration2;
            attribute = (Attribute)namingEnumeration.nextElement();
            String string5 = attribute.getID();
            if (string5.equals("NAME")) {
                string = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            if (string5.equals("NUMERICOID")) {
                string2 = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            if (string5.equals("SUP")) {
                string4 = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            if (string5.equals("DESC")) {
                string3 = SchemaElement.getSchemaAttrValue(attribute);
                continue;
            }
            if (string5.equals("MAY")) {
                namingEnumeration2 = attribute.getAll();
                while (namingEnumeration2.hasMoreElements()) {
                    vector2.addElement((String)namingEnumeration2.nextElement());
                }
                continue;
            }
            if (string5.equals("MUST")) {
                namingEnumeration2 = attribute.getAll();
                while (namingEnumeration2.hasMoreElements()) {
                    vector.addElement((String)namingEnumeration2.nextElement());
                }
                continue;
            }
            if (string5.equals("OBSOLETE")) {
                bl = SchemaElement.parseTrueFalseValue(attribute);
                continue;
            }
            if (string5.equals("ABSTRACT")) {
                bl2 = SchemaElement.parseTrueFalseValue(attribute);
                continue;
            }
            if (string5.equals("STRUCTURAL")) {
                bl3 = SchemaElement.parseTrueFalseValue(attribute);
                continue;
            }
            if (string5.equals("AUXILIARY")) {
                bl4 = SchemaElement.parseTrueFalseValue(attribute);
                continue;
            }
            throw new NamingException("Invalid schema attribute type for object class definition " + string5);
        }
        attribute = new LDAPObjectClassSchema(string, string2, string4, string3, SchemaElement.vectorToStringAry(vector), SchemaElement.vectorToStringAry(vector2));
        if (bl) {
            attribute.setQualifier("OBSOLETE", "");
        }
        if (bl2) {
            attribute.setQualifier("ABSTRACT", "");
        }
        if (bl3) {
            attribute.setQualifier("STRUCTURAL", "");
        }
        if (bl4) {
            attribute.setQualifier("AUXILIARY", "");
        }
        return attribute;
    }
}

