/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;

class LdapNameParser
implements NameParser {
    private static LdapNameParser m_parser;
    static Properties nameSyntax;

    static {
        nameSyntax = new Properties();
        ((Hashtable)nameSyntax).put("jndi.syntax.direction", "right_to_left");
        ((Hashtable)nameSyntax).put("jndi.syntax.separator", ",");
        ((Hashtable)nameSyntax).put("jndi.syntax.ignorecase", "true");
        ((Hashtable)nameSyntax).put("jndi.syntax.escape", "\\");
        ((Hashtable)nameSyntax).put("jndi.syntax.beginquote", "\"");
        ((Hashtable)nameSyntax).put("jndi.syntax.trimblanks", "true");
        ((Hashtable)nameSyntax).put("jndi.syntax.separator.ava", "+");
        ((Hashtable)nameSyntax).put("jndi.syntax.separator.typeval", "=");
    }

    private LdapNameParser() {
    }

    static String getAttrName(String string) throws NamingException {
        int n = string.indexOf("=");
        return n >= 0 ? string.substring(0, n).trim() : null;
    }

    static String getAttrValue(String string) throws NamingException {
        int n = string.indexOf("=");
        return n >= 0 ? string.substring(n + 1).trim() : null;
    }

    public static LdapNameParser getParser() {
        if (m_parser == null) {
            m_parser = new LdapNameParser();
        }
        return m_parser;
    }

    static String getRDN(String string) throws NamingException {
        Name name = LdapNameParser.getParser().parse(string);
        if (name.size() > 0) {
            return name.get(name.size() - 1);
        }
        return "";
    }

    static String getRelativeName(String string, String string2) throws NamingException {
        if (string2 == null) {
            string2 = "";
        }
        Name name = LdapNameParser.getParser().parse(string);
        Name name2 = LdapNameParser.getParser().parse(string2);
        if (!name2.startsWith(name)) {
            throw new NamingException("Name not in context");
        }
        return name2.getSuffix(name.size()).toString();
    }

    static String getRelativeName(Name name, String string) throws NamingException {
        Name name2;
        if (string == null) {
            string = "";
        }
        if (!(name2 = LdapNameParser.getParser().parse(string)).startsWith(name)) {
            throw new NamingException("Name not in context");
        }
        return name2.getSuffix(name.size()).toString();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 2) {
            System.out.println("Usage LdapNameParser <ctxname> <entryname>");
            System.exit(1);
        }
        try {
            StringBuffer stringBuffer = new StringBuffer("relativeName: ");
            LdapNameParser.getParser();
            System.out.println(stringBuffer.append(LdapNameParser.getRelativeName(stringArray[0], stringArray[1])).toString());
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public static void main0(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage LdapNameParser <name>");
            System.exit(1);
        }
        try {
            Name name = LdapNameParser.getParser().parse(stringArray[0]);
            System.out.println(name);
            StringBuffer stringBuffer = new StringBuffer("rdn: ");
            LdapNameParser.getParser();
            System.out.println(stringBuffer.append(LdapNameParser.getRDN(stringArray[0])).toString());
            name.add("attr=val");
            System.out.println(name);
            System.out.println(name.get(0));
            System.out.println("in name=val name:<" + LdapNameParser.getAttrName("name=val ") + "> val:<" + LdapNameParser.getAttrValue("name=val ") + ">");
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public Name parse(String string) throws NamingException {
        return new CompoundName(string, nameSyntax);
    }
}

