/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap;

import com.netscape.jndi.ldap.common.ShareableEnv;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPRebind;
import netscape.ldap.LDAPRebindAuth;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPUrl;

class ContextEnv
extends ShareableEnv {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 389;
    public static final int DEFAULT_SSL_PORT = 636;
    public static final int DEFAULT_LDAP_VERSION = 3;
    public static final String P_PROVIDER_URL = "java.naming.provider.url";
    public static final String P_SECURITY_PROTOCOL = "java.naming.security.protocol";
    public static final String P_SECURITY_AUTHMODE = "java.naming.security.authentication";
    public static final String P_USER_DN = "java.naming.security.principal";
    public static final String P_USER_PASSWORD = "java.naming.security.credentials";
    public static final String P_APPLET = "java.naming.applet";
    public static final String P_AUTHORITATIVE = "java.naming.authoritative";
    public static final String P_LANGUAGE = "java.naming.language";
    public static final String P_BATCHSIZE = "java.naming.batchsize";
    public static final String P_REFERRAL_MODE = "java.naming.referral";
    public static final String P_CONNECT_CTRLS = "java.naming.ldap.control.connect";
    public static final String P_BINARY_ATTRS = "java.naming.ldap.attributes.binary";
    public static final String P_ATTRS_ONLY = "java.naming.ldap.typesOnly";
    public static final String P_DELETE_OLDRDN = "java.naming.ldap.deleteRDN";
    public static final String P_SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    public static final String P_CIPHER_SUITE = "java.naming.ldap.ssl.ciphers";
    public static final String P_TIME_LIMIT = "java.naming.ldap.timelimit";
    public static final String P_MAX_RESULTS = "java.naming.ldap.maxresults";
    public static final String P_DEREF_ALIASES = "java.naming.ldap.derefAliases";
    public static final String P_REFERRAL_HOPLIMIT = "java.naming.referral.limit";
    public static final String P_LDAP_VERSION = "java.naming.ldap.version";
    public static final String P_JNDIREF_SEPARATOR = "java.naming.ref.separator";
    public static final String P_SASL_AUTHID = "java.naming.security.sasl.authorizationId";
    public static final String P_SASL_CALLBACK = "java.naming.security.sasl.callback";
    public static final String P_SASL_PKGS = "javax.security.sasl.client.pkgs";
    private static final String SASL_PROP_PREFIX = "javax.security.sasl";
    public static final String P_TRACE = "com.netscape.ldap.trace";
    private static final String V_REFERRAL_FOLLOW = "follow";
    private static final String V_REFERRAL_IGNORE = "ignore";
    private static final String V_REFERRAL_THROW_EXCEPTION = "throw";
    private static final String V_DEREF_NEVER = "never";
    private static final String V_DEREF_SEARCHING = "searching";
    private static final String V_DEREF_FINDING = "finding";
    private static final String V_DEREF_ALWAYS = "always";
    private static final String V_AUTH_NONE = "none";
    private static final String V_AUTH_SIMPLE = "simple";

    public ContextEnv(ShareableEnv shareableEnv, int n) {
        super(shareableEnv, n);
    }

    public ContextEnv(Hashtable hashtable) {
        super(hashtable);
    }

    public Object clone() {
        this.freezeUpdates();
        if (this.m_sharedEnv != null) {
            return new ContextEnv(this, this.m_sharedEnv.size() - 1);
        }
        return new ContextEnv(this.m_parentEnv, this.m_parentSharedEnvIdx);
    }

    boolean getAttrsOnlyFlag() {
        String string = (String)this.getProperty(P_ATTRS_ONLY);
        if (string == null) {
            return false;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Illegal value for java.naming.ldap.typesOnly");
    }

    Object getCipherSuite() {
        return this.getProperty(P_CIPHER_SUITE);
    }

    LDAPControl[] getConnectControls() throws NamingException {
        Control[] controlArray = (Control[])this.getProperty(P_CONNECT_CTRLS);
        if (controlArray != null) {
            LDAPControl[] lDAPControlArray = new LDAPControl[controlArray.length];
            int n = 0;
            while (n < controlArray.length) {
                try {
                    lDAPControlArray[n] = (LDAPControl)controlArray[n];
                }
                catch (ClassCastException classCastException) {
                    throw new NamingException("Unsupported control type " + controlArray[n].getClass().getName());
                }
                ++n;
            }
            return lDAPControlArray;
        }
        return null;
    }

    boolean getDeleteOldRDNFlag() {
        String string = (String)this.getProperty(P_DELETE_OLDRDN);
        if (string == null) {
            return true;
        }
        if (string.equalsIgnoreCase("true")) {
            return true;
        }
        if (string.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IllegalArgumentException("Illegal value for java.naming.ldap.deleteRDN");
    }

    LDAPUrl getDirectoryServerURL() throws NamingException {
        String string = (String)this.getProperty(P_PROVIDER_URL);
        try {
            return string == null ? null : new LDAPUrl(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Illegal value for java.naming.provider.url");
        }
    }

    int getLdapVersion() throws NamingException {
        String string = (String)this.getProperty(P_LDAP_VERSION);
        if (string != null) {
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Illegal value for java.naming.ldap.version property.");
            }
            return n;
        }
        return 3;
    }

    char getRefSeparator() throws NamingException {
        String string = (String)this.getProperty(P_JNDIREF_SEPARATOR);
        if (string != null) {
            if (string.length() != 1) {
                throw new IllegalArgumentException("Illegal value for java.naming.ref.separator");
            }
            return string.charAt(0);
        }
        return '#';
    }

    String getSaslAuthId() {
        String string = (String)this.getProperty(P_SASL_AUTHID);
        if (string != null) {
            return string;
        }
        return (String)this.getProperty(P_USER_DN);
    }

    Object getSaslCallback() {
        return this.getProperty(P_SASL_CALLBACK);
    }

    String[] getSaslMechanisms() {
        String string = (String)this.getProperty(P_SECURITY_AUTHMODE);
        if (string != null) {
            if (string.equalsIgnoreCase(V_AUTH_NONE)) {
                return null;
            }
            if (string.equalsIgnoreCase(V_AUTH_SIMPLE)) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2] = stringTokenizer.nextToken();
                ++n2;
            }
        }
        return null;
    }

    Hashtable getSaslProps() {
        Hashtable hashtable = this.getAllProperties();
        Hashtable hashtable2 = new Hashtable();
        String string = SASL_PROP_PREFIX.toUpperCase();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(SASL_PROP_PREFIX) && !string2.startsWith(string) || string2.equalsIgnoreCase(P_SASL_AUTHID) || string2.equalsIgnoreCase(P_SASL_CALLBACK)) continue;
            hashtable2.put(string2, hashtable.get(string2));
        }
        return hashtable2.size() > 0 ? hashtable2 : null;
    }

    String getSocketFactory() {
        return (String)this.getProperty(P_SOCKET_FACTORY);
    }

    String getUserDN() {
        return (String)this.getProperty(P_USER_DN);
    }

    String[] getUserDefBinaryAttrs() {
        String string = (String)this.getProperty(P_BINARY_ATTRS);
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    String getUserPassword() {
        return (String)this.getProperty(P_USER_PASSWORD);
    }

    boolean ignoreReferralsMode() {
        String string = (String)this.getProperty(P_REFERRAL_MODE);
        return string == null || string.equalsIgnoreCase(V_REFERRAL_IGNORE);
    }

    boolean isSSLEnabled() throws NamingException {
        String string = (String)this.getProperty(P_SECURITY_PROTOCOL);
        if (string != null) {
            if (string.equalsIgnoreCase("ssl")) {
                return true;
            }
            throw new AuthenticationNotSupportedException("Unsupported value for java.naming.security.protocol");
        }
        return false;
    }

    void updateBatchSize(LDAPSearchConstraints lDAPSearchConstraints) {
        String string = (String)this.getProperty(P_BATCHSIZE);
        if (string != null) {
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Illegal value for java.naming.batchsize");
            }
            lDAPSearchConstraints.setBatchSize(n);
        }
    }

    final void updateDerefAliases(LDAPSearchConstraints lDAPSearchConstraints) throws IllegalArgumentException {
        String string = (String)this.getProperty(P_DEREF_ALIASES);
        if (string != null) {
            if (string.equalsIgnoreCase(V_DEREF_NEVER)) {
                lDAPSearchConstraints.setDereference(0);
            } else if (string.equalsIgnoreCase(V_DEREF_SEARCHING)) {
                lDAPSearchConstraints.setDereference(1);
            } else if (string.equalsIgnoreCase(V_DEREF_FINDING)) {
                lDAPSearchConstraints.setDereference(2);
            } else if (string.equalsIgnoreCase(V_DEREF_ALWAYS)) {
                lDAPSearchConstraints.setDereference(3);
            } else {
                throw new IllegalArgumentException("Illegal value for java.naming.ldap.derefAliases");
            }
        }
    }

    void updateMaxResults(LDAPSearchConstraints lDAPSearchConstraints) {
        String string = (String)this.getProperty(P_MAX_RESULTS);
        if (string != null) {
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Illegal value for java.naming.ldap.maxresults");
            }
            lDAPSearchConstraints.setMaxResults(n);
        }
    }

    Object updateProperty(String string, Object object, LDAPSearchConstraints lDAPSearchConstraints) throws NamingException {
        Object object2 = this.getProperty(string);
        this.setProperty(string, object);
        try {
            if (string.equalsIgnoreCase(P_BATCHSIZE)) {
                this.updateBatchSize(lDAPSearchConstraints);
            } else if (string.equalsIgnoreCase(P_TIME_LIMIT)) {
                this.updateTimeLimit(lDAPSearchConstraints);
            } else if (string.equalsIgnoreCase(P_MAX_RESULTS)) {
                this.updateMaxResults(lDAPSearchConstraints);
            } else if (string.equalsIgnoreCase(P_DEREF_ALIASES)) {
                this.updateDerefAliases(lDAPSearchConstraints);
            } else if (string.equalsIgnoreCase(P_REFERRAL_MODE)) {
                this.updateReferralMode(lDAPSearchConstraints);
            } else if (string.equalsIgnoreCase(P_REFERRAL_HOPLIMIT)) {
                this.updateReferralHopLimit(lDAPSearchConstraints);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (object2 == null) {
                this.removeProperty(string);
            } else {
                this.setProperty(string, object2);
            }
            throw illegalArgumentException;
        }
        return object2;
    }

    void updateReferralHopLimit(LDAPSearchConstraints lDAPSearchConstraints) throws IllegalArgumentException {
        String string = (String)this.getProperty(P_REFERRAL_HOPLIMIT);
        if (string != null) {
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Illegal value for java.naming.referral.limit");
            }
            lDAPSearchConstraints.setHopLimit(n);
        }
    }

    void updateReferralMode(LDAPSearchConstraints lDAPSearchConstraints) {
        String string = (String)this.getProperty(P_REFERRAL_MODE);
        if (string != null) {
            if (string.equalsIgnoreCase(V_REFERRAL_FOLLOW)) {
                lDAPSearchConstraints.setReferrals(true);
                String string2 = this.getUserDN();
                String string3 = this.getUserPassword();
                if (string2 != null && string3 != null) {
                    lDAPSearchConstraints.setRebindProc((LDAPRebind)new ReferralRebindProc(string2, string3));
                }
            } else if (string.equalsIgnoreCase(V_REFERRAL_THROW_EXCEPTION)) {
                lDAPSearchConstraints.setReferrals(false);
            } else if (string.equalsIgnoreCase(V_REFERRAL_IGNORE)) {
                lDAPSearchConstraints.setServerControls(new LDAPControl("2.16.840.1.113730.3.4.2", false, null));
                lDAPSearchConstraints.setReferrals(false);
            } else {
                throw new IllegalArgumentException("Illegal value for java.naming.referral");
            }
        }
    }

    void updateSearchCons(LDAPSearchConstraints lDAPSearchConstraints) throws NamingException {
        this.updateBatchSize(lDAPSearchConstraints);
        this.updateTimeLimit(lDAPSearchConstraints);
        this.updateMaxResults(lDAPSearchConstraints);
        this.updateDerefAliases(lDAPSearchConstraints);
        this.updateReferralMode(lDAPSearchConstraints);
        this.updateReferralHopLimit(lDAPSearchConstraints);
    }

    void updateTimeLimit(LDAPSearchConstraints lDAPSearchConstraints) {
        String string = (String)this.getProperty(P_TIME_LIMIT);
        if (string != null) {
            int n = -1;
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Illegal value for java.naming.ldap.timelimit");
            }
            lDAPSearchConstraints.setTimeLimit(n);
        }
    }

    static class ReferralRebindProc
    implements LDAPRebind {
        LDAPRebindAuth auth;

        public ReferralRebindProc(String string, String string2) {
            this.auth = new LDAPRebindAuth(string, string2);
        }

        public LDAPRebindAuth getRebindAuthentication(String string, int n) {
            return this.auth;
        }
    }
}

