/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Hashtable;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPMatchingRuleSchema;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchemaElement;
import netscape.ldap.LDAPSearchResults;

public class LDAPSchema {
    private Hashtable objectClasses = new Hashtable();
    private Hashtable attributes = new Hashtable();
    private Hashtable matchingRules = new Hashtable();

    public LDAPSchema() {
    }

    public LDAPSchema(LDAPEntry lDAPEntry) {
        this.initialize(lDAPEntry);
    }

    protected void addAttribute(LDAPAttributeSchema lDAPAttributeSchema) {
        this.attributes.put(lDAPAttributeSchema.getName().toLowerCase(), lDAPAttributeSchema);
    }

    protected void addMatchingRule(LDAPMatchingRuleSchema lDAPMatchingRuleSchema) {
        this.matchingRules.put(lDAPMatchingRuleSchema.getName().toLowerCase(), lDAPMatchingRuleSchema);
    }

    protected void addObjectClass(LDAPObjectClassSchema lDAPObjectClassSchema) {
        this.objectClasses.put(lDAPObjectClassSchema.getName().toLowerCase(), lDAPObjectClassSchema);
    }

    public void fetchSchema(LDAPConnection lDAPConnection) throws LDAPException {
        this.fetchSchema(lDAPConnection, "");
    }

    public void fetchSchema(LDAPConnection lDAPConnection, String string) throws LDAPException {
        String string2 = LDAPSchema.getSchemaDN(lDAPConnection, string);
        LDAPEntry lDAPEntry = LDAPSchema.readSchema(lDAPConnection, string2);
        this.initialize(lDAPEntry);
    }

    public LDAPAttributeSchema getAttribute(String string) {
        return (LDAPAttributeSchema)this.attributes.get(string.toLowerCase());
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public Enumeration getAttributes() {
        return this.attributes.elements();
    }

    public LDAPMatchingRuleSchema getMatchingRule(String string) {
        return (LDAPMatchingRuleSchema)this.matchingRules.get(string.toLowerCase());
    }

    public Enumeration getMatchingRuleNames() {
        return this.matchingRules.keys();
    }

    public Enumeration getMatchingRules() {
        return this.matchingRules.elements();
    }

    public LDAPObjectClassSchema getObjectClass(String string) {
        return (LDAPObjectClassSchema)this.objectClasses.get(string.toLowerCase());
    }

    public Enumeration getObjectClassNames() {
        return this.objectClasses.keys();
    }

    public Enumeration getObjectClasses() {
        return this.objectClasses.elements();
    }

    static String getSchemaDN(LDAPConnection lDAPConnection, String string) throws LDAPException {
        Enumeration enumeration;
        if (lDAPConnection == null || !lDAPConnection.isConnected()) {
            throw new LDAPException("No connection", 80);
        }
        String[] stringArray = new String[]{"subschemasubentry"};
        LDAPEntry lDAPEntry = lDAPConnection.read(string, stringArray);
        if (lDAPEntry == null) {
            throw new LDAPException("", 32);
        }
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(stringArray[0]);
        String string2 = "cn=schema";
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
        }
        return string2;
    }

    protected void initialize(LDAPEntry lDAPEntry) {
        LDAPMatchingRuleSchema lDAPMatchingRuleSchema;
        String string;
        Object object;
        Enumeration enumeration;
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("objectclasses");
        if (lDAPAttribute != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                object = new LDAPObjectClassSchema((String)enumeration.nextElement());
                this.addObjectClass((LDAPObjectClassSchema)object);
            }
        }
        if ((lDAPAttribute = lDAPEntry.getAttribute("attributetypes")) != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                object = new LDAPAttributeSchema((String)enumeration.nextElement());
                this.addAttribute((LDAPAttributeSchema)object);
            }
        }
        object = new Hashtable();
        lDAPAttribute = lDAPEntry.getAttribute("matchingruleuse");
        if (lDAPAttribute != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                lDAPMatchingRuleSchema = new LDAPMatchingRuleSchema(null, string);
                ((Hashtable)object).put(lDAPMatchingRuleSchema.getOID(), string);
            }
        }
        if ((lDAPAttribute = lDAPEntry.getAttribute("matchingrules")) != null) {
            enumeration = lDAPAttribute.getStringValues();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                lDAPMatchingRuleSchema = new LDAPMatchingRuleSchema(string, null);
                String string2 = (String)((Hashtable)object).get(lDAPMatchingRuleSchema.getOID());
                if (string2 != null) {
                    lDAPMatchingRuleSchema = new LDAPMatchingRuleSchema(string, string2);
                }
                this.addMatchingRule(lDAPMatchingRuleSchema);
            }
        }
    }

    static boolean isAttributeSyntaxStandardsCompliant(LDAPConnection lDAPConnection) throws LDAPException {
        Enumeration enumeration;
        String[] stringArray;
        String string = (String)lDAPConnection.getProperty("com.netscape.ldap.schema.quoting");
        if (string != null) {
            return string.equalsIgnoreCase("standard");
        }
        boolean bl = true;
        String string2 = LDAPSchema.getSchemaDN(lDAPConnection, "");
        LDAPEntry lDAPEntry = lDAPConnection.read(string2, stringArray = new String[]{"attributetypes"});
        LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute("attributetypes");
        if (lDAPAttribute != null && (enumeration = lDAPAttribute.getStringValues()).hasMoreElements()) {
            bl = LDAPSchema.isSyntaxQuoted((String)enumeration.nextElement()) ^ true;
        }
        lDAPConnection.setProperty("com.netscape.ldap.schema.quoting", bl ? "standard" : "NetscapeBug");
        return bl;
    }

    static boolean isSyntaxQuoted(String string) {
        int n = string.indexOf(" SYNTAX ");
        if (n >= 0) {
            int n2 = string.length() - (n += 8);
            char[] cArray = new char[n2];
            string.getChars(n, string.length(), cArray, 0);
            n = 0;
            while (n < cArray.length && cArray[n] == ' ') {
                ++n;
            }
            if (n < cArray.length) {
                return cArray[n] == '\'';
            }
        }
        return false;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2) {
            System.err.println("Usage: netscape.ldap.LDAPSchema HOST PORT");
            System.exit(1);
        }
        int n = Integer.parseInt(stringArray[1]);
        LDAPConnection lDAPConnection = new LDAPConnection();
        try {
            lDAPConnection.connect(stringArray[0], n);
            LDAPSchema lDAPSchema = new LDAPSchema();
            lDAPSchema.fetchSchema(lDAPConnection);
            lDAPConnection.disconnect();
            System.out.println("Object classes: ");
            LDAPSchema.printEnum(lDAPSchema.getObjectClasses());
            System.out.println("\nAttributes: ");
            LDAPSchema.printEnum(lDAPSchema.getAttributes());
            System.out.println("\nMatching rules: ");
            LDAPSchema.printEnum(lDAPSchema.getMatchingRules());
            System.exit(0);
        }
        catch (LDAPException lDAPException) {
            System.err.println(lDAPException);
        }
    }

    private static void printEnum(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            LDAPSchemaElement lDAPSchemaElement = (LDAPSchemaElement)enumeration.nextElement();
            System.out.println("  " + lDAPSchemaElement);
        }
    }

    private static LDAPEntry readSchema(LDAPConnection lDAPConnection, String string) throws LDAPException {
        return LDAPSchema.readSchema(lDAPConnection, string, null);
    }

    private static LDAPEntry readSchema(LDAPConnection lDAPConnection, String string, String[] stringArray) throws LDAPException {
        LDAPSearchResults lDAPSearchResults = lDAPConnection.search(string, 0, "objectclass=subschema", stringArray, false);
        if (!lDAPSearchResults.hasMoreElements()) {
            throw new LDAPException("Cannot read schema", 50);
        }
        return lDAPSearchResults.next();
    }

    public String toString() {
        String string = "Object classes:\n";
        Enumeration enumeration = this.getObjectClasses();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + enumeration.nextElement().toString();
            string = String.valueOf(string) + '\n';
        }
        string = String.valueOf(string) + "Attributes:\n";
        enumeration = this.getAttributes();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + enumeration.nextElement().toString();
            string = String.valueOf(string) + '\n';
        }
        string = String.valueOf(string) + "Matching rules:\n";
        enumeration = this.getMatchingRules();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + enumeration.nextElement().toString();
            string = String.valueOf(string) + '\n';
        }
        return string;
    }
}

