/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPRebind;

public class LDAPConstraints
implements Cloneable {
    private int m_hop_limit;
    private LDAPBind m_bind_proc;
    private LDAPRebind m_rebind_proc;
    private boolean referrals;
    private int m_time_limit;
    private LDAPControl[] m_clientControls;
    private LDAPControl[] m_serverControls;

    public LDAPConstraints() {
        this.m_time_limit = 0;
        this.referrals = false;
        this.m_bind_proc = null;
        this.m_rebind_proc = null;
        this.m_hop_limit = 5;
        this.m_clientControls = null;
        this.m_serverControls = null;
    }

    public LDAPConstraints(int n, boolean bl, LDAPBind lDAPBind, int n2) {
        this.m_time_limit = n;
        this.referrals = bl;
        this.m_bind_proc = lDAPBind;
        this.m_rebind_proc = null;
        this.m_hop_limit = n2;
        this.m_clientControls = null;
        this.m_serverControls = null;
    }

    public LDAPConstraints(int n, boolean bl, LDAPRebind lDAPRebind, int n2) {
        this.m_time_limit = n;
        this.referrals = bl;
        this.m_bind_proc = null;
        this.m_rebind_proc = lDAPRebind;
        this.m_hop_limit = n2;
        this.m_clientControls = null;
        this.m_serverControls = null;
    }

    public Object clone() {
        int n;
        LDAPConstraints lDAPConstraints = new LDAPConstraints();
        lDAPConstraints.m_time_limit = this.m_time_limit;
        lDAPConstraints.referrals = this.referrals;
        lDAPConstraints.m_bind_proc = this.m_bind_proc;
        lDAPConstraints.m_rebind_proc = this.m_rebind_proc;
        lDAPConstraints.m_hop_limit = this.m_hop_limit;
        if (this.m_clientControls != null && this.m_clientControls.length > 0) {
            lDAPConstraints.m_clientControls = new LDAPControl[this.m_clientControls.length];
            n = 0;
            while (n < this.m_clientControls.length) {
                lDAPConstraints.m_clientControls[n] = (LDAPControl)this.m_clientControls[n].clone();
                ++n;
            }
        }
        if (this.m_serverControls != null && this.m_serverControls.length > 0) {
            lDAPConstraints.m_serverControls = new LDAPControl[this.m_serverControls.length];
            n = 0;
            while (n < this.m_serverControls.length) {
                lDAPConstraints.m_serverControls[n] = (LDAPControl)this.m_serverControls[n].clone();
                ++n;
            }
        }
        return lDAPConstraints;
    }

    public LDAPBind getBindProc() {
        return this.m_bind_proc;
    }

    public LDAPControl[] getClientControls() {
        return this.m_clientControls;
    }

    public int getHopLimit() {
        return this.m_hop_limit;
    }

    public LDAPRebind getRebindProc() {
        return this.m_rebind_proc;
    }

    public boolean getReferrals() {
        return this.referrals;
    }

    public LDAPControl[] getServerControls() {
        return this.m_serverControls;
    }

    public int getTimeLimit() {
        return this.m_time_limit;
    }

    public void setBindProc(LDAPBind lDAPBind) {
        this.m_bind_proc = lDAPBind;
        if (lDAPBind != null) {
            this.m_rebind_proc = null;
        }
    }

    public void setClientControls(LDAPControl lDAPControl) {
        this.m_clientControls = new LDAPControl[1];
        this.m_clientControls[0] = lDAPControl;
    }

    public void setClientControls(LDAPControl[] lDAPControlArray) {
        this.m_clientControls = lDAPControlArray;
    }

    public void setHopLimit(int n) {
        this.m_hop_limit = n;
    }

    public void setRebindProc(LDAPRebind lDAPRebind) {
        this.m_rebind_proc = lDAPRebind;
        if (lDAPRebind != null) {
            this.m_bind_proc = null;
        }
    }

    public void setReferrals(boolean bl) {
        this.referrals = bl;
    }

    public void setServerControls(LDAPControl lDAPControl) {
        this.m_serverControls = new LDAPControl[1];
        this.m_serverControls[0] = lDAPControl;
    }

    public void setServerControls(LDAPControl[] lDAPControlArray) {
        this.m_serverControls = lDAPControlArray;
    }

    public void setTimeLimit(int n) {
        this.m_time_limit = n;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("LDAPConstraints {");
        stringBuffer.append("time limit " + this.getTimeLimit() + ", ");
        stringBuffer.append("referrals " + this.getReferrals() + ", ");
        stringBuffer.append("hop limit " + this.getHopLimit() + ", ");
        stringBuffer.append("bind_proc " + this.getBindProc() + ", ");
        stringBuffer.append("rebind_proc " + this.getRebindProc());
        LDAPControl[] lDAPControlArray = this.getClientControls();
        if (lDAPControlArray != null) {
            stringBuffer.append(", client controls ");
            n = 0;
            while (n < lDAPControlArray.length) {
                stringBuffer.append(lDAPControlArray[n].toString());
                if (n < lDAPControlArray.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n;
            }
        }
        if ((lDAPControlArray = this.getServerControls()) != null) {
            stringBuffer.append(", server controls ");
            n = 0;
            while (n < lDAPControlArray.length) {
                stringBuffer.append(lDAPControlArray[n].toString());
                if (n < lDAPControlArray.length - 1) {
                    stringBuffer.append(" ");
                }
                ++n;
            }
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

