/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j.spi;

import java.nio.charset.Charset;
import java.util.Arrays;
import org.ini4j.Registry;
import org.ini4j.spi.EscapeTool;
import org.ini4j.spi.ServiceFinder;
import org.ini4j.spi.TypeValuesPair;

public class RegEscapeTool
extends EscapeTool {
    private static final RegEscapeTool INSTANCE = ServiceFinder.findService(RegEscapeTool.class);
    private static final Charset HEX_CHARSET = Charset.forName("UTF-16LE");
    private static final int LOWER_DIGIT = 15;
    private static final int UPPER_DIGIT = 240;
    private static final int DIGIT_SIZE = 4;

    public static final RegEscapeTool getInstance() {
        return INSTANCE;
    }

    public TypeValuesPair decode(String raw) {
        Registry.Type type = this.type(raw);
        String value = type == Registry.Type.REG_SZ ? this.unquote(raw) : raw.substring(type.toString().length() + 1);
        switch (type) {
            case REG_EXPAND_SZ: 
            case REG_MULTI_SZ: {
                byte[] bytes = this.binary(value);
                value = new String(bytes, 0, bytes.length - 2, HEX_CHARSET);
                break;
            }
            case REG_DWORD: {
                value = String.valueOf(Long.parseLong(value, 16));
                break;
            }
            case REG_SZ: {
                break;
            }
        }
        String[] values = type == Registry.Type.REG_MULTI_SZ ? this.splitMulti(value) : new String[]{value};
        return new TypeValuesPair(type, values);
    }

    public String encode(TypeValuesPair data) {
        String ret = null;
        if (data.getType() == Registry.Type.REG_SZ) {
            ret = this.quote(data.getValues()[0]);
        } else if (data.getValues()[0] != null) {
            ret = this.encode(data.getType(), data.getValues());
        }
        return ret;
    }

    byte[] binary(String value) {
        byte[] bytes = new byte[value.length()];
        int idx = 0;
        int shift = 4;
        int i = 0;
        while (i < value.length()) {
            char c = value.charAt(i);
            if (!Character.isWhitespace(c)) {
                if (c == ',') {
                    ++idx;
                    shift = 4;
                } else {
                    int digit = Character.digit(c, 16);
                    if (digit >= 0) {
                        int n = idx;
                        bytes[n] = (byte)(bytes[n] | digit << shift);
                        shift = 0;
                    }
                }
            }
            ++i;
        }
        return Arrays.copyOfRange(bytes, 0, idx + 1);
    }

    String encode(Registry.Type type, String[] values) {
        StringBuilder buff = new StringBuilder();
        buff.append(type.toString());
        buff.append(':');
        switch (type) {
            case REG_EXPAND_SZ: {
                buff.append(this.hexadecimal(values[0]));
                break;
            }
            case REG_DWORD: {
                buff.append(String.format("%08x", Long.valueOf(values[0])));
                break;
            }
            case REG_MULTI_SZ: {
                int n = values.length;
                int i = 0;
                while (i < n) {
                    buff.append(this.hexadecimal(values[i]));
                    buff.append(',');
                    ++i;
                }
                buff.append("00,00");
                break;
            }
            default: {
                buff.append(values[0]);
            }
        }
        return buff.toString();
    }

    String hexadecimal(String value) {
        StringBuilder buff = new StringBuilder();
        if (value != null && value.length() != 0) {
            byte[] bytes = value.getBytes(HEX_CHARSET);
            int i = 0;
            while (i < bytes.length) {
                buff.append(Character.forDigit((bytes[i] & 0xF0) >> 4, 16));
                buff.append(Character.forDigit(bytes[i] & 0xF, 16));
                buff.append(',');
                ++i;
            }
            buff.append("00,00");
        }
        return buff.toString();
    }

    Registry.Type type(String raw) {
        int idx;
        Registry.Type type = raw.charAt(0) == '\"' ? Registry.Type.REG_SZ : ((idx = raw.indexOf(58)) < 0 ? Registry.Type.REG_SZ : Registry.Type.fromString(raw.substring(0, idx)));
        return type;
    }

    private String[] splitMulti(String value) {
        int len = value.length();
        int n = 0;
        int start = 0;
        int end = value.indexOf(0, start);
        while (end >= 0) {
            ++n;
            start = end + 1;
            if (start >= len) break;
            end = value.indexOf(0, start);
        }
        String[] values = new String[n];
        start = 0;
        int i = 0;
        while (i < n) {
            end = value.indexOf(0, start);
            values[i] = value.substring(start, end);
            start = end + 1;
            ++i;
        }
        return values;
    }

    public static /* bridge */ /* synthetic */ EscapeTool getInstance() {
        return RegEscapeTool.getInstance();
    }
}

