/*
 * Decompiled with CFR 0.152.
 */
package org.ini4j.spi;

import org.ini4j.Config;
import org.ini4j.Profile;
import org.ini4j.spi.IniHandler;

abstract class AbstractProfileBuilder
implements IniHandler {
    private Profile.Section _currentSection;
    private boolean _header;
    private String _lastComment;

    AbstractProfileBuilder() {
    }

    @Override
    public void endIni() {
        if (this._lastComment != null && this._header) {
            this.getProfile().setComment(this._lastComment);
        }
    }

    @Override
    public void endSection() {
        this._currentSection = null;
    }

    @Override
    public void handleComment(String comment) {
        if (this._lastComment != null && this._header) {
            this.getProfile().setComment(this._lastComment);
            this._header = false;
        }
        this._lastComment = comment;
    }

    @Override
    public void handleOption(String name, String value) {
        this._header = false;
        if (this.getConfig().isMultiOption()) {
            this._currentSection.add(name, value);
        } else {
            this._currentSection.put(name, value);
        }
        if (this._lastComment != null) {
            this._currentSection.putComment(name, this._lastComment);
            this._lastComment = null;
        }
    }

    @Override
    public void startIni() {
        this._header = true;
    }

    @Override
    public void startSection(String sectionName) {
        if (this.getConfig().isMultiSection()) {
            this._currentSection = this.getProfile().add(sectionName);
        } else {
            Profile.Section s = (Profile.Section)this.getProfile().get(sectionName);
            Profile.Section section = this._currentSection = s == null ? this.getProfile().add(sectionName) : s;
        }
        if (this._lastComment != null) {
            if (this._header) {
                this.getProfile().setComment(this._lastComment);
            } else {
                this.getProfile().putComment(sectionName, this._lastComment);
            }
            this._lastComment = null;
        }
        this._header = false;
    }

    abstract Config getConfig();

    abstract Profile getProfile();

    Profile.Section getCurrentSection() {
        return this._currentSection;
    }
}

