/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.ListSelection;
import ca.odell.glazedlists.swt.Selectable;
import ca.odell.glazedlists.util.concurrent.Lock;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SelectionManager<E> {
    private ListSelection<E> selection;
    private Selectable selectable;
    private SelectionListener selectionListener;
    private boolean selectionInProgress = false;

    SelectionManager(EventList<E> source, Selectable selectable) {
        this.selection = new ListSelection<E>(source);
        this.selectable = selectable;
        this.selection.addSelectionListener(new SelectionListListener());
        if ((selectable.getStyle() & 4) == 4) {
            this.selectionListener = new SingleLineSelectionListener();
            this.selection.setSelectionMode(0);
        } else if ((selectable.getStyle() & 2) == 2) {
            this.selectionListener = new MultiLineSelectionListener();
            this.selection.setSelectionMode(103);
        }
        selectable.addSelectionListener(this.selectionListener);
    }

    public ListSelection<E> getSelectionList() {
        return this.selection;
    }

    void fireSelectionChanged(int start, int end) {
        if (start == -1) {
            return;
        }
        for (int i = start; i <= end; ++i) {
            if (this.selection.isSelected(i)) {
                this.selectable.select(i);
                continue;
            }
            this.selectable.deselect(i);
        }
    }

    public void dispose() {
        this.selectable.removeSelectionListener(this.selectionListener);
        this.selection.dispose();
    }

    private final class MultiLineSelectionListener
    implements SelectionListener {
        private MultiLineSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void widgetSelected(SelectionEvent event) {
            if (!SelectionManager.this.selectionInProgress) {
                SelectionManager.this.selectionInProgress = true;
                Lock writeLock = SelectionManager.this.selection.getSource().getReadWriteLock().writeLock();
                writeLock.lock();
                try {
                    SelectionManager.this.selection.setSelection(SelectionManager.this.selectable.getSelectionIndices());
                }
                finally {
                    SelectionManager.this.selectionInProgress = false;
                    writeLock.unlock();
                }
            }
        }
    }

    private final class SingleLineSelectionListener
    implements SelectionListener {
        private SingleLineSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent event) {
            this.widgetSelected(event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void widgetSelected(SelectionEvent event) {
            if (!SelectionManager.this.selectionInProgress) {
                SelectionManager.this.selectionInProgress = true;
                Lock writeLock = SelectionManager.this.selection.getSource().getReadWriteLock().writeLock();
                writeLock.lock();
                try {
                    SelectionManager.this.selection.setSelection(SelectionManager.this.selectable.getSelectionIndex());
                }
                finally {
                    SelectionManager.this.selectionInProgress = false;
                    writeLock.unlock();
                }
            }
        }
    }

    private final class SelectionListListener
    implements ListSelection.Listener {
        private SelectionListListener() {
        }

        public void selectionChanged(int changeStart, int changeEnd) {
            if (!SelectionManager.this.selectionInProgress) {
                SelectionManager.this.selectionInProgress = true;
                SelectionManager.this.fireSelectionChanged(changeStart, changeEnd);
                SelectionManager.this.selectionInProgress = false;
            }
        }
    }
}

