/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import ca.odell.glazedlists.swt.GlazedListsSWT;
import ca.odell.glazedlists.swt.Selectable;
import ca.odell.glazedlists.swt.SelectionManager;
import ca.odell.glazedlists.swt.TableCheckFilterList;
import ca.odell.glazedlists.swt.TableColumnConfigurer;
import ca.odell.glazedlists.swt.TableItemConfigurer;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTableViewer<E>
implements ListEventListener<E> {
    private Table table;
    protected TransformedList<E, E> swtThreadSource;
    private TableCheckFilterList<E, E> checkFilterList;
    protected EventList<E> source;
    private TableHandler<E> tableHandler;
    private TableFormat<? super E> tableFormat;
    private TableItemConfigurer<? super E> tableItemConfigurer;
    private SelectionManager<E> selection;

    public EventTableViewer(EventList<E> source, Table table, String[] propertyNames, String[] columnLabels) {
        this(source, table, GlazedLists.tableFormat(propertyNames, columnLabels));
    }

    public EventTableViewer(EventList<E> source, Table table, TableFormat<? super E> tableFormat) {
        this(source, table, tableFormat, TableItemConfigurer.DEFAULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTableViewer(EventList<E> source, Table table, TableFormat<? super E> tableFormat, TableItemConfigurer<? super E> tableItemConfigurer) {
        if (source == null) {
            throw new IllegalArgumentException("source list may not be null");
        }
        if (table == null) {
            throw new IllegalArgumentException("Table may not be null");
        }
        if (tableFormat == null) {
            throw new IllegalArgumentException("TableFormat may not be null");
        }
        if (tableItemConfigurer == null) {
            throw new IllegalArgumentException("TableItemConfigurer may not be null");
        }
        Lock writeLock = source.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            TransformedList<E, E> decorated = this.createSwtThreadProxyList(source, table.getDisplay());
            if (decorated != null && decorated != source) {
                this.swtThreadSource = decorated;
                this.source = this.swtThreadSource;
            } else {
                this.source = source;
            }
            if ((table.getStyle() & 0x20) == 32) {
                this.checkFilterList = new TableCheckFilterList(this.source, table, tableFormat);
                this.source = this.checkFilterList;
            }
            this.table = table;
            this.tableFormat = tableFormat;
            this.tableItemConfigurer = tableItemConfigurer;
            this.selection = new SelectionManager<E>(this.source, new SelectableTable());
            this.tableHandler = this.isTableVirtual() ? new VirtualTableHandler() : new DefaultTableHandler();
            this.initTable();
            this.tableHandler.populateTable();
            this.source.addListEventListener(this);
            this.source.getPublisher().setRelatedListener(this.selection.getSelectionList(), this);
        }
        finally {
            writeLock.unlock();
        }
    }

    protected TransformedList<E, E> createSwtThreadProxyList(EventList<E> source, Display display) {
        return GlazedListsSWT.isSWTThreadProxyList(source) ? null : GlazedListsSWT.swtThreadProxyList(source, display);
    }

    private boolean isTableVirtual() {
        return (this.table.getStyle() & 0x10000000) == 0x10000000;
    }

    private void initTable() {
        this.table.setHeaderVisible(true);
        TableColumnConfigurer configurer = this.getTableColumnConfigurer();
        for (int c = 0; c < this.tableFormat.getColumnCount(); ++c) {
            TableColumn column = new TableColumn(this.table, 16384, c);
            column.setText(this.tableFormat.getColumnName(c));
            column.setWidth(80);
            if (configurer == null) continue;
            configurer.configure(column, c);
        }
    }

    private void renderTableItem(TableItem item, E value, int row) {
        for (int i = 0; i < this.tableFormat.getColumnCount(); ++i) {
            Object cellValue = this.tableFormat.getColumnValue(value, i);
            this.tableItemConfigurer.configure(item, value, cellValue, row, i);
        }
    }

    public TableFormat<? super E> getTableFormat() {
        return this.tableFormat;
    }

    public void setTableFormat(TableFormat<E> tableFormat) {
        throw new UnsupportedOperationException();
    }

    public TableItemConfigurer<? super E> getTableItemConfigurer() {
        return this.tableItemConfigurer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTableItemConfigurer(TableItemConfigurer<? super E> tableItemConfigurer) {
        if (tableItemConfigurer == null) {
            throw new IllegalArgumentException("TableItemConfigurer may not be null");
        }
        this.tableItemConfigurer = tableItemConfigurer;
        int maxIndex = this.tableHandler.getLastIndex();
        if (maxIndex < 0) {
            return;
        }
        this.table.setRedraw(false);
        Lock readLock = this.source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            for (int i = 0; i <= maxIndex; ++i) {
                Object rowValue = this.source.get(i);
                for (int c = 0; c < this.tableFormat.getColumnCount(); ++c) {
                    Object columnValue = this.tableFormat.getColumnValue(rowValue, c);
                    tableItemConfigurer.configure(this.table.getItem(i), rowValue, columnValue, i, c);
                }
            }
        }
        finally {
            readLock.unlock();
        }
        this.table.setRedraw(true);
    }

    private TableColumnConfigurer getTableColumnConfigurer() {
        if (this.tableFormat instanceof TableColumnConfigurer) {
            return (TableColumnConfigurer)((Object)this.tableFormat);
        }
        return null;
    }

    public Table getTable() {
        return this.table;
    }

    public void setCheckedOnly(boolean checkedOnly) {
        this.checkFilterList.setCheckedOnly(checkedOnly);
    }

    public boolean getCheckedOnly() {
        return this.checkFilterList.getCheckedOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> getAllChecked() {
        Lock readLock = this.checkFilterList.getReadWriteLock().readLock();
        readLock.lock();
        try {
            List<E> list = this.checkFilterList.getAllChecked();
            return list;
        }
        finally {
            readLock.unlock();
        }
    }

    public EventList<E> getSourceList() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getDeselected() {
        Lock readLock = this.source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            EventList<E> eventList = this.selection.getSelectionList().getDeselected();
            return eventList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getTogglingDeselected() {
        Lock readLock = this.source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            EventList<E> eventList = this.selection.getSelectionList().getTogglingDeselected();
            return eventList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getSelected() {
        Lock readLock = this.source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            EventList<E> eventList = this.selection.getSelectionList().getSelected();
            return eventList;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getTogglingSelected() {
        Lock readLock = this.source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            EventList<E> eventList = this.selection.getSelectionList().getTogglingSelected();
            return eventList;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void listChanged(ListEvent listChanges) {
        if (this.table.isDisposed()) {
            return;
        }
        Barcode deletes = new Barcode();
        deletes.addWhite(0, this.source.size());
        int firstChange = this.source.size();
        this.table.setRedraw(false);
        while (listChanges.next()) {
            int changeIndex = listChanges.getIndex();
            int adjustedIndex = deletes.getIndex(changeIndex, Barcode.WHITE);
            int changeType = listChanges.getType();
            if (changeType == 2) {
                deletes.addWhite(adjustedIndex, 1);
                this.tableHandler.addRow(adjustedIndex, this.source.get(changeIndex));
                firstChange = Math.min(changeIndex, firstChange);
                continue;
            }
            if (changeType == 1) {
                this.tableHandler.updateRow(adjustedIndex, this.source.get(changeIndex));
                continue;
            }
            if (changeType != 0) continue;
            deletes.setBlack(adjustedIndex, 1);
            firstChange = Math.min(changeIndex, firstChange);
        }
        if (deletes.blackSize() > 0) {
            int[] deletedIndices = new int[deletes.blackSize()];
            BarcodeIterator i = deletes.iterator();
            while (i.hasNextBlack()) {
                i.nextBlack();
                deletedIndices[i.getBlackIndex()] = i.getIndex();
            }
            this.tableHandler.removeAll(deletedIndices);
        }
        this.table.setRedraw(true);
    }

    public void invertSelection() {
        this.selection.getSelectionList().invertSelection();
    }

    public void dispose() {
        this.tableHandler.dispose();
        this.selection.dispose();
        if (this.swtThreadSource != null) {
            this.swtThreadSource.dispose();
        }
        this.source.removeListEventListener(this);
        this.source.getPublisher().clearRelatedListener(this.selection.getSelectionList(), this);
        if (this.checkFilterList != null) {
            this.checkFilterList.dispose();
        }
        this.swtThreadSource = null;
        this.checkFilterList = null;
        this.tableHandler = null;
        this.selection = null;
        this.source = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class VirtualTableHandler
    implements TableHandler<E>,
    Listener {
        private final Barcode requested = new Barcode();

        public VirtualTableHandler() {
            this.requested.addWhite(0, EventTableViewer.this.source.size());
            EventTableViewer.this.table.addListener(36, (Listener)this);
        }

        @Override
        public void populateTable() {
            EventTableViewer.this.table.setItemCount(EventTableViewer.this.source.size());
        }

        @Override
        public void addRow(int row, E value) {
            if (row <= this.getLastIndex()) {
                this.requested.addBlack(row, 1);
                TableItem item = new TableItem(EventTableViewer.this.table, 0, row);
                EventTableViewer.this.renderTableItem(item, value, row);
            } else {
                this.requested.addWhite(this.requested.size(), 1);
                EventTableViewer.this.table.setItemCount(EventTableViewer.this.table.getItemCount() + 1);
            }
        }

        @Override
        public void updateRow(int row, E value) {
            if (!this.isVirtual(row)) {
                this.requested.setBlack(row, 1);
                TableItem item = EventTableViewer.this.table.getItem(row);
                EventTableViewer.this.renderTableItem(item, value, row);
            }
        }

        @Override
        public void removeAll(int[] rows) {
            for (int i = 0; i < rows.length; ++i) {
                this.requested.remove(rows[i] - i, 1);
            }
            EventTableViewer.this.table.remove(rows);
        }

        @Override
        public int getLastIndex() {
            if (this.requested.blackSize() == 0) {
                return -1;
            }
            return this.requested.getIndex(this.requested.blackSize() - 1, Barcode.BLACK);
        }

        private boolean isVirtual(int rowIndex) {
            return this.requested.getBlackIndex(rowIndex) == -1;
        }

        public void handleEvent(Event e) {
            TableItem item = (TableItem)e.item;
            int whiteIndex = this.requested.getWhiteIndex(EventTableViewer.this.table.indexOf(item), false);
            int index = this.requested.getIndex(whiteIndex, Barcode.WHITE);
            this.requested.setBlack(index, 1);
            EventTableViewer.this.renderTableItem(item, EventTableViewer.this.source.get(index), index);
        }

        @Override
        public void dispose() {
            EventTableViewer.this.table.removeListener(36, (Listener)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultTableHandler
    implements TableHandler<E> {
        private DefaultTableHandler() {
        }

        @Override
        public void populateTable() {
            int n = EventTableViewer.this.source.size();
            for (int i = 0; i < n; ++i) {
                this.addRow(i, EventTableViewer.this.source.get(i));
            }
        }

        @Override
        public void addRow(int row, E value) {
            TableItem item = new TableItem(EventTableViewer.this.table, 0, row);
            EventTableViewer.this.renderTableItem(item, value, row);
        }

        @Override
        public void updateRow(int row, E value) {
            TableItem item = EventTableViewer.this.table.getItem(row);
            EventTableViewer.this.renderTableItem(item, value, row);
        }

        @Override
        public void removeAll(int[] rows) {
            EventTableViewer.this.table.remove(rows);
        }

        @Override
        public void dispose() {
        }

        @Override
        public int getLastIndex() {
            return EventTableViewer.this.table.getItemCount() - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface TableHandler<E> {
        public void populateTable();

        public void addRow(int var1, E var2);

        public void updateRow(int var1, E var2);

        public void removeAll(int[] var1);

        public void dispose();

        public int getLastIndex();
    }

    private final class SelectableTable
    implements Selectable {
        private SelectableTable() {
        }

        public void addSelectionListener(SelectionListener listener) {
            EventTableViewer.this.table.addSelectionListener(listener);
        }

        public void removeSelectionListener(SelectionListener listener) {
            EventTableViewer.this.table.removeSelectionListener(listener);
        }

        public int getSelectionIndex() {
            return EventTableViewer.this.table.getSelectionIndex();
        }

        public int[] getSelectionIndices() {
            return EventTableViewer.this.table.getSelectionIndices();
        }

        public int getStyle() {
            return EventTableViewer.this.table.getStyle();
        }

        public void select(int index) {
            EventTableViewer.this.table.select(index);
        }

        public void deselect(int index) {
            EventTableViewer.this.table.deselect(index);
        }
    }
}

