/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swt.GlazedListsSWT;
import ca.odell.glazedlists.swt.KTableFormat;
import ca.odell.glazedlists.swt.TableFormatKTableFormat;
import ca.odell.glazedlists.util.concurrent.Lock;
import de.kupzog.ktable.KTable;
import de.kupzog.ktable.KTableCellEditor;
import de.kupzog.ktable.KTableCellRenderer;
import de.kupzog.ktable.KTableModel;
import org.eclipse.swt.graphics.Point;

public class EventKTableModel
implements KTableModel,
ListEventListener {
    private KTable table;
    private TransformedList swtThreadSource = null;
    private KTableFormat kTableFormat;

    public EventKTableModel(KTable table, EventList source, TableFormat tableFormat) {
        this.table = table;
        this.swtThreadSource = GlazedListsSWT.swtThreadProxyList(source, table.getDisplay());
        this.kTableFormat = tableFormat instanceof KTableFormat ? (KTableFormat)tableFormat : new TableFormatKTableFormat(tableFormat);
        this.swtThreadSource.addListEventListener(this);
    }

    public void listChanged(ListEvent listChanges) {
        this.table.redraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getContentAt(int column, int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return this.kTableFormat.getColumnHeaderValue(row, column);
        }
        Lock readLock = this.swtThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            Object object = this.kTableFormat.getColumnValue(this.swtThreadSource.get(row - this.getFixedHeaderRowCount()), column);
            return object;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTooltipAt(int column, int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return null;
        }
        Lock readLock = this.swtThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            String string = this.kTableFormat.getColumnTooltip(this.swtThreadSource.get(row - this.getFixedHeaderRowCount()), column);
            return string;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KTableCellEditor getCellEditor(int column, int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return null;
        }
        if (this.kTableFormat instanceof WritableTableFormat) {
            Lock readLock = this.swtThreadSource.getReadWriteLock().readLock();
            readLock.lock();
            try {
                Object baseObject = this.swtThreadSource.get(row);
                KTableCellEditor kTableCellEditor = this.kTableFormat.getColumnEditor(baseObject, column);
                return kTableCellEditor;
            }
            finally {
                readLock.unlock();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setContentAt(int column, int row, Object value) {
        if (row < this.getFixedHeaderRowCount()) {
            throw new UnsupportedOperationException("Unexpected set() on column header");
        }
        if (!(this.kTableFormat instanceof WritableTableFormat)) throw new UnsupportedOperationException("Unexpected set() on read-only table");
        Lock readLock = this.swtThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            WritableTableFormat writableTableFormat = (WritableTableFormat)((Object)this.kTableFormat);
            Object baseObject = this.swtThreadSource.get(row - this.getFixedHeaderRowCount());
            Object updatedObject = writableTableFormat.setColumnValue(baseObject, value, column);
            if (updatedObject == null) return;
            this.swtThreadSource.set(row - this.getFixedHeaderRowCount(), updatedObject);
            return;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KTableCellRenderer getCellRenderer(int column, int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return KTableCellRenderer.defaultRenderer;
        }
        Lock readLock = this.swtThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            KTableCellRenderer kTableCellRenderer = this.kTableFormat.getColumnRenderer(this.swtThreadSource.get(row - this.getFixedHeaderRowCount()), column);
            return kTableCellRenderer;
        }
        finally {
            readLock.unlock();
        }
    }

    public Point belongsToCell(int column, int row) {
        return new Point(column, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() {
        Lock readLock = this.swtThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            int n = this.swtThreadSource.size() + this.getFixedHeaderRowCount();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    public int getFixedHeaderRowCount() {
        return this.kTableFormat.getFixedHeaderRowCount();
    }

    public int getFixedSelectableRowCount() {
        return this.kTableFormat.getFixedSelectableColumnCount();
    }

    public int getColumnCount() {
        return this.kTableFormat.getColumnCount();
    }

    public int getFixedHeaderColumnCount() {
        return this.kTableFormat.getFixedHeaderColumnCount();
    }

    public int getFixedSelectableColumnCount() {
        return this.kTableFormat.getFixedSelectableColumnCount();
    }

    public int getColumnWidth(int col) {
        return this.kTableFormat.getColumnWidth(col);
    }

    public boolean isColumnResizable(int col) {
        return this.kTableFormat.isColumnResizable(col);
    }

    public void setColumnWidth(int col, int width) {
        this.kTableFormat.setColumnWidth(col, width);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowHeight(int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return 20;
        }
        if (row < this.getRowCount()) {
            Lock readLock = this.swtThreadSource.getReadWriteLock().readLock();
            readLock.lock();
            try {
                int n = this.kTableFormat.getRowHeight(this.swtThreadSource.get(row - this.getFixedHeaderRowCount()));
                return n;
            }
            finally {
                readLock.unlock();
            }
        }
        return 20;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRowResizable(int row) {
        if (row < this.getFixedHeaderRowCount()) {
            return false;
        }
        Lock readLock = this.swtThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            boolean bl = this.kTableFormat.isRowResizable(this.swtThreadSource.get(row - this.getFixedHeaderRowCount()));
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public int getRowHeightMinimum() {
        return this.kTableFormat.getRowHeightMinimum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowHeight(int row, int value) {
        if (row < this.getFixedHeaderRowCount()) {
            return;
        }
        Lock readLock = this.swtThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            this.kTableFormat.setRowHeight(this.swtThreadSource.get(row - this.getFixedHeaderRowCount()), value);
        }
        finally {
            readLock.unlock();
        }
    }
}

