/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTreeModel<E>
implements TreeModel,
ListEventListener<E> {
    protected TransformedList swingThreadSource;
    private final boolean disposeSwingThreadSource;
    private TreeList<E> treeList;
    private final Object treeRoot = new Object();
    protected List<TreeModelListener> listenerList = new ArrayList<TreeModelListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTreeModel(TreeList<E> source) {
        Lock readLock = source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            this.disposeSwingThreadSource = !GlazedListsSwing.isSwingThreadProxyList(source);
            this.swingThreadSource = this.disposeSwingThreadSource ? GlazedListsSwing.swingThreadProxyList(source) : source;
            this.swingThreadSource.addListEventListener(this);
        }
        finally {
            readLock.unlock();
        }
        this.treeList = source;
    }

    @Override
    public Object getRoot() {
        return this.treeRoot;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.treeRoot) {
            return this.treeList.getRoots().get(index);
        }
        TreeList.Node node = (TreeList.Node)parent;
        return node.getChildren().get(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.treeRoot) {
            return this.treeList.getRoots().size();
        }
        TreeList.Node node = (TreeList.Node)parent;
        return node.getChildren().size();
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == this.treeRoot) {
            return this.treeList.isEmpty();
        }
        TreeList.Node treeNode = (TreeList.Node)node;
        return treeNode.isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == this.treeRoot) {
            return this.treeList.getRoots().indexOf(child);
        }
        TreeList.Node treeNode = (TreeList.Node)parent;
        return treeNode.getChildren().indexOf(child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this.listenerList.add(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        for (TreeModelListener listener : this.listenerList) {
            listener.treeStructureChanged(new TreeModelEvent((Object)this, new Object[]{this.treeRoot}));
        }
    }

    public void dispose() {
        this.swingThreadSource.removeListEventListener(this);
        if (this.disposeSwingThreadSource) {
            this.swingThreadSource.dispose();
        }
        this.swingThreadSource = null;
    }
}

