/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.DefaultEventTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.util.concurrent.Lock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTableModel<E>
extends DefaultEventTableModel<E> {
    protected TransformedList<E, E> swingThreadSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTableModel(EventList<E> source, TableFormat<? super E> tableFormat) {
        super(source, tableFormat);
        Lock readLock = source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            TransformedList<E, E> decorated = this.createSwingThreadProxyList(source);
            if (decorated != null && decorated != source) {
                this.source.removeListEventListener(this);
                this.swingThreadSource = decorated;
                this.source = this.swingThreadSource;
                this.source.addListEventListener(this);
            }
        }
        finally {
            readLock.unlock();
        }
    }

    public EventTableModel(EventList<E> source, String[] propertyNames, String[] columnLabels, boolean[] writable) {
        this(source, GlazedLists.tableFormat(propertyNames, columnLabels, writable));
    }

    protected TransformedList<E, E> createSwingThreadProxyList(EventList<E> source) {
        return GlazedListsSwing.isSwingThreadProxyList(source) ? null : GlazedListsSwing.swingThreadProxyList(source);
    }

    @Override
    public void dispose() {
        if (this.swingThreadSource != null) {
            this.swingThreadSource.dispose();
        }
        this.swingThreadSource = null;
        super.dispose();
    }
}

