/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.IteratorAsEnumeration;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTableColumnModel<T extends TableColumn>
implements TableColumnModel,
PropertyChangeListener,
ListSelectionListener,
ListEventListener<T> {
    protected TransformedList<T, T> swingThreadSource;
    private final boolean disposeSwingThreadSource;
    private final EventListenerList listenerList = new EventListenerList();
    private final transient ChangeEvent changeEvent = new ChangeEvent(this);
    private ListSelectionModel selectionModel;
    private boolean columnSelectionAllowed;
    private int columnMargin;
    private int totalColumnWidth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventTableColumnModel(EventList<T> source) {
        this.setSelectionModel(this.createSelectionModel());
        this.setColumnMargin(1);
        this.invalidateWidthCache();
        this.setColumnSelectionAllowed(false);
        Lock readLock = source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            int i;
            int n = source.size();
            for (i = 0; i < n; ++i) {
                if (source.get(i) != null) continue;
                throw new IllegalStateException("null TableColumn objects are not allowed in EventTableColumnModel");
            }
            n = source.size();
            for (i = 0; i < n; ++i) {
                ((TableColumn)source.get(i)).addPropertyChangeListener(this);
            }
            this.disposeSwingThreadSource = !GlazedListsSwing.isSwingThreadProxyList(source);
            this.swingThreadSource = this.disposeSwingThreadSource ? GlazedListsSwing.swingThreadProxyList(source) : (TransformedList)source;
            this.swingThreadSource.addListEventListener(this);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(TableColumn column) {
        Lock writeLock = this.swingThreadSource.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            this.swingThreadSource.add(column);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeColumn(TableColumn column) {
        Lock writeLock = this.swingThreadSource.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            this.swingThreadSource.remove(column);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException("columnIndex out of range");
        }
        if (newIndex < 0 || newIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException("newIndex out of range");
        }
        if (columnIndex == newIndex) {
            this.fireColumnMoved(new TableColumnModelEvent(this, columnIndex, newIndex));
            return;
        }
        Lock writeLock = this.swingThreadSource.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            boolean selected = this.selectionModel.isSelectedIndex(columnIndex);
            this.swingThreadSource.add(newIndex, this.swingThreadSource.remove(columnIndex));
            if (selected) {
                this.selectionModel.addSelectionInterval(newIndex, newIndex);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void setColumnMargin(int newMargin) {
        if (newMargin != this.columnMargin) {
            this.columnMargin = newMargin;
            this.fireColumnMarginChanged();
        }
    }

    @Override
    public int getColumnMargin() {
        return this.columnMargin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnCount() {
        Lock readLock = this.swingThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            int n = this.swingThreadSource.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return new IteratorAsEnumeration<TableColumn>(this.swingThreadSource.iterator());
    }

    @Override
    public int getColumnIndex(Object identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("identifier is null");
        }
        Lock readLock = this.swingThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            int n = this.swingThreadSource.size();
            for (int i = 0; i < n; ++i) {
                if (!identifier.equals(((TableColumn)this.swingThreadSource.get(i)).getIdentifier())) continue;
                int n2 = i;
                return n2;
            }
            throw new IllegalArgumentException("Identifier not found");
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableColumn getColumn(int columnIndex) {
        Lock readLock = this.swingThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            TableColumn tableColumn = (TableColumn)this.swingThreadSource.get(columnIndex);
            return tableColumn;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getColumnIndexAtX(int x) {
        if (x < 0) {
            return -1;
        }
        Lock readLock = this.swingThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            int n = this.swingThreadSource.size();
            for (int i = 0; i < n; ++i) {
                TableColumn column = (TableColumn)this.swingThreadSource.get(i);
                if ((x -= column.getWidth()) >= 0) continue;
                int n2 = i;
                return n2;
            }
        }
        finally {
            readLock.unlock();
        }
        return -1;
    }

    @Override
    public int getTotalColumnWidth() {
        if (this.totalColumnWidth == -1) {
            this.recalcWidthCache();
        }
        return this.totalColumnWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalcWidthCache() {
        Lock readLock = this.swingThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            this.totalColumnWidth = 0;
            int n = this.swingThreadSource.size();
            for (int i = 0; i < n; ++i) {
                this.totalColumnWidth += ((TableColumn)this.swingThreadSource.get(i)).getWidth();
            }
        }
        finally {
            readLock.unlock();
        }
    }

    private void invalidateWidthCache() {
        this.totalColumnWidth = -1;
    }

    @Override
    public void setColumnSelectionAllowed(boolean flag) {
        this.columnSelectionAllowed = flag;
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return this.columnSelectionAllowed;
    }

    @Override
    public int[] getSelectedColumns() {
        if (this.selectionModel != null) {
            int iMin = this.selectionModel.getMinSelectionIndex();
            int iMax = this.selectionModel.getMaxSelectionIndex();
            if (iMin == -1 || iMax == -1) {
                return new int[0];
            }
            int[] rvTmp = new int[1 + (iMax - iMin)];
            int n = 0;
            for (int i = iMin; i <= iMax; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                rvTmp[n++] = i;
            }
            int[] rv = new int[n];
            System.arraycopy(rvTmp, 0, rv, 0, n);
            return rv;
        }
        return new int[0];
    }

    @Override
    public int getSelectedColumnCount() {
        if (this.selectionModel != null) {
            int iMin = this.selectionModel.getMinSelectionIndex();
            int iMax = this.selectionModel.getMaxSelectionIndex();
            int count = 0;
            for (int i = iMin; i <= iMax; ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                ++count;
            }
            return count;
        }
        return 0;
    }

    @Override
    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException("newModel may not be null");
        }
        if (newModel != this.selectionModel) {
            if (this.selectionModel != null) {
                this.selectionModel.removeListSelectionListener(this);
            }
            this.selectionModel = newModel;
            this.selectionModel.addListSelectionListener(this);
        }
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener listener) {
        this.listenerList.add(TableColumnModelListener.class, listener);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener listener) {
        this.listenerList.remove(TableColumnModelListener.class, listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name == "width" || name == "preferredWidth") {
            this.invalidateWidthCache();
            this.fireColumnMarginChanged();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.fireColumnSelectionChanged(e);
    }

    @Override
    public void listChanged(ListEvent<T> listChanges) {
        this.invalidateWidthCache();
        while (listChanges.next()) {
            TableColumn oldColumn;
            int index = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 0) {
                if (this.selectionModel != null) {
                    this.selectionModel.removeIndexInterval(index, index);
                }
                oldColumn = (TableColumn)listChanges.getOldValue();
                oldColumn.removePropertyChangeListener(this);
                this.fireColumnRemoved(new TableColumnModelEvent(this, index, 0));
                continue;
            }
            if (changeType == 2) {
                TableColumn newColumn = (TableColumn)listChanges.getSourceList().get(index);
                if (newColumn == null) {
                    throw new IllegalStateException("null TableColumn objects are not allowed in EventTableColumnModel");
                }
                newColumn.addPropertyChangeListener(this);
                this.fireColumnAdded(new TableColumnModelEvent(this, 0, this.getColumnCount() - 1));
                continue;
            }
            if (changeType != 1) continue;
            oldColumn = (TableColumn)listChanges.getOldValue();
            TableColumn newColumn = (TableColumn)listChanges.getSourceList().get(index);
            if (newColumn == null) {
                throw new IllegalStateException("null TableColumn objects are not allowed in EventTableColumnModel");
            }
            if (oldColumn != newColumn) {
                oldColumn.removePropertyChangeListener(this);
                newColumn.addPropertyChangeListener(this);
            }
            this.fireColumnMoved(new TableColumnModelEvent(this, index, index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Lock readLock = this.swingThreadSource.getReadWriteLock().readLock();
        readLock.lock();
        try {
            int n = this.swingThreadSource.size();
            for (int i = 0; i < n; ++i) {
                ((TableColumn)this.swingThreadSource.get(i)).removePropertyChangeListener(this);
            }
            this.swingThreadSource.removeListEventListener(this);
            if (this.disposeSwingThreadSource) {
                this.swingThreadSource.dispose();
            }
        }
        finally {
            readLock.unlock();
        }
        this.swingThreadSource = null;
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    protected void fireColumnAdded(TableColumnModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)listeners[i + 1]).columnAdded(e);
        }
    }

    protected void fireColumnRemoved(TableColumnModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)listeners[i + 1]).columnRemoved(e);
        }
    }

    protected void fireColumnMoved(TableColumnModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)listeners[i + 1]).columnMoved(e);
        }
    }

    protected void fireColumnSelectionChanged(ListSelectionEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)listeners[i + 1]).columnSelectionChanged(e);
        }
    }

    protected void fireColumnMarginChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableColumnModelListener.class) continue;
            ((TableColumnModelListener)listeners[i + 1]).columnMarginChanged(this.changeEvent);
        }
    }
}

