/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.AdvancedListSelectionModel;
import ca.odell.glazedlists.swing.DefaultEventSelectionModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.util.concurrent.Lock;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventSelectionModel<E>
implements AdvancedListSelectionModel<E> {
    private DefaultEventSelectionModel<E> delegateSelectionModel;
    protected TransformedList<E, E> swingThreadSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventSelectionModel(EventList<E> source) {
        Lock readLock = source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            this.swingThreadSource = GlazedListsSwing.swingThreadProxyList(source);
            this.delegateSelectionModel = new DefaultEventSelectionModel(this.swingThreadSource);
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listener) {
        this.delegateSelectionModel.addListSelectionListener(listener);
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        this.delegateSelectionModel.addSelectionInterval(index0, index1);
    }

    @Override
    public void addValidSelectionMatcher(Matcher<E> validSelectionMatcher) {
        this.delegateSelectionModel.addValidSelectionMatcher(validSelectionMatcher);
    }

    @Override
    public void clearSelection() {
        this.delegateSelectionModel.clearSelection();
    }

    @Override
    public void dispose() {
        this.delegateSelectionModel.dispose();
        this.swingThreadSource.dispose();
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.delegateSelectionModel.getAnchorSelectionIndex();
    }

    @Override
    public EventList<E> getDeselected() {
        return this.delegateSelectionModel.getDeselected();
    }

    @Override
    public boolean getEnabled() {
        return this.delegateSelectionModel.getEnabled();
    }

    public EventList<E> getEventList() {
        return this.delegateSelectionModel.getSelected();
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.delegateSelectionModel.getLeadSelectionIndex();
    }

    public ListSelectionModel getListSelectionModel() {
        return this.delegateSelectionModel;
    }

    @Override
    public int getMaxSelectionIndex() {
        return this.delegateSelectionModel.getMaxSelectionIndex();
    }

    @Override
    public int getMinSelectionIndex() {
        return this.delegateSelectionModel.getMinSelectionIndex();
    }

    @Override
    public EventList<E> getSelected() {
        return this.delegateSelectionModel.getSelected();
    }

    @Override
    public int getSelectionMode() {
        return this.delegateSelectionModel.getSelectionMode();
    }

    @Override
    public EventList<E> getTogglingDeselected() {
        return this.delegateSelectionModel.getTogglingDeselected();
    }

    @Override
    public EventList<E> getTogglingSelected() {
        return this.delegateSelectionModel.getTogglingSelected();
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.delegateSelectionModel.getValueIsAdjusting();
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        this.delegateSelectionModel.insertIndexInterval(index, length, before);
    }

    @Override
    public void invertSelection() {
        this.delegateSelectionModel.invertSelection();
    }

    @Override
    public boolean isSelectedIndex(int index) {
        return this.delegateSelectionModel.isSelectedIndex(index);
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.delegateSelectionModel.isSelectionEmpty();
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
        this.delegateSelectionModel.removeIndexInterval(index0, index1);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listener) {
        this.delegateSelectionModel.removeListSelectionListener(listener);
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        this.delegateSelectionModel.removeSelectionInterval(index0, index1);
    }

    @Override
    public void removeValidSelectionMatcher(Matcher<E> validSelectionMatcher) {
        this.delegateSelectionModel.removeValidSelectionMatcher(validSelectionMatcher);
    }

    @Override
    public void setAnchorSelectionIndex(int anchorSelectionIndex) {
        this.delegateSelectionModel.setAnchorSelectionIndex(anchorSelectionIndex);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.delegateSelectionModel.setEnabled(enabled);
    }

    @Override
    public void setLeadSelectionIndex(int leadSelectionIndex) {
        this.delegateSelectionModel.setLeadSelectionIndex(leadSelectionIndex);
    }

    @Override
    public void setSelectionInterval(int index0, int index1) {
        this.delegateSelectionModel.setSelectionInterval(index0, index1);
    }

    @Override
    public void setSelectionMode(int selectionMode) {
        this.delegateSelectionModel.setSelectionMode(selectionMode);
    }

    @Override
    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.delegateSelectionModel.setValueIsAdjusting(valueIsAdjusting);
    }

    public String toString() {
        return this.delegateSelectionModel.toString();
    }
}

