/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.gui.AdvancedTableFormat;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.gui.WritableTableFormat;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.MutableTableModelEvent;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.awt.EventQueue;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEventTableModel<E>
extends AbstractTableModel
implements AdvancedTableModel<E>,
ListEventListener<E> {
    protected EventList<E> source;
    private boolean disposeSource;
    private TableFormat<? super E> tableFormat;
    private final MutableTableModelEvent tableModelEvent = new MutableTableModelEvent(this);

    public DefaultEventTableModel(EventList<E> source, TableFormat<? super E> tableFormat) {
        this(source, false, tableFormat);
    }

    protected DefaultEventTableModel(EventList<E> source, boolean disposeSource, TableFormat<? super E> tableFormat) {
        this.source = source;
        this.disposeSource = disposeSource;
        this.tableFormat = tableFormat;
        source.addListEventListener(this);
    }

    @Override
    public TableFormat<? super E> getTableFormat() {
        return this.tableFormat;
    }

    @Override
    public void setTableFormat(TableFormat<? super E> tableFormat) {
        this.tableFormat = tableFormat;
        this.tableModelEvent.setStructureChanged();
        this.fireTableChanged(this.tableModelEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getElementAt(int index) {
        Lock readLock = this.source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            Object e = this.source.get(index);
            return e;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        this.handleListChange(listChanges);
    }

    protected void handleListChange(ListEvent<E> listChanges) {
        if (!EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Events to " + this.getClass().getSimpleName() + " must arrive on the EDT - consider adding GlazedListsSwing.swingThreadProxyList(source) somewhere in your list pipeline");
        }
        while (listChanges.nextBlock()) {
            int startIndex = listChanges.getBlockStartIndex();
            int endIndex = listChanges.getBlockEndIndex();
            int changeType = listChanges.getType();
            this.tableModelEvent.setValues(startIndex, endIndex, changeType);
            this.fireTableChanged(this.tableModelEvent);
        }
    }

    protected final MutableTableModelEvent getMutableTableModelEvent() {
        return this.tableModelEvent;
    }

    @Override
    public String getColumnName(int column) {
        return this.tableFormat.getColumnName(column);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        Lock readLock = this.source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            int n = this.source.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public int getColumnCount() {
        return this.tableFormat.getColumnCount();
    }

    public Class getColumnClass(int columnIndex) {
        if (this.tableFormat instanceof AdvancedTableFormat) {
            return ((AdvancedTableFormat)this.tableFormat).getColumnClass(columnIndex);
        }
        return super.getColumnClass(columnIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int row, int column) {
        Lock readLock = this.source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            Object object = this.tableFormat.getColumnValue(this.source.get(row), column);
            return object;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCellEditable(int row, int column) {
        if (!(this.tableFormat instanceof WritableTableFormat)) {
            return false;
        }
        Lock readLock = this.source.getReadWriteLock().readLock();
        readLock.lock();
        try {
            Object toEdit = this.source.get(row);
            boolean bl = ((WritableTableFormat)this.tableFormat).isEditable(toEdit, column);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object editedValue, int row, int column) {
        if (!(this.tableFormat instanceof WritableTableFormat)) {
            throw new UnsupportedOperationException("Unexpected setValueAt() on read-only table");
        }
        Lock writeLock = this.source.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            Object baseObject = this.source.get(row);
            WritableTableFormat writableTableFormat = (WritableTableFormat)this.tableFormat;
            Object updatedObject = writableTableFormat.setColumnValue(baseObject, editedValue, column);
            if (updatedObject != null) {
                boolean baseObjectHasNotMoved;
                boolean bl = baseObjectHasNotMoved = row < this.getRowCount() && this.source.get(row) == baseObject;
                if (baseObjectHasNotMoved) {
                    this.source.set(row, updatedObject);
                }
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void dispose() {
        this.source.removeListEventListener(this);
        if (this.disposeSource) {
            this.source.dispose();
        }
        this.source = null;
    }
}

