/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.rbp;

import ca.odell.glazedlists.impl.io.Bufferlo;
import ca.odell.glazedlists.impl.rbp.Peer;
import ca.odell.glazedlists.impl.rbp.PeerBlock;
import ca.odell.glazedlists.impl.rbp.PeerConnection;
import ca.odell.glazedlists.impl.rbp.Resource;
import ca.odell.glazedlists.impl.rbp.ResourceConnection;
import ca.odell.glazedlists.impl.rbp.ResourceListener;
import ca.odell.glazedlists.impl.rbp.ResourceStatus;
import ca.odell.glazedlists.impl.rbp.ResourceStatusListener;
import ca.odell.glazedlists.impl.rbp.ResourceUri;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

class PeerResource {
    private Peer peer;
    private Resource resource = null;
    private int resourceUpdateId = 0;
    private ResourceUri resourceUri;
    private PeerConnection publisher = null;
    private List subscribers = new ArrayList();
    private int sessionId = -1;
    private PrivateResourceListener resourceListener = new PrivateResourceListener();
    private PrivateResourceStatus resourceStatus = new PrivateResourceStatus();

    public PeerResource(Peer peer, Resource resource, ResourceUri resourceUri) {
        this.peer = peer;
        this.resource = resource;
        this.resourceUri = resourceUri;
        if (resourceUri.isLocal()) {
            this.sessionId = new Random(System.currentTimeMillis()).nextInt();
        }
        this.resourceStatus.connect();
    }

    public ResourceUri getResourceUri() {
        return this.resourceUri;
    }

    public void connectionClosed(ResourceConnection connection, Exception reason) {
        if (this.publisher == connection.getConnection()) {
            this.publisher = null;
            this.resourceStatus.setConnected(false, reason);
            connection.getConnection().incomingSubscriptions.remove(this.resourceUri);
        } else {
            this.subscribers.remove(connection);
            connection.getConnection().outgoingPublications.remove(this.resourceUri);
        }
    }

    public ResourceListener resourceListener() {
        return this.resourceListener;
    }

    public ResourceStatus status() {
        return this.resourceStatus;
    }

    void incomingBlock(ResourceConnection source, PeerBlock block) {
        if (block.isSubscribe()) {
            this.remoteSubscribe(source, block);
        } else if (block.isSubscribeConfirm()) {
            this.remoteSubscribeConfirm(source, block);
        } else if (block.isUpdate()) {
            this.remoteUpdate(source, block);
        } else if (block.isUnsubscribe()) {
            this.remoteUnsubscribe(source, block);
        } else if (block.isUnpublish()) {
            this.remoteUnpublish(source, block);
        } else {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteUpdate(ResourceConnection publisher, PeerBlock block) {
        if (block.getSessionId() != this.sessionId) {
            throw new IllegalStateException();
        }
        Lock writeLock = this.resource.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            if (block.getUpdateId() != this.resourceUpdateId + 1) {
                throw new IllegalStateException("Expected update id " + (this.resourceUpdateId + 1) + " but found " + block.getUpdateId());
            }
            this.resource.update(block.getPayload());
            this.resourceListener.resourceUpdated(this.resource, block.getPayload());
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteSubscribe(ResourceConnection subscriber, PeerBlock block) {
        if (this.resourceStatus.isConnected()) {
            int updateId = -1;
            Bufferlo snapshot = null;
            Lock writeLock = this.resource.getReadWriteLock().writeLock();
            writeLock.lock();
            try {
                updateId = this.resourceUpdateId;
                snapshot = this.resource.toSnapshot();
            }
            finally {
                writeLock.unlock();
            }
            subscriber.setUpdateId(updateId);
            subscriber.getConnection().outgoingPublications.put(this.resourceUri, subscriber);
            this.subscribers.add(subscriber);
            PeerBlock subscribeConfirm = PeerBlock.subscribeConfirm(this.resourceUri, this.sessionId, updateId, snapshot);
            subscriber.getConnection().writeBlock(this, subscribeConfirm);
        } else {
            PeerBlock unpublish = PeerBlock.unpublish(this.resourceUri);
            subscriber.getConnection().writeBlock(this, unpublish);
            if (subscriber.getConnection().isIdle()) {
                subscriber.getConnection().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteSubscribeConfirm(ResourceConnection publisher, PeerBlock block) {
        Lock writeLock = this.resource.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            this.resource.fromSnapshot(block.getPayload());
            this.resourceUpdateId = block.getUpdateId();
        }
        finally {
            writeLock.unlock();
        }
        this.sessionId = block.getSessionId();
        this.resourceStatus.setConnected(true, null);
    }

    private void remoteUnsubscribe(ResourceConnection subscriber, PeerBlock block) {
        this.subscribers.remove(subscriber);
        subscriber.getConnection().outgoingPublications.remove(this.resourceUri);
    }

    private void remoteUnpublish(ResourceConnection subscriber, PeerBlock block) {
        this.resourceStatus.setConnected(false, new Exception("Resource became unavailable"));
        if (this.publisher != null) {
            this.publisher.incomingSubscriptions.remove(this.resourceUri);
            if (this.publisher.isIdle()) {
                this.publisher.close();
            }
            this.publisher = null;
        }
    }

    public void print() {
        System.out.print(this.resourceUri);
        System.out.print(" from: ");
        System.out.print(this.publisher);
        System.out.print(" to: ");
        Iterator s = this.subscribers.iterator();
        while (s.hasNext()) {
            ResourceConnection subscriber = (ResourceConnection)s.next();
            System.out.print(subscriber.getConnection().toString());
            if (!s.hasNext()) continue;
            System.out.print(", ");
        }
        System.out.println("");
    }

    private class PrivateResourceStatus
    implements ResourceStatus {
        private List statusListeners = new ArrayList();
        private boolean connected = false;

        private PrivateResourceStatus() {
        }

        public synchronized boolean isConnected() {
            return this.connected;
        }

        public void connect() {
            PeerResource.this.peer.invokeLater(new ConnectRunnable());
        }

        public void disconnect() {
            PeerResource.this.peer.invokeLater(new DisconnectRunnable());
        }

        public synchronized void addResourceStatusListener(ResourceStatusListener listener) {
            this.statusListeners.add(listener);
        }

        public synchronized void removeResourceStatusListener(ResourceStatusListener listener) {
            this.statusListeners.remove(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setConnected(boolean connected, Exception reason) {
            ArrayList listenersToNotify = new ArrayList();
            PrivateResourceStatus privateResourceStatus = this;
            synchronized (privateResourceStatus) {
                this.connected = connected;
                listenersToNotify.addAll(this.statusListeners);
            }
            for (ResourceStatusListener statusListener : listenersToNotify) {
                if (connected) {
                    statusListener.resourceConnected(this);
                    continue;
                }
                statusListener.resourceDisconnected(this, reason);
            }
        }

        private class DisconnectRunnable
        implements Runnable {
            private DisconnectRunnable() {
            }

            public void run() {
                PeerResource.this.resourceStatus.setConnected(false, null);
                if (PeerResource.this.resourceUri.isRemote()) {
                    ((PeerResource)PeerResource.this).peer.subscribed.remove(PeerResource.this.resourceUri);
                    if (PeerResource.this.publisher != null) {
                        PeerResource.this.publisher.writeBlock(PeerResource.this, PeerBlock.unsubscribe(PeerResource.this.resourceUri));
                        ((PeerResource)PeerResource.this).publisher.incomingSubscriptions.remove(PeerResource.this.resourceUri);
                        if (PeerResource.this.publisher.isIdle()) {
                            PeerResource.this.publisher.close();
                        }
                        PeerResource.this.publisher = null;
                    }
                } else if (PeerResource.this.resourceUri.isLocal()) {
                    PeerResource.this.resource.removeResourceListener(PeerResource.this.resourceListener);
                    if (((PeerResource)PeerResource.this).peer.published.get(PeerResource.this.resourceUri) == null) {
                        throw new IllegalStateException();
                    }
                    ((PeerResource)PeerResource.this).peer.published.remove(PeerResource.this.resourceUri);
                    Iterator s = PeerResource.this.subscribers.iterator();
                    while (s.hasNext()) {
                        ResourceConnection subscriber = (ResourceConnection)s.next();
                        subscriber.getConnection().writeBlock(PeerResource.this, PeerBlock.unpublish(PeerResource.this.resourceUri));
                        subscriber.getConnection().outgoingPublications.remove(PeerResource.this.resourceUri);
                        if (subscriber.getConnection().isIdle()) {
                            subscriber.getConnection().close();
                        }
                        s.remove();
                    }
                }
            }
        }

        private class ConnectRunnable
        implements Runnable {
            private ConnectRunnable() {
            }

            public void run() {
                if (PeerResource.this.resourceUri.isRemote()) {
                    PeerResource.this.publisher = PeerResource.this.peer.getConnection(PeerResource.this.resourceUri.getHost(), PeerResource.this.resourceUri.getPort());
                    ((PeerResource)PeerResource.this).peer.subscribed.put(PeerResource.this.resourceUri, PeerResource.this);
                    ((PeerResource)PeerResource.this).publisher.incomingSubscriptions.put(PeerResource.this.resourceUri, new ResourceConnection(PeerResource.this.publisher, PeerResource.this));
                    PeerBlock subscribe = PeerBlock.subscribe(PeerResource.this.resourceUri);
                    PeerResource.this.publisher.writeBlock(PeerResource.this, subscribe);
                } else if (PeerResource.this.resourceUri.isLocal()) {
                    PeerResource.this.resource.addResourceListener(PeerResource.this.resourceListener);
                    PeerResource.this.resourceStatus.setConnected(true, null);
                    if (((PeerResource)PeerResource.this).peer.published.get(PeerResource.this.resourceUri) != null) {
                        throw new IllegalStateException();
                    }
                    ((PeerResource)PeerResource.this).peer.published.put(PeerResource.this.resourceUri, PeerResource.this);
                }
            }
        }
    }

    private class PrivateResourceListener
    implements ResourceListener {
        private PrivateResourceListener() {
        }

        public void resourceUpdated(Resource resource, Bufferlo delta) {
            PeerResource.this.resourceUpdateId++;
            PeerResource.this.peer.invokeLater(new UpdatedRunnable(delta, PeerResource.this.resourceUpdateId));
        }

        private class UpdatedRunnable
        implements Runnable {
            private Bufferlo delta = null;
            private int updateId = -1;

            public UpdatedRunnable(Bufferlo delta, int updateId) {
                this.delta = delta;
                this.updateId = updateId;
            }

            public void run() {
                if (PeerResource.this.subscribers.isEmpty()) {
                    return;
                }
                PeerBlock block = PeerBlock.update(PeerResource.this.resourceUri, PeerResource.this.sessionId, this.updateId, this.delta);
                for (int s = 0; s < PeerResource.this.subscribers.size(); ++s) {
                    ResourceConnection subscriber = (ResourceConnection)PeerResource.this.subscribers.get(s);
                    if (subscriber.getUpdateId() >= this.updateId) continue;
                    subscriber.getConnection().writeBlock(PeerResource.this, block);
                    subscriber.setUpdateId(this.updateId);
                }
            }
        }
    }
}

