/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl.gui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ThreadProxyEventList<E>
extends TransformedList<E, E>
implements RandomAccess {
    protected List<E> localCache = new ArrayList();
    private UpdateRunner updateRunner = new UpdateRunner();
    protected final ListEventAssembler<E> cacheUpdates = new ListEventAssembler(this, ListEventAssembler.createListEventPublisher());
    protected volatile boolean scheduled;

    public ThreadProxyEventList(EventList<E> source) {
        super(source);
        this.localCache.addAll(source);
        this.cacheUpdates.addListEventListener(this.updateRunner);
        source.addListEventListener(this);
    }

    @Override
    public final void listChanged(ListEvent<E> listChanges) {
        if (!this.scheduled) {
            this.updates.beginEvent(true);
            this.cacheUpdates.beginEvent(true);
        }
        this.updates.forwardEvent(listChanges);
        this.cacheUpdates.forwardEvent(listChanges);
        if (!this.scheduled) {
            this.scheduled = true;
            this.schedule(this.updateRunner);
        }
    }

    protected abstract void schedule(Runnable var1);

    @Override
    public final int size() {
        return this.localCache.size();
    }

    @Override
    public final E get(int index) {
        return this.localCache.get(index);
    }

    @Override
    protected final boolean isWritable() {
        return true;
    }

    protected List<E> applyChangeToCache(EventList<E> source, ListEvent<E> listChanges, List<E> localCache) {
        ArrayList result = new ArrayList(source.size());
        int resultIndex = 0;
        int cacheOffset = 0;
        while (true) {
            int changeType;
            int changeIndex;
            if (listChanges.next()) {
                changeIndex = listChanges.getIndex();
                changeType = listChanges.getType();
            } else {
                changeIndex = source.size();
                changeType = -1;
            }
            while (resultIndex < changeIndex) {
                result.add(resultIndex, localCache.get(resultIndex + cacheOffset));
                ++resultIndex;
            }
            if (changeType == 0) {
                ++cacheOffset;
                continue;
            }
            if (changeType == 1) {
                result.add(resultIndex, source.get(changeIndex));
                ++resultIndex;
                continue;
            }
            if (changeType == 2) {
                result.add(resultIndex, source.get(changeIndex));
                ++resultIndex;
                --cacheOffset;
                continue;
            }
            if (changeType == -1) break;
        }
        return result;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cacheUpdates.removeListEventListener(this.updateRunner);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateRunner
    implements Runnable,
    ListEventListener<E> {
        private UpdateRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Lock writeLock = ThreadProxyEventList.this.getReadWriteLock().writeLock();
            writeLock.lock();
            try {
                ThreadProxyEventList.this.cacheUpdates.commitEvent();
                ThreadProxyEventList.this.updates.commitEvent();
            }
            finally {
                ThreadProxyEventList.this.scheduled = false;
                writeLock.unlock();
            }
        }

        @Override
        public void listChanged(ListEvent<E> listChanges) {
            ThreadProxyEventList.this.localCache = ThreadProxyEventList.this.applyChangeToCache(ThreadProxyEventList.this.source, listChanges, ThreadProxyEventList.this.localCache);
        }
    }
}

