/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.util.concurrent.Lock;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadSafeList<E>
extends TransformedList<E, E> {
    public ThreadSafeList(EventList<E> source) {
        super(source);
        source.addListEventListener(this);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        this.updates.forwardEvent(listChanges);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            Object e = this.source.get(index);
            return e;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            int n = this.source.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object object) {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            boolean bl = this.source.contains(object);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            boolean bl = this.source.containsAll(collection);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object object) {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            boolean bl = this.source.equals(object);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            int n = this.source.hashCode();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object object) {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            int n = this.source.indexOf(object);
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object object) {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            int n = this.source.lastIndexOf(object);
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            boolean bl = this.source.isEmpty();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            Object[] objectArray = this.source.toArray();
            return objectArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] array) {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            T[] TArray = this.source.toArray(array);
            return TArray;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E value) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            boolean bl = this.source.add(value);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object toRemove) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            boolean bl = this.source.remove(toRemove);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> values) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            boolean bl = this.source.addAll(values);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> values) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            boolean bl = this.source.addAll(index, values);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> values) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            boolean bl = this.source.removeAll(values);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> values) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            boolean bl = this.source.retainAll(values);
            return bl;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            this.source.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E value) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            E e = this.source.set(index, value);
            return e;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E value) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            this.source.add(index, value);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        Lock writeLock = this.getReadWriteLock().writeLock();
        writeLock.lock();
        try {
            Object e = this.source.remove(index);
            return e;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Lock readLock = this.getReadWriteLock().readLock();
        readLock.lock();
        try {
            String string = this.source.toString();
            return string;
        }
        finally {
            readLock.unlock();
        }
    }
}

