/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.hibernate;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventAssembler;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.hibernate.EventListFactory;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.collection.PersistentList;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;

public final class PersistentEventList
extends PersistentList
implements EventList,
ListEventListener {
    private static final long serialVersionUID = 0L;
    protected transient ListEventAssembler updates;

    public PersistentEventList(SessionImplementor session, EventListFactory listFactory) {
        super(session);
        EventList delegate = listFactory.createEventList();
        this.updates = new ListEventAssembler(this, delegate.getPublisher());
        delegate.addListEventListener(this);
        this.list = delegate;
    }

    public PersistentEventList(SessionImplementor session, EventList newList) {
        super(session, (List)newList);
        if (newList == null) {
            throw new IllegalArgumentException("EventList parameter may not be null");
        }
        this.updates = new ListEventAssembler(this, newList.getPublisher());
        newList.addListEventListener(this);
    }

    public ListEventAssembler getListEventAssembler() {
        return this.updates;
    }

    public void beforeInitialize(CollectionPersister persister) {
        this.beforeInitialize();
    }

    public void beforeInitialize(CollectionPersister persister, int anticipatedSize) {
        this.beforeInitialize();
    }

    private void beforeInitialize() {
        assert (!this.wasInitialized()) : "PersistentEventList is already initialized";
        if (this.list == null) {
            throw new IllegalStateException("'list' member is undefined");
        }
    }

    public ListEventPublisher getPublisher() {
        return ((EventList)this.list).getPublisher();
    }

    public ReadWriteLock getReadWriteLock() {
        return ((EventList)this.list).getReadWriteLock();
    }

    public void addListEventListener(ListEventListener listChangeListener) {
        this.updates.addListEventListener(listChangeListener);
    }

    public void removeListEventListener(ListEventListener listChangeListener) {
        this.updates.removeListEventListener(listChangeListener);
    }

    public void listChanged(ListEvent listChanges) {
        if (this.wasInitialized()) {
            this.updates.forwardEvent(listChanges);
        }
    }

    public void dispose() {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ArrayList serializableListeners = new ArrayList();
        for (ListEventListener listener : this.updates.getListEventListeners()) {
            if (!(listener instanceof Serializable)) continue;
            serializableListeners.add(listener);
        }
        ListEventListener[] listeners = serializableListeners.toArray(new ListEventListener[serializableListeners.size()]);
        out.writeObject(listeners);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        assert (this.list instanceof EventList) : "'list' member type unknown";
        this.updates = new ListEventAssembler(this, ((EventList)this.list).getPublisher());
        ListEventListener[] listeners = (ListEventListener[])in.readObject();
        for (int i = 0; i < listeners.length; ++i) {
            this.updates.addListEventListener(listeners[i]);
        }
    }
}

