/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FunctionList;
import ca.odell.glazedlists.Path;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.TreeList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.GlazedListsImpl;
import ca.odell.glazedlists.impl.adt.CircularArrayList;
import ca.odell.glazedlists.impl.adt.KeyedCollection;
import ca.odell.glazedlists.impl.adt.barcode2.Element;
import ca.odell.glazedlists.impl.adt.barcode2.FourColorTree;
import ca.odell.glazedlists.impl.adt.barcode2.ListToByteCoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TreeList<E>
extends TransformedList<Node<E>, E> {
    static final boolean DEBUG = false;
    static final Logger LOG = Logger.getLogger("glazed.treelist");
    public static final ExpansionModel NODES_START_EXPANDED = new DefaultExpansionModel(true);
    public static final ExpansionModel NODES_START_COLLAPSED = new DefaultExpansionModel(false);
    protected static final Element MINIMUM_ELEMENT = new FakeElement();
    protected static final Element MAXIMUM_ELEMENT = new FakeElement();
    private static final FunctionList.Function NO_OP_FUNCTION = new NoOpFunction();
    protected ExpansionModel<E> expansionModel;
    private static final ListToByteCoder<String> BYTE_CODER = new ListToByteCoder<String>(Arrays.asList("R", "V", "r", "v"));
    private static final byte VISIBLE_REAL = BYTE_CODER.colorToByte("R");
    private static final byte VISIBLE_VIRTUAL = BYTE_CODER.colorToByte("V");
    protected static final byte HIDDEN_REAL = BYTE_CODER.colorToByte("r");
    protected static final byte HIDDEN_VIRTUAL = BYTE_CODER.colorToByte("v");
    protected static final byte ALL_NODES = BYTE_CODER.colorsToByte(Arrays.asList("R", "V", "r", "v"));
    protected static final byte VISIBLE_NODES = BYTE_CODER.colorsToByte(Arrays.asList("R", "V"));
    private static final byte HIDDEN_NODES = BYTE_CODER.colorsToByte(Arrays.asList("r", "v"));
    protected static final byte REAL_NODES = BYTE_CODER.colorsToByte(Arrays.asList("R", "r"));
    private final NodeComparator<E> nodeComparator;
    private EventList<Node<E>> nodesList;
    private List<Node<E>> allNodesList;
    private InitializationData<E> initializationData;
    protected FourColorTree<Node<E>> data = new FourColorTree(BYTE_CODER);
    private Format<E> format;
    private boolean mAvoidRemoveInUpdate;
    private boolean mDebug;

    public static final <E> ExpansionModel<E> nodesStartExpanded() {
        return NODES_START_EXPANDED;
    }

    public static final <E> ExpansionModel<E> nodesStartCollapsed() {
        return NODES_START_COLLAPSED;
    }

    public TreeList(EventList<E> source, Format<E> format, ExpansionModel<E> expansionModel) {
        this(new InitializationData<E>(source, format, expansionModel));
    }

    private TreeList(InitializationData<E> initializationData) {
        super(initializationData.getSource());
        this.format = initializationData.format;
        this.nodeComparator = initializationData.nodeComparator;
        this.expansionModel = initializationData.expansionModel;
        this.initializationData = initializationData;
        NodeAttacher nodeAttacher = new NodeAttacher(false);
        for (int i = 0; i < this.source.size(); ++i) {
            Node node = (Node)this.source.get(i);
            node.expanded = this.expansionModel.isExpanded(node.getElement(), node.path);
            this.addNode(node, HIDDEN_REAL, i);
            nodeAttacher.nodesToAttach.queueNewNodeForInserting(node);
        }
        nodeAttacher.attachAll();
        assert (this.isValid());
        this.source.addListEventListener(this);
    }

    @Deprecated
    public TreeList(EventList<E> source, Format<E> format) {
        this(new InitializationData<E>(source, format, TreeList.<E>nodesStartExpanded()));
    }

    public ExpansionModel<E> getExpansionModel() {
        return this.expansionModel;
    }

    public EventList<Node<E>> getNodesList() {
        if (this.nodesList == null) {
            this.nodesList = new NodesList();
        }
        return this.nodesList;
    }

    List<Node<E>> getAllNodesList() {
        if (this.allNodesList == null) {
            this.allNodesList = new AllNodesList();
        }
        return this.allNodesList;
    }

    public int depth(int visibleIndex) {
        return this.getTreeNode((int)visibleIndex).path.size() - 1;
    }

    private int subtreeSize(int index, boolean indexIsVisibleIndex, boolean includeCollapsedNodes) {
        int indexOut;
        byte coloursIn = indexIsVisibleIndex ? VISIBLE_NODES : ALL_NODES;
        byte coloursOut = includeCollapsedNodes ? ALL_NODES : VISIBLE_NODES;
        Node<E> node = this.data.get(index, coloursIn).get();
        if (coloursIn == coloursOut) {
            indexOut = index;
        } else {
            assert ((node.element.getColor() & coloursOut) != 0);
            indexOut = this.data.convertIndexColor(index, coloursIn, coloursOut);
        }
        Node<E> nextNodeNotInSubtree = this.nextNodeThatsNotAChildOfByStructure(node);
        if (nextNodeNotInSubtree == null) {
            return this.data.size(coloursOut) - indexOut;
        }
        return this.data.indexOfNode(nextNodeNotInSubtree.element, coloursOut) - indexOut;
    }

    public int subtreeSize(int visibleIndex, boolean includeCollapsed) {
        return this.subtreeSize(visibleIndex, true, includeCollapsed);
    }

    private Node<E> nextNodeThatsNotAChildOfByStructure(Node<E> node) {
        while (node != null) {
            Node followerNode = node.siblingAfter;
            if (followerNode != null) {
                return followerNode;
            }
            node = node.parent;
        }
        return null;
    }

    @Override
    public int size() {
        return this.data.size(VISIBLE_NODES);
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    protected int getSourceIndex(int mutationIndex) {
        return this.data.convertIndexColor(mutationIndex, VISIBLE_NODES, REAL_NODES);
    }

    @Override
    public E get(int visibleIndex) {
        return this.getTreeNode(visibleIndex).getElement();
    }

    public Node<E> getTreeNode(int visibleIndex) {
        return this.data.get(visibleIndex, VISIBLE_NODES).get();
    }

    public boolean hasChildren(int visibleIndex) {
        boolean hasChildren = this.subtreeSize(visibleIndex, true) > 1;
        boolean isLeaf = this.getTreeNode(visibleIndex).isLeaf();
        if (isLeaf == hasChildren) {
            this.subtreeSize(visibleIndex, true, true);
        }
        return hasChildren;
    }

    public void setTreeFormat(Format<E> treeFormat) {
    }

    public List<Node<E>> getRoots() {
        ArrayList<Node<Node<E>>> result = new ArrayList<Node<Node<E>>>();
        for (int i = 0; i < this.size(); ++i) {
            Node<E> possibleRoot = this.getTreeNode(i);
            if (possibleRoot.pathLength() != 1) continue;
            result.add(possibleRoot);
        }
        return result;
    }

    public boolean getAllowsChildren(int visibleIndex) {
        return this.format.allowsChildren(this.get(visibleIndex));
    }

    public boolean isExpanded(int visibleIndex) {
        return this.data.get((int)visibleIndex, (byte)TreeList.VISIBLE_NODES).get().expanded;
    }

    public void setExpanded(int visibleIndex, boolean expanded) {
        Node<E> toExpand = this.data.get(visibleIndex, VISIBLE_NODES).get();
        this.expansionModel.setExpanded(toExpand.getElement(), toExpand.path, expanded);
        this.setExpanded(toExpand, expanded);
        assert (this.isValid());
    }

    protected void setExpanded(Node<E> toExpand, boolean expanded) {
        boolean subtreeIsVisible;
        if (toExpand.expanded == expanded) {
            return;
        }
        toExpand.expanded = expanded;
        boolean bl = subtreeIsVisible = (toExpand.element.getColor() & VISIBLE_NODES) != 0;
        if (subtreeIsVisible) {
            this.updates.beginEvent();
            if (toExpand.isVisible()) {
                int visibleIndex = this.data.indexOfNode(toExpand.element, VISIBLE_NODES);
                this.updates.addUpdate(visibleIndex);
            }
            Node<E> toExpandNextSibling = this.nextNodeThatsNotAChildOfByStructure(toExpand);
            for (Node<E> descendent = toExpand.next(); descendent != null && descendent != toExpandNextSibling; descendent = descendent.next()) {
                boolean shouldBeVisible = expanded;
                Node ancestor = descendent.parent;
                while (shouldBeVisible && ancestor != toExpand) {
                    if (!ancestor.expanded) {
                        shouldBeVisible = false;
                    }
                    ancestor = ancestor.parent;
                }
                if (shouldBeVisible == descendent.isVisible()) continue;
                if (shouldBeVisible) {
                    this.setVisible(descendent, true);
                    int insertIndex = this.data.indexOfNode(descendent.element, VISIBLE_NODES);
                    this.updates.elementInserted(insertIndex, descendent.getElement());
                    continue;
                }
                int deleteIndex = this.data.indexOfNode(descendent.element, VISIBLE_NODES);
                this.updates.elementDeleted(deleteIndex, descendent.getElement());
                this.setVisible(descendent, false);
            }
            this.updates.commitEvent();
        }
    }

    public void toggleExpanded(int visibleIndex) {
        this.setExpanded(visibleIndex, !this.isExpanded(visibleIndex));
    }

    protected void setVisible(Node<E> node, boolean visible) {
        byte newColor = visible ? (node.virtual ? VISIBLE_VIRTUAL : VISIBLE_REAL) : (node.virtual ? HIDDEN_VIRTUAL : HIDDEN_REAL);
        this.data.setColor(node.element, newColor);
    }

    private void setVirtual(Node<E> node, boolean virtual) {
        byte newColor = virtual ? (node.isVisible() ? VISIBLE_VIRTUAL : HIDDEN_VIRTUAL) : (node.isVisible() ? VISIBLE_REAL : HIDDEN_REAL);
        this.data.setColor(node.element, newColor);
    }

    @Override
    public void listChanged(ListEvent<Node<E>> listChanges) {
        String old = this.mDebug ? this.data.toString() : null;
        try {
            this.internalListChanged(listChanges);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("old=[" + old + "]" + "\ncurrent=[" + this.data + "]" + "\nsource=[" + this.source + "]" + "\nchanges=[" + listChanges + "]", e);
        }
    }

    private void internalListChanged(ListEvent<Node<E>> listChanges) {
        this.updates.beginEvent(true);
        ArrayList<Node<E>> nodesToVerify = new ArrayList<Node<E>>();
        ArrayList<Node<E>> nodesToExpand = new ArrayList<Node<E>>();
        NodeAttacher nodeAttacher = new NodeAttacher(true);
        FinderInserter finderInserter = new FinderInserter();
        FourColorTree<Node<E>> localData = this.data;
        boolean allowOptimize = this.isAvoidRemoveInUpdate();
        while (listChanges.next()) {
            int sourceIndex = listChanges.getIndex();
            int n = listChanges.getType();
            if (n == 2) {
                Node inserted = finderInserter.insertNode(sourceIndex);
                nodeAttacher.nodesToAttach.queueNewNodeForInserting(inserted);
                continue;
            }
            if (n == 1) {
                Node<E> oldNode = localData.get(sourceIndex, REAL_NODES).get();
                boolean visible = oldNode.isVisible();
                int oldIndex = -1;
                boolean changedPos = true;
                if (visible && allowOptimize) {
                    oldIndex = localData.indexOfNode(oldNode.element, ALL_NODES);
                    changedPos = finderInserter.isPositionChanging(oldNode, sourceIndex, oldIndex);
                }
                if (changedPos || !visible || !allowOptimize) {
                    this.deleteAndDetachNode(sourceIndex, nodesToVerify);
                    Node updated = finderInserter.insertNode(sourceIndex);
                    nodeAttacher.nodesToAttach.queueNewNodeForInserting(updated);
                    continue;
                }
                int viewIndex = localData.indexOfNode(oldNode.element, VISIBLE_NODES);
                this.updates.elementUpdated(viewIndex, oldNode.getElement(), oldNode.getElement());
                boolean expanded = this.expansionModel.isExpanded(oldNode.getElement(), oldNode.path);
                if (oldNode.expanded == expanded) continue;
                nodesToExpand.add(oldNode);
                continue;
            }
            if (n != 0) continue;
            this.deleteAndDetachNode(sourceIndex, nodesToVerify);
        }
        nodeAttacher.attachAll();
        this.deleteObsoleteVirtualLeaves(nodesToVerify);
        this.deleteObsoleteVirtualParents(nodesToVerify);
        for (Node node : nodesToExpand) {
            boolean expanded = this.expansionModel.isExpanded(node.getElement(), node.path);
            this.setExpanded(node, expanded);
        }
        assert (this.isValid());
        this.updates.commitEvent();
    }

    protected boolean deleteAndDetachNode(int sourceIndex, List<Node<E>> nodesToVerify) {
        boolean result = false;
        Node<E> node = this.data.get(sourceIndex, REAL_NODES).get();
        if (!node.isLeaf()) {
            Node replacement = new Node(node.virtual, node.path);
            this.replaceNode(node, replacement, true);
            nodesToVerify.add(replacement);
        } else {
            result = true;
            Node<E> follower = node.next();
            this.deleteNode(node);
            result = true;
            nodesToVerify.add(node.parent);
            if (follower != null && follower.virtual) {
                nodesToVerify.add(follower);
            }
        }
        return result;
    }

    protected void replaceNode(Node<E> before, Node<E> after, boolean virtual) {
        assert (before.pathLength() == after.pathLength());
        after.expanded = before.expanded;
        after.expanded = this.expansionModel.isExpanded(before.getElement(), before.path);
        after.parent = before.parent;
        if (after.parent != null) {
            after.parent.expanded = this.expansionModel.isExpanded(after.parent.getElement(), after.parent.path);
        }
        Node<E> child = before.firstChild();
        while (child != null) {
            assert (child.parent == before);
            child.parent = after;
            child = child.siblingAfter;
        }
        if (before.siblingAfter != null) {
            after.siblingAfter = before.siblingAfter;
            after.siblingAfter.siblingBefore = after;
        }
        if (before.siblingBefore != null) {
            after.siblingBefore = before.siblingBefore;
            after.siblingBefore.siblingAfter = after;
        }
        after.element = before.element;
        after.element.set(after);
        this.setVirtual(after, virtual);
        after.virtual = virtual;
        before.element = null;
    }

    private void deleteObsoleteVirtualLeaves(List<Node<E>> nodesToVerify) {
        for (Node<E> node : nodesToVerify) {
            while (node != null && node.virtual && node.element != null && node.isLeaf()) {
                this.deleteNode(node);
                node = node.parent;
            }
        }
    }

    private void deleteObsoleteVirtualParents(List<Node<E>> nodesToVerify) {
        for (Node<E> node : nodesToVerify) {
            Node<E> previous;
            while (node != null && node.virtual && node.element != null && (previous = node.previous()) != null && this.isAncestorByValue(previous, node)) {
                node = this.deleteVirtualAncestryRootDown(previous, node);
            }
        }
    }

    private Node<E> deleteVirtualAncestryRootDown(Node<E> previous, Node<E> parent) {
        Node<E> replacementLastSibling = previous.ancestorWithPathLength(parent.pathLength() + 1);
        assert (replacementLastSibling.siblingAfter == null);
        Node replacement = replacementLastSibling.parent;
        if (replacement.expanded && !parent.expanded) {
            this.setExpanded(parent, true);
        } else if (parent.expanded && !replacement.expanded) {
            this.setExpanded(replacement, true);
        }
        Node<E> parentFirstChild = parent.firstChild();
        assert (parentFirstChild == null || parentFirstChild.siblingBefore == null);
        replacementLastSibling.siblingAfter = parentFirstChild;
        if (parentFirstChild != null) {
            parentFirstChild.siblingBefore = replacementLastSibling;
        }
        Node<E> child = parentFirstChild;
        while (child != null) {
            child.parent = replacement;
            child = child.siblingAfter;
        }
        this.deleteNode(parent);
        return parentFirstChild;
    }

    private void deleteNode(Node<E> node) {
        node.detachSiblings();
        boolean visible = node.isVisible();
        if (visible) {
            int viewIndex = this.data.indexOfNode(node.element, VISIBLE_NODES);
            this.updates.elementDeleted(viewIndex, node.getElement());
        }
        this.data.remove(node.element);
        node.element = null;
    }

    private int commonPathLength(Node<E> a, Node<E> b) {
        Path pathA = a.path;
        Path pathB = b.path;
        int maxCommonPathLength = Math.min(pathA.size(), pathB.size());
        for (int i = 0; i < maxCommonPathLength; ++i) {
            if (this.valuesEqual(i, pathA.get(i), pathB.get(i))) continue;
            return i;
        }
        return maxCommonPathLength;
    }

    protected boolean isAncestorByValue(Node<E> child, Node<E> possibleAncestor) {
        if (possibleAncestor == null) {
            return true;
        }
        Path possibleAncestorPath = possibleAncestor.path;
        if (possibleAncestorPath.size() >= child.path.size()) {
            return false;
        }
        for (int d = possibleAncestorPath.size() - 1; d >= 0; --d) {
            Object pathElement;
            Object possibleAncestorPathElement = possibleAncestorPath.get(d);
            if (this.valuesEqual(d, possibleAncestorPathElement, pathElement = child.path.get(d))) continue;
            return false;
        }
        return true;
    }

    private boolean valuesEqual(int depth, E a, E b) {
        Comparator<E> comparator = this.format.getComparator(depth);
        if (comparator != null) {
            return comparator.compare(a, b) == 0;
        }
        return GlazedListsImpl.equal(a, b);
    }

    @Override
    public void dispose() {
        this.source.removeListEventListener(this);
        this.initializationData.dispose();
    }

    protected void addNode(Node<E> node, byte nodeColor, int realIndex) {
        node.element = this.data.add(realIndex, ALL_NODES, nodeColor, node, 1);
    }

    protected static <E> NodeComparator<E> comparatorToNodeComparator(Format<E> format) {
        return new NodeComparator<E>(format);
    }

    private boolean isVisibilityValid(Node<E> node) {
        boolean expectedVisible = true;
        Node ancestor = node.parent;
        while (ancestor != null) {
            if (!ancestor.expanded) {
                expectedVisible = false;
                break;
            }
            ancestor = ancestor.parent;
        }
        return node.isVisible() == expectedVisible;
    }

    private boolean isValid() {
        assert (this.source.size() == this.data.size(REAL_NODES));
        int lastPathLengthSeen = 0;
        for (int i = 0; i < this.data.size(ALL_NODES); ++i) {
            Node<E> node = this.data.get(i, ALL_NODES).get();
            assert (node.element != null);
            assert (!node.isNewlyInserted);
            assert (node.pathLength() <= lastPathLengthSeen + 1);
            lastPathLengthSeen = node.pathLength();
            if (!this.isVisibilityValid(node)) {
                throw new IllegalStateException();
            }
            if (node.virtual) {
                assert (node.element.getColor() == HIDDEN_VIRTUAL || node.element.getColor() == VISIBLE_VIRTUAL);
            } else {
                if (this.source.get(this.data.convertIndexColor(i, ALL_NODES, REAL_NODES)) != node) {
                    throw new IllegalStateException();
                }
                assert (node.element.getColor() == HIDDEN_REAL || node.element.getColor() == VISIBLE_REAL);
            }
            if (node.pathLength() != 1) continue;
            this.validateSubtree(node);
        }
        return true;
    }

    private void validateSubtree(Node<E> node) {
        int index = this.data.indexOfNode(node.element, ALL_NODES);
        int size = this.subtreeSize(index, false, true);
        Node<E> lastChildSeen = null;
        for (int i = 1; i < size; ++i) {
            Node<E> descendent = this.data.get(index + i, ALL_NODES).get();
            if (descendent.pathLength() == node.pathLength() + 1) {
                if (descendent.parent != node) {
                    throw new IllegalStateException();
                }
                assert (descendent.parent == node);
                if (lastChildSeen != descendent.siblingBefore) {
                    throw new IllegalStateException();
                }
                if (lastChildSeen != null) {
                    if (lastChildSeen.siblingAfter != descendent) {
                        throw new IllegalStateException();
                    }
                    if (lastChildSeen.pathLength() != descendent.pathLength()) {
                        throw new IllegalStateException();
                    }
                } else if (descendent.siblingBefore != null) {
                    throw new IllegalStateException();
                }
                lastChildSeen = descendent;
                this.validateSubtree(descendent);
                continue;
            }
            if (descendent.pathLength() > node.pathLength() + 1) continue;
            throw new IllegalStateException();
        }
        assert (lastChildSeen == null || lastChildSeen.siblingAfter == null);
    }

    public boolean isAvoidRemoveInUpdate() {
        return this.mAvoidRemoveInUpdate;
    }

    public void setAvoidRemoveInUpdate(boolean pAvoidRemoveInUpdate) {
        this.mAvoidRemoveInUpdate = pAvoidRemoveInUpdate;
    }

    public boolean isDebug() {
        return this.mDebug;
    }

    public void setDebug(boolean pDebug) {
        this.mDebug = pDebug;
    }

    private static final class FakeElement
    implements Element {
        private FakeElement() {
        }

        public Object get() {
            return null;
        }

        public void set(Object value) {
        }

        public byte getColor() {
            return 0;
        }

        public void setSorted(int sorted) {
        }

        public int getSorted() {
            return 0;
        }

        public Element next() {
            return null;
        }

        public Element previous() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AllNodesList
    extends AbstractList<Node<E>> {
        private AllNodesList() {
        }

        @Override
        public Node<E> get(int index) {
            return TreeList.this.data.get(index, ALL_NODES).get();
        }

        @Override
        public int size() {
            return TreeList.this.data.size(ALL_NODES);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodesList
    extends TransformedList<E, Node<E>> {
        public NodesList() {
            super(TreeList.this);
            TreeList.this.addListEventListener(this);
        }

        @Override
        protected boolean isWritable() {
            return true;
        }

        @Override
        public Node<E> get(int index) {
            return TreeList.this.getTreeNode(index);
        }

        @Override
        public void listChanged(ListEvent<E> listChanges) {
            this.updates.forwardEvent(listChanges);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Node<E> {
        protected final Path<E> path;
        protected boolean virtual;
        protected boolean expanded;
        protected Element<Node<E>> element;
        protected Node<E> siblingAfter;
        protected Node<E> siblingBefore;
        protected Node<E> parent;
        protected boolean isNewlyInserted = false;

        Node(boolean virtual, Path<E> path) {
            this.virtual = virtual;
            this.path = path;
        }

        protected void resetDerivedState() {
            this.virtual = false;
            this.element = null;
            this.siblingAfter = null;
            this.siblingBefore = null;
            this.parent = null;
        }

        protected int pathLength() {
            return this.path.size();
        }

        public E getElement() {
            return this.path.get(this.path.size() - 1);
        }

        public Path<E> path() {
            return this.path;
        }

        protected Node<E> describeParent() {
            int pathLength = this.pathLength();
            if (pathLength == 1) {
                return null;
            }
            return new Node<E>(true, this.path.subPath(0, pathLength - 1));
        }

        public String toString() {
            return this.path.toString();
        }

        public boolean isVisible() {
            return (this.element.getColor() & VISIBLE_NODES) > 0;
        }

        public boolean isLeaf() {
            Node<E> next = this.next();
            if (next == null) {
                return true;
            }
            return next.parent != this;
        }

        protected Node<E> next() {
            if (this.element == null) {
                return null;
            }
            Element<Node<E>> next = this.element.next();
            return next == null ? null : next.get();
        }

        protected Node<E> previous() {
            Element<Node<E>> previous = this.element.previous();
            return previous == null ? null : previous.get();
        }

        protected Node<E> firstChild() {
            Node<E> possibleChild = this.next();
            if (possibleChild == null) {
                return null;
            }
            if (possibleChild.parent != this) {
                return null;
            }
            return possibleChild;
        }

        public List<Node<E>> getChildren() {
            ArrayList<Node<Node<E>>> result = new ArrayList<Node<Node<E>>>();
            Node<E> child = this.firstChild();
            while (child != null) {
                result.add(child);
                child = child.siblingAfter;
            }
            return result;
        }

        protected Node<E> ancestorWithPathLength(int ancestorPathLength) {
            assert (this.pathLength() >= ancestorPathLength);
            Node<E> ancestor = this;
            while (ancestor.pathLength() > ancestorPathLength) {
                ancestor = ancestor.parent;
                if (ancestor != null) continue;
                throw new IllegalStateException();
            }
            return ancestor;
        }

        protected void detachSiblings() {
            if (this.siblingBefore != null) {
                this.siblingBefore.siblingAfter = this.siblingAfter;
            }
            if (this.siblingAfter != null) {
                this.siblingAfter.siblingBefore = this.siblingBefore;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Node node = (Node)o;
            return this.path.equals(node.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }

    private static class NoOpFunction
    implements FunctionList.Function {
        private NoOpFunction() {
        }

        public Object evaluate(Object sourceValue) {
            return sourceValue;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ElementToTreeNodeFunction<E>
    implements FunctionList.AdvancedFunction<E, Node<E>> {
        private static final ThreadLocal<List> CACHED_PATH = new ThreadLocal<List>(){

            @Override
            protected List initialValue() {
                return new ArrayList(4);
            }
        };
        private final Format<E> format;
        private final ExpansionModel<E> expansionModel;

        public ElementToTreeNodeFunction(Format<E> format, ExpansionModel<E> expansionModel) {
            this.format = format;
            this.expansionModel = expansionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Node<E> evaluate(E sourceValue) {
            Path path;
            List tmp = CACHED_PATH.get();
            try {
                this.format.getPath(tmp, sourceValue);
                path = new Path(tmp);
            }
            finally {
                tmp.clear();
            }
            Node result = new Node(false, path);
            result.expanded = this.expansionModel.isExpanded(sourceValue, path);
            return result;
        }

        @Override
        public Node<E> reevaluate(E sourceValue, Node<E> transformedValue) {
            assert (!transformedValue.virtual);
            Object result = this.evaluate((Object)sourceValue);
            ((Node)result).expanded = transformedValue.expanded;
            return result;
        }

        @Override
        public void dispose(E sourceValue, Node<E> transformedValue) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NodeComparator<E>
    implements Comparator<Node<E>> {
        private final Format<E> format;

        public NodeComparator(Format<E> format) {
            if (format == null) {
                throw new IllegalArgumentException();
            }
            this.format = format;
        }

        @Override
        public int compare(Node<E> a, Node<E> b) {
            Path pathA = a.path;
            Path pathB = b.path;
            int aPathLength = pathA.size();
            int bPathLength = pathB.size();
            boolean aAllowsChildren = a.virtual || this.format.allowsChildren(pathA.get(aPathLength - 1));
            boolean bAllowsChildren = b.virtual || this.format.allowsChildren(pathB.get(bPathLength - 1));
            int aEffectiveLength = aPathLength + (aAllowsChildren ? 0 : -1);
            int bEffectiveLength = bPathLength + (bAllowsChildren ? 0 : -1);
            for (int d = 0; d < aEffectiveLength && d < bEffectiveLength; ++d) {
                Comparator<E> comparator = this.format.getComparator(d);
                if (comparator == null) {
                    return 0;
                }
                int result = comparator.compare(pathA.get(d), pathB.get(d));
                if (result == 0) continue;
                return result;
            }
            return aEffectiveLength - bEffectiveLength;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Format<E> {
        public void getPath(List<E> var1, E var2);

        public boolean allowsChildren(E var1);

        public Comparator<? extends E> getComparator(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CloneStateNewNodeStateModel<E>
    implements ExpansionModel<E> {
        private boolean[] expandedStateByDepth;

        public CloneStateNewNodeStateModel(Node<E> nodeToPrototype) {
            this.expandedStateByDepth = new boolean[nodeToPrototype.pathLength()];
            Node<E> nodeWithDepthD = nodeToPrototype;
            for (int d = this.expandedStateByDepth.length - 1; d >= 0; --d) {
                if (nodeWithDepthD != null) {
                    this.expandedStateByDepth[d] = nodeWithDepthD.expanded;
                    nodeWithDepthD = nodeWithDepthD.parent;
                    continue;
                }
                this.expandedStateByDepth[d] = true;
            }
        }

        @Override
        public boolean isExpanded(E element, Path<E> path) {
            return this.expandedStateByDepth[path.size() - 1];
        }

        @Override
        public void setExpanded(E element, Path<E> path, boolean expanded) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultExpansionModel<E>
    implements ExpansionModel<E> {
        private boolean expanded;

        public DefaultExpansionModel(boolean expanded) {
            this.expanded = expanded;
        }

        @Override
        public boolean isExpanded(E element, Path<E> path) {
            return this.expanded;
        }

        @Override
        public void setExpanded(E element, Path<E> path, boolean expanded) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ExpansionModel<E> {
        public boolean isExpanded(E var1, Path<E> var2);

        public void setExpanded(E var1, Path<E> var2, boolean var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FinderInserter {
        final KeyedCollection<Element<Node<E>>, Path<E>> indicesByValue = GlazedListsImpl.keyedCollection(new ElementLocationComparator());

        protected Node<E> insertNode(int sourceIndex) {
            Node inserted = (Node)TreeList.this.source.get(sourceIndex);
            inserted.resetDerivedState();
            Path insertedPath = inserted.path;
            inserted.expanded = TreeList.this.expansionModel.isExpanded(inserted.getElement(), insertedPath);
            int dataSize = TreeList.this.data.size(ALL_NODES);
            int firstPossibleIndex = sourceIndex > 0 ? TreeList.this.data.convertIndexColor(sourceIndex - 1, REAL_NODES, ALL_NODES) + 1 : 0;
            int lastPossibleIndex = sourceIndex < TreeList.this.data.size(REAL_NODES) ? TreeList.this.data.convertIndexColor(sourceIndex, REAL_NODES, ALL_NODES) : TreeList.this.data.size(ALL_NODES);
            Element firstPossibleElement = this.indexToElement(firstPossibleIndex, dataSize);
            Element lastPossibleElement = this.indexToElement(lastPossibleIndex, dataSize);
            this.populateIndicesByValue(firstPossibleIndex, lastPossibleIndex);
            Element virtualSameElement = this.indicesByValue.find(firstPossibleElement, lastPossibleElement, insertedPath);
            if (virtualSameElement != null) {
                Node virtualSameNode = virtualSameElement.get();
                if (!virtualSameNode.virtual) {
                    throw new IllegalStateException();
                }
                TreeList.this.replaceNode(virtualSameNode, inserted, false);
                return inserted;
            }
            int insertIndex = firstPossibleIndex;
            for (int i = insertedPath.size() - 1; i >= 0; --i) {
                Path pathOfLengthI = insertedPath.subPath(0, i);
                Element bestAncestor = this.indicesByValue.find(firstPossibleElement, lastPossibleElement, pathOfLengthI);
                if (bestAncestor == null) continue;
                if (!bestAncestor.get().virtual) {
                    throw new IllegalStateException();
                }
                insertIndex = TreeList.this.data.indexOfNode(bestAncestor, ALL_NODES) + 1;
                break;
            }
            TreeList.this.addNode(inserted, HIDDEN_REAL, insertIndex);
            return inserted;
        }

        protected boolean isPositionChanging(Node<E> pNode, int pSourceIndex, int pOldIndex) {
            Path path = pNode.path;
            int dataSize = TreeList.this.data.size(ALL_NODES);
            int firstPossibleIndex = pSourceIndex > 0 ? TreeList.this.data.convertIndexColor(pSourceIndex - 1, REAL_NODES, ALL_NODES) + 1 : 0;
            int lastPossibleIndex = pSourceIndex < TreeList.this.data.size(REAL_NODES) ? TreeList.this.data.convertIndexColor(pSourceIndex, REAL_NODES, ALL_NODES) : TreeList.this.data.size(ALL_NODES);
            Element firstPossibleElement = this.indexToElement(firstPossibleIndex, dataSize);
            Element lastPossibleElement = this.indexToElement(lastPossibleIndex, dataSize);
            this.populateIndicesByValue(firstPossibleIndex, lastPossibleIndex);
            int insertIndex = -1;
            Element virtualSameElement = this.indicesByValue.find(firstPossibleElement, lastPossibleElement, path);
            if (virtualSameElement == null) {
                insertIndex = firstPossibleIndex;
                for (int i = path.size() - 1; i >= 0; --i) {
                    Path pathOfLengthI = path.subPath(0, i);
                    Element bestAncestor = this.indicesByValue.find(firstPossibleElement, lastPossibleElement, pathOfLengthI);
                    if (bestAncestor == null) continue;
                    if (!bestAncestor.get().virtual) {
                        throw new IllegalStateException();
                    }
                    insertIndex = TreeList.this.data.indexOfNode(bestAncestor, ALL_NODES) + 1;
                    break;
                }
            }
            return insertIndex != pOldIndex;
        }

        private Element<Node<E>> indexToElement(int index, int dataSize) {
            if (index >= 0 && index < dataSize) {
                return TreeList.this.data.get(index, ALL_NODES);
            }
            if (index == 0) {
                return MINIMUM_ELEMENT;
            }
            if (index == dataSize) {
                return MAXIMUM_ELEMENT;
            }
            throw new IllegalArgumentException();
        }

        private void populateIndicesByValue(int firstNeeded, int lastNeeded) {
            Element firstAvailableElement = this.indicesByValue.first();
            int firstAvailable = firstAvailableElement != null ? TreeList.this.data.indexOfNode(firstAvailableElement, ALL_NODES) : lastNeeded;
            this.populate(firstNeeded, firstAvailable);
            Element lastAvailableElement = this.indicesByValue.last();
            int lastAvailable = lastAvailableElement != null ? TreeList.this.data.indexOfNode(lastAvailableElement, ALL_NODES) : firstAvailable;
            this.populate(lastAvailable + 1, lastNeeded);
        }

        private void populate(int start, int end) {
            for (int i = start; i < end; ++i) {
                Element element = TreeList.this.data.get(i, ALL_NODES);
                this.indicesByValue.insert(element, element.get().path);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class PathAsListComparator
        implements Comparator<List<E>> {
            private PathAsListComparator() {
            }

            @Override
            public int compare(List<E> a, List<E> b) {
                int aPathLength = a.size();
                int bPathLength = b.size();
                for (int d = 0; d < aPathLength && d < bPathLength; ++d) {
                    Comparator comparator = TreeList.this.format.getComparator(d);
                    if (comparator == null) {
                        return 0;
                    }
                    int result = comparator.compare(a.get(d), b.get(d));
                    if (result == 0) continue;
                    return result;
                }
                return aPathLength - bPathLength;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class ElementLocationComparator
        implements Comparator<Element<Node<E>>> {
            private ElementLocationComparator() {
            }

            @Override
            public int compare(Element<Node<E>> a, Element<Node<E>> b) {
                if (a == b) {
                    return 0;
                }
                if (a == MINIMUM_ELEMENT || b == MAXIMUM_ELEMENT) {
                    return -1;
                }
                if (b == MINIMUM_ELEMENT || a == MAXIMUM_ELEMENT) {
                    return 1;
                }
                int aIndex = TreeList.this.data.indexOfNode(a, ALL_NODES);
                int bIndex = TreeList.this.data.indexOfNode(b, ALL_NODES);
                return aIndex - bIndex;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NodesToAttach {
        private final List<Node<E>> nodes = new CircularArrayList();
        private final ca.odell.glazedlists.TreeList$NodesToAttach.NodeIndexComparator nodeIndexComparator = new NodeIndexComparator();

        private NodesToAttach() {
        }

        protected void queueOutOfOrderNodeForAttaching(Node<E> node) {
            int position = Collections.binarySearch(this.nodes, node, this.nodeIndexComparator);
            if (position >= 0) {
                return;
            }
            this.nodes.add(-position - 1, node);
            assert (this.isValid());
        }

        protected void queuePrefixForAttaching(Node<E> node) {
            if (!this.nodes.isEmpty()) {
                if (this.nodes.get(0) == node) {
                    return;
                }
                assert (this.nodeIndexComparator.compare(this.nodes.get(0), node) >= 0);
            }
            this.nodes.add(0, node);
            assert (this.isValid());
        }

        protected void queueNewNodeForInserting(Node<E> node) {
            assert (this.nodes.isEmpty() || this.nodeIndexComparator.compare(this.nodes.get(this.nodes.size() - 1), node) < 0);
            this.nodes.add(node);
            node.isNewlyInserted = true;
            assert (this.isValid());
        }

        protected boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        protected Node<E> removeFirst() {
            return this.nodes.remove(0);
        }

        protected boolean getNewlyInsertedAndReset(Node<E> node) {
            boolean result = node.isNewlyInserted;
            node.isNewlyInserted = false;
            return result;
        }

        private boolean isValid() {
            for (int i = 0; i < this.nodes.size() - 1; ++i) {
                Node a = this.nodes.get(i);
                Node b = this.nodes.get(i + 1);
                assert (this.nodeIndexComparator.compare(a, b) <= 0);
            }
            return true;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class NodeIndexComparator
        implements Comparator<Node<E>> {
            private NodeIndexComparator() {
            }

            @Override
            public int compare(Node<E> a, Node<E> b) {
                if (a.element == null || b.element == null) {
                    throw new IllegalStateException();
                }
                return TreeList.this.data.indexOfNode(a.element, ALL_NODES) - TreeList.this.data.indexOfNode(b.element, ALL_NODES);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeAttacher {
        private final boolean fireEvents;
        protected final NodesToAttach nodesToAttach;
        private Node<E> current;
        private Node<E> predecessor;
        private Node<E> predecessorAtOurHeight;
        private List<Node<E>> pathToRoot;
        private int index;
        private ExpansionModel<E> expansionModel;
        private List<Node<E>> nodesToExpand;

        public NodeAttacher(boolean fireEvents) {
            this.nodesToAttach = new NodesToAttach();
            this.pathToRoot = new ArrayList();
            this.nodesToExpand = new ArrayList();
            this.fireEvents = fireEvents;
        }

        public void attachAll() {
            while (!this.nodesToAttach.isEmpty()) {
                Node changed = this.nodesToAttach.removeFirst();
                boolean newlyInserted = this.nodesToAttach.getNewlyInsertedAndReset(changed);
                this.attach(changed, newlyInserted);
            }
            for (Node node : this.nodesToExpand) {
                boolean expanded = this.expansionModel.isExpanded(node.getElement(), node.path);
                TreeList.this.setExpanded(node, expanded);
            }
            this.nodesToExpand.clear();
        }

        private void attach(Node<E> changed, boolean newlyInserted) {
            Node follower;
            this.current = changed;
            this.expansionModel = newlyInserted ? TreeList.this.expansionModel : new CloneStateNewNodeStateModel(this.current);
            this.index = TreeList.this.data.indexOfNode(this.current.element, ALL_NODES);
            this.predecessor = this.current.previous();
            this.predecessorAtOurHeight = null;
            if (newlyInserted && (follower = this.current.next()) != null) {
                this.nodesToAttach.queuePrefixForAttaching(follower);
            }
            this.attachParentsAndSiblings();
            this.fixVisibilityAndFireEvents();
            this.pathToRoot.clear();
        }

        private void attachParentsAndSiblings() {
            boolean preexistingParentFound = false;
            while (this.current != null) {
                int predecessorPathLength;
                int currentPathLength = this.current.pathLength();
                int n = predecessorPathLength = this.predecessor == null ? 0 : this.predecessor.pathLength();
                if (preexistingParentFound) {
                    this.incrementCurrent();
                    continue;
                }
                if (currentPathLength > predecessorPathLength + 1) {
                    this.createAndAttachParent();
                    continue;
                }
                if (predecessorPathLength >= currentPathLength) {
                    this.incrementPredecessor();
                    continue;
                }
                if (TreeList.this.isAncestorByValue(this.current, this.predecessor)) {
                    assert (currentPathLength == predecessorPathLength + 1);
                    this.attachParent(this.predecessor, this.predecessorAtOurHeight);
                    preexistingParentFound = true;
                    continue;
                }
                assert (currentPathLength == predecessorPathLength + 1);
                assert (this.predecessor != null);
                this.createAndAttachParent();
                this.incrementPredecessor();
            }
        }

        private void incrementCurrent() {
            this.pathToRoot.add(this.current);
            this.current = this.current.parent;
        }

        private void incrementPredecessor() {
            if (this.predecessor.siblingAfter != null && this.predecessor.siblingAfter != this.current) {
                this.nodesToAttach.queueOutOfOrderNodeForAttaching(this.predecessor.siblingAfter);
                this.predecessor.siblingAfter.siblingBefore = null;
                this.predecessor.siblingAfter = null;
            }
            this.predecessorAtOurHeight = this.predecessor;
            this.predecessor = this.predecessor.parent;
        }

        private void createAndAttachParent() {
            Node parent = this.current.describeParent();
            if (parent != null) {
                parent.expanded = this.expansionModel.isExpanded(parent.getElement(), parent.path);
                TreeList.this.addNode(parent, HIDDEN_VIRTUAL, this.index);
            }
            this.attachParent(parent, null);
        }

        private void attachParent(Node<E> parent, Node<E> siblingBeforeNode) {
            assert (this.current != null);
            assert (this.current.pathLength() == 1 && parent == null || this.current.pathLength() == parent.pathLength() + 1);
            if (siblingBeforeNode != null && siblingBeforeNode.siblingAfter != this.current) {
                if (siblingBeforeNode.pathLength() != this.current.pathLength()) {
                    throw new IllegalStateException();
                }
                assert (siblingBeforeNode.parent == parent);
                if (siblingBeforeNode.siblingAfter != null) {
                    assert (this.current.siblingAfter == null);
                    this.current.siblingAfter = siblingBeforeNode.siblingAfter;
                    siblingBeforeNode.siblingAfter.siblingBefore = this.current;
                }
                this.current.siblingBefore = siblingBeforeNode;
                siblingBeforeNode.siblingAfter = this.current;
                assert (this.current.siblingBefore != this.current);
                assert (this.current.siblingAfter != this.current);
            }
            Node currentSibling = this.current;
            while (currentSibling != null) {
                currentSibling.parent = parent;
                currentSibling = currentSibling.siblingAfter;
            }
            if (parent != null && !parent.expanded && this.current.isVisible()) {
                this.nodesToExpand.add(parent);
            }
            this.incrementCurrent();
        }

        private void fixVisibilityAndFireEvents() {
            boolean visible = true;
            for (int i = this.pathToRoot.size() - 1; i >= 0; --i) {
                this.current = this.pathToRoot.get(i);
                this.current.expanded = this.expansionModel.isExpanded(this.current.getElement(), this.current.path);
                if (visible) {
                    int visibleIndex;
                    if (!this.current.isVisible()) {
                        TreeList.this.setVisible(this.current, true);
                        visibleIndex = TreeList.this.data.indexOfNode(this.current.element, VISIBLE_NODES);
                        if (this.fireEvents) {
                            TreeList.this.updates.addInsert(visibleIndex);
                        }
                    } else {
                        visibleIndex = TreeList.this.data.indexOfNode(this.current.element, VISIBLE_NODES);
                        if (this.fireEvents) {
                            TreeList.this.updates.addUpdate(visibleIndex);
                        }
                    }
                }
                visible = visible && this.current.expanded;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InitializationData<E> {
        protected final Format<E> format;
        protected final ExpansionModel<E> expansionModel;
        protected final NodeComparator<E> nodeComparator;
        private final FunctionList<E, Node<E>> sourceNodes;
        private final SortedList<Node<E>> sortedList;

        public InitializationData(EventList<E> sourceElements, Format<E> format, ExpansionModel<E> expansionModel) {
            this.format = format;
            this.expansionModel = expansionModel;
            this.sourceNodes = new FunctionList(sourceElements, new ElementToTreeNodeFunction<E>(format, expansionModel), NO_OP_FUNCTION);
            this.nodeComparator = TreeList.comparatorToNodeComparator(format);
            this.sortedList = new SortedList<E>(this.sourceNodes, this.nodeComparator);
        }

        public EventList<Node<E>> getSource() {
            if (this.sortedList != null) {
                return this.sortedList;
            }
            return this.sourceNodes;
        }

        public void dispose() {
            if (this.sortedList != null) {
                this.sortedList.dispose();
            }
            this.sourceNodes.dispose();
        }
    }
}

