/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Path<E> {
    private final Object[] mPath;
    private final int mFromIndex;
    private final int mToIndex;
    private int mHashCode;

    public Path(List<E> pPath) {
        this.mPath = pPath.toArray(new Object[pPath.size()]);
        this.mFromIndex = 0;
        this.mToIndex = this.mPath.length;
        this.updateHash();
    }

    public Path(Path<E> pPath) {
        this.mPath = pPath.mPath;
        this.mFromIndex = pPath.mFromIndex;
        this.mToIndex = pPath.mToIndex;
        this.mHashCode = pPath.mHashCode;
    }

    private Path(Path pPath, int pFromIndex, int pToIndex) {
        this.mPath = pPath.mPath;
        this.mFromIndex = pFromIndex;
        this.mToIndex = pToIndex;
        this.updateHash();
    }

    private void updateHash() {
        int hash = 1;
        for (int i = this.mToIndex - 1; i >= this.mFromIndex; --i) {
            Object elem = this.mPath[i];
            hash = 31 * hash + (elem == null ? 0 : elem.hashCode());
        }
        this.mHashCode = hash;
    }

    public int hashCode() {
        return this.mHashCode;
    }

    public boolean equals(Object pObj) {
        boolean result;
        if (this == pObj) {
            return true;
        }
        if (null == pObj) {
            return false;
        }
        Path b = (Path)pObj;
        int size = this.size();
        boolean bl = result = this.mHashCode == b.mHashCode && size == b.size();
        if (result) {
            for (int i = size - 1; result && i >= 0; --i) {
                E elemA = this.get(i);
                E elemB = b.get(i);
                result = elemA != null ? elemA.equals(elemB) : elemB == null;
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append('[');
        for (int i = this.mFromIndex; i < this.mToIndex; ++i) {
            sb.append(this.mPath[i]);
            if (i >= this.mToIndex - 1) continue;
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    public int size() {
        return this.mToIndex - this.mFromIndex;
    }

    public E get(int pIndex) {
        return (E)this.mPath[this.mFromIndex + pIndex];
    }

    public Path<E> subPath(int pFromIndex, int pToIndex) {
        return new Path<E>(this, pFromIndex, pToIndex);
    }
}

