/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.AbstractSnmpUtility;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;

public class TreeUtils
extends AbstractSnmpUtility {
    private static final LogAdapter logger = LogFactory.getLogger(TreeUtils.class);
    private int maxRepetitions = 10;

    public TreeUtils(Session session, PDUFactory pDUFactory) {
        super(session, pDUFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSubtree(Target target, OID oID) {
        InternalTreeListener internalTreeListener;
        LinkedList linkedList = new LinkedList();
        InternalTreeListener internalTreeListener2 = internalTreeListener = new InternalTreeListener(linkedList);
        synchronized (internalTreeListener2) {
            this.walk(target, oID, oID, null, internalTreeListener);
            try {
                internalTreeListener.wait();
            }
            catch (InterruptedException interruptedException) {
                logger.warn("Tree retrieval interrupted: " + interruptedException.getMessage());
            }
        }
        return linkedList;
    }

    public void getSubtree(Target target, OID oID, Object object, TreeListener treeListener) {
        this.walk(target, oID, oID, object, treeListener);
    }

    private void walk(Target target, OID oID, OID oID2, Object object, TreeListener treeListener) {
        PDU pDU = this.pduFactory.createPDU(target);
        pDU.add(new VariableBinding(oID2));
        if (target.getVersion() == 0) {
            pDU.setType(-95);
        } else {
            pDU.setType(-91);
            pDU.setMaxRepetitions(this.maxRepetitions);
        }
        TreeRequest treeRequest = new TreeRequest(treeListener, oID, target, object, pDU);
        treeRequest.send();
    }

    public void setMaxRepetitions(int n) {
        this.maxRepetitions = n;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    class InternalTreeListener
    implements TreeListener {
        private List collectedEvents;
        private volatile boolean finished = false;

        public InternalTreeListener(List list) {
            this.collectedEvents = list;
        }

        public synchronized boolean next(TreeEvent treeEvent) {
            this.collectedEvents.add(treeEvent);
            return true;
        }

        public synchronized void finished(TreeEvent treeEvent) {
            this.collectedEvents.add(treeEvent);
            this.finished = true;
            this.notify();
        }

        public List getCollectedEvents() {
            return this.collectedEvents;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    class TreeRequest
    implements ResponseListener {
        private TreeListener listener;
        private Object userObject;
        private PDU request;
        private OID rootOID;
        private Target target;

        public TreeRequest(TreeListener treeListener, OID oID, Target target, Object object, PDU pDU) {
            this.listener = treeListener;
            this.userObject = object;
            this.request = pDU;
            this.rootOID = oID;
            this.target = target;
        }

        public void send() {
            try {
                TreeUtils.this.session.send(this.request, this.target, null, this);
            }
            catch (IOException iOException) {
                this.listener.finished(new TreeEvent((Object)this, this.userObject, iOException));
            }
        }

        public void onResponse(ResponseEvent responseEvent) {
            TreeUtils.this.session.cancel(responseEvent.getRequest(), this);
            PDU pDU = responseEvent.getResponse();
            if (pDU == null) {
                this.listener.finished(new TreeEvent((Object)this, this.userObject, -1));
            } else if (pDU.getErrorStatus() != 0) {
                this.listener.finished(new TreeEvent((Object)this, this.userObject, pDU.getErrorStatus()));
            } else if (pDU.getType() == -88) {
                this.listener.finished(new TreeEvent((Object)this, this.userObject, pDU));
            } else {
                VariableBinding variableBinding;
                ArrayList<VariableBinding> arrayList = new ArrayList<VariableBinding>(pDU.size());
                OID oID = this.request.get(0).getOid();
                boolean bl = false;
                for (int i = 0; !bl && i < pDU.size(); ++i) {
                    variableBinding = pDU.get(i);
                    if (variableBinding.getOid() == null || variableBinding.getOid().size() < this.rootOID.size() || this.rootOID.leftMostCompare(this.rootOID.size(), variableBinding.getOid()) != 0) {
                        bl = true;
                        continue;
                    }
                    if (Null.isExceptionSyntax(variableBinding.getVariable().getSyntax())) {
                        bl = true;
                        continue;
                    }
                    if (variableBinding.getOid().compareTo(oID) <= 0) {
                        this.listener.finished(new TreeEvent((Object)this, this.userObject, -2));
                        bl = true;
                        break;
                    }
                    oID = variableBinding.getOid();
                    arrayList.add(variableBinding);
                }
                if (pDU.size() == 0) {
                    bl = true;
                }
                VariableBinding[] variableBindingArray = arrayList.toArray(new VariableBinding[arrayList.size()]);
                if (bl) {
                    this.listener.finished(new TreeEvent((Object)this, this.userObject, variableBindingArray));
                } else {
                    if (this.listener.next(new TreeEvent((Object)this, this.userObject, variableBindingArray))) {
                        variableBinding = (VariableBinding)pDU.get(pDU.size() - 1).clone();
                        variableBinding.setVariable(new Null());
                        this.request.set(0, variableBinding);
                        this.request.setRequestID(new Integer32(0));
                        this.send();
                        return;
                    }
                    bl = true;
                }
            }
        }
    }
}

