/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.snmp4j.AbstractTarget;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.util.ArgumentParser;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.PDUFactory;

public class SnmpConfigurator {
    public static final String O_VERSION = "v";
    public static final String P_VERSION = "org.snmp4j.arg.version";
    public static final String F_VERSION = "s<1|2c|3>";
    public static final String O_LOCAL_ENGINE_ID = "l";
    public static final String P_LOCAL_ENGINE_ID = "org.snmp4j.arg.localEngineID";
    public static final String F_LOCAL_ENGINE_ID = "o<\\n\\n[:\\n\\n]*>";
    public static final String O_AUTHORITATIVE_ENGINE_ID = "e";
    public static final String P_AUTHORITATIVE_ENGINE_ID = "org.snmp4j.arg.authoritativeEngineID";
    public static final String F_AUTHORITATIVE_ENGINE_ID = "o<\\n\\n[:\\n\\n]*>";
    public static final String O_COMMUNITY = "c";
    public static final String P_COMMUNITY = "org.snmp4j.arg.community";
    public static final String F_COMMUNITY = "s{=public}";
    public static final String O_CONTEXT_NAME = "n";
    public static final String P_CONTEXT_NAME = "org.snmp4j.arg.contextName";
    public static final String F_CONTEXT_NAME = "s{=}";
    public static final String O_CONTEXT_ENGINE_ID = "E";
    public static final String P_CONTEXT_ENGINE_ID = "org.snmp4j.arg.contextEngineID";
    public static final String F_CONTEXT_ENGINE_ID = "o<\\n\\n[:\\n\\n]*>";
    public static final String O_SECURITY_NAME = "u";
    public static final String P_SECURITY_NAME = "org.snmp4j.arg.securityName";
    public static final String F_SECURITY_NAME = "s";
    public static final String O_RETRIES = "r";
    public static final String P_RETRIES = "org.snmp4j.arg.retries";
    public static final String F_RETRIES = "i";
    public static final String O_TIMEOUT = "t";
    public static final String P_TIMEOUT = "org.snmp4j.arg.timeout";
    public static final String F_TIMEOUT = "l";
    public static final String O_ADDRESS = "address";
    public static final String P_ADDRESS = "org.snmp4j.arg.address";
    public static final String F_ADDRESS = "s<(udp|tcp):.*[/[0-9]+]?>";
    public static final String O_AUTH_PASSPHRASE = "A";
    public static final String P_AUTH_PASSPHRASE = "org.snmp4j.arg.authPassphrase";
    public static final String F_AUTH_PASSPHRASE = "s<.*>";
    public static final String O_PRIV_PASSPHRASE = "Y";
    public static final String P_PRIV_PASSPHRASE = "org.snmp4j.arg.privPassphrase";
    public static final String F_PRIV_PASSPHRASE = "s<.*>";
    public static final String O_AUTH_PROTOCOL = "a";
    public static final String P_AUTH_PROTOCOL = "org.snmp4j.arg.authProtocol";
    public static final String F_AUTH_PROTOCOL = "s<(MD5|SHA)>";
    public static final String O_PRIV_PROTOCOL = "y";
    public static final String P_PRIV_PROTOCOL = "org.snmp4j.arg.privProtocol";
    public static final String F_PRIV_PROTOCOL = "s<(DES|3DES|AES|AES128|AES192|AES256)>";
    public static final String O_OPERATION = "o";
    public static final String P_OPERATION = "org.snmp4j.arg.operation";
    public static final String F_OPERATION = "s<(?i)(GET|GETNEXT|GETBULK|TRAP|NOTIFICATION|SET|INFORM)>";
    public static final String O_MAX_REPETITIONS = "Cr";
    public static final String P_MAX_REPETITIONS = "org.snmp4j.arg.maxRepetitions";
    public static final String F_MAX_REPETITIONS = "i{=10}";
    public static final String O_NON_REPEATERS = "Cn";
    public static final String P_NON_REPEATERS = "org.snmp4j.arg.nonRepeaters";
    public static final String F_NON_REPEATERS = "i{=0}";
    public static final String O_BOOT_COUNTER = "bc";
    public static final String P_BOOT_COUNTER = "org.snmp4j.arg.bootCounter";
    public static final String F_BOOT_COUNTER = "i{=0}";
    public static final String O_SEC_LEVEL = "sl";
    public static final String P_SEC_LEVEL = "org.snmp4j.arg.securityLevel";
    public static final String F_SEC_LEVEL = "i";
    private String oVersion;
    private String oLocalEngineID;
    private String oRetries;
    private String oTimeout;
    private String oAddress;
    private String oCommunity;
    private String oAuthoritativeEngineID;
    private String oSecurityName;
    private String oAuthPassphrase;
    private String oAuthProtocol;
    private String oPrivPassphrase;
    private String oPrivProtocol;
    private String oOperation;
    private String oMaxRepetitions;
    private String oNonRepeaters;
    private String oBootCounter;
    private String oContextName;
    private String oContextEngineID;
    private String oSecLevel;

    public SnmpConfigurator() {
        this(new Properties());
    }

    public SnmpConfigurator(Properties properties) {
        this.oVersion = properties.getProperty(P_VERSION, O_VERSION);
        this.oLocalEngineID = properties.getProperty(P_LOCAL_ENGINE_ID, "l");
        this.oRetries = properties.getProperty(P_RETRIES, O_RETRIES);
        this.oTimeout = properties.getProperty(P_TIMEOUT, O_TIMEOUT);
        this.oAddress = properties.getProperty(P_ADDRESS, O_ADDRESS);
        this.oCommunity = properties.getProperty(P_COMMUNITY, O_COMMUNITY);
        this.oSecurityName = properties.getProperty(P_SECURITY_NAME, O_SECURITY_NAME);
        this.oAuthoritativeEngineID = properties.getProperty(P_AUTHORITATIVE_ENGINE_ID, O_AUTHORITATIVE_ENGINE_ID);
        this.oAuthPassphrase = properties.getProperty(P_AUTH_PASSPHRASE, O_AUTH_PASSPHRASE);
        this.oAuthProtocol = properties.getProperty(P_AUTH_PROTOCOL, O_AUTH_PROTOCOL);
        this.oPrivPassphrase = properties.getProperty(P_PRIV_PASSPHRASE, O_PRIV_PASSPHRASE);
        this.oPrivProtocol = properties.getProperty(P_PRIV_PROTOCOL, O_PRIV_PROTOCOL);
        this.oOperation = properties.getProperty(P_OPERATION, O_OPERATION);
        this.oMaxRepetitions = properties.getProperty(P_MAX_REPETITIONS, O_MAX_REPETITIONS);
        this.oNonRepeaters = properties.getProperty(P_NON_REPEATERS, O_NON_REPEATERS);
        this.oBootCounter = properties.getProperty(P_BOOT_COUNTER, O_BOOT_COUNTER);
        this.oContextName = properties.getProperty(P_CONTEXT_NAME, O_CONTEXT_NAME);
        this.oContextEngineID = properties.getProperty(P_CONTEXT_ENGINE_ID, O_CONTEXT_ENGINE_ID);
        this.oSecLevel = properties.getProperty(P_SEC_LEVEL, O_SEC_LEVEL);
    }

    public void configure(Snmp snmp, Map map) {
        if (snmp.getUSM() != null) {
            String string;
            int n = 0;
            Integer n2 = (Integer)ArgumentParser.getValue(map, this.oBootCounter, 0);
            if (n2 != null) {
                n = n2;
                snmp.getUSM().setEngineBoots(n);
            }
            int n3 = 0;
            OctetString octetString = (OctetString)ArgumentParser.getValue(map, this.oLocalEngineID, 0);
            if (octetString == null) {
                if (snmp.getLocalEngineID() == null) {
                    snmp.setLocalEngine(MPv3.createLocalEngineID(), n, n3);
                }
            } else {
                snmp.setLocalEngine(octetString.getValue(), n, n3);
            }
            if ((string = (String)ArgumentParser.getValue(map, this.oSecurityName, 0)) != null) {
                String string2 = (String)ArgumentParser.getValue(map, this.oAuthPassphrase, 0);
                String string3 = (String)ArgumentParser.getValue(map, this.oPrivPassphrase, 0);
                OID oID = null;
                String string4 = (String)ArgumentParser.getValue(map, this.oAuthProtocol, 0);
                String string5 = (String)ArgumentParser.getValue(map, this.oPrivProtocol, 0);
                OID oID2 = null;
                if ("MD5".equals(string4)) {
                    oID = AuthMD5.ID;
                } else if ("SHA".equals(string4)) {
                    oID = AuthSHA.ID;
                }
                if ("DES".equals(string5)) {
                    oID2 = PrivDES.ID;
                } else if ("3DES".equals(string5)) {
                    oID2 = Priv3DES.ID;
                } else if ("AES".equals(string5) || "AES128".equals(string5)) {
                    oID2 = PrivAES128.ID;
                } else if ("AES192".equals(string5)) {
                    oID2 = PrivAES192.ID;
                } else if ("AES256".equals(string5)) {
                    oID2 = PrivAES256.ID;
                }
                OctetString octetString2 = SnmpConfigurator.createOctetString(string, null);
                snmp.getUSM().addUser(octetString2, new UsmUser(octetString2, oID, SnmpConfigurator.createOctetString(string2, null), oID2, SnmpConfigurator.createOctetString(string3, null)));
            }
        }
    }

    public PDUFactory getPDUFactory(Map map) {
        return new InnerPDUFactory(map);
    }

    public Target getTarget(Map map) {
        Object object;
        AbstractTarget abstractTarget;
        String string = (String)ArgumentParser.getValue(map, this.oVersion, 0);
        OctetString octetString = SnmpConfigurator.createOctetString((String)ArgumentParser.getValue(map, this.oCommunity, 0), "public");
        if ("1".equals(string)) {
            abstractTarget = new CommunityTarget();
            abstractTarget.setVersion(0);
            ((CommunityTarget)abstractTarget).setCommunity(octetString);
        } else if ("2c".equals(string)) {
            abstractTarget = new CommunityTarget();
            abstractTarget.setVersion(1);
            ((CommunityTarget)abstractTarget).setCommunity(octetString);
        } else {
            Integer n;
            UserTarget userTarget = new UserTarget();
            abstractTarget = userTarget;
            object = (String)ArgumentParser.getValue(map, this.oAuthoritativeEngineID, 0);
            if (object != null) {
                userTarget.setAuthoritativeEngineID(SnmpConfigurator.createOctetString((String)object, null).getValue());
            }
            userTarget.setSecurityModel(3);
            String string2 = (String)ArgumentParser.getValue(map, this.oSecurityName, 0);
            if (string2 != null) {
                userTarget.setSecurityName(SnmpConfigurator.createOctetString(string2, null));
            }
            if ((n = (Integer)ArgumentParser.getValue(map, this.oSecLevel, 0)) == null) {
                if (map.containsKey(this.oPrivPassphrase)) {
                    userTarget.setSecurityLevel(3);
                } else if (map.containsKey(this.oAuthPassphrase)) {
                    userTarget.setSecurityLevel(2);
                } else {
                    userTarget.setSecurityLevel(1);
                }
            } else {
                userTarget.setSecurityLevel(n);
            }
        }
        int n = 0;
        object = (Integer)ArgumentParser.getValue(map, this.oRetries, 0);
        if (object != null) {
            n = (Integer)object;
        }
        abstractTarget.setRetries(n);
        long l = 5000L;
        Long l2 = (Long)ArgumentParser.getValue(map, this.oTimeout, 0);
        if (l2 != null) {
            l = l2;
        }
        abstractTarget.setTimeout(l);
        String string3 = (String)ArgumentParser.getValue(map, this.oAddress, 0);
        if (string3 != null) {
            abstractTarget.setAddress(GenericAddress.parse(string3));
        }
        return abstractTarget;
    }

    private static OctetString createOctetString(String string, String string2) {
        if (string == null) {
            string = string2;
        }
        OctetString octetString = string.startsWith("0x") ? OctetString.fromHexString(string.substring(2), ':') : new OctetString(string);
        return octetString;
    }

    public class InnerPDUFactory
    implements PDUFactory {
        private Map settings;

        public InnerPDUFactory(Map map) {
            this.settings = map;
        }

        public PDU createPDU(Target target) {
            Comparable<Integer> comparable;
            Serializable serializable;
            String string = (String)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oOperation, 0);
            if (string == null) {
                string = "GET";
            }
            string = string.toUpperCase();
            int n = PDU.getTypeFromString(string);
            PDU pDU = DefaultPDUFactory.createPDU(target, n);
            if (n == -91) {
                serializable = this.getMaxRepetitions();
                if (serializable != null) {
                    pDU.setMaxRepetitions((Integer)serializable);
                }
                if ((comparable = this.getNonRepeaters()) != null) {
                    pDU.setNonRepeaters((int)comparable);
                }
            }
            if (pDU instanceof ScopedPDU) {
                String string2;
                serializable = (ScopedPDU)pDU;
                comparable = (OctetString)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oContextEngineID, 0);
                if (comparable != null) {
                    ((ScopedPDU)serializable).setContextEngineID((OctetString)comparable);
                }
                if ((string2 = (String)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oContextName, 0)) != null) {
                    ((ScopedPDU)serializable).setContextName(SnmpConfigurator.createOctetString(string2, null));
                }
            }
            return pDU;
        }

        public Integer getMaxRepetitions() {
            Integer n = (Integer)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oMaxRepetitions, 0);
            return n;
        }

        public Integer getNonRepeaters() {
            return (Integer)ArgumentParser.getValue(this.settings, SnmpConfigurator.this.oNonRepeaters, 0);
        }
    }
}

