/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.text.ParseException;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.VariableTextFormat;

public class SimpleVariableTextFormat
implements VariableTextFormat {
    public String format(OID oID, Variable variable, boolean bl) {
        return bl ? SNMP4JSettings.getOIDTextFormat().format(oID.getValue()) + " = " + variable : ((Object)variable).toString();
    }

    public Variable parse(int n, String string) throws ParseException {
        Variable variable = AbstractVariable.createFromSyntax(n);
        if (variable instanceof AssignableFromString) {
            ((AssignableFromString)((Object)variable)).setValue(string);
        }
        return variable;
    }

    public Variable parse(OID oID, String string) throws ParseException {
        throw new UnsupportedOperationException();
    }

    public VariableBinding parseVariableBinding(String string) throws ParseException {
        int n = string.indexOf(" = ");
        if (n <= 0) {
            throw new ParseException("Could not locate assignment ' = ' string in '" + string, 0);
        }
        OID oID = new OID(SNMP4JSettings.getOIDTextFormat().parse(string.substring(0, n)));
        Variable variable = this.parse(oID, string.substring(n + 3));
        return new VariableBinding(oID, variable);
    }
}

