/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.UdpTransportMapping;
import org.snmp4j.util.WorkerTask;

public class DefaultUdpTransportMapping
extends UdpTransportMapping {
    private static final LogAdapter logger = LogFactory.getLogger(DefaultUdpTransportMapping.class);
    protected DatagramSocket socket = null;
    protected WorkerTask listener;
    protected ListenThread listenerThread;
    private int socketTimeout = 0;
    private int receiveBufferSize = 0;

    public DefaultUdpTransportMapping() throws IOException {
        super(new UdpAddress(InetAddress.getLocalHost(), 0));
        this.socket = new DatagramSocket(this.udpAddress.getPort());
    }

    public DefaultUdpTransportMapping(UdpAddress udpAddress, boolean bl) throws IOException {
        super(udpAddress);
        this.socket = new DatagramSocket(null);
        this.socket.setReuseAddress(bl);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(udpAddress.getInetAddress(), udpAddress.getPort());
        this.socket.bind(inetSocketAddress);
    }

    public DefaultUdpTransportMapping(UdpAddress udpAddress) throws IOException {
        super(udpAddress);
        this.socket = new DatagramSocket(udpAddress.getPort(), udpAddress.getInetAddress());
    }

    public void sendMessage(Address address, byte[] byArray) throws IOException {
        InetSocketAddress inetSocketAddress = new InetSocketAddress(((UdpAddress)address).getInetAddress(), ((UdpAddress)address).getPort());
        if (logger.isDebugEnabled()) {
            logger.debug("Sending message to " + address + " with length " + byArray.length + ": " + new OctetString(byArray).toHexString());
        }
        DatagramSocket datagramSocket = this.ensureSocket();
        datagramSocket.send(new DatagramPacket(byArray, byArray.length, inetSocketAddress));
    }

    public void close() throws IOException {
        boolean bl = false;
        WorkerTask workerTask = this.listener;
        if (workerTask != null) {
            workerTask.terminate();
            workerTask.interrupt();
            if (this.socketTimeout > 0) {
                try {
                    workerTask.join();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    logger.warn(interruptedException);
                }
            }
            this.listener = null;
        }
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        this.socket = null;
        if (bl) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void listen() throws IOException {
        if (this.listener != null) {
            throw new SocketException("Port already listening");
        }
        this.ensureSocket();
        this.listenerThread = new ListenThread();
        this.listener = SNMP4JSettings.getThreadFactory().createWorkerThread("DefaultUDPTransportMapping_" + this.getAddress(), this.listenerThread, true);
        this.listener.run();
    }

    private synchronized DatagramSocket ensureSocket() throws SocketException {
        DatagramSocket datagramSocket = this.socket;
        if (datagramSocket == null) {
            datagramSocket = new DatagramSocket(this.udpAddress.getPort());
            datagramSocket.setSoTimeout(this.socketTimeout);
            this.socket = datagramSocket;
        }
        return datagramSocket;
    }

    public void setPriority(int n) {
        WorkerTask workerTask = this.listener;
        if (workerTask instanceof Thread) {
            ((Thread)((Object)workerTask)).setPriority(n);
        }
    }

    public int getPriority() {
        WorkerTask workerTask = this.listener;
        if (workerTask instanceof Thread) {
            return ((Thread)((Object)workerTask)).getPriority();
        }
        return 5;
    }

    public void setThreadName(String string) {
        WorkerTask workerTask = this.listener;
        if (workerTask instanceof Thread) {
            ((Thread)((Object)workerTask)).setName(string);
        }
    }

    public String getThreadName() {
        WorkerTask workerTask = this.listener;
        if (workerTask instanceof Thread) {
            return ((Thread)((Object)workerTask)).getName();
        }
        return null;
    }

    public void setMaxInboundMessageSize(int n) {
        this.maxInboundMessageSize = n;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Receive buffer size must be > 0");
        }
        this.receiveBufferSize = n;
    }

    public void setSocketTimeout(int n) {
        this.socketTimeout = n;
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(n);
            }
            catch (SocketException socketException) {
                throw new RuntimeException(socketException);
            }
        }
    }

    public boolean isListening() {
        return this.listener != null;
    }

    class ListenThread
    implements WorkerTask {
        private byte[] buf;
        private volatile boolean stop = false;

        public ListenThread() throws SocketException {
            this.buf = new byte[DefaultUdpTransportMapping.this.getMaxInboundMessageSize()];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            try {
                DefaultUdpTransportMapping.this.socket.setSoTimeout(DefaultUdpTransportMapping.this.getSocketTimeout());
                if (DefaultUdpTransportMapping.this.receiveBufferSize > 0) {
                    DefaultUdpTransportMapping.this.socket.setReceiveBufferSize(Math.max(DefaultUdpTransportMapping.this.receiveBufferSize, DefaultUdpTransportMapping.this.maxInboundMessageSize));
                }
                if (logger.isInfoEnabled()) {
                    logger.info("UDP receive buffer size for socket " + DefaultUdpTransportMapping.this.getAddress() + " is set to: " + DefaultUdpTransportMapping.this.socket.getReceiveBufferSize());
                }
            }
            catch (SocketException socketException) {
                logger.error(socketException);
                DefaultUdpTransportMapping.this.setSocketTimeout(0);
            }
            while (!this.stop) {
                Object object2;
                object = new DatagramPacket(this.buf, this.buf.length, DefaultUdpTransportMapping.this.udpAddress.getInetAddress(), DefaultUdpTransportMapping.this.udpAddress.getPort());
                try {
                    ByteBuffer byteBuffer;
                    try {
                        DefaultUdpTransportMapping.this.socket.receive((DatagramPacket)object);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        if (interruptedIOException.bytesTransferred <= 0) continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Received message from " + ((DatagramPacket)object).getAddress() + "/" + ((DatagramPacket)object).getPort() + " with length " + ((DatagramPacket)object).getLength() + ": " + new OctetString(((DatagramPacket)object).getData(), 0, ((DatagramPacket)object).getLength()).toHexString());
                    }
                    if (DefaultUdpTransportMapping.this.isAsyncMsgProcessingSupported()) {
                        object2 = new byte[((DatagramPacket)object).getLength()];
                        System.arraycopy(((DatagramPacket)object).getData(), 0, object2, 0, ((Object)object2).length);
                        byteBuffer = ByteBuffer.wrap((byte[])object2);
                    } else {
                        byteBuffer = ByteBuffer.wrap(((DatagramPacket)object).getData());
                    }
                    DefaultUdpTransportMapping.this.fireProcessMessage(new UdpAddress(((DatagramPacket)object).getAddress(), ((DatagramPacket)object).getPort()), byteBuffer);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (PortUnreachableException portUnreachableException) {
                    object2 = DefaultUdpTransportMapping.this;
                    synchronized (object2) {
                        DefaultUdpTransportMapping.this.listener = null;
                    }
                    logger.error(portUnreachableException);
                    if (logger.isDebugEnabled()) {
                        portUnreachableException.printStackTrace();
                    }
                    if (!SNMP4JSettings.isFowardRuntimeExceptions()) break;
                    throw new RuntimeException(portUnreachableException);
                }
                catch (SocketException socketException) {
                    if (!this.stop) {
                        logger.error("Socket for transport mapping " + this.toString() + " error: " + socketException.getMessage(), socketException);
                    }
                    this.stop = true;
                }
                catch (IOException iOException) {
                    logger.warn(iOException);
                    if (logger.isDebugEnabled()) {
                        iOException.printStackTrace();
                    }
                    if (!SNMP4JSettings.isFowardRuntimeExceptions()) continue;
                    throw new RuntimeException(iOException);
                }
            }
            object = DefaultUdpTransportMapping.this;
            synchronized (object) {
                DefaultUdpTransportMapping.this.listener = null;
                this.stop = true;
                if (DefaultUdpTransportMapping.this.socket != null) {
                    DefaultUdpTransportMapping.this.socket.close();
                }
            }
        }

        public void close() {
            this.stop = true;
        }

        public void terminate() {
            this.close();
        }

        public void join() throws InterruptedException {
        }

        public void interrupt() {
            this.close();
        }
    }
}

